/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.mortbay.log.LogFactory;
import org.mortbay.util.LogSupport;

public class TypeUtil {
    private static Log log = LogFactory.getLog(TypeUtil.class);
    private static final HashMap name2Class = new HashMap();
    private static final HashMap class2Name;
    private static final HashMap class2Value;
    private static Class[] stringArg;
    private static int intCacheSize;
    private static Integer[] integerCache;
    private static String[] integerStrCache;
    private static Integer minusOne;

    public static Class fromName(String string) {
        return (Class)name2Class.get(string);
    }

    public static String toName(Class clazz) {
        return (String)class2Name.get(clazz);
    }

    public static Object valueOf(Class clazz, String string) {
        try {
            if (clazz.equals(String.class)) {
                return string;
            }
            Method method = (Method)class2Value.get(clazz);
            if (method != null) {
                return method.invoke(null, string);
            }
            if (clazz.equals(Character.TYPE) || clazz.equals(Character.class)) {
                return new Character(string.charAt(0));
            }
            Constructor constructor = clazz.getConstructor(stringArg);
            return constructor.newInstance(string);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            LogSupport.ignore(log, noSuchMethodException);
        }
        catch (IllegalAccessException illegalAccessException) {
            LogSupport.ignore(log, illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            LogSupport.ignore(log, instantiationException);
        }
        catch (InvocationTargetException invocationTargetException) {
            if (invocationTargetException.getTargetException() instanceof Error) {
                throw (Error)invocationTargetException.getTargetException();
            }
            LogSupport.ignore(log, invocationTargetException);
        }
        return null;
    }

    public static Object valueOf(String string, String string2) {
        return TypeUtil.valueOf(TypeUtil.fromName(string), string2);
    }

    public static Integer newInteger(int n) {
        if (n >= 0 && n < intCacheSize) {
            if (integerCache[n] == null) {
                TypeUtil.integerCache[n] = new Integer(n);
            }
            return integerCache[n];
        }
        if (n == -1) {
            return minusOne;
        }
        return new Integer(n);
    }

    public static String toString(int n) {
        if (n >= 0 && n < intCacheSize) {
            if (integerStrCache[n] == null) {
                TypeUtil.integerStrCache[n] = Integer.toString(n);
            }
            return integerStrCache[n];
        }
        if (n == -1) {
            return "-1";
        }
        return Integer.toString(n);
    }

    public static int parseInt(String string, int n, int n2, int n3) throws NumberFormatException {
        int n4 = 0;
        if (n2 < 0) {
            n2 = string.length() - n;
        }
        for (int i = 0; i < n2; ++i) {
            char c = string.charAt(n + i);
            int n5 = c - 48;
            if (!(n5 >= 0 && n5 < n3 && n5 < 10 || (n5 = 10 + c - 65) >= 10 && n5 < n3)) {
                n5 = 10 + c - 97;
            }
            if (n5 < 0 || n5 >= n3) {
                throw new NumberFormatException(string.substring(n, n + n2));
            }
            n4 = n4 * n3 + n5;
        }
        return n4;
    }

    public static byte[] parseBytes(String string, int n) {
        byte[] byArray = new byte[string.length() / 2];
        for (int i = 0; i < string.length(); i += 2) {
            byArray[i / 2] = (byte)TypeUtil.parseInt(string, i, 2, n);
        }
        return byArray;
    }

    public static String toString(byte[] byArray, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < byArray.length; ++i) {
            int n2 = 0xFF & byArray[i];
            int n3 = 48 + n2 / n % n;
            if (n3 > 57) {
                n3 = 97 + (n3 - 48 - 10);
            }
            stringBuffer.append((char)n3);
            n3 = 48 + n2 % n;
            if (n3 > 57) {
                n3 = 97 + (n3 - 48 - 10);
            }
            stringBuffer.append((char)n3);
        }
        return stringBuffer.toString();
    }

    public static byte convertHexDigit(byte by) {
        if (by >= 48 && by <= 57) {
            return (byte)(by - 48);
        }
        if (by >= 97 && by <= 102) {
            return (byte)(by - 97 + 10);
        }
        if (by >= 65 && by <= 70) {
            return (byte)(by - 65 + 10);
        }
        return 0;
    }

    public static char toHexChar(int n) {
        return (char)(n < 10 ? 48 + n : 65 + n - 10);
    }

    public static String toHexString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < byArray.length; ++i) {
            int n = 0xFF & byArray[i];
            int n2 = 48 + n / 16 % 16;
            if (n2 > 57) {
                n2 = 65 + (n2 - 48 - 10);
            }
            stringBuffer.append((char)n2);
            n2 = 48 + n % 16;
            if (n2 > 57) {
                n2 = 97 + (n2 - 48 - 10);
            }
            stringBuffer.append((char)n2);
        }
        return stringBuffer.toString();
    }

    public static String toHexString(byte[] byArray, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = n; i < n + n2; ++i) {
            int n3 = 0xFF & byArray[i];
            int n4 = 48 + n3 / 16 % 16;
            if (n4 > 57) {
                n4 = 65 + (n4 - 48 - 10);
            }
            stringBuffer.append((char)n4);
            n4 = 48 + n3 % 16;
            if (n4 > 57) {
                n4 = 97 + (n4 - 48 - 10);
            }
            stringBuffer.append((char)n4);
        }
        return stringBuffer.toString();
    }

    public static byte[] fromHexString(String string) {
        if (string.length() % 2 != 0) {
            throw new IllegalArgumentException(string);
        }
        byte[] byArray = new byte[string.length() / 2];
        for (int i = 0; i < byArray.length; ++i) {
            int n = Integer.parseInt(string.substring(i * 2, i * 2 + 2), 16);
            byArray[i] = (byte)(0xFF & n);
        }
        return byArray;
    }

    public static void dump(Class clazz) {
        System.err.println("Dump: " + clazz);
        TypeUtil.dump(clazz.getClassLoader());
    }

    public static void dump(ClassLoader classLoader) {
        System.err.println("Dump Loaders:");
        while (classLoader != null) {
            System.err.println("  loader " + classLoader);
            classLoader = classLoader.getParent();
        }
    }

    static {
        name2Class.put("boolean", Boolean.TYPE);
        name2Class.put("byte", Byte.TYPE);
        name2Class.put("char", Character.TYPE);
        name2Class.put("double", Double.TYPE);
        name2Class.put("float", Float.TYPE);
        name2Class.put("int", Integer.TYPE);
        name2Class.put("long", Long.TYPE);
        name2Class.put("short", Short.TYPE);
        name2Class.put("void", Void.TYPE);
        name2Class.put("java.lang.Boolean.TYPE", Boolean.TYPE);
        name2Class.put("java.lang.Byte.TYPE", Byte.TYPE);
        name2Class.put("java.lang.Character.TYPE", Character.TYPE);
        name2Class.put("java.lang.Double.TYPE", Double.TYPE);
        name2Class.put("java.lang.Float.TYPE", Float.TYPE);
        name2Class.put("java.lang.Integer.TYPE", Integer.TYPE);
        name2Class.put("java.lang.Long.TYPE", Long.TYPE);
        name2Class.put("java.lang.Short.TYPE", Short.TYPE);
        name2Class.put("java.lang.Void.TYPE", Void.TYPE);
        name2Class.put("java.lang.Boolean", Boolean.class);
        name2Class.put("java.lang.Byte", Byte.class);
        name2Class.put("java.lang.Character", Character.class);
        name2Class.put("java.lang.Double", Double.class);
        name2Class.put("java.lang.Float", Float.class);
        name2Class.put("java.lang.Integer", Integer.class);
        name2Class.put("java.lang.Long", Long.class);
        name2Class.put("java.lang.Short", Short.class);
        name2Class.put("Boolean", Boolean.class);
        name2Class.put("Byte", Byte.class);
        name2Class.put("Character", Character.class);
        name2Class.put("Double", Double.class);
        name2Class.put("Float", Float.class);
        name2Class.put("Integer", Integer.class);
        name2Class.put("Long", Long.class);
        name2Class.put("Short", Short.class);
        name2Class.put(null, Void.TYPE);
        name2Class.put("string", String.class);
        name2Class.put("String", String.class);
        name2Class.put("java.lang.String", String.class);
        class2Name = new HashMap();
        class2Name.put(Boolean.TYPE, "boolean");
        class2Name.put(Byte.TYPE, "byte");
        class2Name.put(Character.TYPE, "char");
        class2Name.put(Double.TYPE, "double");
        class2Name.put(Float.TYPE, "float");
        class2Name.put(Integer.TYPE, "int");
        class2Name.put(Long.TYPE, "long");
        class2Name.put(Short.TYPE, "short");
        class2Name.put(Void.TYPE, "void");
        class2Name.put(Boolean.class, "java.lang.Boolean");
        class2Name.put(Byte.class, "java.lang.Byte");
        class2Name.put(Character.class, "java.lang.Character");
        class2Name.put(Double.class, "java.lang.Double");
        class2Name.put(Float.class, "java.lang.Float");
        class2Name.put(Integer.class, "java.lang.Integer");
        class2Name.put(Long.class, "java.lang.Long");
        class2Name.put(Short.class, "java.lang.Short");
        class2Name.put(null, "void");
        name2Class.put(String.class, "java.lang.String");
        class2Value = new HashMap();
        try {
            Class[] classArray = new Class[]{String.class};
            class2Value.put(Boolean.TYPE, Boolean.class.getMethod("valueOf", classArray));
            class2Value.put(Byte.TYPE, Byte.class.getMethod("valueOf", classArray));
            class2Value.put(Double.TYPE, Double.class.getMethod("valueOf", classArray));
            class2Value.put(Float.TYPE, Float.class.getMethod("valueOf", classArray));
            class2Value.put(Integer.TYPE, Integer.class.getMethod("valueOf", classArray));
            class2Value.put(Long.TYPE, Long.class.getMethod("valueOf", classArray));
            class2Value.put(Short.TYPE, Short.class.getMethod("valueOf", classArray));
            class2Value.put(Boolean.class, Boolean.class.getMethod("valueOf", classArray));
            class2Value.put(Byte.class, Byte.class.getMethod("valueOf", classArray));
            class2Value.put(Double.class, Double.class.getMethod("valueOf", classArray));
            class2Value.put(Float.class, Float.class.getMethod("valueOf", classArray));
            class2Value.put(Integer.class, Integer.class.getMethod("valueOf", classArray));
            class2Value.put(Long.class, Long.class.getMethod("valueOf", classArray));
            class2Value.put(Short.class, Short.class.getMethod("valueOf", classArray));
        }
        catch (Exception exception) {
            log.warn((Object)"EXCEPTION ", (Throwable)exception);
        }
        stringArg = new Class[]{String.class};
        intCacheSize = Integer.getInteger("org.mortbay.util.TypeUtil.IntegerCacheSize", 600);
        integerCache = new Integer[intCacheSize];
        integerStrCache = new String[intCacheSize];
        minusOne = new Integer(-1);
    }
}

