/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.mortbay.log.LogFactory;

public class RolloverFileOutputStream
extends FilterOutputStream {
    static Log log = LogFactory.getLog(RolloverFileOutputStream.class);
    static Rollover __rollover;
    static final String YYYY_MM_DD = "yyyy_mm_dd";
    static final ArrayList __rollovers;
    private SimpleDateFormat _fileBackupFormat = new SimpleDateFormat(System.getProperty("ROLLOVERFILE_BACKUP_FORMAT", "HHmmssSSS"));
    private SimpleDateFormat _fileDateFormat = new SimpleDateFormat(System.getProperty("ROLLOVERFILE_DATE_FORMAT", "yyyy_MM_dd"));
    private String _filename;
    private File _file;
    private boolean _append;
    private int _retainDays;
    private WeakReference _ref;

    public RolloverFileOutputStream(String string) throws IOException {
        this(string, true, Integer.getInteger("ROLLOVERFILE_RETAIN_DAYS", 31));
    }

    public RolloverFileOutputStream(String string, boolean bl) throws IOException {
        this(string, bl, Integer.getInteger("ROLLOVERFILE_RETAIN_DAYS", 31));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RolloverFileOutputStream(String string, boolean bl, int n) throws IOException {
        super(null);
        if (string != null && (string = string.trim()).length() == 0) {
            string = null;
        }
        if (string == null) {
            throw new IllegalArgumentException("Invalid filename");
        }
        this._filename = string;
        this._append = bl;
        this._retainDays = n;
        this._ref = new WeakReference<RolloverFileOutputStream>(this);
        this.setFile();
        ArrayList arrayList = __rollovers;
        synchronized (arrayList) {
            if (__rollover == null) {
                __rollover = new Rollover();
                __rollover.start();
            }
            __rollovers.add(this._ref);
        }
    }

    public String getFilename() {
        return this._filename;
    }

    public String getDatedFilename() {
        if (this._file == null) {
            return null;
        }
        return this._file.toString();
    }

    public int getRetainDays() {
        return this._retainDays;
    }

    private synchronized void setFile() throws IOException {
        File file = new File(this._filename);
        this._filename = file.getCanonicalPath();
        file = new File(this._filename);
        File file2 = new File(file.getParent());
        if (!file2.isDirectory() || !file2.canWrite()) {
            throw new IOException("Cannot write log directory " + file2);
        }
        Date date = new Date();
        String string = file.getName();
        int n = string.toLowerCase().indexOf(YYYY_MM_DD);
        if (n >= 0) {
            file = new File(file2, string.substring(0, n) + this._fileDateFormat.format(date) + string.substring(n + YYYY_MM_DD.length()));
        }
        if (file.exists() && !file.canWrite()) {
            throw new IOException("Cannot write log file " + file);
        }
        if (this.out == null || !file.equals(this._file)) {
            this._file = file;
            if (!this._append && file.exists()) {
                file.renameTo(new File(file.toString() + "." + this._fileBackupFormat.format(date)));
            }
            OutputStream outputStream = this.out;
            this.out = new FileOutputStream(file.toString(), this._append);
            if (outputStream != null) {
                outputStream.close();
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Opened " + this._file));
            }
        }
    }

    private void removeOldFiles() {
        if (this._retainDays > 0) {
            Calendar calendar = Calendar.getInstance();
            calendar.add(5, -this._retainDays);
            int n = calendar.get(1);
            int n2 = calendar.get(2) + 1;
            int n3 = calendar.get(5);
            File file = new File(this._filename);
            File file2 = new File(file.getParent());
            String string = file.getName();
            int n4 = string.toLowerCase().indexOf(YYYY_MM_DD);
            if (n4 < 0) {
                return;
            }
            String string2 = string.substring(0, n4);
            String string3 = string.substring(n4 + YYYY_MM_DD.length());
            String[] stringArray = file2.list();
            for (int i = 0; i < stringArray.length; ++i) {
                string = stringArray[i];
                if (!string.startsWith(string2) || string.indexOf(string3, string2.length()) < 0) continue;
                try {
                    StringTokenizer stringTokenizer = new StringTokenizer(string.substring(string2.length(), string2.length() + YYYY_MM_DD.length()), "_.");
                    int n5 = Integer.parseInt(stringTokenizer.nextToken());
                    int n6 = Integer.parseInt(stringTokenizer.nextToken());
                    int n7 = Integer.parseInt(stringTokenizer.nextToken());
                    if (n5 >= n && (n5 != n || n6 >= n2) && (n5 != n || n6 != n2 || n7 > n3)) continue;
                    log.info((Object)("Log age " + string));
                    new File(file2, string).delete();
                    continue;
                }
                catch (Exception exception) {
                    if (!log.isDebugEnabled()) continue;
                    exception.printStackTrace();
                }
            }
        }
    }

    public void write(byte[] byArray) throws IOException {
        this.out.write(byArray);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.out.write(byArray, n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        ArrayList arrayList = __rollovers;
        synchronized (arrayList) {
            __rollovers.remove(this._ref);
            this._ref = null;
            try {
                super.close();
            }
            finally {
                this.out = null;
                this._file = null;
            }
            if (__rollovers.size() == 0) {
                __rollover.timeToStop();
                __rollover.interrupt();
                __rollover = null;
            }
        }
    }

    static {
        __rollovers = new ArrayList();
    }

    private class Rollover
    extends Thread {
        private boolean timeToStop = false;

        Rollover() {
            this.setName("Rollover");
            this.setDaemon(true);
        }

        synchronized void timeToStop() {
            this.timeToStop = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!this.timeToStop) {
                Object object;
                Cloneable cloneable;
                block11: {
                    try {
                        cloneable = Calendar.getInstance();
                        object = new GregorianCalendar(((Calendar)cloneable).get(1), ((Calendar)cloneable).get(2), ((Calendar)cloneable).get(5), 23, 0);
                        ((GregorianCalendar)object).add(10, 1);
                        long l = ((Calendar)object).getTime().getTime() - ((Calendar)cloneable).getTime().getTime();
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Rollover sleep until " + ((Calendar)object).getTime()));
                        }
                        Thread.sleep(l);
                    }
                    catch (InterruptedException interruptedException) {
                        if (this.timeToStop) break block11;
                        interruptedException.printStackTrace();
                    }
                }
                cloneable = __rollovers;
                synchronized (cloneable) {
                    object = __rollovers.listIterator();
                    while (object.hasNext()) {
                        WeakReference weakReference = (WeakReference)object.next();
                        RolloverFileOutputStream rolloverFileOutputStream = (RolloverFileOutputStream)weakReference.get();
                        if (rolloverFileOutputStream == null) {
                            object.remove();
                            continue;
                        }
                        try {
                            rolloverFileOutputStream.setFile();
                            rolloverFileOutputStream.removeOldFiles();
                        }
                        catch (IOException iOException) {
                            if (this.timeToStop) continue;
                            iOException.printStackTrace();
                        }
                    }
                }
            }
        }
    }
}

