/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.util;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import org.mortbay.util.IO;
import org.mortbay.util.Loader;
import org.mortbay.util.Password;

public class KeyPairTool {
    private File keyStoreFile = new File(System.getProperty("user.home"), ".keystore");
    private String keyStoreType = KeyStore.getDefaultType();
    private Password keyStorePassword = null;
    private Password keyPassword = null;
    private String alias = "mykey";
    private File privateKeyFile = null;
    private File certFile = null;
    private String providerClassName = "org.bouncycastle.jce.provider.BouncyCastleProvider";
    private static final String usageString = "Tool to insert a private key/certificate pair into a keystore.\nParameters:\n -key        FILENAME, location of private key [MANDATORY]\n -cert       FILENAME, location of certificate [MANDATORY]\n -storepass  PASSWORD, keystore password       [OPTIONAL - security RISK!]\n -keypass    PASSWORD, password for new entry  [=STOREPASS]\n -keystore   FILENAME, location of keystore,   [~/.keystore]\n -storetype  STRING,   name/type of keystore,  [" + KeyStore.getDefaultType() + "]\n" + " -alias      NAME,     alias used to store key [mykey]\n" + " -provider   NAME,     name of provider class [org.bouncycastle.jce.provider.BouncyCastleProvider]\n\n" + "The keystore and key passwords will be prompted for or can be\n" + "set with the following JVM system properties:\n" + "  jetty.ssl.password\n" + "  jetty.ssl.keypassword";

    public static void main(String[] stringArray) {
        KeyPairTool keyPairTool = new KeyPairTool();
        keyPairTool.doit(stringArray);
    }

    private void doit(String[] stringArray) {
        try {
            this.loadParameters(stringArray);
            this.importKeyPair();
        }
        catch (Exception exception) {
            System.out.println("Exception: " + exception.getMessage());
            exception.printStackTrace();
            System.exit(23);
        }
    }

    private void importKeyPair() throws IOException, GeneralSecurityException, Exception {
        PrivateKey privateKey = this.loadPrivateKey(this.privateKeyFile);
        Certificate[] certificateArray = this.loadCertChain(this.certFile);
        if (this.keyPassword == null) {
            this.keyPassword = this.keyStorePassword;
        }
        KeyStore keyStore = KeyStore.getInstance(this.keyStoreType);
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(this.keyStoreFile);
            System.out.println("Will load " + this.keyStoreType + " keystore: " + this.keyStoreFile);
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("Creating keystore: " + this.keyStoreFile);
        }
        keyStore.load(fileInputStream, this.keyStorePassword.toString().toCharArray());
        if (fileInputStream != null) {
            ((InputStream)fileInputStream).close();
            System.out.println("Keystore loaded OK...");
        }
        keyStore.setKeyEntry(this.alias, privateKey, this.keyPassword.toString().toCharArray(), certificateArray);
        FileOutputStream fileOutputStream = new FileOutputStream(this.keyStoreFile);
        keyStore.store(fileOutputStream, this.keyStorePassword.toString().toCharArray());
        fileOutputStream.close();
        System.out.println("Keys have been written to keystore");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Certificate[] loadCertChain(File file) throws Exception {
        Certificate[] certificateArray;
        DataInputStream dataInputStream = null;
        try {
            Certificate[] certificateArray2;
            FileInputStream fileInputStream = new FileInputStream(file);
            dataInputStream = new DataInputStream(fileInputStream);
            byte[] byArray = new byte[dataInputStream.available()];
            dataInputStream.readFully(byArray);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            ArrayList<Certificate[]> arrayList = new ArrayList<Certificate[]>();
            while (byteArrayInputStream.available() > 0) {
                certificateArray2 = certificateFactory.generateCertificate(byteArrayInputStream);
                arrayList.add(certificateArray2);
            }
            certificateArray2 = arrayList.toArray(new Certificate[arrayList.size()]);
            System.out.println("Loaded the cert chain. Depth = " + certificateArray2.length);
            certificateArray = certificateArray2;
        }
        catch (Throwable throwable) {
            IO.close(dataInputStream);
            throw throwable;
        }
        IO.close(dataInputStream);
        return certificateArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PrivateKey loadPrivateKey(File file) throws Exception {
        byte[] byArray;
        System.out.println("Loading private key from " + file + ", using " + this.providerClassName + " as the private key loading provider");
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            byArray = new byte[(int)file.length()];
            fileInputStream.read(byArray);
        }
        catch (Throwable throwable) {
            IO.close(fileInputStream);
            throw throwable;
        }
        IO.close(fileInputStream);
        Class clazz = Loader.loadClass(this.getClass(), this.providerClassName);
        Provider provider = (Provider)clazz.newInstance();
        Security.insertProviderAt(provider, 1);
        try {
            PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(byArray);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            PrivateKey privateKey = keyFactory.generatePrivate(pKCS8EncodedKeySpec);
            System.out.println("Loaded " + privateKey.getAlgorithm() + " " + privateKey.getFormat() + " private key.");
            PrivateKey privateKey2 = privateKey;
            return privateKey2;
        }
        finally {
            Security.removeProvider(provider.getName());
        }
    }

    private static void usage() {
        System.out.println(usageString);
        System.exit(23);
    }

    private void loadParameters(String[] stringArray) {
        for (int i = 0; i < stringArray.length && stringArray[i].startsWith("-"); ++i) {
            String string = stringArray[i];
            if (string.equalsIgnoreCase("-key")) {
                this.privateKeyFile = new File(stringArray[++i]);
                continue;
            }
            if (string.equalsIgnoreCase("-cert")) {
                this.certFile = new File(stringArray[++i]);
                continue;
            }
            if (string.equalsIgnoreCase("-keystore")) {
                this.keyStoreFile = new File(stringArray[++i]);
                continue;
            }
            if (string.equalsIgnoreCase("-storetype")) {
                this.keyStoreType = stringArray[++i];
                continue;
            }
            if (string.equalsIgnoreCase("-alias")) {
                this.alias = stringArray[++i];
                continue;
            }
            if (string.equalsIgnoreCase("-provider")) {
                this.providerClassName = stringArray[++i];
                continue;
            }
            System.err.println("Illegal parameter: " + string);
            KeyPairTool.usage();
        }
        if (this.privateKeyFile == null || this.certFile == null) {
            KeyPairTool.usage();
        }
        this.keyStorePassword = Password.getPassword("jetty.ssl.password", null, null);
        this.keyPassword = Password.getPassword("jetty.ssl.keypassword", null, this.keyStorePassword.toString());
    }
}

