/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.apache.commons.logging.Log;
import org.mortbay.log.LogFactory;
import org.mortbay.util.IO;
import org.mortbay.util.LogSupport;
import org.mortbay.util.Resource;
import org.mortbay.util.URLResource;

public class JarResource
extends URLResource {
    private static Log log = LogFactory.getLog(JarResource.class);
    protected transient JarURLConnection _jarConnection;

    JarResource(URL uRL) {
        super(uRL, null);
    }

    public synchronized void release() {
        this._jarConnection = null;
        super.release();
    }

    protected boolean checkConnection() {
        super.checkConnection();
        try {
            if (this._jarConnection != this._connection) {
                this.newConnection();
            }
        }
        catch (IOException iOException) {
            LogSupport.ignore(log, iOException);
            this._jarConnection = null;
        }
        return this._jarConnection != null;
    }

    protected void newConnection() throws IOException {
        this._jarConnection = (JarURLConnection)this._connection;
    }

    public boolean exists() {
        if (this._urlString.endsWith("!/")) {
            return this.checkConnection();
        }
        return super.exists();
    }

    public File getFile() throws IOException {
        return null;
    }

    public InputStream getInputStream() throws IOException {
        if (!this._urlString.endsWith("!/")) {
            return super.getInputStream();
        }
        URL uRL = new URL(this._urlString.substring(4, this._urlString.length() - 2));
        return uRL.openStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void extract(Resource resource, File file, boolean bl) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Extract " + resource + " to " + file));
        }
        JarInputStream jarInputStream = new JarInputStream(resource.getInputStream());
        JarEntry jarEntry = null;
        while ((jarEntry = jarInputStream.getNextJarEntry()) != null) {
            File file2;
            block8: {
                block7: {
                    file2 = new File(file, jarEntry.getName());
                    if (!jarEntry.isDirectory()) break block7;
                    if (!file2.exists()) {
                        file2.mkdirs();
                    }
                    break block8;
                }
                File file3 = new File(file2.getParent());
                if (!file3.exists()) {
                    file3.mkdirs();
                }
                FileOutputStream fileOutputStream = null;
                try {
                    fileOutputStream = new FileOutputStream(file2);
                    IO.copy(jarInputStream, fileOutputStream);
                }
                catch (Throwable throwable) {
                    IO.close(fileOutputStream);
                    throw throwable;
                }
                IO.close(fileOutputStream);
                if (jarEntry.getTime() >= 0L) {
                    file2.setLastModified(jarEntry.getTime());
                }
            }
            if (!bl) continue;
            file2.deleteOnExit();
        }
    }

    public void extract(File file, boolean bl) throws IOException {
        JarResource.extract(this, file, bl);
    }
}

