/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import org.apache.commons.logging.Log;
import org.mortbay.log.LogFactory;
import org.mortbay.util.LogSupport;
import org.mortbay.util.ThreadPool;

public class IO
extends ThreadPool {
    private static Log log = LogFactory.getLog(IO.class);
    public static final String CRLF = "\r\n";
    public static final byte[] CRLF_BYTES = new byte[]{13, 10};
    public static int bufferSize = Integer.getInteger("org.mortbay.util.IO.bufferSize", 8192);
    private static NullOS __nullStream = new NullOS();
    private static NullWrite __nullWriter = new NullWrite();

    public static IO instance() {
        return Singleton.__instance;
    }

    public static void copyThread(InputStream inputStream, OutputStream outputStream) {
        try {
            IO.instance().run(new Job(inputStream, outputStream));
        }
        catch (InterruptedException interruptedException) {
            log.warn((Object)"EXCEPTION ", (Throwable)interruptedException);
        }
    }

    public static void copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        IO.copy(inputStream, outputStream, -1L);
    }

    public static void copyThread(Reader reader, Writer writer) {
        try {
            IO.instance().run(new Job(reader, writer));
        }
        catch (InterruptedException interruptedException) {
            log.warn((Object)"EXCEPTION ", (Throwable)interruptedException);
        }
    }

    public static void copy(Reader reader, Writer writer) throws IOException {
        IO.copy(reader, writer, -1L);
    }

    public static void copy(InputStream inputStream, OutputStream outputStream, long l) throws IOException {
        byte[] byArray = new byte[bufferSize];
        int n = bufferSize;
        if (l >= 0L) {
            while (l > 0L && (n = l < (long)bufferSize ? inputStream.read(byArray, 0, (int)l) : inputStream.read(byArray, 0, bufferSize)) != -1) {
                l -= (long)n;
                outputStream.write(byArray, 0, n);
            }
        } else {
            while ((n = inputStream.read(byArray, 0, bufferSize)) >= 0) {
                outputStream.write(byArray, 0, n);
            }
        }
    }

    public static void copy(Reader reader, Writer writer, long l) throws IOException {
        char[] cArray = new char[bufferSize];
        int n = bufferSize;
        if (l >= 0L) {
            while (l > 0L && (n = l < (long)bufferSize ? reader.read(cArray, 0, (int)l) : reader.read(cArray, 0, bufferSize)) != -1) {
                l -= (long)n;
                writer.write(cArray, 0, n);
            }
        } else {
            while ((n = reader.read(cArray, 0, bufferSize)) != -1) {
                writer.write(cArray, 0, n);
            }
        }
    }

    public static String toString(InputStream inputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        IO.copy(inputStream, byteArrayOutputStream);
        return new String(byteArrayOutputStream.toByteArray());
    }

    public static boolean delete(File file) {
        if (!file.exists()) {
            return false;
        }
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            for (int i = 0; fileArray != null && i < fileArray.length; ++i) {
                IO.delete(fileArray[i]);
            }
        }
        return file.delete();
    }

    public void handle(Object object) {
        Job job = (Job)object;
        try {
            if (job.in != null) {
                IO.copy(job.in, job.out, -1L);
            } else {
                IO.copy(job.read, job.write, -1L);
            }
        }
        catch (IOException iOException) {
            LogSupport.ignore(log, iOException);
            try {
                if (job.out != null) {
                    job.out.close();
                }
                if (job.write != null) {
                    job.write.close();
                }
            }
            catch (IOException iOException2) {
                LogSupport.ignore(log, iOException2);
            }
        }
    }

    public static OutputStream getNullStream() {
        return __nullStream;
    }

    public static void close(InputStream inputStream) {
        try {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (IOException iOException) {
            LogSupport.ignore(log, iOException);
        }
    }

    public static void close(OutputStream outputStream) {
        try {
            if (outputStream != null) {
                outputStream.close();
            }
        }
        catch (IOException iOException) {
            LogSupport.ignore(log, iOException);
        }
    }

    public static Writer getNullWriter() {
        return __nullWriter;
    }

    private static class NullWrite
    extends Writer {
        private NullWrite() {
        }

        public void close() {
        }

        public void flush() {
        }

        public void write(char[] cArray) {
        }

        public void write(char[] cArray, int n, int n2) {
        }

        public void write(int n) {
        }

        public void write(String string) {
        }

        public void write(String string, int n, int n2) {
        }
    }

    private static class NullOS
    extends OutputStream {
        private NullOS() {
        }

        public void close() {
        }

        public void flush() {
        }

        public void write(byte[] byArray) {
        }

        public void write(byte[] byArray, int n, int n2) {
        }

        public void write(int n) {
        }
    }

    static class Job {
        InputStream in;
        OutputStream out;
        Reader read;
        Writer write;

        Job(InputStream inputStream, OutputStream outputStream) {
            this.in = inputStream;
            this.out = outputStream;
            this.read = null;
            this.write = null;
        }

        Job(Reader reader, Writer writer) {
            this.in = null;
            this.out = null;
            this.read = reader;
            this.write = writer;
        }
    }

    private static class Singleton {
        static final IO __instance = new IO();

        private Singleton() {
        }

        static {
            try {
                __instance.start();
            }
            catch (Exception exception) {
                log.fatal((Object)exception);
                System.exit(1);
            }
        }
    }
}

