/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.mortbay.util.ByteArrayOutputStream2;
import org.mortbay.util.IO;
import org.mortbay.util.Resource;

public class CachedResource
extends Resource {
    Resource _resource;
    long _lastModified;
    byte[] _buf;
    String[] _list;

    CachedResource(Resource resource) throws IOException {
        this._resource = resource;
        this.update();
    }

    public synchronized boolean isUptoDate() throws IOException {
        return this._resource != null && this._resource.exists() && this._resource.lastModified() == this._lastModified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean update() throws IOException {
        if (this._resource != null && !this._resource.exists()) {
            this.clear();
            return true;
        }
        long l = this._resource.lastModified();
        if (l == this._lastModified && (this._buf != null || this._list != null)) {
            return false;
        }
        this._lastModified = l;
        if (this._resource.isDirectory()) {
            this._list = this._resource.list();
        }
        if (this._list == null) {
            int n = (int)this._resource.length();
            if (n < 0) {
                n = 1024;
            }
            ByteArrayOutputStream2 byteArrayOutputStream2 = new ByteArrayOutputStream2(n);
            InputStream inputStream = this._resource.getInputStream();
            try {
                IO.copy(inputStream, byteArrayOutputStream2);
            }
            finally {
                inputStream.close();
            }
            this._buf = byteArrayOutputStream2.getBuf();
            if (this._buf.length != n) {
                this._buf = byteArrayOutputStream2.toByteArray();
            }
        }
        return true;
    }

    public synchronized void clear() {
        this._buf = null;
        this._list = null;
    }

    public void release() {
        this.clear();
        this._resource.release();
    }

    public synchronized boolean exists() {
        return this._buf != null || this._list != null;
    }

    public boolean isDirectory() {
        return this._list != null;
    }

    public long lastModified() {
        return this._lastModified;
    }

    public long length() {
        if (this._buf != null) {
            return this._buf.length;
        }
        return -1L;
    }

    public URL getURL() {
        return this._resource.getURL();
    }

    public File getFile() throws IOException {
        return this._resource.getFile();
    }

    public String getName() {
        return this._resource.getName();
    }

    public InputStream getInputStream() throws IOException {
        if (this._buf != null) {
            return new ByteArrayInputStream(this._buf);
        }
        return this._resource.getInputStream();
    }

    public OutputStream getOutputStream() throws IOException, SecurityException {
        return this._resource.getOutputStream();
    }

    public synchronized boolean delete() throws SecurityException {
        if (this._resource.delete()) {
            this.clear();
            return true;
        }
        return false;
    }

    public synchronized boolean renameTo(Resource resource) throws SecurityException {
        if (this._resource.renameTo(resource)) {
            this.clear();
            return true;
        }
        return false;
    }

    public String[] list() {
        return this._list;
    }

    public Resource addPath(String string) throws IOException, MalformedURLException {
        return this._resource.addPath(string);
    }

    public String toString() {
        return this._resource.toString();
    }

    public int hashCode() {
        return this._resource.hashCode();
    }

    public boolean equals(Object object) {
        return this._resource.equals(object);
    }

    public void writeTo(OutputStream outputStream, long l, long l2) throws IOException {
        if (l2 < 0L) {
            l2 = (long)this._buf.length - l;
        }
        if (this._buf != null) {
            outputStream.write(this._buf, (int)l, (int)l2);
        }
    }

    public byte[] getCachedData() {
        return this._buf;
    }

    public void setCachedData(byte[] byArray) {
        this._buf = byArray;
    }
}

