/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.Socket;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.HashSet;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mortbay.util.IO;
import org.mortbay.util.InetAddrPort;

public class ProxyServlet
implements Servlet {
    private int _tunnelTimeoutMs = 3000;
    protected HashSet _DontProxyHeaders = new HashSet();
    private ServletConfig config;
    private ServletContext context;

    public ProxyServlet() {
        this._DontProxyHeaders.add("proxy-connection");
        this._DontProxyHeaders.add("connection");
        this._DontProxyHeaders.add("keep-alive");
        this._DontProxyHeaders.add("transfer-encoding");
        this._DontProxyHeaders.add("te");
        this._DontProxyHeaders.add("trailer");
        this._DontProxyHeaders.add("proxy-authorization");
        this._DontProxyHeaders.add("proxy-authenticate");
        this._DontProxyHeaders.add("upgrade");
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        this.config = servletConfig;
        this.context = servletConfig.getServletContext();
    }

    public ServletConfig getServletConfig() {
        return this.config;
    }

    public void service(ServletRequest servletRequest, ServletResponse servletResponse) throws ServletException, IOException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
        if ("CONNECT".equalsIgnoreCase(httpServletRequest.getMethod())) {
            this.handleConnect(httpServletRequest, httpServletResponse);
        } else {
            Object object;
            String string;
            String string2;
            String string3 = httpServletRequest.getRequestURI();
            if (httpServletRequest.getQueryString() != null) {
                string3 = string3 + "?" + httpServletRequest.getQueryString();
            }
            URL uRL = new URL(httpServletRequest.getScheme(), httpServletRequest.getServerName(), httpServletRequest.getServerPort(), string3);
            this.context.log("URL=" + uRL);
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.setAllowUserInteraction(false);
            HttpURLConnection httpURLConnection = null;
            if (uRLConnection instanceof HttpURLConnection) {
                httpURLConnection = (HttpURLConnection)uRLConnection;
                httpURLConnection.setRequestMethod(httpServletRequest.getMethod());
                httpURLConnection.setInstanceFollowRedirects(false);
            }
            if ((string2 = httpServletRequest.getHeader("Connection")) != null && ((string2 = string2.toLowerCase()).equals("keep-alive") || string2.equals("close"))) {
                string2 = null;
            }
            boolean bl = false;
            boolean bl2 = false;
            Enumeration enumeration = httpServletRequest.getHeaderNames();
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                object = string.toLowerCase();
                if (this._DontProxyHeaders.contains(object) || string2 != null && string2.indexOf((String)object) >= 0) continue;
                if ("content-type".equals(object)) {
                    bl2 = true;
                }
                Enumeration enumeration2 = httpServletRequest.getHeaders(string);
                while (enumeration2.hasMoreElements()) {
                    String string4 = (String)enumeration2.nextElement();
                    if (string4 == null) continue;
                    uRLConnection.addRequestProperty(string, string4);
                    this.context.log("req " + string + ": " + string4);
                    bl |= "X-Forwarded-For".equalsIgnoreCase(string);
                }
            }
            uRLConnection.setRequestProperty("Via", "1.1 (jetty)");
            if (!bl) {
                uRLConnection.addRequestProperty("X-Forwarded-For", httpServletRequest.getRemoteAddr());
            }
            if ((string = httpServletRequest.getHeader("Cache-Control")) != null && (string.indexOf("no-cache") >= 0 || string.indexOf("no-store") >= 0)) {
                uRLConnection.setUseCaches(false);
            }
            try {
                uRLConnection.setDoInput(true);
                object = httpServletRequest.getInputStream();
                if (bl2) {
                    uRLConnection.setDoOutput(true);
                    IO.copy((InputStream)object, uRLConnection.getOutputStream());
                }
                uRLConnection.connect();
            }
            catch (Exception exception) {
                this.context.log("proxy", (Throwable)exception);
            }
            object = null;
            int n = 500;
            if (httpURLConnection != null) {
                object = httpURLConnection.getErrorStream();
                n = httpURLConnection.getResponseCode();
                httpServletResponse.setStatus(n, httpURLConnection.getResponseMessage());
                this.context.log("response = " + httpURLConnection.getResponseCode());
            }
            if (object == null) {
                try {
                    object = uRLConnection.getInputStream();
                }
                catch (Exception exception) {
                    this.context.log("stream", (Throwable)exception);
                    object = httpURLConnection.getErrorStream();
                }
            }
            httpServletResponse.setHeader("Date", null);
            httpServletResponse.setHeader("Server", null);
            int n2 = 0;
            String string5 = uRLConnection.getHeaderFieldKey(n2);
            String string6 = uRLConnection.getHeaderField(n2);
            while (string5 != null || string6 != null) {
                String string7;
                String string8 = string7 = string5 != null ? string5.toLowerCase() : null;
                if (string5 != null && string6 != null && !this._DontProxyHeaders.contains(string7)) {
                    httpServletResponse.addHeader(string5, string6);
                }
                this.context.log("res " + string5 + ": " + string6);
                string5 = uRLConnection.getHeaderFieldKey(++n2);
                string6 = uRLConnection.getHeaderField(n2);
            }
            httpServletResponse.addHeader("Via", "1.1 (jetty)");
            if (object != null) {
                IO.copy((InputStream)object, (OutputStream)httpServletResponse.getOutputStream());
            }
        }
    }

    public void handleConnect(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        String string = httpServletRequest.getRequestURI();
        this.context.log("CONNECT: " + string);
        InetAddrPort inetAddrPort = new InetAddrPort(string);
        ServletInputStream servletInputStream = httpServletRequest.getInputStream();
        ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
        Socket socket = new Socket(inetAddrPort.getInetAddress(), inetAddrPort.getPort());
        this.context.log("Socket: " + socket);
        httpServletResponse.setStatus(200);
        httpServletResponse.setHeader("Connection", "close");
        httpServletResponse.flushBuffer();
        System.err.println(httpServletResponse);
        this.context.log("out<-in");
        IO.copyThread(socket.getInputStream(), (OutputStream)servletOutputStream);
        this.context.log("in->out");
        IO.copy((InputStream)servletInputStream, socket.getOutputStream());
    }

    public String getServletInfo() {
        return "Proxy Servlet";
    }

    public void destroy() {
    }
}

