/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.servlet;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.mortbay.log.LogFactory;
import org.mortbay.util.LineInput;
import org.mortbay.util.MultiMap;
import org.mortbay.util.StringUtil;

public class MultiPartRequest {
    private static Log log = LogFactory.getLog(MultiPartRequest.class);
    HttpServletRequest _request;
    LineInput _in;
    String _boundary;
    String _encoding;
    byte[] _byteBoundary;
    MultiMap _partMap = new MultiMap(10);
    int _char = -2;
    boolean _lastPart = false;

    public MultiPartRequest(HttpServletRequest httpServletRequest) throws IOException {
        this._request = httpServletRequest;
        String string = httpServletRequest.getHeader("Content-Type");
        if (!string.startsWith("multipart/form-data")) {
            throw new IOException("Not multipart/form-data request");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Multipart content type = " + string));
        }
        this._encoding = httpServletRequest.getCharacterEncoding();
        this._in = this._encoding != null ? new LineInput((InputStream)httpServletRequest.getInputStream(), 2048, this._encoding) : new LineInput((InputStream)httpServletRequest.getInputStream());
        this._boundary = "--" + this.value(string.substring(string.indexOf("boundary=")));
        if (log.isDebugEnabled()) {
            log.debug((Object)("Boundary=" + this._boundary));
        }
        this._byteBoundary = (this._boundary + "--").getBytes(StringUtil.__ISO_8859_1);
        this.loadAllParts();
    }

    public String[] getPartNames() {
        Set set = this._partMap.keySet();
        return set.toArray(new String[set.size()]);
    }

    public boolean contains(String string) {
        Part part = (Part)this._partMap.get(string);
        return part != null;
    }

    public String getString(String string) {
        List list = this._partMap.getValues(string);
        if (list == null) {
            return null;
        }
        if (this._encoding != null) {
            try {
                return new String(((Part)list.get((int)0))._data, this._encoding);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Invalid character set: " + unsupportedEncodingException));
                }
                return null;
            }
        }
        return new String(((Part)list.get((int)0))._data);
    }

    public String[] getStrings(String string) {
        List list = this._partMap.getValues(string);
        if (list == null) {
            return null;
        }
        String[] stringArray = new String[list.size()];
        if (this._encoding == null) {
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = new String(((Part)list.get((int)i))._data);
            }
        } else {
            try {
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray[i] = new String(((Part)list.get((int)i))._data, this._encoding);
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Invalid character set: " + unsupportedEncodingException));
                }
                return null;
            }
        }
        return stringArray;
    }

    public InputStream getInputStream(String string) {
        List list = this._partMap.getValues(string);
        if (list == null) {
            return null;
        }
        return new ByteArrayInputStream(((Part)list.get((int)0))._data);
    }

    public InputStream[] getInputStreams(String string) {
        List list = this._partMap.getValues(string);
        if (list == null) {
            return null;
        }
        InputStream[] inputStreamArray = new InputStream[list.size()];
        for (int i = 0; i < inputStreamArray.length; ++i) {
            inputStreamArray[i] = new ByteArrayInputStream(((Part)list.get((int)i))._data);
        }
        return inputStreamArray;
    }

    public Hashtable getParams(String string) {
        List list = this._partMap.getValues(string);
        if (list == null) {
            return null;
        }
        return ((Part)list.get((int)0))._headers;
    }

    public Hashtable[] getMultipleParams(String string) {
        List list = this._partMap.getValues(string);
        if (list == null) {
            return null;
        }
        Hashtable[] hashtableArray = new Hashtable[list.size()];
        for (int i = 0; i < hashtableArray.length; ++i) {
            hashtableArray[i] = ((Part)list.get((int)i))._headers;
        }
        return hashtableArray;
    }

    public String getFilename(String string) {
        List list = this._partMap.getValues(string);
        if (list == null) {
            return null;
        }
        return ((Part)list.get((int)0))._filename;
    }

    public String[] getFilenames(String string) {
        List list = this._partMap.getValues(string);
        if (list == null) {
            return null;
        }
        String[] stringArray = new String[list.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = ((Part)list.get((int)i))._filename;
        }
        return stringArray;
    }

    private void loadAllParts() throws IOException {
        String string = this._in.readLine();
        if (!string.equals(this._boundary)) {
            log.warn((Object)string);
            throw new IOException("Missing initial multi part boundary");
        }
        while (!this._lastPart) {
            String string2;
            String string3;
            Object object;
            int n;
            Part part = new Part();
            String string4 = null;
            while ((string = this._in.readLine()) != null && string.length() != 0) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("LINE=" + string));
                }
                if ((n = string.indexOf(58, 0)) <= 0) continue;
                object = string.substring(0, n).trim().toLowerCase();
                string3 = string.substring(n + 1, string.length()).trim();
                string2 = (String)part._headers.get(object);
                part._headers.put(object, string2 != null ? string2 + ';' + string3 : string3);
                if (log.isDebugEnabled()) {
                    log.debug((Object)((String)object + ": " + string3));
                }
                if (!((String)object).equals("content-disposition")) continue;
                string4 = string3;
            }
            n = 0;
            if (string4 == null) {
                throw new IOException("Missing content-disposition");
            }
            object = new StringTokenizer(string4, ";");
            while (((StringTokenizer)object).hasMoreTokens()) {
                string3 = ((StringTokenizer)object).nextToken().trim();
                string2 = string3.toLowerCase();
                if (string3.startsWith("form-data")) {
                    n = 1;
                    continue;
                }
                if (string2.startsWith("name=")) {
                    part._name = this.value(string3);
                    continue;
                }
                if (!string2.startsWith("filename=")) continue;
                part._filename = this.value(string3);
            }
            if (n == 0) {
                log.warn((Object)"Non form-data part in multipart/form-data");
                continue;
            }
            if (part._name == null || part._name.length() == 0) {
                log.warn((Object)"Part with no name in multipart/form-data");
                continue;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("name=" + part._name));
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("filename=" + part._filename));
            }
            this._partMap.add(part._name, part);
            part._data = this.readBytes();
        }
    }

    private byte[] readBytes() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        boolean bl = false;
        boolean bl2 = false;
        while (true) {
            int n;
            int n2 = 0;
            while ((n = this._char != -2 ? this._char : this._in.read()) != -1) {
                this._char = -2;
                if (n == 13 || n == 10) {
                    if (n != 13) break;
                    this._char = this._in.read();
                    break;
                }
                if (n2 >= 0 && n2 < this._byteBoundary.length && n == this._byteBoundary[n2]) {
                    ++n2;
                    continue;
                }
                if (bl) {
                    byteArrayOutputStream.write(13);
                }
                if (bl2) {
                    byteArrayOutputStream.write(10);
                }
                bl2 = false;
                bl = false;
                if (n2 > 0) {
                    byteArrayOutputStream.write(this._byteBoundary, 0, n2);
                }
                n2 = -1;
                byteArrayOutputStream.write(n);
            }
            if (n2 > 0 && n2 < this._byteBoundary.length - 2 || n2 == this._byteBoundary.length - 1) {
                if (bl) {
                    byteArrayOutputStream.write(13);
                }
                if (bl2) {
                    byteArrayOutputStream.write(10);
                }
                bl2 = false;
                bl = false;
                byteArrayOutputStream.write(this._byteBoundary, 0, n2);
                n2 = -1;
            }
            if (n2 > 0 || n == -1) {
                if (n2 == this._byteBoundary.length) {
                    this._lastPart = true;
                }
                if (this._char != 10) break;
                this._char = -2;
                break;
            }
            if (bl) {
                byteArrayOutputStream.write(13);
            }
            if (bl2) {
                byteArrayOutputStream.write(10);
            }
            bl = n == 13;
            boolean bl3 = bl2 = n == 10 || this._char == 10;
            if (this._char != 10) continue;
            this._char = -2;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)byteArrayOutputStream.toString());
        }
        return byteArrayOutputStream.toByteArray();
    }

    private String value(String string) {
        String string2 = string.substring(string.indexOf(61) + 1).trim();
        int n = string2.indexOf(59);
        if (n > 0) {
            string2 = string2.substring(0, n);
        }
        if (string2.startsWith("\"")) {
            string2 = string2.substring(1, string2.indexOf(34, 1));
        } else {
            n = string2.indexOf(32);
            if (n > 0) {
                string2 = string2.substring(0, n);
            }
        }
        return string2;
    }

    private class Part {
        String _name = null;
        String _filename = null;
        Hashtable _headers = new Hashtable(10);
        byte[] _data = null;

        private Part() {
        }
    }
}

