/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.servlet;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.logging.Log;
import org.mortbay.log.LogFactory;
import org.mortbay.util.IO;
import org.mortbay.util.LineInput;
import org.mortbay.util.MultiMap;
import org.mortbay.util.StringUtil;

public class MultiPartFilter
implements Filter {
    private static Log log = LogFactory.getLog(MultiPartFilter.class);
    private File tempdir;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.tempdir = (File)filterConfig.getServletContext().getAttribute("javax.servlet.context.tempdir");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        if (httpServletRequest.getContentType() == null || !httpServletRequest.getContentType().startsWith("multipart/form-data")) {
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        LineInput lineInput = new LineInput((InputStream)servletRequest.getInputStream());
        String string = httpServletRequest.getContentType();
        String string2 = "--" + this.value(string.substring(string.indexOf("boundary=")));
        byte[] byArray = (string2 + "--").getBytes(StringUtil.__ISO_8859_1);
        MultiMap multiMap = new MultiMap();
        String string3 = lineInput.readLine();
        if (!string3.equals(string2)) {
            log.warn((Object)string3);
            throw new IOException("Missing initial multi part boundary");
        }
        boolean bl = false;
        String string4 = null;
        while (!bl) {
            Object object;
            Object object2;
            String string5;
            Object object3;
            int n;
            while ((string3 = lineInput.readLine()) != null && string3.length() != 0) {
                n = string3.indexOf(58, 0);
                if (n <= 0) continue;
                object3 = string3.substring(0, n).trim().toLowerCase();
                string5 = string3.substring(n + 1, string3.length()).trim();
                if (!((String)object3).equals("content-disposition")) continue;
                string4 = string5;
            }
            n = 0;
            if (string4 == null) {
                throw new IOException("Missing content-disposition");
            }
            object3 = new StringTokenizer(string4, ";");
            string5 = null;
            String string6 = null;
            while (((StringTokenizer)object3).hasMoreTokens()) {
                object2 = ((StringTokenizer)object3).nextToken().trim();
                object = ((String)object2).toLowerCase();
                if (((String)object2).startsWith("form-data")) {
                    n = 1;
                    continue;
                }
                if (((String)object).startsWith("name=")) {
                    string5 = this.value((String)object2);
                    continue;
                }
                if (!((String)object).startsWith("filename=")) continue;
                string6 = this.value((String)object2);
            }
            if (n == 0) {
                log.warn((Object)"Non form-data part in multipart/form-data");
                continue;
            }
            if (string5 == null || string5.length() == 0) {
                log.warn((Object)"Part with no name in multipart/form-data");
                continue;
            }
            object2 = null;
            object = null;
            try {
                if (string6 != null && string6.length() > 0) {
                    object = File.createTempFile("MultiPart", "", this.tempdir);
                    object2 = new FileOutputStream((File)object);
                    servletRequest.setAttribute(string5, object);
                    multiMap.put(string5, string6);
                } else {
                    object2 = new ByteArrayOutputStream();
                }
                int n2 = -2;
                boolean bl2 = false;
                boolean bl3 = false;
                while (true) {
                    int n3;
                    int n4 = 0;
                    while ((n3 = n2 != -2 ? n2 : lineInput.read()) != -1) {
                        n2 = -2;
                        if (n3 == 13 || n3 == 10) {
                            if (n3 != 13) break;
                            n2 = lineInput.read();
                            break;
                        }
                        if (n4 >= 0 && n4 < byArray.length && n3 == byArray[n4]) {
                            ++n4;
                            continue;
                        }
                        if (bl2) {
                            ((OutputStream)object2).write(13);
                        }
                        if (bl3) {
                            ((OutputStream)object2).write(10);
                        }
                        bl3 = false;
                        bl2 = false;
                        if (n4 > 0) {
                            ((OutputStream)object2).write(byArray, 0, n4);
                        }
                        n4 = -1;
                        ((OutputStream)object2).write(n3);
                    }
                    if (n4 > 0 && n4 < byArray.length - 2 || n4 == byArray.length - 1) {
                        if (bl2) {
                            ((OutputStream)object2).write(13);
                        }
                        if (bl3) {
                            ((OutputStream)object2).write(10);
                        }
                        bl3 = false;
                        bl2 = false;
                        ((OutputStream)object2).write(byArray, 0, n4);
                        n4 = -1;
                    }
                    if (n4 > 0 || n3 == -1) {
                        if (n4 == byArray.length) {
                            bl = true;
                        }
                        if (n2 == 10) {
                            n2 = -2;
                        }
                        break;
                    }
                    if (bl2) {
                        ((OutputStream)object2).write(13);
                    }
                    if (bl3) {
                        ((OutputStream)object2).write(10);
                    }
                    bl2 = n3 == 13;
                    boolean bl4 = bl3 = n3 == 10 || n2 == 10;
                    if (n2 != 10) continue;
                    n2 = -2;
                }
            }
            finally {
                IO.close((OutputStream)object2);
            }
            if (object != null) continue;
            byte[] byArray2 = ((ByteArrayOutputStream)object2).toByteArray();
            multiMap.add(string5, byArray2);
        }
        filterChain.doFilter((ServletRequest)new Wrapper(httpServletRequest, multiMap), servletResponse);
    }

    private String value(String string) {
        String string2 = string.substring(string.indexOf(61) + 1).trim();
        int n = string2.indexOf(59);
        if (n > 0) {
            string2 = string2.substring(0, n);
        }
        if (string2.startsWith("\"")) {
            string2 = string2.substring(1, string2.indexOf(34, 1));
        } else {
            n = string2.indexOf(32);
            if (n > 0) {
                string2 = string2.substring(0, n);
            }
        }
        return string2;
    }

    public void destroy() {
    }

    private static class Wrapper
    extends HttpServletRequestWrapper {
        String encoding = "UTF-8";
        MultiMap map;

        public Wrapper(HttpServletRequest httpServletRequest, MultiMap multiMap) {
            super(httpServletRequest);
            this.map = multiMap;
        }

        public int getContentLength() {
            return 0;
        }

        public String getParameter(String string) {
            Object object = this.map.get(string);
            if (object instanceof byte[]) {
                try {
                    String string2 = new String((byte[])object, this.encoding);
                    return string2;
                }
                catch (Exception exception) {
                    log.warn((Object)exception);
                }
            } else if (object instanceof String) {
                return (String)object;
            }
            return null;
        }

        public Map getParameterMap() {
            return this.map;
        }

        public Enumeration getParameterNames() {
            return Collections.enumeration(this.map.keySet());
        }

        public String[] getParameterValues(String string) {
            List list = this.map.getValues(string);
            if (list == null || list.size() == 0) {
                return new String[0];
            }
            String[] stringArray = new String[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                Object e = list.get(i);
                if (e instanceof byte[]) {
                    try {
                        stringArray[i] = new String((byte[])e, this.encoding);
                    }
                    catch (Exception exception) {
                        log.warn((Object)exception);
                    }
                    continue;
                }
                if (!(e instanceof String)) continue;
                stringArray[i] = (String)e;
            }
            return stringArray;
        }

        public void setCharacterEncoding(String string) throws UnsupportedEncodingException {
            this.encoding = string;
        }
    }
}

