/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.log;

import java.io.PrintStream;
import org.apache.commons.logging.Log;
import org.mortbay.log.LogFactory;
import org.mortbay.util.ByteArrayOutputStream2;

public class LogStream
extends PrintStream {
    static final PrintStream STDERR_STREAM = System.err;
    static final PrintStream STDOUT_STREAM = System.out;
    private String tag;
    private Log log;
    private ByteArrayOutputStream2 bout;

    public static void setLogStdErr(boolean bl) {
        if (bl) {
            if (!(System.err instanceof LogStream)) {
                System.setErr(new STDERR());
            }
        } else {
            System.setErr(STDERR_STREAM);
        }
    }

    public static boolean getLogStdErr() {
        return System.err instanceof LogStream;
    }

    public static void setLogStdOut(boolean bl) {
        if (bl) {
            if (!(System.out instanceof LogStream)) {
                System.setOut(new STDOUT());
            }
        } else {
            System.setOut(STDOUT_STREAM);
        }
    }

    public static boolean getLogStdOut() {
        return System.out instanceof LogStream;
    }

    public void flush() {
        String string;
        super.flush();
        if (this.bout.size() > 0 && (string = new String(this.bout.getBuf(), 0, this.bout.size()).trim()).length() > 0 && this.log != null) {
            this.log.info((Object)(this.tag + ": " + string));
        }
        this.bout.reset();
    }

    public LogStream(String string, Log log) {
        super(new ByteArrayOutputStream2(128), true);
        this.bout = (ByteArrayOutputStream2)this.out;
        this.tag = string;
        this.log = log;
    }

    public void close() {
        this.flush();
        super.close();
    }

    public void println() {
        super.println();
        this.flush();
    }

    public void println(boolean bl) {
        super.println(bl);
        this.flush();
    }

    public void println(char c) {
        super.println(c);
        this.flush();
    }

    public void println(char[] cArray) {
        super.println(cArray);
        this.flush();
    }

    public void println(double d) {
        super.println(d);
        this.flush();
    }

    public void println(float f) {
        super.println(f);
        this.flush();
    }

    public void println(int n) {
        super.println(n);
        this.flush();
    }

    public void println(long l) {
        super.println(l);
        this.flush();
    }

    public void println(Object object) {
        super.println(object);
        this.flush();
    }

    public void println(String string) {
        super.println(string);
        this.flush();
    }

    public void write(byte[] byArray, int n, int n2) {
        super.write(byArray, n, n2);
        this.flush();
    }

    public static class STDOUT
    extends LogStream {
        STDOUT() {
            super("STDOUT ", LogFactory.getLog("stdout"));
        }
    }

    public static class STDERR
    extends LogStream {
        STDERR() {
            super("STDERR ", LogFactory.getLog("stderr"));
        }
    }
}

