/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.win32;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.mortbay.http.HttpServer;
import org.mortbay.jetty.Server;
import org.mortbay.log.LogFactory;

public class Service {
    private static Log log = LogFactory.getLog(Service.class);
    static String serviceLogFile = System.getProperty("SERVICE_LOG_FILE", "logs" + File.separator + "yyyy_mm_dd.service.log");
    public static final int SERVICE_CONTROL_STOP = 1;
    public static final int SERVICE_CONTROL_PAUSE = 2;
    public static final int SERVICE_CONTROL_CONTINUE = 3;
    public static final int SERVICE_CONTROL_INTERROGATE = 4;
    public static final int SERVICE_CONTROL_SHUTDOWN = 5;
    public static final int SERVICE_CONTROL_PARAMCHANGE = 6;
    private static Vector _servers;
    private static Vector _configs;

    private Service() {
    }

    public static void dispatchSCMEvent(int n) {
        switch (n) {
            case 1: 
            case 2: {
                Service.stopAll();
                break;
            }
            case 3: {
                Service.startAll();
                break;
            }
            case 5: {
                Service.destroyAll();
                break;
            }
            case 6: {
                Service.stopAll();
                Service.destroyAll();
                Service.createAll();
                Service.startAll();
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createAll() {
        if (_configs != null) {
            Vector vector = _configs;
            synchronized (vector) {
                _servers = new Vector();
                for (int i = 0; i < _configs.size(); ++i) {
                    try {
                        Server server = new Server((String)_configs.get(i));
                        _servers.add(server);
                        continue;
                    }
                    catch (Exception exception) {
                        log.warn((Object)(_configs.get(i) + " configuration problem: "), (Throwable)exception);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void startAll() {
        block6: {
            try {
                if (_configs == null) break block6;
                Vector vector = _configs;
                synchronized (vector) {
                    for (int i = 0; i < _servers.size(); ++i) {
                        HttpServer httpServer = (HttpServer)_servers.get(i);
                        if (httpServer.isStarted()) continue;
                        httpServer.start();
                    }
                }
            }
            catch (Exception exception) {
                log.warn((Object)"EXCEPTION ", (Throwable)exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void stopAll() {
        if (_configs != null) {
            Vector vector = _configs;
            synchronized (vector) {
                for (int i = 0; i < _servers.size(); ++i) {
                    HttpServer httpServer = (HttpServer)_servers.get(i);
                    try {
                        httpServer.stop();
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private static void destroyAll() {
        Service.stopAll();
        if (_servers != null) {
            _servers.clear();
        }
        _servers = null;
    }

    public static void stopAndDestroy(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            Service.stopAll();
            Service.destroyAll();
        } else {
            log.warn((Object)"NOT IMPLEMENTED ");
        }
    }

    public static void main(String[] stringArray) {
        PrintStream printStream;
        String string = System.getProperty("SERVICE_OUT");
        if (string != null) {
            try {
                printStream = new PrintStream(new FileOutputStream(string));
                System.setOut(printStream);
            }
            catch (Exception exception) {
                log.warn((Object)"EXCEPTION ", (Throwable)exception);
            }
        }
        if ((string = System.getProperty("SERVICE_ERR")) != null) {
            try {
                printStream = new PrintStream(new FileOutputStream(string));
                System.setErr(printStream);
            }
            catch (Exception exception) {
                log.warn((Object)"EXCEPTION ", (Throwable)exception);
            }
        }
        if (stringArray.length == 0) {
            stringArray = new String[]{"etc/jetty.xml"};
        }
        try {
            _configs = new Vector();
            for (int i = 0; i < stringArray.length; ++i) {
                _configs.add(stringArray[i]);
            }
            Service.createAll();
            Service.startAll();
        }
        catch (Exception exception) {
            log.warn((Object)"EXCEPTION ", (Throwable)exception);
        }
    }
}

