/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.servlet;

import java.io.IOException;
import java.security.Principal;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.SingleThreadModel;
import javax.servlet.UnavailableException;
import org.apache.commons.logging.Log;
import org.mortbay.http.HttpRequest;
import org.mortbay.http.UserRealm;
import org.mortbay.jetty.servlet.Holder;
import org.mortbay.jetty.servlet.ServletHandler;
import org.mortbay.log.LogFactory;

public class ServletHolder
extends Holder
implements Comparable {
    private static Log log = LogFactory.getLog(ServletHolder.class);
    private int _initOrder;
    private boolean _initOnStartup = false;
    private Map _roleMap;
    private String _forcedPath;
    private String _runAs;
    private UserRealm _realm;
    private transient Stack _servlets;
    private transient Servlet _servlet;
    private transient Config _config;
    private transient long _unavailable;
    private transient UnavailableException _unavailableEx;

    public ServletHolder() {
    }

    public ServletHolder(ServletHandler servletHandler, String string, String string2) {
        super(servletHandler, string == null ? string2 : string, string2);
    }

    public ServletHolder(ServletHandler servletHandler, String string, String string2, String string3) {
        this(servletHandler, string == null ? string2 : string, string2);
        this._forcedPath = string3;
    }

    public int getInitOrder() {
        return this._initOrder;
    }

    public void setInitOrder(int n) {
        this._initOnStartup = true;
        this._initOrder = n;
    }

    public int compareTo(Object object) {
        if (object instanceof ServletHolder) {
            ServletHolder servletHolder = (ServletHolder)object;
            if (servletHolder == this) {
                return 0;
            }
            if (servletHolder._initOrder < this._initOrder) {
                return 1;
            }
            if (servletHolder._initOrder > this._initOrder) {
                return -1;
            }
            int n = this._className.compareTo(servletHolder._className);
            if (n == 0) {
                n = this._name.compareTo(servletHolder._name);
            }
            if (n == 0) {
                n = this.hashCode() > object.hashCode() ? 1 : -1;
            }
            return n;
        }
        return 1;
    }

    public boolean equals(Object object) {
        return this.compareTo(object) == 0;
    }

    public int hashCode() {
        return this._name.hashCode();
    }

    public ServletContext getServletContext() {
        return ((ServletHandler)this._httpHandler).getServletContext();
    }

    public synchronized void setUserRoleLink(String string, String string2) {
        if (this._roleMap == null) {
            this._roleMap = new HashMap();
        }
        this._roleMap.put(string, string2);
    }

    public String getUserRoleLink(String string) {
        if (this._roleMap == null) {
            return string;
        }
        String string2 = (String)this._roleMap.get(string);
        return string2 == null ? string : string2;
    }

    public void setRunAs(String string) {
        this._runAs = string;
    }

    public String getRunAs() {
        return this._runAs;
    }

    public void start() throws Exception {
        this._unavailable = 0L;
        super.start();
        if (!Servlet.class.isAssignableFrom(this._class)) {
            IllegalStateException illegalStateException = new IllegalStateException("Servlet " + this._class + " is not a javax.servlet.Servlet");
            super.stop();
            throw illegalStateException;
        }
        this._config = new Config();
        if (this._runAs != null) {
            this._realm = this._httpHandler.getHttpContext().getRealm();
        }
        if (SingleThreadModel.class.isAssignableFrom(this._class)) {
            this._servlets = new Stack();
        }
        if (this._initOnStartup) {
            this._servlet = (Servlet)this.newInstance();
            try {
                this.initServlet(this._servlet, this._config);
            }
            catch (Throwable throwable) {
                this._servlet = null;
                this._config = null;
                if (throwable instanceof Exception) {
                    throw (Exception)throwable;
                }
                if (throwable instanceof Error) {
                    throw (Error)throwable;
                }
                throw new ServletException(throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        block6: {
            Principal principal = null;
            try {
                if (this._runAs != null && this._realm != null) {
                    principal = this._realm.pushRole(null, this._runAs);
                }
                if (this._servlet != null) {
                    this._servlet.destroy();
                }
                this._servlet = null;
                while (this._servlets != null && this._servlets.size() > 0) {
                    Servlet servlet = (Servlet)this._servlets.pop();
                    servlet.destroy();
                }
                this._config = null;
                Object var4_3 = null;
                super.stop();
                if (this._runAs == null || this._realm == null || principal == null) break block6;
                this._realm.popRole(principal);
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                super.stop();
                if (this._runAs != null && this._realm != null && principal != null) {
                    this._realm.popRole(principal);
                }
                throw throwable;
            }
            {
            }
        }
    }

    public synchronized Servlet getServlet() throws ServletException {
        if (this._unavailable != 0L) {
            if (this._unavailable < 0L || this._unavailable > 0L && System.currentTimeMillis() < this._unavailable) {
                throw this._unavailableEx;
            }
            this._unavailable = 0L;
            this._unavailableEx = null;
        }
        try {
            if (this._servlets != null) {
                Servlet servlet = null;
                if (this._servlets.size() == 0) {
                    servlet = (Servlet)this.newInstance();
                    if (this._config == null) {
                        this._config = new Config();
                    }
                    this.initServlet(servlet, this._config);
                } else {
                    servlet = (Servlet)this._servlets.pop();
                }
                return servlet;
            }
            if (this._servlet == null) {
                this._servlet = (Servlet)this.newInstance();
                if (this._config == null) {
                    this._config = new Config();
                }
                this.initServlet(this._servlet, this._config);
            }
            return this._servlet;
        }
        catch (UnavailableException unavailableException) {
            this._servlet = null;
            this._config = null;
            return this.makeUnavailable(unavailableException);
        }
        catch (ServletException servletException) {
            this._servlet = null;
            this._config = null;
            throw servletException;
        }
        catch (Throwable throwable) {
            this._servlet = null;
            this._config = null;
            throw new ServletException("init", throwable);
        }
    }

    private Servlet makeUnavailable(UnavailableException unavailableException) throws UnavailableException {
        this._unavailableEx = unavailableException;
        this._unavailable = -1L;
        this._unavailable = unavailableException.isPermanent() ? -1L : (this._unavailableEx.getUnavailableSeconds() > 0 ? System.currentTimeMillis() + (long)(1000 * this._unavailableEx.getUnavailableSeconds()) : System.currentTimeMillis() + 5000L);
        throw this._unavailableEx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initServlet(Servlet servlet, ServletConfig servletConfig) throws ServletException {
        block4: {
            Principal principal = null;
            try {
                if (this._runAs != null && this._realm != null) {
                    principal = this._realm.pushRole(null, this._runAs);
                }
                servlet.init(servletConfig);
                Object var5_4 = null;
                if (this._runAs == null || this._realm == null || principal == null) break block4;
                this._realm.popRole(principal);
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                if (this._runAs != null && this._realm != null && principal != null) {
                    this._realm.popRole(principal);
                }
                throw throwable;
            }
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void handle(ServletRequest servletRequest, ServletResponse servletResponse) throws ServletException, UnavailableException, IOException {
        Servlet servlet;
        block19: {
            if (this._class == null) {
                throw new UnavailableException("Servlet Not Initialized");
            }
            Servlet servlet2 = servlet = !this._initOnStartup || this._servlets != null ? this.getServlet() : this._servlet;
            if (servlet == null) {
                throw new UnavailableException("Could not instantiate " + this._class);
            }
            boolean bl = true;
            Principal principal = null;
            HttpRequest httpRequest = null;
            try {
                try {
                    if (this._forcedPath != null) {
                        servletRequest.setAttribute("org.apache.catalina.jsp_file", (Object)this._forcedPath);
                    }
                    if (this._runAs != null && this._realm != null) {
                        httpRequest = this.getHttpContext().getHttpConnection().getRequest();
                        principal = this._realm.pushRole(httpRequest.getUserPrincipal(), this._runAs);
                        httpRequest.setUserPrincipal(principal);
                    }
                    servlet.service(servletRequest, servletResponse);
                    bl = false;
                }
                catch (UnavailableException unavailableException) {
                    if (this._servlets != null && servlet != null) {
                        this.stop();
                    }
                    this.makeUnavailable(unavailableException);
                    Object var9_8 = null;
                    if (this._runAs != null && this._realm != null && principal != null) {
                        principal = this._realm.popRole(principal);
                        httpRequest.setUserPrincipal(principal);
                    }
                    if (bl) {
                        servletRequest.setAttribute("javax.servlet.error.servlet_name", (Object)this.getName());
                    }
                    ServletHolder servletHolder2 = this;
                    synchronized (servletHolder2) {
                        if (this._servlets == null) return;
                        if (servlet == null) return;
                        this._servlets.push(servlet);
                        return;
                    }
                }
                Object var9_7 = null;
                if (this._runAs != null && this._realm != null && principal != null) {
                    principal = this._realm.popRole(principal);
                    httpRequest.setUserPrincipal(principal);
                }
                if (!bl) break block19;
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                if (this._runAs != null && this._realm != null && principal != null) {
                    principal = this._realm.popRole(principal);
                    httpRequest.setUserPrincipal(principal);
                }
                if (bl) {
                    servletRequest.setAttribute("javax.servlet.error.servlet_name", (Object)this.getName());
                }
                ServletHolder servletHolder = this;
                synchronized (servletHolder) {
                    if (this._servlets == null) throw throwable;
                    if (servlet == null) throw throwable;
                    this._servlets.push(servlet);
                    throw throwable;
                }
            }
            servletRequest.setAttribute("javax.servlet.error.servlet_name", (Object)this.getName());
        }
        ServletHolder servletHolder = this;
        synchronized (servletHolder) {
            if (this._servlets == null) return;
            if (servlet == null) return;
            this._servlets.push(servlet);
            return;
        }
    }

    class Config
    implements ServletConfig {
        Config() {
        }

        public String getServletName() {
            return ServletHolder.this.getName();
        }

        public ServletContext getServletContext() {
            return ((ServletHandler)ServletHolder.this._httpHandler).getServletContext();
        }

        public String getInitParameter(String string) {
            return ServletHolder.this.getInitParameter(string);
        }

        public Enumeration getInitParameterNames() {
            return ServletHolder.this.getInitParameterNames();
        }
    }
}

