/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.servlet;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.mortbay.http.EOFException;
import org.mortbay.http.HttpContext;
import org.mortbay.http.HttpException;
import org.mortbay.http.HttpHandler;
import org.mortbay.http.HttpRequest;
import org.mortbay.http.HttpResponse;
import org.mortbay.http.PathMap;
import org.mortbay.http.Version;
import org.mortbay.jetty.servlet.Dispatcher;
import org.mortbay.jetty.servlet.HashSessionManager;
import org.mortbay.jetty.servlet.ServletHolder;
import org.mortbay.jetty.servlet.ServletHttpRequest;
import org.mortbay.jetty.servlet.ServletHttpResponse;
import org.mortbay.jetty.servlet.SessionManager;
import org.mortbay.jetty.servlet.WebApplicationContext;
import org.mortbay.log.LogFactory;
import org.mortbay.util.ByteArrayISO8859Writer;
import org.mortbay.util.Container;
import org.mortbay.util.LogSupport;
import org.mortbay.util.MultiException;
import org.mortbay.util.Resource;
import org.mortbay.util.URI;

public class ServletHandler
extends Container
implements HttpHandler {
    private static Log log = LogFactory.getLog(ServletHandler.class);
    public static final String __DEFAULT_SERVLET = "default";
    public static final String __J_S_CONTEXT_TEMPDIR = "javax.servlet.context.tempdir";
    public static final String __J_S_ERROR_EXCEPTION = "javax.servlet.error.exception";
    public static final String __J_S_ERROR_EXCEPTION_TYPE = "javax.servlet.error.exception_type";
    public static final String __J_S_ERROR_MESSAGE = "javax.servlet.error.message";
    public static final String __J_S_ERROR_REQUEST_URI = "javax.servlet.error.request_uri";
    public static final String __J_S_ERROR_SERVLET_NAME = "javax.servlet.error.servlet_name";
    public static final String __J_S_ERROR_STATUS_CODE = "javax.servlet.error.status_code";
    private static final boolean __Slosh2Slash = File.separatorChar == '\\';
    private static String __AllowString = "GET, HEAD, POST, OPTIONS, TRACE";
    private boolean _usingCookies = true;
    private boolean _autoInitializeServlets = true;
    private String _name;
    protected PathMap _servletMap = new PathMap();
    protected Map _nameMap = new HashMap();
    protected Map _attributes = new HashMap(3);
    protected String _formLoginPage;
    protected String _formErrorPage;
    protected SessionManager _sessionManager;
    protected transient Context _context = new Context();
    protected transient ClassLoader _loader;
    protected transient Log _contextLog;
    protected transient HttpContext _httpContext;

    public void setName(String string) {
        this._name = string;
    }

    public String getName() {
        if (this._name == null) {
            this._name = this.getClass().getName();
            if (!log.isDebugEnabled()) {
                this._name = this._name.substring(this._name.lastIndexOf(46) + 1);
            }
        }
        return this._name;
    }

    public HttpContext getHttpContext() {
        return this._httpContext;
    }

    public void initialize(HttpContext httpContext) {
        SessionManager sessionManager = this.getSessionManager();
        if (this._httpContext != null && this._httpContext != httpContext) {
            throw new IllegalStateException("Can't initialize handler for different context");
        }
        this._httpContext = httpContext;
        sessionManager.initialize(this);
    }

    public void formAuthInit(String string, String string2) {
        this._formLoginPage = string;
        this._formErrorPage = string2;
    }

    public void setSessionManager(SessionManager sessionManager) {
        if (this.isStarted()) {
            throw new IllegalStateException("Started");
        }
        int n = 0;
        boolean bl = false;
        if (this._sessionManager != null) {
            n = this._sessionManager.getMaxInactiveInterval();
            bl = true;
            if (this.getHttpContext() != null) {
                this._sessionManager.initialize(null);
            }
            this.removeComponent(this._sessionManager);
        }
        this._sessionManager = sessionManager;
        if (this._sessionManager != null) {
            if (this.getHttpContext() != null) {
                this._sessionManager.initialize(this);
            }
            if (bl) {
                this._sessionManager.setMaxInactiveInterval(n);
            }
            this.addComponent(this._sessionManager);
        }
        this._sessionManager = sessionManager;
    }

    public SessionManager getSessionManager() {
        if (this._sessionManager == null) {
            this._sessionManager = new HashSessionManager();
            this.addComponent(this._sessionManager);
        }
        return this._sessionManager;
    }

    public ServletContext getServletContext() {
        return this._context;
    }

    public PathMap getServletMap() {
        return this._servletMap;
    }

    public boolean isUsingCookies() {
        return this._usingCookies;
    }

    public void setDynamicServletPathSpec(String string) {
        log.warn((Object)"setDynamicServletPathSpec is Deprecated.");
    }

    public void setDynamicInitParams(Map map) {
        log.warn((Object)"setDynamicInitParams is Deprecated.");
    }

    public void setServeDynamicSystemServlets(boolean bl) {
        log.warn((Object)"setServeDynamicSystemServlets is Deprecated.");
    }

    public ClassLoader getClassLoader() {
        return this._loader;
    }

    public void setUsingCookies(boolean bl) {
        this._usingCookies = bl;
    }

    public ServletHolder newServletHolder(String string, String string2, String string3) {
        if (this._nameMap.containsKey(string)) {
            throw new IllegalArgumentException("Named servlet already exists: " + string);
        }
        ServletHolder servletHolder = new ServletHolder(this, string, string2, string3);
        this.addServletHolder(servletHolder);
        return servletHolder;
    }

    public ServletHolder newServletHolder(String string, String string2) {
        return this.newServletHolder(string, string2, null);
    }

    public ServletHolder getServletHolder(String string) {
        return (ServletHolder)this._nameMap.get(string);
    }

    public ServletHolder mapPathToServlet(String string, String string2) {
        ServletHolder servletHolder = (ServletHolder)this._nameMap.get(string2);
        if (!string.startsWith("/") && !string.startsWith("*")) {
            log.warn((Object)("pathSpec should start with '/' or '*' : " + string));
            string = "/" + string;
        }
        if (servletHolder == null) {
            throw new IllegalArgumentException("Unknown servlet: " + string2);
        }
        this._servletMap.put(string, servletHolder);
        return servletHolder;
    }

    public ServletHolder addServlet(String string, String string2, String string3, String string4) {
        ServletHolder servletHolder = this.getServletHolder(string);
        if (servletHolder == null) {
            servletHolder = this.newServletHolder(string, string3, string4);
        }
        this.mapPathToServlet(string2, string);
        if (this.isStarted() && !servletHolder.isStarted()) {
            try {
                servletHolder.start();
            }
            catch (Exception exception) {
                log.warn((Object)"EXCEPTION ", (Throwable)exception);
            }
        }
        return servletHolder;
    }

    public ServletHolder addServlet(String string, String string2, String string3) {
        return this.addServlet(string, string2, string3, null);
    }

    public ServletHolder addServlet(String string, String string2) {
        return this.addServlet(string2, string, string2, null);
    }

    public void addServletHolder(ServletHolder servletHolder) {
        ServletHolder servletHolder2 = (ServletHolder)this._nameMap.get(servletHolder.getName());
        if (servletHolder2 == null) {
            this._nameMap.put(servletHolder.getName(), servletHolder);
        } else if (servletHolder2 != servletHolder) {
            throw new IllegalArgumentException("Holder already exists for name: " + servletHolder.getName());
        }
        this.addComponent(servletHolder);
    }

    public boolean isAutoInitializeServlets() {
        return this._autoInitializeServlets;
    }

    public void setAutoInitializeServlets(boolean bl) {
        this._autoInitializeServlets = bl;
    }

    protected synchronized void doStart() throws Exception {
        if (this.isStarted()) {
            return;
        }
        this._contextLog = LogFactory.getLog("org.mortbay.jetty.context." + this.getHttpContext().getHttpContextName());
        if (this._contextLog == null) {
            this._contextLog = log;
        }
        if (this._sessionManager != null) {
            this._sessionManager.start();
        }
        this._loader = this.getHttpContext().getClassLoader();
        if (this._autoInitializeServlets) {
            this.initializeServlets();
        }
    }

    public ServletHolder[] getServlets() {
        HashSet hashSet = new HashSet(this._nameMap.size());
        hashSet.addAll(this._nameMap.values());
        Object[] objectArray = hashSet.toArray(new ServletHolder[hashSet.size()]);
        Arrays.sort(objectArray);
        return objectArray;
    }

    public void initializeServlets() throws Exception {
        MultiException multiException = new MultiException();
        ServletHolder[] servletHolderArray = this.getServlets();
        for (int i = 0; i < servletHolderArray.length; ++i) {
            try {
                servletHolderArray[i].start();
                continue;
            }
            catch (Exception exception) {
                log.debug((Object)"EXCEPTION ", (Throwable)exception);
                multiException.add(exception);
            }
        }
        multiException.ifExceptionThrow();
    }

    protected synchronized void doStop() throws Exception {
        ServletHolder[] servletHolderArray = this.getServlets();
        int n = servletHolderArray.length;
        while (n-- > 0) {
            try {
                if (!servletHolderArray[n].isStarted()) continue;
                servletHolderArray[n].stop();
            }
            catch (Exception exception) {
                log.warn((Object)"EXCEPTION ", (Throwable)exception);
            }
        }
        this._sessionManager.stop();
        this._attributes.clear();
        this._loader = null;
    }

    public HttpSession getHttpSession(String string) {
        return this._sessionManager.getHttpSession(string);
    }

    public HttpSession newHttpSession(HttpServletRequest httpServletRequest) {
        return this._sessionManager.newHttpSession(httpServletRequest);
    }

    public void setSessionInactiveInterval(int n) {
        this._sessionManager.setMaxInactiveInterval(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void handle(String string, String string2, HttpRequest httpRequest, HttpResponse httpResponse) throws IOException {
        ServletHolder servletHolder;
        if (!this.isStarted()) {
            return;
        }
        if ("TRACE".equals(httpRequest.getMethod())) {
            this.handleTrace(httpRequest, httpResponse);
            return;
        }
        ServletHttpRequest servletHttpRequest = (ServletHttpRequest)httpRequest.getWrapper();
        ServletHttpResponse servletHttpResponse = (ServletHttpResponse)httpResponse.getWrapper();
        if (servletHttpRequest == null) {
            servletHttpRequest = new ServletHttpRequest(this, string, httpRequest);
            servletHttpResponse = new ServletHttpResponse(servletHttpRequest, httpResponse);
            httpRequest.setWrapper(servletHttpRequest);
            httpResponse.setWrapper(servletHttpResponse);
        } else {
            servletHttpRequest.recycle(this, string);
            servletHttpResponse.recycle();
        }
        Map.Entry entry = this.getHolderEntry(string);
        ServletHolder servletHolder2 = servletHolder = entry == null ? null : (ServletHolder)entry.getValue();
        if (log.isDebugEnabled()) {
            log.debug((Object)("servlet=" + entry));
        }
        try {
            block32: {
                try {
                    String string3;
                    if (entry != null) {
                        string3 = (String)entry.getKey();
                        servletHttpRequest.setServletPaths(PathMap.pathMatch(string3, string), PathMap.pathInfo(string3, string), servletHolder);
                    }
                    servletHttpRequest.setRequestedSessionId(string2);
                    string3 = servletHttpRequest.getSession(false);
                    if (string3 != null) {
                        ((SessionManager.Session)((Object)string3)).access();
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("session=" + string3));
                    }
                    if (servletHolder == null) break block32;
                    this.dispatch(string, servletHttpRequest, servletHttpResponse, servletHolder, 1);
                }
                catch (Exception exception) {
                    block33: {
                        Throwable throwable2;
                        block34: {
                            Throwable throwable;
                            log.debug((Object)"EXCEPTION ", (Throwable)exception);
                            throwable2 = exception;
                            while (throwable2 instanceof ServletException) {
                                log.warn((Object)"EXCEPTION ", throwable2);
                                throwable = ((ServletException)throwable2).getRootCause();
                                if (throwable == throwable2 || throwable == null) break;
                                throwable2 = throwable;
                            }
                            if (throwable2 instanceof HttpException) {
                                throw (HttpException)throwable2;
                            }
                            if (throwable2 instanceof EOFException) {
                                throw (IOException)throwable2;
                            }
                            if (log.isDebugEnabled() || !(throwable2 instanceof IOException)) {
                                if (this._contextLog != null) {
                                    if (throwable2 instanceof RuntimeException) {
                                        this._contextLog.error((Object)(httpRequest.getURI() + ": "), throwable2);
                                    } else {
                                        this._contextLog.warn((Object)(httpRequest.getURI() + ": "), throwable2);
                                    }
                                }
                                if (log.isDebugEnabled()) {
                                    if (throwable2 instanceof RuntimeException) {
                                        log.error((Object)(httpRequest.getURI() + ": "), throwable2);
                                    } else {
                                        log.warn((Object)(httpRequest.getURI() + ": "), throwable2);
                                    }
                                    log.debug((Object)httpRequest);
                                }
                            }
                            httpResponse.getHttpConnection().forceClose();
                            if (httpResponse.isCommitted()) break block34;
                            servletHttpRequest.setAttribute(__J_S_ERROR_EXCEPTION_TYPE, throwable2.getClass());
                            servletHttpRequest.setAttribute(__J_S_ERROR_EXCEPTION, throwable2);
                            if (throwable2 instanceof UnavailableException) {
                                throwable = (UnavailableException)throwable2;
                                if (throwable.isPermanent()) {
                                    servletHttpResponse.sendError(404, exception.getMessage());
                                    break block33;
                                } else {
                                    servletHttpResponse.sendError(503, exception.getMessage());
                                }
                                break block33;
                            } else {
                                servletHttpResponse.sendError(500, exception.getMessage());
                            }
                            break block33;
                        }
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Response already committed for handling " + throwable2));
                        }
                    }
                    Object var13_13 = null;
                    if (servletHolder == null) return;
                    if (servletHttpResponse == null) return;
                    servletHttpResponse.complete();
                    return;
                }
                catch (Error error) {
                    log.warn((Object)("Error for " + httpRequest.getURI()), (Throwable)error);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)httpRequest);
                    }
                    httpResponse.getHttpConnection().forceClose();
                    if (!httpResponse.isCommitted()) {
                        servletHttpRequest.setAttribute(__J_S_ERROR_EXCEPTION_TYPE, error.getClass());
                        servletHttpRequest.setAttribute(__J_S_ERROR_EXCEPTION, error);
                        servletHttpResponse.sendError(500, error.getMessage());
                    } else if (log.isDebugEnabled()) {
                        log.debug((Object)"Response already committed for handling ", (Throwable)error);
                    }
                    Object var13_14 = null;
                    if (servletHolder == null) return;
                    if (servletHttpResponse == null) return;
                    servletHttpResponse.complete();
                    return;
                }
            }
            Object var13_12 = null;
            if (servletHolder == null) return;
            if (servletHttpResponse == null) return;
            servletHttpResponse.complete();
            return;
        }
        catch (Throwable throwable) {
            Object var13_15 = null;
            if (servletHolder == null) throw throwable;
            if (servletHttpResponse == null) throw throwable;
            servletHttpResponse.complete();
            throw throwable;
        }
    }

    protected void dispatch(String string, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, ServletHolder servletHolder, int n) throws ServletException, UnavailableException, IOException {
        servletHolder.handle((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
    }

    public Map.Entry getHolderEntry(String string) {
        return this._servletMap.getMatch(string);
    }

    public Set getResourcePaths(String string) {
        try {
            string = URI.canonicalPath(string);
            if (string == null) {
                return Collections.EMPTY_SET;
            }
            Resource resource = this.getHttpContext().getResource(string);
            if (resource == null || !resource.isDirectory()) {
                return Collections.EMPTY_SET;
            }
            String[] stringArray = resource.list();
            if (stringArray == null || stringArray.length == 0) {
                return Collections.EMPTY_SET;
            }
            HashSet<String> hashSet = new HashSet<String>(stringArray.length * 2);
            for (int i = 0; i < stringArray.length; ++i) {
                hashSet.add(URI.addPaths(string, stringArray[i]));
            }
            return hashSet;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            LogSupport.ignore(log, exception);
            return Collections.EMPTY_SET;
        }
    }

    public URL getResource(String string) throws MalformedURLException {
        if (string == null || !string.startsWith("/")) {
            throw new MalformedURLException(string);
        }
        try {
            Resource resource = this.getHttpContext().getResource(string);
            if (resource != null && resource.exists()) {
                return resource.getURL();
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            LogSupport.ignore(log, illegalArgumentException);
        }
        catch (MalformedURLException malformedURLException) {
            throw malformedURLException;
        }
        catch (IOException iOException) {
            log.warn((Object)"EXCEPTION ", (Throwable)iOException);
        }
        return null;
    }

    public InputStream getResourceAsStream(String string) {
        if (string == null || !string.startsWith("/")) {
            return null;
        }
        try {
            Resource resource = this.getHttpContext().getResource(string);
            if (resource != null) {
                return resource.getInputStream();
            }
            URL uRL = this.getResource(string = URI.canonicalPath(string));
            if (uRL != null) {
                return uRL.openStream();
            }
        }
        catch (IOException iOException) {
            LogSupport.ignore(log, iOException);
        }
        return null;
    }

    public String getRealPath(String string) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getRealPath of " + string + " in " + this));
        }
        if (__Slosh2Slash) {
            string = string.replace('\\', '/');
        }
        if ((string = URI.canonicalPath(string)) == null) {
            return null;
        }
        Resource resource = this.getHttpContext().getBaseResource();
        if (resource == null) {
            return null;
        }
        try {
            Resource resource2 = resource.addPath(string);
            File file = resource2.getFile();
            return file == null ? null : file.getAbsolutePath();
        }
        catch (IOException iOException) {
            log.warn((Object)"EXCEPTION ", (Throwable)iOException);
            return null;
        }
    }

    public RequestDispatcher getRequestDispatcher(String string) {
        if (string == null) {
            return null;
        }
        if (!string.startsWith("/")) {
            return null;
        }
        try {
            String string2;
            Map.Entry entry;
            String string3 = null;
            int n = 0;
            n = string.indexOf(63);
            if (n > 0) {
                string3 = string.substring(n + 1);
                string = string.substring(0, n);
            }
            if ((n = string.indexOf(59)) > 0) {
                string = string.substring(0, n);
            }
            if ((entry = this.getHolderEntry(string2 = URI.canonicalPath(URI.decodePath(string)))) != null) {
                return new Dispatcher(this, string, string2, string3, entry);
            }
        }
        catch (Exception exception) {
            LogSupport.ignore(log, exception);
        }
        return null;
    }

    public RequestDispatcher getNamedDispatcher(String string) {
        if (string == null || string.length() == 0) {
            string = __DEFAULT_SERVLET;
        }
        try {
            return new Dispatcher(this, string);
        }
        catch (Exception exception) {
            LogSupport.ignore(log, exception);
            return null;
        }
    }

    protected void notFound(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        String string;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Not Found " + httpServletRequest.getRequestURI()));
        }
        if ((string = httpServletRequest.getMethod()).equals("GET") || string.equals("HEAD") || string.equals("POST")) {
            httpServletResponse.sendError(404);
        } else if (string.equals("TRACE")) {
            this.handleTrace(httpServletRequest, httpServletResponse);
        } else if (string.equals("OPTIONS")) {
            this.handleOptions(httpServletRequest, httpServletResponse);
        } else {
            httpServletResponse.setHeader("Allow", __AllowString);
            httpServletResponse.sendError(405);
        }
    }

    protected void handleTrace(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        httpServletResponse.setHeader("Content-Type", "message/http");
        ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
        ByteArrayISO8859Writer byteArrayISO8859Writer = new ByteArrayISO8859Writer();
        byteArrayISO8859Writer.write(httpServletRequest.toString());
        byteArrayISO8859Writer.flush();
        httpServletResponse.setIntHeader("Content-Length", byteArrayISO8859Writer.size());
        byteArrayISO8859Writer.writeTo((OutputStream)servletOutputStream);
        servletOutputStream.flush();
    }

    protected void handleOptions(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        if ("*".equals(httpServletRequest.getRequestURI())) {
            httpServletResponse.setIntHeader("Content-Length", 0);
            httpServletResponse.setHeader("Allow", __AllowString);
            httpServletResponse.flushBuffer();
        } else {
            httpServletResponse.sendError(404);
        }
    }

    public String getErrorPage(int n, ServletHttpRequest servletHttpRequest) {
        return null;
    }

    protected Object getContextAttribute(String string) {
        if (__J_S_CONTEXT_TEMPDIR.equals(string)) {
            Object object = this.getHttpContext().getAttribute(__J_S_CONTEXT_TEMPDIR);
            if (object instanceof File) {
                return (File)object;
            }
            return this.getHttpContext().getTempDirectory();
        }
        if (this._attributes.containsKey(string)) {
            return this._attributes.get(string);
        }
        return this.getHttpContext().getAttribute(string);
    }

    protected Enumeration getContextAttributeNames() {
        if (this._attributes.size() == 0) {
            return this.getHttpContext().getAttributeNames();
        }
        HashSet hashSet = new HashSet(this._attributes.keySet());
        Enumeration enumeration = this.getHttpContext().getAttributeNames();
        while (enumeration.hasMoreElements()) {
            hashSet.add(enumeration.nextElement());
        }
        return Collections.enumeration(hashSet);
    }

    protected void setContextAttribute(String string, Object object) {
        this._attributes.put(string, object);
    }

    protected void removeContextAttribute(String string) {
        this._attributes.remove(string);
    }

    public void handleTrace(HttpRequest httpRequest, HttpResponse httpResponse) throws IOException {
        boolean bl = this.getHttpContext().getHttpServer().getTrace();
        httpResponse.setField("Content-Type", "message/http");
        if (bl) {
            OutputStream outputStream = httpResponse.getOutputStream();
            ByteArrayISO8859Writer byteArrayISO8859Writer = new ByteArrayISO8859Writer();
            byteArrayISO8859Writer.write(httpRequest.toString());
            byteArrayISO8859Writer.flush();
            httpResponse.setIntField("Content-Length", byteArrayISO8859Writer.size());
            byteArrayISO8859Writer.writeTo(outputStream);
            outputStream.flush();
        }
        httpRequest.setHandled(true);
    }

    public void destroy() {
        Iterator iterator = this._nameMap.values().iterator();
        while (iterator.hasNext()) {
            Object v = iterator.next();
            iterator.remove();
            this.removeComponent(v);
        }
        if (this._sessionManager != null) {
            this.removeComponent(this._sessionManager);
        }
        this._sessionManager = null;
        this._context = null;
        super.destroy();
    }

    protected void finalize() throws Throwable {
        this.destroy();
    }

    class Context
    implements ServletContext {
        Context() {
        }

        ServletHandler getServletHandler() {
            return ServletHandler.this;
        }

        public ServletContext getContext(String string) {
            ServletHandler servletHandler = (ServletHandler)ServletHandler.this.getHttpContext().getHttpServer().findHandler(class$org$mortbay$jetty$servlet$ServletHandler == null ? (class$org$mortbay$jetty$servlet$ServletHandler = ServletHandler.class$("org.mortbay.jetty.servlet.ServletHandler")) : class$org$mortbay$jetty$servlet$ServletHandler, string, ServletHandler.this.getHttpContext().getVirtualHosts());
            if (servletHandler != null) {
                return servletHandler.getServletContext();
            }
            return null;
        }

        public int getMajorVersion() {
            return 2;
        }

        public int getMinorVersion() {
            return 4;
        }

        public String getMimeType(String string) {
            return ServletHandler.this.getHttpContext().getMimeByExtension(string);
        }

        public Set getResourcePaths(String string) {
            return ServletHandler.this.getResourcePaths(string);
        }

        public URL getResource(String string) throws MalformedURLException {
            return ServletHandler.this.getResource(string);
        }

        public InputStream getResourceAsStream(String string) {
            return ServletHandler.this.getResourceAsStream(string);
        }

        public String getRealPath(String string) {
            return ServletHandler.this.getRealPath(string);
        }

        public RequestDispatcher getRequestDispatcher(String string) {
            return ServletHandler.this.getRequestDispatcher(string);
        }

        public RequestDispatcher getNamedDispatcher(String string) {
            return ServletHandler.this.getNamedDispatcher(string);
        }

        public Servlet getServlet(String string) {
            return null;
        }

        public Enumeration getServlets() {
            return Collections.enumeration(Collections.EMPTY_LIST);
        }

        public Enumeration getServletNames() {
            return Collections.enumeration(Collections.EMPTY_LIST);
        }

        public void log(String string) {
            ServletHandler.this._contextLog.info((Object)string);
        }

        public void log(Exception exception, String string) {
            ServletHandler.this._contextLog.warn((Object)string, (Throwable)exception);
        }

        public void log(String string, Throwable throwable) {
            ServletHandler.this._contextLog.warn((Object)string, throwable);
        }

        public String getServerInfo() {
            return Version.getImplVersion();
        }

        public String getInitParameter(String string) {
            return ServletHandler.this.getHttpContext().getInitParameter(string);
        }

        public Enumeration getInitParameterNames() {
            return ServletHandler.this.getHttpContext().getInitParameterNames();
        }

        public Object getAttribute(String string) {
            return ServletHandler.this.getContextAttribute(string);
        }

        public Enumeration getAttributeNames() {
            return ServletHandler.this.getContextAttributeNames();
        }

        public void setAttribute(String string, Object object) {
            ServletHandler.this.setContextAttribute(string, object);
        }

        public void removeAttribute(String string) {
            ServletHandler.this.removeContextAttribute(string);
        }

        public String getServletContextName() {
            if (ServletHandler.this.getHttpContext() instanceof WebApplicationContext) {
                return ((WebApplicationContext)ServletHandler.this.getHttpContext()).getDisplayName();
            }
            return null;
        }

        public String toString() {
            return "ServletContext[" + ServletHandler.this.getHttpContext() + "]";
        }
    }
}

