/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.servlet;

import org.apache.commons.logging.Log;
import org.mortbay.jetty.servlet.WebApplicationContext;
import org.mortbay.log.LogFactory;
import org.mortbay.util.Resource;
import org.mortbay.xml.XmlConfiguration;

public class JettyWebConfiguration
implements WebApplicationContext.Configuration {
    private static Log log = LogFactory.getLog(JettyWebConfiguration.class);
    private WebApplicationContext _context;

    public void setWebApplicationContext(WebApplicationContext webApplicationContext) {
        this._context = webApplicationContext;
    }

    public WebApplicationContext getWebApplicationContext() {
        return this._context;
    }

    public void configureClassPath() throws Exception {
    }

    public void configureDefaults() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configureWebApp() throws Exception {
        Resource resource;
        if (this._context.isStarted()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Cannot configure webapp after it is started");
            }
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Configuring web-jetty.xml");
        }
        if ((resource = this.getWebApplicationContext().getWebInf()) != null && resource.isDirectory()) {
            Resource resource2 = resource.addPath("web-jetty.xml");
            if (!resource2.exists()) {
                resource2 = resource.addPath("jetty-web.xml");
            }
            if (!this.getWebApplicationContext().isIgnoreWebJetty() && resource2.exists()) {
                String[] stringArray = this._context.getServerClasses();
                String[] stringArray2 = new String[1 + (stringArray == null ? 0 : stringArray.length)];
                stringArray2[0] = "-org.mortbay.";
                if (stringArray2 != null) {
                    System.arraycopy(stringArray, 0, stringArray2, 1, stringArray.length);
                }
                try {
                    this._context.setServerClasses(stringArray2);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Configure: " + resource2));
                    }
                    XmlConfiguration xmlConfiguration = new XmlConfiguration(resource2.getURL());
                    xmlConfiguration.configure(this.getWebApplicationContext());
                    Object var7_6 = null;
                }
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    if (this._context.getServerClasses() == stringArray2) {
                        this._context.setServerClasses(stringArray);
                    }
                    throw throwable;
                }
                if (this._context.getServerClasses() == stringArray2) {
                    this._context.setServerClasses(stringArray);
                }
            }
        }
    }
}

