/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.servlet;

import java.io.IOException;
import java.io.Serializable;
import java.security.Principal;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import org.apache.commons.logging.Log;
import org.mortbay.http.Authenticator;
import org.mortbay.http.HttpRequest;
import org.mortbay.http.HttpResponse;
import org.mortbay.http.SSORealm;
import org.mortbay.http.SecurityConstraint;
import org.mortbay.http.UserRealm;
import org.mortbay.jetty.servlet.ServletHttpRequest;
import org.mortbay.log.LogFactory;
import org.mortbay.util.Credential;
import org.mortbay.util.Password;
import org.mortbay.util.URI;

public class FormAuthenticator
implements Authenticator {
    static Log log = LogFactory.getLog(FormAuthenticator.class);
    public static final String __J_URI = "org.mortbay.jetty.URI";
    public static final String __J_AUTHENTICATED = "org.mortbay.jetty.Auth";
    public static final String __J_SECURITY_CHECK = "j_security_check";
    public static final String __J_USERNAME = "j_username";
    public static final String __J_PASSWORD = "j_password";
    private String _formErrorPage;
    private String _formErrorPath;
    private String _formLoginPage;
    private String _formLoginPath;

    public String getAuthMethod() {
        return "FORM";
    }

    public void setLoginPage(String string) {
        if (!string.startsWith("/")) {
            log.warn((Object)"form-login-page must start with /");
            string = "/" + string;
        }
        this._formLoginPage = string;
        this._formLoginPath = string;
        if (this._formLoginPath.indexOf(63) > 0) {
            this._formLoginPath = this._formLoginPath.substring(0, this._formLoginPath.indexOf(63));
        }
    }

    public String getLoginPage() {
        return this._formLoginPage;
    }

    public void setErrorPage(String string) {
        if (string == null || string.trim().length() == 0) {
            this._formErrorPath = null;
            this._formErrorPage = null;
        } else {
            if (!string.startsWith("/")) {
                log.warn((Object)"form-error-page must start with /");
                string = "/" + string;
            }
            this._formErrorPage = string;
            this._formErrorPath = string;
            if (this._formErrorPath != null && this._formErrorPath.indexOf(63) > 0) {
                this._formErrorPath = this._formErrorPath.substring(0, this._formErrorPath.indexOf(63));
            }
        }
    }

    public String getErrorPage() {
        return this._formErrorPage;
    }

    public Principal authenticate(UserRealm userRealm, String string, HttpRequest httpRequest, HttpResponse httpResponse) throws IOException {
        ServletHttpRequest servletHttpRequest = (ServletHttpRequest)httpRequest.getWrapper();
        HttpServletResponse httpServletResponse = httpResponse == null ? null : (HttpServletResponse)httpResponse.getWrapper();
        String string2 = string;
        HttpSession httpSession = servletHttpRequest.getSession(httpServletResponse != null);
        if (httpSession == null) {
            return null;
        }
        if (string2.substring(string2.lastIndexOf("/") + 1).startsWith(__J_SECURITY_CHECK)) {
            FormCredential formCredential = new FormCredential();
            formCredential.authenticate(userRealm, servletHttpRequest.getParameter(__J_USERNAME), servletHttpRequest.getParameter(__J_PASSWORD), httpRequest);
            String string3 = (String)httpSession.getAttribute(__J_URI);
            if ((string3 == null || string3.length() == 0) && (string3 = servletHttpRequest.getContextPath()).length() == 0) {
                string3 = "/";
            }
            if (formCredential._userPrincipal != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Form authentication OK for " + formCredential._jUserName));
                }
                httpSession.removeAttribute(__J_URI);
                httpRequest.setAuthType("FORM");
                httpRequest.setAuthUser(formCredential._jUserName);
                httpRequest.setUserPrincipal(formCredential._userPrincipal);
                httpSession.setAttribute(__J_AUTHENTICATED, (Object)formCredential);
                if (userRealm instanceof SSORealm) {
                    ((SSORealm)((Object)userRealm)).setSingleSignOn(httpRequest, httpResponse, formCredential._userPrincipal, new Password(formCredential._jPassword));
                }
                if (httpServletResponse != null) {
                    httpServletResponse.setContentLength(0);
                    httpServletResponse.sendRedirect(httpServletResponse.encodeRedirectURL(string3));
                }
            } else if (httpServletResponse != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Form authentication FAILED for " + formCredential._jUserName));
                }
                if (this._formErrorPage != null) {
                    httpServletResponse.setContentLength(0);
                    httpServletResponse.sendRedirect(httpServletResponse.encodeRedirectURL(URI.addPaths(servletHttpRequest.getContextPath(), this._formErrorPage)));
                } else {
                    httpServletResponse.sendError(403);
                }
            }
            return null;
        }
        FormCredential formCredential = (FormCredential)httpSession.getAttribute(__J_AUTHENTICATED);
        if (formCredential != null) {
            if (formCredential._userPrincipal == null) {
                formCredential.authenticate(userRealm, httpRequest);
                if (formCredential._userPrincipal != null && userRealm instanceof SSORealm) {
                    ((SSORealm)((Object)userRealm)).setSingleSignOn(httpRequest, httpResponse, formCredential._userPrincipal, new Password(formCredential._jPassword));
                }
            } else if (!userRealm.reauthenticate(formCredential._userPrincipal)) {
                formCredential._userPrincipal = null;
            }
            if (formCredential._userPrincipal != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("FORM Authenticated for " + formCredential._userPrincipal.getName()));
                }
                httpRequest.setAuthType("FORM");
                httpRequest.setAuthUser(formCredential._userPrincipal.getName());
                httpRequest.setUserPrincipal(formCredential._userPrincipal);
                return formCredential._userPrincipal;
            }
            httpSession.setAttribute(__J_AUTHENTICATED, null);
        } else if (userRealm instanceof SSORealm) {
            Credential credential = ((SSORealm)((Object)userRealm)).getSingleSignOn(httpRequest, httpResponse);
            if (httpRequest.hasUserPrincipal()) {
                formCredential = new FormCredential();
                formCredential._userPrincipal = servletHttpRequest.getUserPrincipal();
                formCredential._jUserName = formCredential._userPrincipal.getName();
                if (credential != null) {
                    formCredential._jPassword = credential.toString();
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("SSO for " + formCredential._userPrincipal));
                }
                httpRequest.setAuthType("FORM");
                httpSession.setAttribute(__J_AUTHENTICATED, (Object)formCredential);
                return formCredential._userPrincipal;
            }
        }
        if (this.isLoginOrErrorPage(string)) {
            return SecurityConstraint.__NOBODY;
        }
        if (httpServletResponse != null) {
            if (httpRequest.getQuery() != null) {
                string2 = string2 + "?" + httpRequest.getQuery();
            }
            httpSession.setAttribute(__J_URI, (Object)(servletHttpRequest.getScheme() + "://" + servletHttpRequest.getServerName() + ":" + servletHttpRequest.getServerPort() + URI.addPaths(servletHttpRequest.getContextPath(), string2)));
            httpServletResponse.setContentLength(0);
            httpServletResponse.sendRedirect(httpServletResponse.encodeRedirectURL(URI.addPaths(servletHttpRequest.getContextPath(), this._formLoginPage)));
        }
        return null;
    }

    public boolean isLoginOrErrorPage(String string) {
        return string != null && (string.equals(this._formErrorPath) || string.equals(this._formLoginPath));
    }

    private static class FormCredential
    implements Serializable,
    HttpSessionBindingListener {
        String _jUserName;
        String _jPassword;
        transient Principal _userPrincipal;
        transient UserRealm _realm;

        private FormCredential() {
        }

        void authenticate(UserRealm userRealm, String string, String string2, HttpRequest httpRequest) {
            this._jUserName = string;
            this._jPassword = string2;
            this._userPrincipal = userRealm.authenticate(string, string2, httpRequest);
            if (this._userPrincipal != null) {
                this._realm = userRealm;
            }
        }

        void authenticate(UserRealm userRealm, HttpRequest httpRequest) {
            this._userPrincipal = userRealm.authenticate(this._jUserName, this._jPassword, httpRequest);
            if (this._userPrincipal != null) {
                this._realm = userRealm;
            }
        }

        public void valueBound(HttpSessionBindingEvent httpSessionBindingEvent) {
        }

        public void valueUnbound(HttpSessionBindingEvent httpSessionBindingEvent) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Logout " + this._jUserName));
            }
            if (this._realm instanceof SSORealm) {
                ((SSORealm)((Object)this._realm)).clearSingleSignOn(this._jUserName);
            }
            if (this._realm != null && this._userPrincipal != null) {
                this._realm.logout(this._userPrincipal);
            }
        }

        public int hashCode() {
            return this._jUserName.hashCode() + this._jPassword.hashCode();
        }

        public boolean equals(Object object) {
            if (!(object instanceof FormCredential)) {
                return false;
            }
            FormCredential formCredential = (FormCredential)object;
            return this._jUserName.equals(formCredential._jUserName) && this._jPassword.equals(formCredential._jPassword);
        }

        public String toString() {
            return "Cred[" + this._jUserName + "]";
        }
    }
}

