/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.http.handler;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.mortbay.http.HttpContext;
import org.mortbay.http.HttpHandler;
import org.mortbay.http.HttpRequest;
import org.mortbay.http.HttpResponse;
import org.mortbay.log.LogFactory;
import org.mortbay.util.ByteArrayISO8859Writer;

public abstract class AbstractHttpHandler
implements HttpHandler {
    private static Log log = LogFactory.getLog(AbstractHttpHandler.class);
    private String _name;
    private transient HttpContext _context;
    private transient boolean _started = false;

    public void setName(String string) {
        this._name = string;
    }

    public String getName() {
        if (this._name == null) {
            this._name = this.getClass().getName();
            if (!log.isDebugEnabled()) {
                this._name = this._name.substring(this._name.lastIndexOf(46) + 1);
            }
        }
        return this._name;
    }

    public HttpContext getHttpContext() {
        return this._context;
    }

    public void initialize(HttpContext httpContext) {
        if (this._context == null) {
            this._context = httpContext;
        } else if (this._context != httpContext) {
            throw new IllegalStateException("Can't initialize handler for different context");
        }
    }

    public void start() throws Exception {
        if (this._context == null) {
            throw new IllegalStateException("No context for " + this);
        }
        this._started = true;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Started " + this));
        }
    }

    public void stop() throws InterruptedException {
        this._started = false;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Stopped " + this));
        }
    }

    public boolean isStarted() {
        return this._started;
    }

    public String toString() {
        return this.getName() + " in " + this._context;
    }

    public void handleTrace(HttpRequest httpRequest, HttpResponse httpResponse) throws IOException {
        boolean bl = this.getHttpContext().getHttpServer().getTrace();
        httpResponse.setField("Content-Type", "message/http");
        if (bl) {
            OutputStream outputStream = httpResponse.getOutputStream();
            ByteArrayISO8859Writer byteArrayISO8859Writer = new ByteArrayISO8859Writer();
            byteArrayISO8859Writer.write(httpRequest.toString());
            byteArrayISO8859Writer.flush();
            httpResponse.setIntField("Content-Length", byteArrayISO8859Writer.size());
            byteArrayISO8859Writer.writeTo(outputStream);
            outputStream.flush();
        }
        httpRequest.setHandled(true);
    }
}

