/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.http.ajp;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import org.apache.commons.logging.Log;
import org.mortbay.http.BufferedOutputStream;
import org.mortbay.http.HttpMessage;
import org.mortbay.http.HttpResponse;
import org.mortbay.http.ajp.AJP13Packet;
import org.mortbay.http.ajp.AJP13ResponsePacket;
import org.mortbay.log.LogFactory;

public class AJP13OutputStream
extends BufferedOutputStream {
    private static Log log = LogFactory.getLog(AJP13OutputStream.class);
    private AJP13ResponsePacket _packet;
    private boolean _complete;
    private boolean _completed;
    private boolean _persistent = true;
    private AJP13ResponsePacket _ajpResponse;

    AJP13OutputStream(OutputStream outputStream, int n) {
        super(outputStream, n, 7, 7, 0);
        this.setFixed(true);
        this._packet = new AJP13ResponsePacket(this._buf);
        this._packet.prepare();
        this.setBypassBuffer(false);
        this.setFixed(true);
        this._ajpResponse = new AJP13ResponsePacket(n);
        this._ajpResponse.prepare();
    }

    public void writeHeader(HttpMessage httpMessage) throws IOException {
        HttpResponse httpResponse = (HttpResponse)httpMessage;
        httpResponse.setState(3);
        this._ajpResponse.resetData();
        this._ajpResponse.addByte((byte)4);
        this._ajpResponse.addInt(httpResponse.getStatus());
        this._ajpResponse.addString(httpResponse.getReason());
        int n = this._ajpResponse.getMark();
        this._ajpResponse.addInt(0);
        int n2 = 0;
        Enumeration enumeration = httpResponse.getFieldNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Enumeration enumeration2 = httpResponse.getFieldValues(string);
            while (enumeration2.hasMoreElements()) {
                this._ajpResponse.addHeader(string);
                this._ajpResponse.addString((String)enumeration2.nextElement());
                ++n2;
            }
        }
        if (n2 > 0) {
            this._ajpResponse.setInt(n, n2);
        }
        this._ajpResponse.setDataSize();
        this.write(this._ajpResponse);
        this._ajpResponse.resetData();
    }

    public void write(AJP13Packet aJP13Packet) throws IOException {
        aJP13Packet.write(this._out);
    }

    public void flush() throws IOException {
        super.flush();
        if (this._complete && !this._completed) {
            this._completed = true;
            this._packet.resetData();
            this._packet.addByte((byte)5);
            this._packet.addBoolean(this._persistent);
            this._packet.setDataSize();
            this.write(this._packet);
            this._packet.resetData();
        }
    }

    public void close() throws IOException {
        this._complete = true;
        this.flush();
    }

    public void resetStream() {
        this._complete = false;
        this._completed = false;
        super.resetStream();
    }

    public void destroy() {
        if (this._packet != null) {
            this._packet.destroy();
        }
        this._packet = null;
        if (this._ajpResponse != null) {
            this._ajpResponse.destroy();
        }
        this._ajpResponse = null;
        this._out = null;
    }

    public void end() throws IOException {
        this._persistent = false;
    }

    protected void wrapBuffer() throws IOException {
        if (this.size() == 0) {
            return;
        }
        if (this._buf != this._packet.getBuffer()) {
            this._packet = new AJP13ResponsePacket(this._buf);
            this._packet.prepare();
        }
        this.prewrite(this._buf, 0, 7);
        this._packet.resetData();
        this._packet.addByte((byte)3);
        this._packet.setDataSize(this.size() - 4);
    }

    protected void bypassWrite(byte[] byArray, int n, int n2) throws IOException {
        log.warn((Object)"NOT IMPLEMENTED ");
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        int n = this.size();
        if (n <= 8192) {
            super.writeTo(outputStream);
        } else {
            int n2 = this.preReserve();
            int n3 = n - 7;
            while (n3 > 8185) {
                this._packet.setDataSize(8188);
                if (n2 > 0) {
                    System.arraycopy(this._buf, 0, this._buf, n2, 7);
                }
                outputStream.write(this._buf, n2, 8192);
                n3 -= 8185;
                n2 += 8185;
            }
            int n4 = n3 + 7;
            this._packet.setDataSize(n4 - 4);
            if (n2 > 0) {
                System.arraycopy(this._buf, 0, this._buf, n2, 7);
            }
            outputStream.write(this._buf, n2, n4);
        }
    }
}

