/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.http.ajp;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import org.apache.commons.logging.Log;
import org.mortbay.http.HttpConnection;
import org.mortbay.http.Version;
import org.mortbay.http.ajp.AJP13InputStream;
import org.mortbay.http.ajp.AJP13Listener;
import org.mortbay.http.ajp.AJP13OutputStream;
import org.mortbay.log.LogFactory;
import org.mortbay.util.LineInput;
import org.mortbay.util.LogSupport;
import org.mortbay.util.URI;

public class AJP13Connection
extends HttpConnection {
    private static Log log = LogFactory.getLog(AJP13Connection.class);
    private AJP13Listener _listener;
    private AJP13InputStream _ajpIn;
    private AJP13OutputStream _ajpOut;
    private String _remoteHost;
    private String _remoteAddr;
    private String _serverName;
    private int _serverPort;
    private boolean _isSSL;

    public AJP13Connection(AJP13Listener aJP13Listener, InputStream inputStream, OutputStream outputStream, Socket socket, int n) throws IOException {
        super(aJP13Listener, null, new AJP13InputStream(inputStream, outputStream, n), outputStream, socket);
        LineInput lineInput = (LineInput)this.getInputStream().getInputStream();
        this._ajpIn = (AJP13InputStream)lineInput.getInputStream();
        this._ajpOut = new AJP13OutputStream(this.getOutputStream().getOutputStream(), n);
        this._ajpOut.setCommitObserver(this);
        this.getOutputStream().setBufferedOutputStream(this._ajpOut);
        this._listener = aJP13Listener;
    }

    public InetAddress getRemoteInetAddress() {
        return null;
    }

    public void destroy() {
        if (this._ajpIn != null) {
            this._ajpIn.destroy();
        }
        this._ajpIn = null;
        if (this._ajpOut != null) {
            this._ajpOut.destroy();
        }
        this._ajpOut = null;
        this._remoteHost = null;
        this._remoteAddr = null;
        this._serverName = null;
    }

    public String getRemoteAddr() {
        return this._remoteAddr;
    }

    public String getRemoteHost() {
        return this._remoteHost;
    }

    public String getServerName() {
        return this._serverName;
    }

    public int getServerPort() {
        return this._serverPort;
    }

    public String getDefaultScheme() {
        return this._isSSL ? "https" : super.getDefaultScheme();
    }

    public boolean isSSL() {
        return this._isSSL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean handleNext() {
        block78: {
            block72: {
                block77: {
                    block71: {
                        block76: {
                            block69: {
                                var1_1 = null;
                                var2_2 = this.getRequest();
                                var3_3 = this.getResponse();
                                var4_4 = null;
                                var5_5 = false;
                                this._persistent = true;
                                this._keepAlive = true;
                                try {
                                    try {
                                        block70: {
                                            try {
                                                var1_1 = null;
                                                var1_1 = this._ajpIn.nextPacket();
                                                if (var1_1 == null) {
                                                    var6_6 = false;
                                                }
                                                ** GOTO lbl-1000
                                            }
                                            catch (IOException var6_8) {
                                                LogSupport.ignore(AJP13Connection.log, var6_8);
                                                var7_40 = false;
                                                var17_14 = null;
                                                if (var1_1 == null) return false;
                                                if (!var5_5) {
                                                    return false;
                                                }
                                                try {
                                                    try {
                                                        this.getOutputStream().close();
                                                        if (!this._persistent) {
                                                            this._ajpOut.end();
                                                        }
                                                        this._ajpOut.close();
                                                        this.getOutputStream().resetStream();
                                                        this.getOutputStream().addObserver(this);
                                                        this.getInputStream().resetStream();
                                                        this._ajpIn.resetStream();
                                                        this._ajpOut.resetStream();
                                                        v0 = null;
                                                    }
                                                    catch (Exception var18_21) {
                                                        AJP13Connection.log.debug((Object)"EXCEPTION ", (Throwable)var18_21);
                                                        this._persistent = false;
                                                        v0 = null;
                                                    }
                                                }
                                                catch (Throwable var19_28) {
                                                    v0 = null;
                                                }
                                                var20_35 = v0;
                                                this.statsRequestEnd();
                                                if (var4_4 == null) return var7_40;
                                                var4_4.log(var2_2, var3_3, -1);
                                                return var7_40;
                                            }
                                            var17_12 = null;
                                            if (var1_1 == null) return false;
                                            if (!var5_5) {
                                                return false;
                                            }
                                            break block69;
lbl-1000:
                                            // 1 sources

                                            {
                                                if (var1_1.getDataSize() != 0) break block70;
                                                var6_7 = true;
                                            }
                                            break block71;
                                        }
                                        var6_9 = var1_1.getByte();
                                        if (AJP13Connection.log.isDebugEnabled()) {
                                            AJP13Connection.log.debug((Object)("AJP13 type=" + var6_9 + " size=" + var1_1.unconsumedData()));
                                        }
                                        switch (var6_9) {
                                            case 2: {
                                                var2_2.setTimeStamp(System.currentTimeMillis());
                                                var2_2.setState(0);
                                                var2_2.setMethod(var1_1.getMethod());
                                                var2_2.setVersion(var1_1.getString());
                                                var7_41 = var1_1.getString();
                                                var8_43 = var7_41.lastIndexOf(";");
                                                if (var8_43 < 0) {
                                                    var2_2.setPath(URI.encodePath(var7_41));
                                                } else {
                                                    var2_2.setPath(URI.encodePath(var7_41.substring(0, var8_43)) + var7_41.substring(var8_43));
                                                }
                                                this._remoteAddr = var1_1.getString();
                                                this._remoteHost = var1_1.getString();
                                                this._serverName = var1_1.getString();
                                                this._serverPort = var1_1.getInt();
                                                this._isSSL = var1_1.getBoolean();
                                                this._keepAlive = var2_2.getDotVersion() >= 1;
                                                var9_44 = var1_1.getInt();
                                                for (var10_45 = 0; var10_45 < var9_44; ++var10_45) {
                                                    var11_46 = var1_1.getHeader();
                                                    var12_47 = var1_1.getString();
                                                    var2_2.addField(var11_46, (String)var12_47);
                                                    if (this._keepAlive || !var11_46.equalsIgnoreCase("Connection") || !var12_47.equalsIgnoreCase("keep-alive")) continue;
                                                    this._keepAlive = true;
                                                }
                                                var10_45 = var1_1.getByte();
                                                while ((255 & var10_45) != 255) {
                                                    var11_46 = var10_45 == 11 ? null : var1_1.getString();
                                                    switch (var10_45) {
                                                        case 11: {
                                                            var2_2.setAttribute("javax.servlet.request.key_size", new Integer(var1_1.getInt()));
                                                            break;
                                                        }
                                                        case 10: {
                                                            var2_2.setAttribute(var11_46, var1_1.getString());
                                                            break;
                                                        }
                                                        case 9: {
                                                            var2_2.setAttribute("javax.servlet.request.ssl_session", var11_46);
                                                            break;
                                                        }
                                                        case 8: {
                                                            var2_2.setAttribute("javax.servlet.request.cipher_suite", var11_46);
                                                            break;
                                                        }
                                                        case 7: {
                                                            var12_47 = CertificateFactory.getInstance("X.509");
                                                            var13_48 = new ByteArrayInputStream(var11_46.getBytes());
                                                            var14_49 = (X509Certificate)var12_47.generateCertificate(var13_48);
                                                            var15_50 = new X509Certificate[]{var14_49};
                                                            var2_2.setAttribute("javax.servlet.request.X509Certificate", var15_50);
                                                            break;
                                                        }
                                                        case 6: {
                                                            var2_2.setAttribute("org.mortbay.http.ajp.JVMRoute", var11_46);
                                                            break;
                                                        }
                                                        case 5: {
                                                            var2_2.setQuery(var11_46);
                                                            break;
                                                        }
                                                        case 4: {
                                                            var2_2.setAuthType(var11_46);
                                                            break;
                                                        }
                                                        case 3: {
                                                            var2_2.setAuthUser(var11_46);
                                                            break;
                                                        }
                                                        default: {
                                                            AJP13Connection.log.warn((Object)("Unknown attr: " + var10_45 + "=" + var11_46));
                                                        }
                                                    }
                                                    var10_45 = var1_1.getByte();
                                                }
                                                this._listener.customizeRequest(this, var2_2);
                                                var5_5 = true;
                                                this.statsRequestStart();
                                                var2_2.setState(2);
                                                if (var2_2.getContentLength() == 0 && var2_2.getField("Transfer-Encoding") == null) {
                                                    this._ajpIn.close();
                                                }
                                                var3_3.setState(0);
                                                var3_3.setVersion("HTTP/1.1");
                                                var3_3.setDateField("Date", this._request.getTimeStamp());
                                                if (!Version.isParanoid()) {
                                                    var3_3.setField("Server", Version.getDetail());
                                                }
                                                if (AJP13Connection.log.isDebugEnabled()) {
                                                    AJP13Connection.log.debug((Object)("REQUEST:\n" + var2_2));
                                                }
                                                var4_4 = this.service(var2_2, var3_3);
                                                if (!AJP13Connection.log.isDebugEnabled()) break;
                                                AJP13Connection.log.debug((Object)("RESPONSE:\n" + var3_3));
                                                break;
                                            }
                                            default: {
                                                if (AJP13Connection.log.isDebugEnabled()) {
                                                    AJP13Connection.log.debug((Object)("Ignored: " + var1_1));
                                                }
                                                this._persistent = false;
                                                break;
                                            }
                                        }
                                        break block72;
                                    }
                                    catch (SocketException var6_10) {
                                        block73: {
                                            LogSupport.ignore(AJP13Connection.log, var6_10);
                                            this._persistent = false;
                                            var17_16 = null;
                                            if (var1_1 == null) return false;
                                            if (!var5_5) {
                                                return false;
                                            }
                                            ** try [egrp 5[TRYBLOCK] [19 : 1007->1102)] { 
lbl171:
                                            // 1 sources

                                            ** try [egrp 6[TRYBLOCK] [18 : 1007->1071)] { 
lbl172:
                                            // 1 sources

                                            this.getOutputStream().close();
                                            if (!this._persistent) {
                                                this._ajpOut.end();
                                            }
                                            this._ajpOut.close();
                                            this.getOutputStream().resetStream();
                                            this.getOutputStream().addObserver(this);
                                            this.getInputStream().resetStream();
                                            this._ajpIn.resetStream();
                                            this._ajpOut.resetStream();
                                            v1 = null;
lbl183:
                                            // 1 sources

                                            catch (Exception var18_23) {
                                                AJP13Connection.log.debug((Object)"EXCEPTION ", (Throwable)var18_23);
                                                this._persistent = false;
                                                v1 = null;
                                            }
                                            break block73;
lbl188:
                                            // 1 sources

                                            catch (Throwable var19_30) {
                                                v1 = null;
                                            }
                                        }
                                        var20_37 = v1;
                                        this.statsRequestEnd();
                                        if (var4_4 == null) return this._persistent;
                                        var4_4.log(var2_2, var3_3, -1);
                                        return this._persistent;
                                    }
                                    catch (Exception var6_11) {
                                        block74: {
                                            AJP13Connection.log.warn((Object)"EXCEPTION ", (Throwable)var6_11);
                                            this._persistent = false;
                                            try {
                                                if (var5_5) {
                                                    this._ajpOut.close();
                                                }
                                            }
                                            catch (IOException var7_42) {
                                                LogSupport.ignore(AJP13Connection.log, var7_42);
                                            }
                                            var17_17 = null;
                                            if (var1_1 == null) return false;
                                            if (!var5_5) {
                                                return false;
                                            }
                                            ** try [egrp 5[TRYBLOCK] [19 : 1007->1102)] { 
lbl211:
                                            // 1 sources

                                            ** try [egrp 6[TRYBLOCK] [18 : 1007->1071)] { 
lbl212:
                                            // 1 sources

                                            this.getOutputStream().close();
                                            if (!this._persistent) {
                                                this._ajpOut.end();
                                            }
                                            this._ajpOut.close();
                                            this.getOutputStream().resetStream();
                                            this.getOutputStream().addObserver(this);
                                            this.getInputStream().resetStream();
                                            this._ajpIn.resetStream();
                                            this._ajpOut.resetStream();
                                            v2 = null;
lbl223:
                                            // 1 sources

                                            catch (Exception var18_24) {
                                                AJP13Connection.log.debug((Object)"EXCEPTION ", (Throwable)var18_24);
                                                this._persistent = false;
                                                v2 = null;
                                            }
                                            break block74;
lbl228:
                                            // 1 sources

                                            catch (Throwable var19_31) {
                                                v2 = null;
                                            }
                                        }
                                        var20_38 = v2;
                                        this.statsRequestEnd();
                                        if (var4_4 == null) return this._persistent;
                                        var4_4.log(var2_2, var3_3, -1);
                                        return this._persistent;
                                    }
                                }
                                catch (Throwable var16_51) {
                                    block75: {
                                        var17_18 = null;
                                        if (var1_1 == null) return false;
                                        if (!var5_5) {
                                            return false;
                                        }
                                        ** try [egrp 5[TRYBLOCK] [19 : 1007->1102)] { 
lbl243:
                                        // 1 sources

                                        ** try [egrp 6[TRYBLOCK] [18 : 1007->1071)] { 
lbl244:
                                        // 1 sources

                                        this.getOutputStream().close();
                                        if (!this._persistent) {
                                            this._ajpOut.end();
                                        }
                                        this._ajpOut.close();
                                        this.getOutputStream().resetStream();
                                        this.getOutputStream().addObserver(this);
                                        this.getInputStream().resetStream();
                                        this._ajpIn.resetStream();
                                        this._ajpOut.resetStream();
                                        v3 = null;
lbl255:
                                        // 1 sources

                                        catch (Exception var18_25) {
                                            AJP13Connection.log.debug((Object)"EXCEPTION ", (Throwable)var18_25);
                                            this._persistent = false;
                                            v3 = null;
                                        }
                                        break block75;
lbl260:
                                        // 1 sources

                                        catch (Throwable var19_32) {
                                            v3 = null;
                                        }
                                    }
                                    var20_39 = v3;
                                    this.statsRequestEnd();
                                    if (var4_4 == null) throw var16_51;
                                    var4_4.log(var2_2, var3_3, -1);
                                    throw var16_51;
                                }
                            }
                            ** try [egrp 5[TRYBLOCK] [19 : 1007->1102)] { 
lbl270:
                            // 1 sources

                            ** try [egrp 6[TRYBLOCK] [18 : 1007->1071)] { 
lbl271:
                            // 1 sources

                            this.getOutputStream().close();
                            if (!this._persistent) {
                                this._ajpOut.end();
                            }
                            this._ajpOut.close();
                            this.getOutputStream().resetStream();
                            this.getOutputStream().addObserver(this);
                            this.getInputStream().resetStream();
                            this._ajpIn.resetStream();
                            this._ajpOut.resetStream();
                            v4 = null;
lbl282:
                            // 1 sources

                            catch (Exception var18_19) {
                                AJP13Connection.log.debug((Object)"EXCEPTION ", (Throwable)var18_19);
                                this._persistent = false;
                                v4 = null;
                            }
                            break block76;
lbl287:
                            // 1 sources

                            catch (Throwable var19_26) {
                                v4 = null;
                            }
                        }
                        var20_33 = v4;
                        this.statsRequestEnd();
                        if (var4_4 == null) return var6_6;
                        var4_4.log(var2_2, var3_3, -1);
                        return var6_6;
                    }
                    var17_13 = null;
                    if (var1_1 == null) return false;
                    if (!var5_5) {
                        return false;
                    }
                    ** try [egrp 5[TRYBLOCK] [19 : 1007->1102)] { 
lbl301:
                    // 1 sources

                    ** try [egrp 6[TRYBLOCK] [18 : 1007->1071)] { 
lbl302:
                    // 1 sources

                    this.getOutputStream().close();
                    if (!this._persistent) {
                        this._ajpOut.end();
                    }
                    this._ajpOut.close();
                    this.getOutputStream().resetStream();
                    this.getOutputStream().addObserver(this);
                    this.getInputStream().resetStream();
                    this._ajpIn.resetStream();
                    this._ajpOut.resetStream();
                    v5 = null;
lbl313:
                    // 1 sources

                    catch (Exception var18_20) {
                        AJP13Connection.log.debug((Object)"EXCEPTION ", (Throwable)var18_20);
                        this._persistent = false;
                        v5 = null;
                    }
                    break block77;
lbl318:
                    // 1 sources

                    catch (Throwable var19_27) {
                        v5 = null;
                    }
                }
                var20_34 = v5;
                this.statsRequestEnd();
                if (var4_4 == null) return var6_7;
                var4_4.log(var2_2, var3_3, -1);
                return var6_7;
            }
            var17_15 = null;
            if (var1_1 == null) return false;
            if (!var5_5) {
                return false;
            }
            ** try [egrp 5[TRYBLOCK] [19 : 1007->1102)] { 
lbl332:
            // 1 sources

            ** try [egrp 6[TRYBLOCK] [18 : 1007->1071)] { 
lbl333:
            // 1 sources

            this.getOutputStream().close();
            if (!this._persistent) {
                this._ajpOut.end();
            }
            this._ajpOut.close();
            this.getOutputStream().resetStream();
            this.getOutputStream().addObserver(this);
            this.getInputStream().resetStream();
            this._ajpIn.resetStream();
            this._ajpOut.resetStream();
            v6 = null;
lbl344:
            // 1 sources

            catch (Exception var18_22) {
                AJP13Connection.log.debug((Object)"EXCEPTION ", (Throwable)var18_22);
                this._persistent = false;
                v6 = null;
            }
            break block78;
lbl349:
            // 1 sources

            catch (Throwable var19_29) {
                v6 = null;
            }
        }
        var20_36 = v6;
        this.statsRequestEnd();
        if (var4_4 == null) return this._persistent;
        var4_4.log(var2_2, var3_3, -1);
        return this._persistent;
    }

    protected void firstWrite() throws IOException {
        log.debug((Object)"ajp13 firstWrite()");
    }

    protected void commit() throws IOException {
        log.debug((Object)"ajp13 commit()");
        if (this._response.isCommitted()) {
            return;
        }
        this._request.setHandled(true);
        this.getOutputStream().writeHeader(this._response);
    }

    protected void setupOutputStream() throws IOException {
        if ("HEAD".equals(this.getRequest().getMethod())) {
            this.getOutputStream().nullOutput();
        }
    }
}

