/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.http;

import java.io.IOException;
import java.io.Serializable;
import java.security.Principal;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.mortbay.http.Authenticator;
import org.mortbay.http.BasicAuthenticator;
import org.mortbay.http.HttpConnection;
import org.mortbay.http.HttpContext;
import org.mortbay.http.HttpException;
import org.mortbay.http.HttpRequest;
import org.mortbay.http.HttpResponse;
import org.mortbay.http.UserRealm;
import org.mortbay.jetty.servlet.FormAuthenticator;
import org.mortbay.log.LogFactory;
import org.mortbay.util.LazyList;

public class SecurityConstraint
implements Cloneable,
Serializable {
    private static Log log = LogFactory.getLog(SecurityConstraint.class);
    public static final String __BASIC_AUTH = "BASIC";
    public static final String __FORM_AUTH = "FORM";
    public static final String __DIGEST_AUTH = "DIGEST";
    public static final String __CERT_AUTH = "CLIENT_CERT";
    public static final String __CERT_AUTH2 = "CLIENT-CERT";
    public static final int DC_UNSET = -1;
    public static final int DC_NONE = 0;
    public static final int DC_INTEGRAL = 1;
    public static final int DC_CONFIDENTIAL = 2;
    public static final String NONE = "NONE";
    public static final String ANY_ROLE = "*";
    public static final Nobody __NOBODY = new Nobody();
    private String _name;
    private Object _methods;
    private Object _roles;
    private int _dataConstraint = -1;
    private boolean _anyRole = false;
    private boolean _authenticate = false;
    private transient List _umMethods;
    private transient List _umRoles;

    public SecurityConstraint() {
    }

    public SecurityConstraint(String string, String string2) {
        this.setName(string);
        this.addRole(string2);
    }

    public void setName(String string) {
        this._name = string;
    }

    public synchronized void addMethod(String string) {
        this._methods = LazyList.add(this._methods, string);
    }

    public List getMethods() {
        if (this._umMethods == null && this._methods != null) {
            this._umMethods = Collections.unmodifiableList(LazyList.getList(this._methods));
        }
        return this._umMethods;
    }

    public boolean forMethod(String string) {
        if (this._methods == null) {
            return true;
        }
        for (int i = 0; i < LazyList.size(this._methods); ++i) {
            if (!LazyList.get(this._methods, i).equals(string)) continue;
            return true;
        }
        return false;
    }

    public synchronized void addRole(String string) {
        this._authenticate = true;
        if (ANY_ROLE.equals(string)) {
            this._roles = null;
            this._umRoles = null;
            this._anyRole = true;
        } else if (!this._anyRole) {
            this._roles = LazyList.add(this._roles, string);
        }
    }

    public boolean isAnyRole() {
        return this._anyRole;
    }

    public List getRoles() {
        if (this._umRoles == null && this._roles != null) {
            this._umRoles = Collections.unmodifiableList(LazyList.getList(this._roles));
        }
        return this._umRoles;
    }

    public boolean hasRole(String string) {
        return LazyList.contains(this._roles, string);
    }

    public void setAuthenticate(boolean bl) {
        this._authenticate = bl;
    }

    public boolean getAuthenticate() {
        return this._authenticate;
    }

    public boolean isForbidden() {
        return this._authenticate && !this._anyRole && LazyList.size(this._roles) == 0;
    }

    public void setDataConstraint(int n) {
        if (n < 0 || n > 2) {
            throw new IllegalArgumentException("Constraint out of range");
        }
        this._dataConstraint = n;
    }

    public int getDataConstraint() {
        return this._dataConstraint;
    }

    public boolean hasDataConstraint() {
        return this._dataConstraint >= 0;
    }

    public Object clone() throws CloneNotSupportedException {
        SecurityConstraint securityConstraint = (SecurityConstraint)super.clone();
        securityConstraint._umMethods = null;
        securityConstraint._umRoles = null;
        return securityConstraint;
    }

    public String toString() {
        return "SC{" + this._name + "," + this._methods + "," + (this._anyRole ? ANY_ROLE : (this._roles == null ? "-" : this._roles.toString())) + "," + (this._dataConstraint == 0 ? "NONE}" : (this._dataConstraint == 1 ? "INTEGRAL}" : "CONFIDENTIAL}"));
    }

    public static boolean check(List list, Authenticator authenticator, UserRealm userRealm, String string, HttpRequest httpRequest, HttpResponse httpResponse) throws HttpException, IOException {
        Object object;
        Serializable serializable;
        int n = 0;
        Object object2 = null;
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; i < list.size(); ++i) {
            serializable = (SecurityConstraint)list.get(i);
            if (!((SecurityConstraint)serializable).forMethod(httpRequest.getMethod())) continue;
            if (n > -1 && ((SecurityConstraint)serializable).hasDataConstraint()) {
                if (((SecurityConstraint)serializable).getDataConstraint() > n) {
                    n = ((SecurityConstraint)serializable).getDataConstraint();
                }
            } else {
                n = -1;
            }
            if (bl || bl2) continue;
            if (((SecurityConstraint)serializable).getAuthenticate()) {
                if (((SecurityConstraint)serializable).isAnyRole()) {
                    object2 = ANY_ROLE;
                    continue;
                }
                object = ((SecurityConstraint)serializable).getRoles();
                if (object == null || object.size() == 0) {
                    bl2 = true;
                    break;
                }
                if (object2 == ANY_ROLE) continue;
                object2 = LazyList.addCollection(object2, (Collection)object);
                continue;
            }
            bl = true;
        }
        if (!(!bl2 || authenticator instanceof FormAuthenticator && ((FormAuthenticator)authenticator).isLoginOrErrorPage(string))) {
            HttpContext.sendContextError(httpResponse, 403, null);
            return false;
        }
        if (n > 0) {
            HttpConnection httpConnection = httpRequest.getHttpConnection();
            serializable = httpConnection.getListener();
            switch (n) {
                case 1: {
                    if (serializable.isIntegral(httpConnection)) break;
                    if (serializable.getIntegralPort() > 0) {
                        object = serializable.getIntegralScheme() + "://" + httpRequest.getHost() + ":" + serializable.getIntegralPort() + httpRequest.getPath();
                        if (httpRequest.getQuery() != null) {
                            object = (String)object + "?" + httpRequest.getQuery();
                        }
                        httpResponse.setContentLength(0);
                        httpResponse.sendRedirect((String)object);
                    } else {
                        HttpContext.sendContextError(httpResponse, 403, null);
                    }
                    return false;
                }
                case 2: {
                    if (serializable.isConfidential(httpConnection)) break;
                    if (serializable.getConfidentialPort() > 0) {
                        object = serializable.getConfidentialScheme() + "://" + httpRequest.getHost() + ":" + serializable.getConfidentialPort() + httpRequest.getPath();
                        if (httpRequest.getQuery() != null) {
                            object = (String)object + "?" + httpRequest.getQuery();
                        }
                        httpResponse.setContentLength(0);
                        httpResponse.sendRedirect((String)object);
                    } else {
                        HttpContext.sendContextError(httpResponse, 403, null);
                    }
                    return false;
                }
                default: {
                    HttpContext.sendContextError(httpResponse, 403, null);
                    return false;
                }
            }
        }
        if (!bl && object2 != null) {
            if (userRealm == null) {
                HttpContext.sendContextError(httpResponse, 500, "Configuration error");
                return false;
            }
            Principal principal = null;
            if (httpRequest.getAuthType() != null && httpRequest.getAuthUser() != null) {
                principal = httpRequest.getUserPrincipal();
                if (principal == null) {
                    principal = userRealm.authenticate(httpRequest.getAuthUser(), null, httpRequest);
                }
                if (principal == null && authenticator != null) {
                    principal = authenticator.authenticate(userRealm, string, httpRequest, httpResponse);
                }
            } else if (authenticator != null) {
                principal = authenticator.authenticate(userRealm, string, httpRequest, httpResponse);
            } else {
                log.warn((Object)("Mis-configured Authenticator for " + httpRequest.getPath()));
                HttpContext.sendContextError(httpResponse, 500, "Configuration error");
            }
            if (principal == null) {
                return false;
            }
            if (principal == __NOBODY) {
                return true;
            }
            if (object2 != ANY_ROLE) {
                boolean bl3 = false;
                int n2 = LazyList.size(object2);
                while (n2-- > 0) {
                    if (!userRealm.isUserInRole(principal, (String)LazyList.get(object2, n2))) continue;
                    bl3 = true;
                    break;
                }
                if (!bl3) {
                    log.warn((Object)("AUTH FAILURE: role for " + principal.getName()));
                    if (__BASIC_AUTH.equalsIgnoreCase(authenticator.getAuthMethod())) {
                        ((BasicAuthenticator)authenticator).sendChallenge(userRealm, httpResponse);
                    } else {
                        HttpContext.sendContextError(httpResponse, 403, "User not in required role");
                    }
                    return false;
                }
            }
        } else {
            httpRequest.setUserPrincipal(HttpRequest.__NOT_CHECKED);
        }
        return true;
    }

    public static class Nobody
    implements Principal {
        public String getName() {
            return "Nobody";
        }
    }
}

