/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.http;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Locale;
import java.util.TimeZone;
import javax.servlet.http.Cookie;
import org.apache.commons.logging.Log;
import org.mortbay.http.HttpRequest;
import org.mortbay.http.HttpResponse;
import org.mortbay.http.PathMap;
import org.mortbay.http.RequestLog;
import org.mortbay.log.LogFactory;
import org.mortbay.util.DateCache;
import org.mortbay.util.LogSupport;
import org.mortbay.util.RolloverFileOutputStream;
import org.mortbay.util.StringUtil;

public class NCSARequestLog
implements RequestLog {
    private static Log log = LogFactory.getLog(NCSARequestLog.class);
    private String _filename;
    private boolean _extended = true;
    private boolean _append = true;
    private int _retainDays = 31;
    private boolean _closeOut;
    private boolean _preferProxiedForAddress;
    private String _logDateFormat = "dd/MMM/yyyy:HH:mm:ss ZZZ";
    private Locale _logLocale = Locale.getDefault();
    private String _logTimeZone = TimeZone.getDefault().getID();
    private String[] _ignorePaths;
    private boolean _logLatency = false;
    private boolean _logCookies = false;
    private transient OutputStream _out;
    private transient OutputStream _fileOut;
    private transient DateCache _logDateCache;
    private transient PathMap _ignorePathMap;
    private transient Writer _writer;

    public NCSARequestLog() {
    }

    public NCSARequestLog(String string) throws IOException {
        this.setFilename(string);
    }

    public void setFilename(String string) {
        if (string != null && (string = string.trim()).length() == 0) {
            string = null;
        }
        this._filename = string;
    }

    public String getFilename() {
        return this._filename;
    }

    public String getDatedFilename() {
        if (this._fileOut instanceof RolloverFileOutputStream) {
            return ((RolloverFileOutputStream)this._fileOut).getDatedFilename();
        }
        return null;
    }

    public void setLogDateFormat(String string) {
        this._logDateFormat = string;
    }

    public String getLogDateFormat() {
        return this._logDateFormat;
    }

    public void setLogTimeZone(String string) {
        this._logTimeZone = string;
    }

    public String getLogTimeZone() {
        return this._logTimeZone;
    }

    public int getRetainDays() {
        return this._retainDays;
    }

    public void setRetainDays(int n) {
        this._retainDays = n;
    }

    public boolean isExtended() {
        return this._extended;
    }

    public void setExtended(boolean bl) {
        this._extended = bl;
    }

    public boolean isAppend() {
        return this._append;
    }

    public void setAppend(boolean bl) {
        this._append = bl;
    }

    public void setBuffered(boolean bl) {
    }

    public void setIgnorePaths(String[] stringArray) {
        this._ignorePaths = stringArray;
    }

    public String[] getIgnorePaths() {
        return this._ignorePaths;
    }

    public boolean getLogCookies() {
        return this._logCookies;
    }

    public void setLogCookies(boolean bl) {
        this._logCookies = bl;
    }

    public boolean getLogLatency() {
        return this._logLatency;
    }

    public void setLogLatency(boolean bl) {
        this._logLatency = bl;
    }

    public void setPreferProxiedForAddress(boolean bl) {
        this._preferProxiedForAddress = bl;
    }

    public void start() throws Exception {
        this._logDateCache = new DateCache(this._logDateFormat, this._logLocale);
        this._logDateCache.setTimeZoneID(this._logTimeZone);
        if (this._filename != null) {
            this._fileOut = new RolloverFileOutputStream(this._filename, this._append, this._retainDays);
            this._closeOut = true;
        } else {
            this._fileOut = System.err;
        }
        this._out = this._fileOut;
        if (this._ignorePaths != null && this._ignorePaths.length > 0) {
            this._ignorePathMap = new PathMap();
            for (int i = 0; i < this._ignorePaths.length; ++i) {
                this._ignorePathMap.put(this._ignorePaths[i], this._ignorePaths[i]);
            }
        } else {
            this._ignorePathMap = null;
        }
        this._writer = new OutputStreamWriter(this._out);
    }

    public boolean isStarted() {
        return this._fileOut != null;
    }

    public void stop() {
        try {
            if (this._writer != null) {
                this._writer.flush();
            }
        }
        catch (IOException iOException) {
            LogSupport.ignore(log, iOException);
        }
        if (this._out != null && this._closeOut) {
            try {
                this._out.close();
            }
            catch (IOException iOException) {
                LogSupport.ignore(log, iOException);
            }
        }
        this._out = null;
        this._fileOut = null;
        this._closeOut = false;
        this._logDateCache = null;
        this._writer = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log(HttpRequest httpRequest, HttpResponse httpResponse, int n) {
        try {
            if (this._ignorePathMap != null && this._ignorePathMap.getMatch(httpRequest.getPath()) != null) {
                return;
            }
            if (this._fileOut == null) {
                return;
            }
            StringBuffer stringBuffer = new StringBuffer(160);
            String string = null;
            if (this._preferProxiedForAddress) {
                string = httpRequest.getField("X-Forwarded-For");
            }
            if (string == null) {
                string = httpRequest.getRemoteAddr();
            }
            stringBuffer.append(string);
            stringBuffer.append(" - ");
            String string2 = httpRequest.getAuthUser();
            stringBuffer.append(string2 == null ? "-" : string2);
            stringBuffer.append(" [");
            stringBuffer.append(this._logDateCache.format(httpRequest.getTimeStamp()));
            stringBuffer.append("] \"");
            stringBuffer.append(httpRequest.getMethod());
            stringBuffer.append(' ');
            stringBuffer.append(httpRequest.getURI());
            stringBuffer.append(' ');
            stringBuffer.append(httpRequest.getVersion());
            stringBuffer.append("\" ");
            int n2 = httpResponse.getStatus();
            stringBuffer.append((char)(48 + n2 / 100 % 10));
            stringBuffer.append((char)(48 + n2 / 10 % 10));
            stringBuffer.append((char)(48 + n2 % 10));
            if (n >= 0) {
                stringBuffer.append(' ');
                if (n > 99999) {
                    stringBuffer.append(Integer.toString(n));
                } else {
                    if (n > 9999) {
                        stringBuffer.append((char)(48 + n / 10000 % 10));
                    }
                    if (n > 999) {
                        stringBuffer.append((char)(48 + n / 1000 % 10));
                    }
                    if (n > 99) {
                        stringBuffer.append((char)(48 + n / 100 % 10));
                    }
                    if (n > 9) {
                        stringBuffer.append((char)(48 + n / 10 % 10));
                    }
                    stringBuffer.append((char)(48 + n % 10));
                }
                stringBuffer.append(' ');
            } else {
                stringBuffer.append(" - ");
            }
            String string3 = stringBuffer.toString();
            Writer writer = this._writer;
            synchronized (writer) {
                this._writer.write(string3);
                if (this._extended) {
                    this.logExtended(httpRequest, httpResponse, this._writer);
                    if (!this._logCookies) {
                        this._writer.write(" -");
                    }
                }
                if (this._logCookies) {
                    Cookie[] cookieArray = httpRequest.getCookies();
                    if (cookieArray == null || cookieArray.length == 0) {
                        this._writer.write(" -");
                    } else {
                        this._writer.write(" \"");
                        for (int i = 0; i < cookieArray.length; ++i) {
                            if (i != 0) {
                                this._writer.write(59);
                            }
                            this._writer.write(cookieArray[i].getName());
                            this._writer.write(61);
                            this._writer.write(cookieArray[i].getValue());
                        }
                        this._writer.write("\"");
                    }
                }
                if (this._logLatency) {
                    this._writer.write(" " + (System.currentTimeMillis() - httpRequest.getTimeStamp()));
                }
                this._writer.write(StringUtil.__LINE_SEPARATOR);
                this._writer.flush();
            }
        }
        catch (IOException iOException) {
            log.warn((Object)"EXCEPTION ", (Throwable)iOException);
        }
    }

    protected void logExtended(HttpRequest httpRequest, HttpResponse httpResponse, Writer writer) throws IOException {
        String string = httpRequest.getField("Referer");
        if (string == null) {
            writer.write("\"-\" ");
        } else {
            writer.write(34);
            writer.write(string);
            writer.write("\" ");
        }
        String string2 = httpRequest.getField("User-Agent");
        if (string2 == null) {
            writer.write("\"-\"");
        } else {
            writer.write(34);
            writer.write(string2);
            writer.write(34);
        }
    }
}

