/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.Socket;
import org.apache.commons.logging.Log;
import org.mortbay.log.LogFactory;
import org.mortbay.util.IO;
import org.mortbay.util.LogSupport;

public class HttpTunnel {
    private static Log log = LogFactory.getLog(HttpTunnel.class);
    private Thread _thread;
    private int _timeoutMs;
    private Socket _socket;
    private InputStream _sIn;
    private OutputStream _sOut;
    private InputStream _in;
    private OutputStream _out;

    protected HttpTunnel() {
    }

    public HttpTunnel(Socket socket, InputStream inputStream, OutputStream outputStream) throws IOException {
        this._socket = socket;
        this._sIn = inputStream;
        this._sOut = outputStream;
        if (this._sIn == null) {
            this._sIn = this._socket.getInputStream();
        }
        if (this._sOut == null) {
            this._sOut = socket.getOutputStream();
        }
        this._timeoutMs = 30000;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void handle(InputStream inputStream, OutputStream outputStream) {
        block15: {
            Copy copy = new Copy();
            this._in = inputStream;
            this._out = outputStream;
            this._thread = Thread.currentThread();
            copy.start();
            this.copydata(this._sIn, this._out);
            Object var6_4 = null;
            try {
                this._in.close();
                if (this._socket != null) {
                    this._socket.shutdownOutput();
                    this._socket.close();
                } else {
                    this._sIn.close();
                    this._sOut.close();
                }
            }
            catch (Exception exception) {
                LogSupport.ignore(log, exception);
            }
            copy.interrupt();
            {
                break block15;
                catch (Exception exception) {
                    LogSupport.ignore(log, exception);
                    Object var6_5 = null;
                    try {
                        this._in.close();
                        if (this._socket != null) {
                            this._socket.shutdownOutput();
                            this._socket.close();
                        } else {
                            this._sIn.close();
                            this._sOut.close();
                        }
                    }
                    catch (Exception exception2) {
                        LogSupport.ignore(log, exception2);
                    }
                    copy.interrupt();
                }
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                try {
                    this._in.close();
                    if (this._socket != null) {
                        this._socket.shutdownOutput();
                        this._socket.close();
                    } else {
                        this._sIn.close();
                        this._sOut.close();
                    }
                }
                catch (Exception exception) {
                    LogSupport.ignore(log, exception);
                }
                copy.interrupt();
                throw throwable;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void copydata(InputStream inputStream, OutputStream outputStream) throws IOException {
        long l = 0L;
        long l2 = 0L;
        while (true) {
            try {
                do {
                    l2 = HttpTunnel.copyBytes(inputStream, outputStream, -1L);
                    l = 0L;
                } while (l2 != -1L);
                return;
            }
            catch (InterruptedIOException interruptedIOException) {
                LogSupport.ignore(log, interruptedIOException);
                if (l == 0L) {
                    l = System.currentTimeMillis();
                    continue;
                }
                if (this._timeoutMs > 0 && System.currentTimeMillis() - l > (long)this._timeoutMs) throw interruptedIOException;
                continue;
            }
            break;
        }
    }

    public static int copyBytes(InputStream inputStream, OutputStream outputStream, long l) throws IOException {
        byte[] byArray = new byte[IO.bufferSize];
        int n = IO.bufferSize;
        int n2 = 0;
        if (l >= 0L) {
            n2 = (int)l;
            while (l > 0L) {
                try {
                    n = l < (long)IO.bufferSize ? inputStream.read(byArray, 0, (int)l) : inputStream.read(byArray, 0, IO.bufferSize);
                    if (n == -1 && (long)n2 == l) {
                        n2 = (int)l - 1;
                    }
                }
                catch (InterruptedIOException interruptedIOException) {
                    if ((long)n2 == l) {
                        throw interruptedIOException;
                    }
                    LogSupport.ignore(log, interruptedIOException);
                    n = 0;
                }
                if (n <= 0) break;
                l -= (long)n;
                outputStream.write(byArray, 0, n);
            }
            n2 = (int)((long)n2 - l);
        } else {
            while (n > 0) {
                try {
                    n = inputStream.read(byArray, 0, IO.bufferSize);
                    if (n == -1 && n2 == 0) {
                        n2 = -1;
                    }
                }
                catch (InterruptedIOException interruptedIOException) {
                    if (n2 == 0) {
                        throw interruptedIOException;
                    }
                    LogSupport.ignore(log, interruptedIOException);
                    n = 0;
                }
                if (n <= 0) continue;
                outputStream.write(byArray, 0, n);
                n2 += n;
            }
        }
        return n2;
    }

    public Socket getSocket() {
        return this._socket;
    }

    public int getTimeoutMs() {
        return this._timeoutMs;
    }

    public void setTimeoutMs(int n) {
        this._timeoutMs = n;
    }

    private class Copy
    extends Thread {
        private Copy() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public void run() {
            block15: {
                HttpTunnel.this.copydata(HttpTunnel.this._in, HttpTunnel.this._sOut);
                Object var3_1 = null;
                try {
                    HttpTunnel.this._out.close();
                    if (HttpTunnel.this._socket != null) {
                        HttpTunnel.this._socket.shutdownInput();
                        HttpTunnel.this._socket.close();
                    } else {
                        HttpTunnel.this._sOut.close();
                        HttpTunnel.this._sIn.close();
                    }
                }
                catch (Exception exception) {
                    LogSupport.ignore(log, exception);
                }
                HttpTunnel.this._thread.interrupt();
                {
                    break block15;
                    catch (Exception exception) {
                        LogSupport.ignore(log, exception);
                        Object var3_2 = null;
                        try {
                            HttpTunnel.this._out.close();
                            if (HttpTunnel.this._socket != null) {
                                HttpTunnel.this._socket.shutdownInput();
                                HttpTunnel.this._socket.close();
                            } else {
                                HttpTunnel.this._sOut.close();
                                HttpTunnel.this._sIn.close();
                            }
                        }
                        catch (Exception exception2) {
                            LogSupport.ignore(log, exception2);
                        }
                        HttpTunnel.this._thread.interrupt();
                    }
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    try {
                        HttpTunnel.this._out.close();
                        if (HttpTunnel.this._socket != null) {
                            HttpTunnel.this._socket.shutdownInput();
                            HttpTunnel.this._socket.close();
                        } else {
                            HttpTunnel.this._sOut.close();
                            HttpTunnel.this._sIn.close();
                        }
                    }
                    catch (Exception exception) {
                        LogSupport.ignore(log, exception);
                    }
                    HttpTunnel.this._thread.interrupt();
                    throw throwable;
                }
            }
        }
    }
}

