/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.http;

import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import javax.servlet.http.Cookie;
import org.apache.commons.logging.Log;
import org.mortbay.http.HttpConnection;
import org.mortbay.http.HttpContext;
import org.mortbay.http.HttpFields;
import org.mortbay.http.HttpHandler;
import org.mortbay.http.HttpInputStream;
import org.mortbay.http.HttpMessage;
import org.mortbay.http.HttpOutputStream;
import org.mortbay.http.HttpRequest;
import org.mortbay.http.Version;
import org.mortbay.log.LogFactory;
import org.mortbay.util.StringUtil;
import org.mortbay.util.TypeUtil;
import org.mortbay.util.UrlEncoded;

public class HttpResponse
extends HttpMessage {
    private static Log log = LogFactory.getLog(HttpResponse.class);
    public static final int __100_Continue = 100;
    public static final int __101_Switching_Protocols = 101;
    public static final int __102_Processing = 102;
    public static final int __200_OK = 200;
    public static final int __201_Created = 201;
    public static final int __202_Accepted = 202;
    public static final int __203_Non_Authoritative_Information = 203;
    public static final int __204_No_Content = 204;
    public static final int __205_Reset_Content = 205;
    public static final int __206_Partial_Content = 206;
    public static final int __207_Multi_Status = 207;
    public static final int __300_Multiple_Choices = 300;
    public static final int __301_Moved_Permanently = 301;
    public static final int __302_Moved_Temporarily = 302;
    public static final int __302_Found = 302;
    public static final int __303_See_Other = 303;
    public static final int __304_Not_Modified = 304;
    public static final int __305_Use_Proxy = 305;
    public static final int __400_Bad_Request = 400;
    public static final int __401_Unauthorized = 401;
    public static final int __402_Payment_Required = 402;
    public static final int __403_Forbidden = 403;
    public static final int __404_Not_Found = 404;
    public static final int __405_Method_Not_Allowed = 405;
    public static final int __406_Not_Acceptable = 406;
    public static final int __407_Proxy_Authentication_Required = 407;
    public static final int __408_Request_Timeout = 408;
    public static final int __409_Conflict = 409;
    public static final int __410_Gone = 410;
    public static final int __411_Length_Required = 411;
    public static final int __412_Precondition_Failed = 412;
    public static final int __413_Request_Entity_Too_Large = 413;
    public static final int __414_Request_URI_Too_Large = 414;
    public static final int __415_Unsupported_Media_Type = 415;
    public static final int __416_Requested_Range_Not_Satisfiable = 416;
    public static final int __417_Expectation_Failed = 417;
    public static final int __422_Unprocessable_Entity = 422;
    public static final int __423_Locked = 423;
    public static final int __424_Failed_Dependency = 424;
    public static final int __500_Internal_Server_Error = 500;
    public static final int __501_Not_Implemented = 501;
    public static final int __502_Bad_Gateway = 502;
    public static final int __503_Service_Unavailable = 503;
    public static final int __504_Gateway_Timeout = 504;
    public static final int __505_HTTP_Version_Not_Supported = 505;
    public static final int __507_Insufficient_Storage = 507;
    public static final HashMap __statusMsg = new HashMap();
    static byte[] __Continue;
    private int _status = 200;
    private String _reason;
    private HttpContext _httpContext;

    public HttpResponse() {
        this._version = "HTTP/1.1";
        this._dotVersion = 1;
        this._state = 0;
    }

    public HttpResponse(HttpConnection httpConnection) {
        super(httpConnection);
        this._version = "HTTP/1.1";
        this._dotVersion = 1;
        this._state = 0;
    }

    public HttpContext getHttpContext() {
        return this._httpContext;
    }

    public void setHttpContext(HttpContext httpContext) {
        this._httpContext = httpContext;
    }

    public boolean isDirty() {
        return this._status != 200 || super.isDirty();
    }

    public void reset() {
        if (this.isCommitted()) {
            throw new IllegalStateException("Already committed");
        }
        try {
            ((HttpOutputStream)this.getOutputStream()).resetBuffer();
            this._status = 200;
            this._reason = null;
            super.reset();
            this.setField("Date", this.getRequest().getTimeStampStr());
            if (!Version.isParanoid()) {
                this.setField("Server", Version.getDetail());
            }
        }
        catch (Exception exception) {
            log.warn((Object)"EXCEPTION ", (Throwable)exception);
            throw new IllegalStateException(exception.toString());
        }
    }

    public HttpRequest getRequest() {
        return this.getHttpRequest();
    }

    public HttpRequest getHttpRequest() {
        if (this._connection == null) {
            return null;
        }
        return this._connection.getRequest();
    }

    public void readHeader(HttpInputStream httpInputStream) throws IOException {
        this._state = 1;
        log.warn((Object)"NOT IMPLEMENTED ");
    }

    public void writeHeader(Writer writer) throws IOException {
        if (this._state != 0) {
            throw new IllegalStateException(__state[this._state] + " is not EDITABLE");
        }
        if (this._header == null) {
            throw new IllegalStateException("Response is destroyed");
        }
        if (this.getHttpRequest().getDotVersion() >= 0) {
            this._state = 1;
            writer.write(this._version);
            writer.write(32);
            writer.write(48 + this._status / 100 % 10);
            writer.write(48 + this._status / 10 % 10);
            writer.write(48 + this._status % 10);
            writer.write(32);
            writer.write(this.getReason());
            writer.write(HttpFields.__CRLF);
            this._header.write(writer);
        }
        this._state = 3;
    }

    public int getStatus() {
        return this._status;
    }

    public void setStatus(int n) {
        this._status = n;
    }

    public String getReason() {
        if (this._reason != null) {
            return this._reason;
        }
        this._reason = (String)__statusMsg.get(TypeUtil.newInteger(this._status));
        if (this._reason == null) {
            this._reason = "unknown";
        }
        return this._reason;
    }

    public void setReason(String string) {
        this._reason = string;
    }

    public void setStatus(int n, String string) {
        this.setStatus(n);
        Integer n2 = TypeUtil.newInteger(n);
        if (string == null) {
            string = (String)__statusMsg.get(n2);
            if (string == null) {
                string = "" + n;
            }
            this.setReason(string);
        } else {
            this.setReason(UrlEncoded.encodeString(string));
        }
    }

    public void sendError(int n, String string) throws IOException {
        this.setStatus(n, string);
        HttpRequest httpRequest = this.getHttpRequest();
        if (n != 204 && n != 304 && n != 206 && n >= 200) {
            Object object;
            if (this.getHttpContext() != null && (object = this.getHttpContext().getAttribute("org.mortbay.http.ErrorHandler")) != null && object instanceof HttpHandler) {
                ((HttpHandler)object).handle(httpRequest.getPath(), null, httpRequest, this);
            }
        } else if (n != 206) {
            this._header.remove("Content-Type");
            this._header.remove("Content-Length");
            this._characterEncoding = null;
            this._mimeType = null;
        }
        this.commit();
    }

    public void sendError(int n) throws IOException {
        this.sendError(n, null);
    }

    public void sendRedirect(String string) throws IOException {
        if (this.isCommitted()) {
            throw new IllegalStateException("Commited");
        }
        this._header.put("Location", string);
        this.setStatus(302);
        this.commit();
    }

    public void addSetCookie(String string, String string2) {
        this._header.addSetCookie(new Cookie(string, string2));
    }

    public void addSetCookie(Cookie cookie) {
        this._header.addSetCookie(cookie);
    }

    public void completing() {
        this.getHttpConnection().completing();
    }

    public void commit() throws IOException {
        if (!this.isCommitted()) {
            this.getOutputStream().flush();
        }
        this.getHttpConnection().commit();
    }

    void recycle(HttpConnection httpConnection) {
        super.recycle(httpConnection);
        this._status = 200;
        this._reason = null;
        this._httpContext = null;
    }

    public void destroy() {
        this._reason = null;
        super.destroy();
    }

    static {
        try {
            Field[] fieldArray = HttpResponse.class.getDeclaredFields();
            int n = fieldArray.length;
            while (n-- > 0) {
                int n2 = fieldArray[n].getModifiers();
                String string = fieldArray[n].getName();
                if (!Modifier.isFinal(n2) || !Modifier.isStatic(n2) || !fieldArray[n].getType().equals(Integer.TYPE) || !string.startsWith("__") || !Character.isDigit(string.charAt(2))) continue;
                String string2 = string.substring(6);
                string2 = string2.replace('_', ' ');
                __statusMsg.put(fieldArray[n].get(null), string2);
            }
        }
        catch (Exception exception) {
            log.warn((Object)"EXCEPTION ", (Throwable)exception);
        }
        try {
            __Continue = "HTTP/1.1 100 Continue\r\n\r\n".getBytes(StringUtil.__ISO_8859_1);
        }
        catch (Exception exception) {
            log.fatal((Object)exception);
            System.exit(1);
        }
    }
}

