/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.http;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.apache.commons.logging.Log;
import org.mortbay.http.ChunkingInputStream;
import org.mortbay.http.HttpFields;
import org.mortbay.http.HttpResponse;
import org.mortbay.log.LogFactory;
import org.mortbay.util.LineInput;
import org.mortbay.util.StringUtil;

public class HttpInputStream
extends FilterInputStream {
    private static Log log = LogFactory.getLog(HttpInputStream.class);
    private static ClosedStream __closedStream = new ClosedStream();
    private ChunkingInputStream _deChunker;
    private LineInput _realIn;
    private boolean _chunking;
    private OutputStream _expectContinues;

    public HttpInputStream(InputStream inputStream) {
        this(inputStream, 4096);
    }

    public HttpInputStream(InputStream inputStream, int n) {
        super(null);
        try {
            this._realIn = new LineInput(inputStream, n, StringUtil.__ISO_8859_1);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            log.fatal((Object)unsupportedEncodingException);
            System.exit(1);
        }
        this.in = this._realIn;
    }

    public OutputStream getExpectContinues() {
        return this._expectContinues;
    }

    public void setExpectContinues(OutputStream outputStream) {
        this._expectContinues = outputStream;
    }

    public int read() throws IOException {
        if (this._expectContinues != null) {
            this.expectContinues();
        }
        return super.read();
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this._expectContinues != null) {
            this.expectContinues();
        }
        return super.read(byArray, n, n2);
    }

    public int read(byte[] byArray) throws IOException {
        if (this._expectContinues != null) {
            this.expectContinues();
        }
        return super.read(byArray);
    }

    public long skip(long l) throws IOException {
        if (this._expectContinues != null) {
            this.expectContinues();
        }
        return super.skip(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void expectContinues() throws IOException {
        try {
            if (this.available() <= 0) {
                this._expectContinues.write(HttpResponse.__Continue);
                this._expectContinues.flush();
            }
        }
        finally {
            this._expectContinues = null;
        }
    }

    public InputStream getInputStream() {
        return this._realIn;
    }

    public InputStream getFilterStream() {
        return this.in;
    }

    public void setFilterStream(InputStream inputStream) {
        this.in = inputStream;
    }

    public boolean isChunking() {
        return this._chunking;
    }

    public void setChunking() throws IllegalStateException {
        if (this._realIn.getByteLimit() >= 0) {
            throw new IllegalStateException("Has Content-Length");
        }
        if (this._deChunker == null) {
            this._deChunker = new ChunkingInputStream(this._realIn);
        }
        this.in = this._deChunker;
        this._chunking = true;
        this._deChunker._trailer = null;
    }

    public void resetStream() throws IllegalStateException {
        if (this._deChunker != null && this._deChunker._chunkSize > 0 || this._realIn.getByteLimit() > 0) {
            throw new IllegalStateException("Unread input");
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)"resetStream()");
        }
        this.in = this._realIn;
        if (this._deChunker != null) {
            this._deChunker.resetStream();
        }
        this._chunking = false;
        this._realIn.setByteLimit(-1);
    }

    public void close() throws IOException {
        this.in = __closedStream;
    }

    public void setContentLength(int n) {
        if (this._chunking && n >= 0 && this.getExpectContinues() == null) {
            throw new IllegalStateException("Chunking");
        }
        this._realIn.setByteLimit(n);
    }

    void unsafeSetContentLength(int n) {
        this._realIn.setByteLimit(n);
    }

    public int getContentLength() {
        return this._realIn.getByteLimit();
    }

    public HttpFields getTrailer() {
        return this._deChunker._trailer;
    }

    public void destroy() {
        if (this._realIn != null) {
            this._realIn.destroy();
        }
        this._realIn = null;
        this._deChunker = null;
        this._expectContinues = null;
    }

    private static class ClosedStream
    extends InputStream {
        private ClosedStream() {
        }

        public int read() throws IOException {
            return -1;
        }
    }
}

