/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.http;

import java.io.IOException;
import java.io.OutputStream;
import org.mortbay.http.BufferedOutputStream;
import org.mortbay.http.HttpMessage;

public class ChunkingOutputStream
extends BufferedOutputStream
implements HttpMessage.HeaderWriter {
    static final byte[] __CRLF = new byte[]{13, 10};
    static final byte[] __CHUNK_EOF = new byte[]{48, 13, 10, 13, 10};
    static final int __CHUNK_RESERVE = 8;
    static final int __EOF_RESERVE = 8;
    private boolean _chunking;
    private boolean _complete;
    private boolean _completed;

    public ChunkingOutputStream(OutputStream outputStream, int n, int n2) {
        this(outputStream, n, n2, true);
    }

    public ChunkingOutputStream(OutputStream outputStream, int n, int n2, boolean bl) {
        super(outputStream, n, n2, 8, 8);
        this._chunking = bl;
        this.setBypassBuffer(true);
        this.setFixed(true);
    }

    public boolean isChunking() {
        return this._chunking;
    }

    public void setChunking(boolean bl) {
        this._chunking = bl;
    }

    public void close() throws IOException {
        this._complete = true;
        this.flush();
    }

    public void resetStream() {
        this._complete = false;
        this._completed = false;
        this._chunking = true;
        super.resetStream();
    }

    protected void wrapBuffer() throws IOException {
        if (this._chunking && this.size() > 0) {
            this.prewrite(__CRLF, 0, __CRLF.length);
            for (int i = this.size(); i > 0; i /= 16) {
                int n = i % 16;
                if (n <= 9) {
                    this.prewrite(48 + n);
                    continue;
                }
                this.prewrite(87 + n);
            }
            this.postwrite(__CRLF, 0, __CRLF.length);
        }
        if (this._complete && !this._completed) {
            this._completed = true;
            if (this._chunking) {
                this.postwrite(__CHUNK_EOF, 0, __CHUNK_EOF.length);
            }
        }
    }

    protected void bypassWrite(byte[] byArray, int n, int n2) throws IOException {
        int n3 = 9;
        this._buf[10] = 10;
        this._buf[9] = 13;
        for (int i = n2; i > 0; i /= 16) {
            int n4 = i % 16;
            this._buf[--n3] = n4 <= 9 ? (byte)(48 + n4) : (byte)(87 + n4);
        }
        if (this._chunking) {
            this._out.write(this._buf, n3, 10 - n3 + 1);
        }
        this._out.write(byArray, n, n2);
        if (this._chunking) {
            this._out.write(__CRLF, 0, __CRLF.length);
        }
        this._out.flush();
    }
}

