/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.html;

import java.io.IOException;
import java.io.Writer;
import java.util.Dictionary;
import java.util.Hashtable;
import org.mortbay.html.Composite;
import org.mortbay.html.FrameSet;

public class Page
extends Composite {
    public static final String Request = "Request";
    public static final String Response = "Response";
    public static final String Header = "Header";
    public static final String Title = "Title";
    public static final String Section = "Section";
    public static final String HeaderSize = "HdrSize";
    public static final String Footer = "Footer";
    public static final String FooterSize = "FtrSize";
    public static final String Content = "Content";
    public static final String ContentSize = "CntSize";
    public static final String Margin = "Margin";
    public static final String MarginSize = "MrgSize";
    public static final String LeftMargin = "Left";
    public static final String LeftMarginSize = "LMSize";
    public static final String RightMargin = "Right";
    public static final String RightMarginSize = "RMSize";
    public static final String Help = "Help";
    public static final String Home = "Home";
    public static final String Heading = "Heading";
    public static final String Up = "Up";
    public static final String Prev = "Prev";
    public static final String Next = "Next";
    public static final String Back = "Back";
    public static final String Target = "Target";
    public static final String BaseUrl = "BaseUrl";
    public static final String FgColour = "FgColour";
    public static final String BgColour = "BgColour";
    public static final String HighlightColour = "HlColour";
    public static final String PageType = "PageType";
    public static final String NoTitle = "No Title";
    protected Hashtable properties = new Hashtable(10);
    Hashtable sections = new Hashtable(10);
    private Composite head = new Composite();
    private String base = "";
    private boolean writtenHtmlHead = false;
    private boolean writtenBodyTag = false;

    public Page() {
        this(NoTitle);
    }

    public Page(String string) {
        this.title(string);
    }

    public Page(String string, String string2) {
        this.title(string);
        this.attribute(string2);
    }

    public Page title(String string) {
        this.properties.put(Title, string);
        String string2 = (String)this.properties.get(Heading);
        if (string2 == null || string2.equals(NoTitle)) {
            this.properties.put(Heading, string);
        }
        return this;
    }

    public Page addHeader(Object object) {
        this.head.add("\n");
        this.head.add(object);
        return this;
    }

    public final Page setBackGroundImage(String string) {
        this.attribute("background", string);
        return this;
    }

    public final Page setBackGroundColor(String string) {
        this.properties.put(BgColour, string);
        this.attribute("bgcolor", string);
        return this;
    }

    public final Page setBase(String string, String string2) {
        this.base = "<base " + (string != null ? "TARGET=\"" + string + "\"" : "") + (string2 != null ? "HREF=\"" + string2 + "\"" : "") + ">";
        return this;
    }

    public void write(Writer writer) throws IOException {
        this.writeHtmlHead(writer);
        this.writeBodyTag(writer);
        this.writeElements(writer);
        this.writeHtmlEnd(writer);
    }

    public void writeHtmlHead(Writer writer) throws IOException {
        if (!this.writtenHtmlHead) {
            this.writtenHtmlHead = true;
            this.completeSections();
            writer.write("<html><head>");
            String string = (String)this.properties.get(Title);
            if (string != null && string.length() > 0 && !string.equals(NoTitle)) {
                writer.write("<title>" + string + "</title>");
            }
            this.head.write(writer);
            writer.write(this.base);
            writer.write("\n</head>\n");
        }
    }

    public void writeBodyTag(Writer writer) throws IOException {
        if (!this.writtenBodyTag) {
            this.writtenBodyTag = true;
            writer.write("<body " + this.attributes() + ">\n");
        }
    }

    public void writeHtmlEnd(Writer writer) throws IOException {
        writer.write("\n</body>\n");
        writer.write("</html>\n");
    }

    public void writeElements(Writer writer) throws IOException {
        super.write(writer);
    }

    public void write(Writer writer, String string, boolean bl) throws IOException {
        this.writeHtmlHead(writer);
        this.writeBodyTag(writer);
        Composite composite = this.getSection(string);
        if (composite == null) {
            if (string.equals(Content)) {
                this.writeElements(writer);
            }
        } else {
            composite.write(writer);
        }
        if (bl) {
            this.writeHtmlEnd(writer);
        }
        writer.flush();
    }

    public void flush(Writer writer) throws IOException {
        this.writeHtmlHead(writer);
        this.writeBodyTag(writer);
        super.flush(writer);
    }

    public void rewind() {
        this.writtenHtmlHead = false;
        this.writtenBodyTag = false;
    }

    public Dictionary properties() {
        return this.properties;
    }

    public FrameSet frameSet() {
        return null;
    }

    public void setSection(String string, Composite composite) {
        this.sections.put(string, composite);
    }

    public void addSection(String string, Composite composite) {
        this.sections.put(string, composite);
        this.add(composite);
    }

    public Composite getSection(String string) {
        return (Composite)this.sections.get(string);
    }

    public void addTo(String string, Object object) {
        Composite composite = (Composite)this.sections.get(string);
        if (composite == null) {
            this.add(object);
        } else {
            composite.add(object);
        }
    }

    protected void completeSections() {
    }
}

