/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.servlet.jmx;

import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.mortbay.jetty.servlet.WebApplicationContext;
import org.mortbay.jetty.servlet.jmx.ServletHttpContextMBean;
import org.mortbay.log.LogFactory;
import org.mortbay.util.LifeCycleEvent;
import org.mortbay.util.LifeCycleListener;

public class WebApplicationContextMBean
extends ServletHttpContextMBean {
    private static final Log log = LogFactory.getLog((Class)WebApplicationContextMBean.class);
    private WebApplicationContext _webappContext;
    private Map _configurations = new HashMap();

    protected void defineManagedResource() {
        super.defineManagedResource();
        this.defineAttribute("displayName", false);
        this.defineAttribute("defaultsDescriptor", true);
        this.defineAttribute("WAR", true);
        this.defineAttribute("extractWAR", true);
        this._webappContext = (WebApplicationContext)this.getManagedResource();
        this._webappContext.addEventListener((EventListener)new LifeCycleListener(){

            public void lifeCycleStarting(LifeCycleEvent lifeCycleEvent) {
            }

            public void lifeCycleStarted(LifeCycleEvent lifeCycleEvent) {
                WebApplicationContextMBean.this.getConfigurations();
            }

            public void lifeCycleFailure(LifeCycleEvent lifeCycleEvent) {
            }

            public void lifeCycleStopping(LifeCycleEvent lifeCycleEvent) {
            }

            public void lifeCycleStopped(LifeCycleEvent lifeCycleEvent) {
                WebApplicationContextMBean.this.destroyConfigurations();
            }
        });
    }

    public void postRegister(Boolean bl) {
        super.postRegister(bl);
        this.getConfigurations();
    }

    public void postDeregister() {
        this.destroyConfigurations();
        super.postDeregister();
    }

    public ObjectName[] getConfigurations() {
        return this.getComponentMBeans(this._webappContext.getConfigurations(), this._configurations);
    }

    public void destroyConfigurations() {
        MBeanServer mBeanServer = this.getMBeanServer();
        Iterator iterator = this._configurations.values().iterator();
        while (iterator.hasNext()) {
            try {
                ObjectName objectName = (ObjectName)iterator.next();
                log.debug((Object)("Unregistering: " + objectName));
                if (null == mBeanServer) continue;
                mBeanServer.unregisterMBean(objectName);
            }
            catch (Exception exception) {
                log.warn((Object)"EXCEPTION ", (Throwable)exception);
            }
        }
        this._configurations.clear();
    }
}

