/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.http.jmx;

import java.util.EventListener;
import java.util.HashMap;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.ObjectName;
import javax.management.modelmbean.InvalidTargetObjectTypeException;
import javax.management.modelmbean.ModelMBean;
import org.apache.commons.logging.Log;
import org.mortbay.http.HttpServer;
import org.mortbay.http.Version;
import org.mortbay.log.LogFactory;
import org.mortbay.util.ComponentEvent;
import org.mortbay.util.ComponentListener;
import org.mortbay.util.jmx.LifeCycleMBean;
import org.mortbay.util.jmx.ModelMBeanImpl;

public class HttpServerMBean
extends LifeCycleMBean
implements ComponentListener {
    private static Log log = LogFactory.getLog((Class)HttpServerMBean.class);
    private HttpServer _httpServer;
    private HashMap _mbeanMap = new HashMap();

    protected HttpServerMBean(HttpServer httpServer) throws MBeanException, InstanceNotFoundException {
        this._httpServer = httpServer;
        this._httpServer.addEventListener((EventListener)((Object)this));
        try {
            super.setManagedResource(this._httpServer, "objectReference");
        }
        catch (InvalidTargetObjectTypeException invalidTargetObjectTypeException) {
            log.warn((Object)"EXCEPTION ", (Throwable)invalidTargetObjectTypeException);
        }
    }

    public HttpServerMBean() throws MBeanException, InstanceNotFoundException {
        this(new HttpServer());
    }

    public void setManagedResource(Object object, String string) throws MBeanException, InstanceNotFoundException, InvalidTargetObjectTypeException {
        if (object != null) {
            ((HttpServer)object).addEventListener((EventListener)((Object)this));
        }
        super.setManagedResource(object, string);
    }

    protected void defineManagedResource() {
        super.defineManagedResource();
        this.defineAttribute("listeners", false);
        this.defineAttribute("contexts", false);
        this.defineAttribute("version", false, true);
        this.defineAttribute("components", false, true);
        this.defineAttribute("requestLog");
        this.defineAttribute("trace");
        this.defineOperation("addListener", new String[]{"java.lang.String"}, 1);
        this.defineOperation("addListener", new String[]{"org.mortbay.util.InetAddrPort"}, 1);
        this.defineOperation("addListener", new String[]{"org.mortbay.http.HttpListener"}, 1);
        this.defineOperation("removeListener", new String[]{"org.mortbay.http.HttpListener"}, 1);
        this.defineOperation("addContext", new String[]{"org.mortbay.http.HttpContext"}, 1);
        this.defineOperation("removeContext", new String[]{"org.mortbay.http.HttpContext"}, 1);
        this.defineOperation("addContext", new String[]{"java.lang.String"}, 1);
        this.defineOperation("addContext", new String[]{"java.lang.String", "java.lang.String"}, 1);
        this.defineAttribute("requestsPerGC");
        this.defineAttribute("statsOn");
        this.defineAttribute("statsOnMs");
        this.defineOperation("statsReset", 1);
        this.defineAttribute("connections");
        this.defineAttribute("connectionsOpen");
        this.defineAttribute("connectionsOpenMin");
        this.defineAttribute("connectionsOpenMax");
        this.defineAttribute("connectionsDurationAve");
        this.defineAttribute("connectionsDurationMin");
        this.defineAttribute("connectionsDurationMax");
        this.defineAttribute("connectionsDurationTotal");
        this.defineAttribute("connectionsRequestsAve");
        this.defineAttribute("connectionsRequestsMin");
        this.defineAttribute("connectionsRequestsMax");
        this.defineAttribute("errors");
        this.defineAttribute("requests");
        this.defineAttribute("requestsActive");
        this.defineAttribute("requestsActiveMin");
        this.defineAttribute("requestsActiveMax");
        this.defineAttribute("requestsDurationAve");
        this.defineAttribute("requestsDurationMin");
        this.defineAttribute("requestsDurationMax");
        this.defineOperation("stop", new String[]{"java.lang.Boolean.TYPE"}, 1);
        this.defineOperation("save", new String[]{"java.lang.String"}, 1);
        this.defineOperation("destroy", 1);
    }

    public synchronized void addComponent(ComponentEvent componentEvent) {
        try {
            Object object;
            ModelMBean modelMBean;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Component added " + componentEvent));
            }
            if ((modelMBean = ModelMBeanImpl.mbeanFor(object = componentEvent.getComponent())) == null) {
                log.warn((Object)("No MBean for " + object));
            } else {
                ObjectName objectName = null;
                if (modelMBean instanceof ModelMBeanImpl) {
                    ((ModelMBeanImpl)modelMBean).setBaseObjectName(this.getObjectName().toString());
                    objectName = this.getMBeanServer().registerMBean(modelMBean, null).getObjectName();
                } else {
                    objectName = this.uniqueObjectName(this.getMBeanServer(), object, this.getObjectName().toString());
                    objectName = this.getMBeanServer().registerMBean(modelMBean, objectName).getObjectName();
                }
                Holder holder = new Holder(objectName, modelMBean);
                this._mbeanMap.put(object, holder);
            }
        }
        catch (Exception exception) {
            log.warn((Object)"EXCEPTION ", (Throwable)exception);
        }
    }

    public String getVersion() {
        return Version.getDetail();
    }

    public ObjectName[] getComponents() {
        Holder[] holderArray = this._mbeanMap.values().toArray(new Holder[this._mbeanMap.size()]);
        ObjectName[] objectNameArray = new ObjectName[holderArray.length];
        for (int i = 0; i < objectNameArray.length; ++i) {
            objectNameArray[i] = holderArray[i].oName;
        }
        return objectNameArray;
    }

    public synchronized void removeComponent(ComponentEvent componentEvent) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Component removed " + componentEvent));
        }
        try {
            Object object = componentEvent.getComponent();
            Holder holder = (Holder)this._mbeanMap.remove(object);
            if (holder != null) {
                this.getMBeanServer().unregisterMBean(holder.oName);
            } else if (object == this._httpServer) {
                this.getMBeanServer().unregisterMBean(this.getObjectName());
            }
        }
        catch (Exception exception) {
            log.warn((Object)"EXCEPTION ", (Throwable)exception);
        }
    }

    public void postRegister(Boolean bl) {
        super.postRegister(bl);
    }

    public void postDeregister() {
        this._httpServer.removeEventListener((EventListener)((Object)this));
        this._httpServer = null;
        if (this._mbeanMap != null) {
            this._mbeanMap.clear();
        }
        this._mbeanMap = null;
        super.postDeregister();
    }

    private static class Holder {
        ObjectName oName;
        Object mbean;

        Holder(ObjectName objectName, Object object) {
            this.oName = objectName;
            this.mbean = object;
        }
    }
}

