/*
 * Copyright PMEase (c) 2005-2006,
 * Date: 2006-1-11
 * Time: 18:30:08
 * All rights reserved.
 */

import com.caucho.hessian.client.HessianProxyFactory;
import com.pmease.quickbuild.RemoteService;
import com.pmease.quickbuild.model.UserFacade;
import com.pmease.quickbuild.model.UserGroupRelationFacade;
import com.pmease.quickbuild.model.ConfigurationAuthorizationFacade;

import java.net.MalformedURLException;
import java.util.List;
import java.util.Iterator;

/**
 * This sample demonstrates how to dump all configurations accessible by current user.
 */
public class DumpAllAccessibleConfigurations {
    public static void main(String[] args) throws MalformedURLException {
        HessianProxyFactory factory = new HessianProxyFactory();

        // specify login information here.
        factory.setUser("user1");
        factory.setPassword("user1");

        // specify hessian service URL of your QuickBuild installation.
        RemoteService remote = (RemoteService) factory.create(RemoteService.class,
                "http://localhost:8080/app.do?service=hessian");

        UserFacade user = remote.getUserByName("user1");
        List relations = remote.getUserGroupRelationsByUser(user.getId());
        for (Iterator it1 = relations.iterator(); it1.hasNext();) {
            UserGroupRelationFacade relation = (UserGroupRelationFacade) it1.next();
            List authorizations = remote.getConfigurationAuthorizationsByGroup(relation.getGroup());
            for (Iterator it2 = authorizations.iterator(); it2.hasNext();) {
                ConfigurationAuthorizationFacade authorization = (ConfigurationAuthorizationFacade) it2.next();
                System.out.println(remote.getConfigurationHierarchyName(authorization.getConfiguration()) + ": " + authorization.getPermission());
            }
        }
    }
}
