/*
 * Copyright PMEase (c) 2005-2006,
 * Date: 2006-1-11
 * Time: 18:30:08
 * All rights reserved.
 */

import com.caucho.hessian.client.HessianProxyFactory;
import com.pmease.quickbuild.RemoteService;
import com.pmease.quickbuild.model.UserFacade;
import com.pmease.quickbuild.model.GroupFacade;
import com.pmease.quickbuild.model.UserGroupRelationFacade;

import java.net.MalformedURLException;
import java.util.List;
import java.util.ArrayList;
import java.util.Iterator;

/**
 * This sample demonstrates how to create users. This is useful to programmatically add a large
 * number of users into QuickBuild, instead of inputting them one by one in the user interface.
 */
public class CreateUsers {
    public static void main(String[] args) throws MalformedURLException {
        HessianProxyFactory factory = new HessianProxyFactory();

        // specify login information here.
        factory.setUser("admin");
        factory.setPassword("admin");

        // specify hessian service URL of your QuickBuild installation.
        RemoteService remote = (RemoteService) factory.create(RemoteService.class,
                "http://localhost:8080/app.do?service=hessian");

        /**
         * Create list of users that need to be added to QuickBuild. You may want to generate this list
         * from other sources such as LDAP or CAS.
         */
        List users = new ArrayList();
        UserFacade user = new UserFacade();
        user.setEmail("user1@somecompany.com");
        user.setName("user1");
        user.setPassword("user1");
        users.add(user);
        user = new UserFacade();
        user.setEmail("user2@somecompany.com");
        user.setName("user2");
        user.setPassword("user2");
        users.add(user);

        GroupFacade group = remote.getGroupByName("group1");
        if (group == null)
            throw new RuntimeException("Can not find specified group!");
        for (Iterator it = users.iterator(); it.hasNext();) {
            user = (UserFacade) it.next();
            UserFacade userInQuickBuild = remote.getUserByName(user.getName());
            if (userInQuickBuild != null) {
                System.out.println("User \"" + user.getName() + "\" already exist, deleting...");
                remote.deleteUser(userInQuickBuild.getId());
            }

            // first save current user
            Long userId = remote.saveUser(user);
            System.out.println("User \"" + user.getName() + "\" has been saved.");

            // then associate saved user with group1
            UserGroupRelationFacade relation = new UserGroupRelationFacade();
            relation.setGroup(group.getId());
            relation.setUser(userId);
            remote.saveUserGroupRelation(relation);
            System.out.println("User \"" + user.getName() + "\" has been assigned with group \"" + group.getName() + "\".");
        }

        System.out.println("Users have been created successfully!");
    }
}
