/*
 * Copyright PMEase (c) 2005-2006,
 * Date: 2006-1-11
 * Time: 18:30:08
 * All rights reserved.
 */

import com.caucho.hessian.client.HessianProxyFactory;
import com.pmease.quickbuild.RemoteService;
import com.pmease.quickbuild.web.util.BackupSettingFacade;

import java.net.MalformedURLException;

/**
 * This sample demonstrates how to backup database. You can use this sample to periodically backup
 * your database.
 */
public class BackupDatabase {
    public static void main(String[] args) throws MalformedURLException {
        HessianProxyFactory factory = new HessianProxyFactory();

        // specify login information here.
        factory.setUser("admin");
        factory.setPassword("admin");

        // specify hessian service URL of your QuickBuild installation.
        RemoteService remote = (RemoteService) factory.create(RemoteService.class,
                "http://localhost:8080/app.do?service=hessian");

        BackupSettingFacade backupSetting = new BackupSettingFacade();

        /**
         * backup database to file "backups/backup.xml" under QuickBuild's installation directory.
         */
        backupSetting.setXmlFilePath("backups/backup.xml");
        remote.backupDatabase(backupSetting);

        System.out.println("Database has been backed up successfully!");
    }
}
