/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.contrib.tree.components;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.IAsset;
import org.apache.tapestry.IBinding;
import org.apache.tapestry.IComponent;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRender;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.contrib.tree.components.INodeRenderFactory;
import org.apache.tapestry.contrib.tree.model.ITreeModelSource;
import org.apache.tapestry.contrib.tree.model.ITreeRowSource;
import org.apache.tapestry.contrib.tree.model.ITreeStateListener;
import org.apache.tapestry.contrib.tree.model.ITreeStateModel;
import org.apache.tapestry.contrib.tree.model.TreeRowObject;
import org.apache.tapestry.contrib.tree.model.TreeStateEvent;
import org.apache.tapestry.contrib.tree.simple.SimpleNodeRenderFactory;
import org.apache.tapestry.engine.IPageLoader;
import org.apache.tapestry.event.PageDetachListener;
import org.apache.tapestry.event.PageEvent;
import org.apache.tapestry.spec.ComponentSpecification;
import org.apache.tapestry.spec.IComponentSpecification;
import org.apache.tapestry.util.ComponentAddress;

public class TreeNodeView
extends BaseComponent
implements PageDetachListener {
    private static final Log LOG = LogFactory.getLog((Class)(class$org$apache$tapestry$contrib$tree$components$TreeNodeView == null ? (class$org$apache$tapestry$contrib$tree$components$TreeNodeView = TreeNodeView.class$("org.apache.tapestry.contrib.tree.components.TreeNodeView")) : class$org$apache$tapestry$contrib$tree$components$TreeNodeView));
    private IBinding m_objNodeRenderFactoryBinding;
    private IBinding m_objShowNodeImagesBinding;
    private IBinding m_objMakeNodeDirectBinding;
    private Boolean m_objNodeState;
    private Boolean m_objShowNodeImages;
    private Boolean m_objMakeNodeDirect;
    private INodeRenderFactory m_objNodeRenderFactory;
    private IAsset m_objOpenNodeImage;
    private IAsset m_objCloseNodeImage;
    static /* synthetic */ Class class$org$apache$tapestry$contrib$tree$components$TreeNodeView;

    public TreeNodeView() {
        this.initialize();
    }

    private void initialize() {
        this.m_objNodeState = null;
        this.m_objShowNodeImages = null;
        this.m_objNodeRenderFactory = null;
        this.m_objMakeNodeDirect = null;
    }

    public IRender getCurrentRenderer() {
        INodeRenderFactory objRenderFactory = this.getNodeRenderFactory();
        ITreeRowSource objTreeRowSource = this.getTreeRowSource();
        return objRenderFactory.getRender(objTreeRowSource.getTreeRow().getTreeNode(), this.getTreeModelSource(), this.getPage().getRequestCycle());
    }

    public Object[] getNodeContext() {
        ITreeModelSource objModelSource = this.getTreeModelSource();
        ComponentAddress objModelSourceAddress = new ComponentAddress((IComponent)objModelSource);
        ITreeRowSource objTreeRowSource = this.getTreeRowSource();
        TreeRowObject objTreeRowObject = objTreeRowSource.getTreeRow();
        Object objValueUID = objTreeRowObject.getTreeNodeUID();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("getNodeContext objValueUID = " + objValueUID));
        }
        return new Object[]{objValueUID, new Boolean(this.isNodeOpen()), objModelSourceAddress};
    }

    public void nodeSelect(IRequestCycle cycle) {
        ComponentAddress objModelSourceAddress;
        ITreeModelSource objTreeModelSource;
        ITreeStateModel objStateModel;
        boolean bState;
        Object[] context = cycle.getServiceParameters();
        Object objValueUID = null;
        if (context != null && context.length > 0) {
            objValueUID = context[0];
        }
        if (bState = (objStateModel = (objTreeModelSource = (ITreeModelSource)(objModelSourceAddress = (ComponentAddress)context[2]).findComponent(cycle)).getTreeModel().getTreeStateModel()).isUniqueKeyExpanded(objValueUID)) {
            objStateModel.collapse(objValueUID);
            this.fireNodeCollapsed(objValueUID, objTreeModelSource);
        } else {
            objStateModel.expandPath(objValueUID);
            this.fireNodeExpanded(objValueUID, objTreeModelSource);
        }
    }

    private void fireNodeCollapsed(Object objValueUID, ITreeModelSource objTreeModelSource) {
        this.deliverEvent(4, objValueUID, objTreeModelSource);
    }

    private void fireNodeExpanded(Object objValueUID, ITreeModelSource objTreeModelSource) {
        this.deliverEvent(2, objValueUID, objTreeModelSource);
    }

    private void deliverEvent(int nEventUID, Object objValueUID, ITreeModelSource objTreeModelSource) {
        ITreeStateListener objListener = objTreeModelSource.getTreeStateListener();
        if (objListener != null) {
            TreeStateEvent objEvent = new TreeStateEvent(nEventUID, objValueUID, objTreeModelSource.getTreeModel().getTreeStateModel());
            objListener.treeStateChanged(objEvent);
        }
    }

    private void deliverEventOld(int nEventUID, Object objValueUID, ITreeStateModel objStateModel) {
        IBinding objBinding = this.getBinding("treeStateListener");
        if (objBinding != null) {
            ITreeStateListener objListener = (ITreeStateListener)objBinding.getObject();
            TreeStateEvent objEvent = new TreeStateEvent(nEventUID, objValueUID, objStateModel);
            objListener.treeStateChanged(objEvent);
        }
    }

    public void pageDetached(PageEvent arg0) {
        this.initialize();
    }

    public void finishLoad(IRequestCycle objCycle, IPageLoader arg0, ComponentSpecification arg1) {
        super.finishLoad(objCycle, arg0, (IComponentSpecification)arg1);
        this.getPage().addPageDetachListener((PageDetachListener)this);
        this.m_objOpenNodeImage = this.getAsset("_openNodeImage");
        this.m_objCloseNodeImage = this.getAsset("_closeNodeImage");
    }

    public boolean isNodeOpen() {
        if (this.m_objNodeState == null) {
            ITreeRowSource objTreeRowSource = this.getTreeRowSource();
            TreeRowObject objTreeRowObject = objTreeRowSource.getTreeRow();
            Object objValueUID = objTreeRowObject.getTreeNodeUID();
            ITreeModelSource objTreeModelSource = this.getTreeModelSource();
            ITreeStateModel objStateModel = objTreeModelSource.getTreeModel().getTreeStateModel();
            boolean bState = objStateModel.isUniqueKeyExpanded(objValueUID);
            this.m_objNodeState = new Boolean(bState);
        }
        return this.m_objNodeState;
    }

    public IAsset getNodeImage() {
        if (this.isNodeOpen()) {
            if (this.m_objOpenNodeImage == null) {
                this.m_objOpenNodeImage = this.getAsset("_openNodeImage");
            }
            return this.m_objOpenNodeImage;
        }
        if (this.m_objCloseNodeImage == null) {
            this.m_objCloseNodeImage = this.getAsset("_closeNodeImage");
        }
        return this.m_objCloseNodeImage;
    }

    public IAsset getCloseNodeImage() {
        return this.m_objCloseNodeImage;
    }

    public IAsset getOpenNodeImage() {
        return this.m_objOpenNodeImage;
    }

    public void setCloseNodeImage(IAsset closeNodeImage) {
        this.m_objCloseNodeImage = closeNodeImage;
    }

    public void setOpenNodeImage(IAsset openNodeImage) {
        this.m_objOpenNodeImage = openNodeImage;
    }

    protected void renderComponent(IMarkupWriter arg0, IRequestCycle arg1) {
        super.renderComponent(arg0, arg1);
        this.m_objNodeState = null;
    }

    public IBinding getShowNodeImagesBinding() {
        return this.m_objShowNodeImagesBinding;
    }

    public void setShowNodeImagesBinding(IBinding ShowNodeImagesBinding) {
        this.m_objShowNodeImagesBinding = ShowNodeImagesBinding;
    }

    public Boolean isShowNodeImages() {
        if (this.m_objShowNodeImages == null) {
            this.m_objShowNodeImages = this.getNodeRenderFactoryBinding() == null ? Boolean.TRUE : (this.m_objShowNodeImagesBinding != null ? (Boolean)this.m_objShowNodeImagesBinding.getObject() : Boolean.TRUE);
        }
        return this.m_objShowNodeImages;
    }

    public boolean getShowImages() {
        boolean bResult = this.isShowNodeImages();
        return bResult;
    }

    public boolean getShowWithoutImages() {
        boolean bResult = this.isShowNodeImages() == false;
        return bResult;
    }

    public String getOffsetStyle() {
        ITreeRowSource objTreeRowSource = this.getTreeRowSource();
        TreeRowObject objTreeRowObject = objTreeRowSource.getTreeRow();
        int nTreeRowDepth = 0;
        if (objTreeRowObject != null) {
            nTreeRowDepth = objTreeRowObject.getTreeRowDepth();
        }
        return "padding-left: " + nTreeRowDepth * 15 + "px";
    }

    public IBinding getNodeRenderFactoryBinding() {
        return this.m_objNodeRenderFactoryBinding;
    }

    public void setNodeRenderFactoryBinding(IBinding nodeRenderFactoryBinding) {
        this.m_objNodeRenderFactoryBinding = nodeRenderFactoryBinding;
    }

    public INodeRenderFactory getNodeRenderFactory() {
        if (this.m_objNodeRenderFactory == null) {
            IBinding objBinding = this.getNodeRenderFactoryBinding();
            this.m_objNodeRenderFactory = objBinding != null ? (INodeRenderFactory)objBinding.getObject() : new SimpleNodeRenderFactory();
        }
        return this.m_objNodeRenderFactory;
    }

    public IBinding getMakeNodeDirectBinding() {
        return this.m_objMakeNodeDirectBinding;
    }

    public void setMakeNodeDirectBinding(IBinding makeNodeDirectBinding) {
        this.m_objMakeNodeDirectBinding = makeNodeDirectBinding;
    }

    public boolean getMakeNodeDirect() {
        if (this.m_objMakeNodeDirect == null) {
            IBinding objBinding = this.getMakeNodeDirectBinding();
            this.m_objMakeNodeDirect = objBinding != null ? (Boolean)objBinding.getObject() : Boolean.TRUE;
        }
        return this.m_objMakeNodeDirect;
    }

    public boolean getMakeNodeNoDirect() {
        return !this.getMakeNodeDirect();
    }

    public String getCleanSelectedID() {
        return this.getSelectedNodeID();
    }

    public String getSelectedID() {
        Object objSelectedNode;
        ITreeRowSource objTreeRowSource = this.getTreeRowSource();
        ITreeModelSource objTreeModelSource = this.getTreeModelSource();
        TreeRowObject objTreeRowObject = objTreeRowSource.getTreeRow();
        Object objNodeValueUID = objTreeRowObject.getTreeNodeUID();
        if (objNodeValueUID.equals(objSelectedNode = objTreeModelSource.getTreeModel().getTreeStateModel().getSelectedNode())) {
            return this.getSelectedNodeID();
        }
        return "";
    }

    private String getSelectedNodeID() {
        return "tree";
    }

    public String getNodeStyleClass() {
        ITreeRowSource objTreeRowSource = this.getTreeRowSource();
        ITreeModelSource objTreeModelSource = this.getTreeModelSource();
        TreeRowObject objTreeRowObject = objTreeRowSource.getTreeRow();
        boolean bResult = false;
        if (objTreeRowObject != null) {
            Object objNodeValueUID = objTreeRowObject.getTreeNodeUID();
            Object objSelectedNode = objTreeModelSource.getTreeModel().getTreeStateModel().getSelectedNode();
            bResult = objNodeValueUID.equals(objSelectedNode);
        }
        if (bResult) {
            return "selectedNodeViewClass";
        }
        return "notSelectedNodeViewClass";
    }

    public ITreeRowSource getTreeRowSource() {
        ITreeRowSource objSource = (ITreeRowSource)this.getPage().getRequestCycle().getAttribute("org.apache.tapestry.contrib.tree.model.ITreeRowSource");
        return objSource;
    }

    public ITreeModelSource getTreeModelSource() {
        ITreeModelSource objSource = (ITreeModelSource)this.getPage().getRequestCycle().getAttribute("org.apache.tapestry.contrib.tree.model.ITreeModelSource");
        return objSource;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

