/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.dotnet;

import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.taskdefs.optional.dotnet.NetCommand;
import org.apache.tools.ant.types.FileSet;

public class DotnetBaseMatchingTask
extends MatchingTask {
    protected File outputFile;
    protected Vector filesets = new Vector();
    protected File srcDir;

    public File getSrcDir() {
        return this.srcDir;
    }

    public void setSrcDir(File srcDirName) {
        this.srcDir = srcDirName;
    }

    public void setDestFile(File file) {
        this.outputFile = file;
    }

    public void addSrc(FileSet src) {
        this.filesets.add(src);
    }

    public File getDestFile() {
        return this.outputFile;
    }

    protected int buildFileList(NetCommand command, Hashtable filesToBuild, long outputTimestamp) {
        boolean scanImplicitFileset;
        int filesOutOfDate = 0;
        boolean bl = scanImplicitFileset = this.getSrcDir() != null || this.filesets.size() == 0;
        if (scanImplicitFileset) {
            if (this.getSrcDir() == null) {
                this.setSrcDir(this.getProject().resolveFile("."));
            }
            this.log("working from source directory " + this.getSrcDir(), 3);
            DirectoryScanner scanner = this.getDirectoryScanner(this.getSrcDir());
            filesOutOfDate = command.scanOneFileset(scanner, filesToBuild, outputTimestamp);
        }
        for (int i = 0; i < this.filesets.size(); ++i) {
            FileSet fs = (FileSet)this.filesets.elementAt(i);
            filesOutOfDate += command.scanOneFileset(fs.getDirectoryScanner(this.getProject()), filesToBuild, outputTimestamp);
        }
        return filesOutOfDate;
    }

    protected void addFilesToCommand(Hashtable filesToBuild, NetCommand command) {
        int count = filesToBuild.size();
        this.log("compiling " + count + " file" + (count == 1 ? "" : "s"));
        Enumeration files = filesToBuild.elements();
        while (files.hasMoreElements()) {
            File file = (File)files.nextElement();
            command.addArgument(file.toString());
        }
    }

    protected long getOutputFileTimestamp() {
        long outputTimestamp = this.getDestFile() != null && this.getDestFile().exists() ? this.getDestFile().lastModified() : 0L;
        return outputTimestamp;
    }

    protected void addFilesAndExecute(NetCommand command, boolean ignoreTimestamps) {
        long outputTimestamp = this.getOutputFileTimestamp();
        Hashtable filesToBuild = new Hashtable();
        int filesOutOfDate = this.buildFileList(command, filesToBuild, outputTimestamp);
        this.addFilesToCommand(filesToBuild, command);
        if (filesOutOfDate > 0) {
            command.runCommand();
        } else {
            this.log("output file is up to date", 3);
        }
    }
}

