/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.binding;

import java.util.HashMap;
import java.util.Map;
import org.apache.tapestry.BindingException;
import org.apache.tapestry.IBinding;
import org.apache.tapestry.ILocation;
import org.apache.tapestry.Tapestry;

public abstract class AbstractBinding
implements IBinding {
    private ILocation _location;
    private static final Map PRIMITIVE_TYPES = new HashMap();
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;

    protected AbstractBinding(ILocation location) {
        this._location = location;
    }

    public ILocation getLocation() {
        return this._location;
    }

    public boolean getBoolean() {
        return Tapestry.evaluateBoolean(this.getObject());
    }

    public int getInt() {
        Object raw = this.getObject();
        if (raw == null) {
            throw Tapestry.createNullBindingException(this);
        }
        if (raw instanceof Number) {
            return ((Number)raw).intValue();
        }
        if (raw instanceof Boolean) {
            return (Boolean)raw != false ? 1 : 0;
        }
        return Integer.parseInt((String)raw);
    }

    public double getDouble() {
        Object raw = this.getObject();
        if (raw == null) {
            throw Tapestry.createNullBindingException(this);
        }
        if (raw instanceof Number) {
            return ((Number)raw).doubleValue();
        }
        if (raw instanceof Boolean) {
            return (Boolean)raw != false ? 1.0 : 0.0;
        }
        return Double.parseDouble((String)raw);
    }

    public String getString() {
        Object value = this.getObject();
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    public void setBoolean(boolean value) {
        throw this.createReadOnlyBindingException(this);
    }

    public void setInt(int value) {
        throw this.createReadOnlyBindingException(this);
    }

    public void setDouble(double value) {
        throw this.createReadOnlyBindingException(this);
    }

    public void setString(String value) {
        throw this.createReadOnlyBindingException(this);
    }

    public void setObject(Object value) {
        throw this.createReadOnlyBindingException(this);
    }

    public boolean isInvariant() {
        return true;
    }

    public Object getObject(String parameterName, Class type) {
        Object result = this.getObject();
        if (result == null) {
            return result;
        }
        Class<?> resultClass = result.getClass();
        if (type.isAssignableFrom(resultClass)) {
            return result;
        }
        if (type.isPrimitive() && this.isWrapper(type, resultClass)) {
            return result;
        }
        String key = type.isInterface() ? "AbstractBinding.wrong-interface" : "AbstractBinding.wrong-type";
        String message = Tapestry.format(key, new Object[]{parameterName, result, resultClass.getName(), type.getName()});
        throw new BindingException(message, this);
    }

    public boolean isWrapper(Class primitiveType, Class subjectClass) {
        return PRIMITIVE_TYPES.get(primitiveType).equals(subjectClass);
    }

    protected BindingException createReadOnlyBindingException(IBinding binding) {
        return new BindingException(Tapestry.getMessage("AbstractBinding.read-only-binding"), binding);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public abstract /* synthetic */ Object getObject();

    static {
        PRIMITIVE_TYPES.put(Boolean.TYPE, class$java$lang$Boolean == null ? (class$java$lang$Boolean = AbstractBinding.class$("java.lang.Boolean")) : class$java$lang$Boolean);
        PRIMITIVE_TYPES.put(Byte.TYPE, class$java$lang$Byte == null ? (class$java$lang$Byte = AbstractBinding.class$("java.lang.Byte")) : class$java$lang$Byte);
        PRIMITIVE_TYPES.put(Character.TYPE, class$java$lang$Character == null ? (class$java$lang$Character = AbstractBinding.class$("java.lang.Character")) : class$java$lang$Character);
        PRIMITIVE_TYPES.put(Short.TYPE, class$java$lang$Short == null ? (class$java$lang$Short = AbstractBinding.class$("java.lang.Short")) : class$java$lang$Short);
        PRIMITIVE_TYPES.put(Integer.TYPE, class$java$lang$Integer == null ? (class$java$lang$Integer = AbstractBinding.class$("java.lang.Integer")) : class$java$lang$Integer);
        PRIMITIVE_TYPES.put(Long.TYPE, class$java$lang$Long == null ? (class$java$lang$Long = AbstractBinding.class$("java.lang.Long")) : class$java$lang$Long);
        PRIMITIVE_TYPES.put(Float.TYPE, class$java$lang$Float == null ? (class$java$lang$Float = AbstractBinding.class$("java.lang.Float")) : class$java$lang$Float);
        PRIMITIVE_TYPES.put(Double.TYPE, class$java$lang$Double == null ? (class$java$lang$Double = AbstractBinding.class$("java.lang.Double")) : class$java$lang$Double);
    }
}

