/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.visdiff;

import com.starbase.diff.CharSequence;
import com.starbase.diff.ParsedCharSequence;
import com.starbase.util.LocaleChangeEvent;
import com.starbase.util.LocaleChangeListener;
import com.starbase.util.swing.ActionMap;
import com.starbase.util.swing.ActionUtils;
import com.starbase.util.swing.ButtonLook;
import com.starbase.util.swing.FindTextPane;
import com.starbase.util.swing.LocaleChooserPanel;
import com.starbase.util.swing.metalthemes.AquaMetalTheme;
import com.starbase.util.swing.metalthemes.BigContrastMetalTheme;
import com.starbase.util.swing.metalthemes.BigGreenMetalTheme;
import com.starbase.util.swing.metalthemes.ContrastMetalTheme;
import com.starbase.util.swing.metalthemes.DemoMetalTheme;
import com.starbase.util.swing.metalthemes.GreenMetalTheme;
import com.starbase.util.swing.metalthemes.KhakiMetalTheme;
import com.starbase.util.swing.metalthemes.MetalThemeMenu;
import com.starbase.util.swing.metalthemes.PropertiesMetalTheme;
import com.starbase.visdiff.ExampleFileFilter;
import com.starbase.visdiff.FileEncodingPane;
import com.starbase.visdiff.MessageTray;
import com.starbase.visdiff.OptionsSetter;
import com.starbase.visdiff.SplitDualDiffPane;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.PrintJob;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.filechooser.FileFilter;
import javax.swing.plaf.metal.DefaultMetalTheme;
import javax.swing.plaf.metal.MetalTheme;

public class TextDiffFrame
extends JFrame
implements LocaleChangeListener {
    private static final int HACK_TYPE_SIMPLE = 0;
    private static final int HACK_TYPE_TOGGLE = 1;
    private static final int HACK_TYPE_RADIO = 2;
    protected static final String ACT_FILE_OPEN = "FileOpen";
    protected static final String ACT_FILE_FOLDERS = "FileFolders";
    protected static final String ACT_FILE_CLOSE = "FileClose";
    protected static final String ACT_FILE_MERGE = "FileMerge";
    protected static final String ACT_FILE_PAGESETUP = "FilePrintPageSetup";
    protected static final String ACT_FILE_PRINT = "FilePrint";
    protected static final String ACT_FILE_CHART = "FileChart";
    protected static final String ACT_FILE_RELOAD = "FileReload";
    protected static final String ACT_EXIT = "ApplicationExit";
    protected static final String ACT_CUT = "Cut";
    protected static final String ACT_COPY = "Copy";
    protected static final String ACT_PASTE = "Paste";
    protected static final String ACT_SELECT_ALL = "SelectAll";
    protected static final String ACT_FIND = "Find";
    protected static final String ACT_FIND_NEXT = "FindNext";
    protected static final String ACT_DIFF_ONLY = "DiffOnly";
    protected static final String ACT_DIFF_NEXT = "FindDiffNext";
    protected static final String ACT_DIFF_PREV = "FindDiffPrev";
    protected static final String ACT_MATCH_NEXT = "FindMatchNext";
    protected static final String ACT_MATCH_PREV = "FindMatchPrev";
    protected static final String ACT_OPTIONS = "Options";
    protected static final String ACT_SOURCE_ENCODE = "EncodingSource";
    protected static final String ACT_TARGET_ENCODE = "EncodingTarget";
    protected static final String ACT_SPLIT_VERT = "SplitVert";
    protected static final String ACT_SPLIT_HORIZ = "SplitHoriz";
    protected static final String ACT_SPLIT_NONE = "SplitNone";
    protected static final String ACT_SWAP_SOURCES = "SwitchPanes";
    protected static final String ACT_SET_LOCALE = "SetLocale";
    protected static final String ACT_HELP = "Help";
    protected static final String ACT_HELP_ABOUT = "HelpAbout";
    protected static final String APP_CONFIG_FILENAME = "visdiff.cfg";
    protected static final String USER_HOME_PROPERTY_KEY = "user.home";
    protected static final String CFG_SHOW_LINE_NUMBERS = "ShowLineNumbers";
    protected static final String CFG_SHOW_DIFFS_ONLY = "ShowDiffsOnly";
    protected static final String CFG_SHOW_TOOLBAR = "ShowToolbar";
    protected static final String CFG_SHOW_STATUSBAR = "ShowStatusbar";
    protected static final String CFG_COMP_IGNORE_CASE = "CompareIgnoreCase";
    protected static final String CFG_COMP_IGNORE_EOL = "CompareIgnoreEOL";
    protected static final String CFG_COMP_WHITESPACE = "CompareWhitespace";
    protected static final String CFG_DISPLAYED_TABSTOP = "TabStop";
    protected static final String CFG_COLOR_KEYBASE = "Color";
    private static final String MENU_BASE_FILE = "File";
    private static final String MENU_BASE_EDIT = "Edit";
    private static final String MENU_BASE_SEARCH = "Search";
    private static final String MENU_BASE_WINDOW = "Window";
    private static final String MENU_BASE_HELP = "Help";
    private static final int ERR_GENERAL = 0;
    private static final int ERR_CONFIG_FILE = 100;
    private static final int ERR_OPEN_NON_FILE = 101;
    private static final int ERR_BAD_PARAM = 102;
    private static final String EXIT_ACTION = "exit";
    private PropertyChangeListener m_lafListener = null;
    private transient TextDiffFrame m_UI = null;
    private transient boolean m_monitorFiles = true;
    private transient boolean m_hasDiffs = false;
    private transient File m_firstFile = null;
    private transient String m_firstEncoding = null;
    private transient long m_firstFileModified = 0L;
    private transient File m_secondFile = null;
    private transient String m_secondEncoding = null;
    private transient long m_secondFileModified = 0L;
    private transient URL m_firstUrl = null;
    private transient URL m_secondUrl = null;
    private transient String m_sourceTitle = null;
    private transient String m_targetTitle = null;
    private JPanel m_contentPane = null;
    private transient MessageTray m_messageTray = null;
    private transient SplitDualDiffPane m_mainView = null;
    private ActionMap m_commands = null;
    private Hashtable m_commandFlags = null;
    private StateBean m_stateHack;
    private transient Locale m_locale = null;
    private transient ResourceBundle m_comonResources = null;
    private transient FileFilter[] m_chooseFilters = null;
    private transient FileFilter m_lastFilter = null;
    private transient File m_lastDirectory = null;
    private String m_findText = null;
    private boolean m_findCase = false;
    private int m_findDirection = 0;
    private boolean m_optShowLineNumbers = true;
    private boolean m_optShowDiffsOnly = false;
    private boolean m_optShowToolbar = true;
    private boolean m_optShowStatusbar = false;
    private boolean m_optIgnoreCase = false;
    private boolean m_optIgnoreEOL = false;
    private int m_whitespaceIgnoreType = 0;
    private int m_displayTabSize = 8;
    private Color[][] m_textColors = new Color[][]{{new Color(0, 0, 0), new Color(255, 255, 255)}, {new Color(0, 0, 255), new Color(255, 255, 255)}, {new Color(0, 128, 0), new Color(255, 255, 255)}, {new Color(255, 0, 0), new Color(255, 255, 255)}};
    private transient Box m_toolArea = null;
    private boolean m_askingForReload = false;
    private FindTextPane m_textFinder = null;
    private JDialog m_textFindDialog = null;
    private boolean m_diffsOnly = false;

    public File getSourceFile() {
        return this.m_firstFile;
    }

    public void setSourceFile(File file, String string) throws UnsupportedEncodingException {
        this.setSourceFileEncoding(string);
        this.m_firstFile = file;
    }

    public String getSourceFileEncoding() {
        return this.m_firstEncoding;
    }

    public void setSourceFileEncoding(String string) throws UnsupportedEncodingException {
        if (string != null) {
            new String(new byte[0], string);
        }
        this.m_firstEncoding = string;
    }

    void setSourceURL(URL uRL) {
        throw new RuntimeException("Not yet implemented");
    }

    URL getSourceURL() {
        throw new RuntimeException("Not yet implemented");
    }

    public void setSourceCharSequence(CharSequence charSequence) {
        throw new RuntimeException("Not yet implemented");
    }

    public CharSequence getSourceCharSequence() {
        throw new RuntimeException("Not yet implemented");
    }

    public File getTargetFile() {
        return this.m_secondFile;
    }

    public void setTargetFile(File file, String string) throws UnsupportedEncodingException {
        this.setTargetFileEncoding(string);
        this.m_secondFile = file;
    }

    public String getTargetFileEncoding() {
        return this.m_secondEncoding;
    }

    public void setTargetFileEncoding(String string) throws UnsupportedEncodingException {
        if (string != null) {
            new String(new byte[0], string);
        }
        this.m_secondEncoding = string;
    }

    void setTargetURL(URL uRL) {
        throw new RuntimeException("Not yet implemented");
    }

    URL getTargetURL() {
        throw new RuntimeException("Not yet implemented");
    }

    public void setTargetCharSequence(CharSequence charSequence) {
        throw new RuntimeException("Not yet implemented");
    }

    public CharSequence getTargetCharSequence() {
        throw new RuntimeException("Not yet implemented");
    }

    public String getSourceTitle() {
        return this.m_sourceTitle;
    }

    public void setSourceTitle(String string) {
        this.m_sourceTitle = string;
        if (this.m_mainView != null) {
            this.m_mainView.setSourceTitle(this.m_sourceTitle);
        }
    }

    public String getTargetTitle() {
        return this.m_targetTitle;
    }

    public void setTargetTitle(String string) {
        this.m_targetTitle = string;
        if (this.m_mainView != null) {
            this.m_mainView.setTargetTitle(this.m_targetTitle);
        }
    }

    public boolean isMonitoringFileChanges() {
        return this.m_monitorFiles;
    }

    public void setMonitoringFileChanges(boolean bl) {
        this.m_monitorFiles = bl;
    }

    public void performDiff() throws IOException, UnsupportedEncodingException, SecurityException {
        if (this.m_firstFile != null && this.m_secondFile != null) {
            if (!(this.m_firstFile.exists() && this.m_firstFile.canRead() && this.m_firstFile.isFile())) {
                throw new IOException();
            }
            if (!(this.m_secondFile.exists() && this.m_secondFile.canRead() && this.m_secondFile.isFile())) {
                throw new IOException();
            }
        } else {
            throw new IOException();
        }
        this.parseinFiles(this.m_mainView);
        this.setDocsPresent(true);
    }

    public boolean hasDifferences() {
        return this.m_hasDiffs;
    }

    public void clearSource() {
    }

    public void clearTarget() {
    }

    public void localeChanged(LocaleChangeEvent localeChangeEvent) {
        this.m_locale = localeChangeEvent.getLocale();
        this.setCommonResources(this.m_locale);
        this.buildControls();
        this.invalidate();
        this.validate();
    }

    private void buildControls() {
        JMenu[] jMenuArray = this.createMenus(this.m_commands, this.m_commandFlags);
        JToolBar[] jToolBarArray = this.createToolBars(this.m_commands, this.m_commandFlags);
        if (this.m_toolArea != null) {
            this.m_contentPane.remove(this.m_toolArea);
        }
        this.m_toolArea = new Box(0);
        int n = 0;
        while (n < jToolBarArray.length) {
            jToolBarArray[n].setAlignmentY(0.0f);
            this.m_toolArea.add(jToolBarArray[n]);
            ++n;
        }
        this.m_contentPane.add((Component)this.m_toolArea, "North");
        this.m_toolArea.add(Box.createHorizontalGlue());
        Serializable serializable = this.getClass().getResource("images/logo.gif");
        serializable = new JMenuBar();
        int n2 = 0;
        while (n2 < jMenuArray.length) {
            ((JMenuBar)serializable).add(jMenuArray[n2]);
            ++n2;
        }
        this.setJMenuBar((JMenuBar)serializable);
        this.setToolAreaVisible(this.m_optShowToolbar);
    }

    private void showError(Throwable throwable) {
        this.showError(throwable, 0);
    }

    private void showError(Throwable throwable, int n) {
        this.showError(throwable, n, null);
    }

    private void showError(Throwable throwable, int n, String string) {
        String string2 = null;
        switch (n) {
            case 101: {
                string2 = "Not a file\n" + throwable.toString();
                break;
            }
            case 102: {
                string2 = "Bad format for parameter '" + string + "'\n" + throwable.toString();
                break;
            }
            case 100: {
                string2 = "Configuration file\n" + throwable.toString();
                break;
            }
            default: {
                string2 = throwable.toString();
            }
        }
        int n2 = JOptionPane.showConfirmDialog(this, string2 + "\n (more?)", "Alert", 0, 0);
        if (n2 == 0) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PrintWriter printWriter = new PrintWriter(byteArrayOutputStream, true);
            throwable.printStackTrace(printWriter);
            printWriter.flush();
            JOptionPane.showMessageDialog(this, byteArrayOutputStream.toString(), "Details", 0);
        }
    }

    private void saveSettings() {
        Properties properties = new Properties();
        ((Hashtable)properties).put(CFG_SHOW_LINE_NUMBERS, new Boolean(this.m_optShowLineNumbers).toString());
        ((Hashtable)properties).put(CFG_SHOW_DIFFS_ONLY, new Boolean(this.m_optShowDiffsOnly).toString());
        ((Hashtable)properties).put(CFG_SHOW_TOOLBAR, new Boolean(this.getToolAreaVisible()).toString());
        ((Hashtable)properties).put(CFG_SHOW_STATUSBAR, new Boolean(this.getStatusbarVisible()).toString());
        ((Hashtable)properties).put(CFG_COMP_IGNORE_CASE, new Boolean(this.m_optIgnoreCase).toString());
        ((Hashtable)properties).put(CFG_COMP_IGNORE_EOL, new Boolean(this.m_optIgnoreEOL).toString());
        ((Hashtable)properties).put(CFG_COMP_WHITESPACE, new Integer(this.m_whitespaceIgnoreType).toString());
        ((Hashtable)properties).put(CFG_DISPLAYED_TABSTOP, new Integer(this.m_displayTabSize).toString());
        int n = 0;
        while (n < this.m_textColors.length) {
            int n2 = 0;
            while (n2 < this.m_textColors[n].length) {
                ((Hashtable)properties).put(CFG_COLOR_KEYBASE + new Integer(n).toString() + "_" + new Integer(n2).toString(), "0x" + Integer.toHexString(this.m_textColors[n][n2].getRGB() & 0xFFFFFF));
                ++n2;
            }
            ++n;
        }
        File file = new File(System.getProperty(USER_HOME_PROPERTY_KEY), APP_CONFIG_FILENAME);
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
        }
        catch (IOException iOException) {
            this.showError(iOException, 100);
        }
        properties.save(fileOutputStream, "Visual Diff settings");
        try {
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            this.showError(iOException, 100);
        }
    }

    private void loadSettings() {
        File file = new File(System.getProperty(USER_HOME_PROPERTY_KEY), APP_CONFIG_FILENAME);
        Hashtable hashtable = null;
        if (file.exists()) {
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(file);
                hashtable = new Properties();
                try {
                    ((Properties)hashtable).load(fileInputStream);
                }
                catch (IOException iOException) {
                    this.showError(iOException, 100);
                }
                fileInputStream.close();
            }
            catch (IOException iOException) {
                this.showError(iOException, 100);
            }
        }
        if (hashtable != null) {
            if (hashtable.containsKey(CFG_SHOW_LINE_NUMBERS)) {
                this.setNumberingVisible(Boolean.valueOf(((Properties)hashtable).getProperty(CFG_SHOW_LINE_NUMBERS)));
            }
            if (hashtable.containsKey(CFG_SHOW_DIFFS_ONLY)) {
                this.m_optShowDiffsOnly = Boolean.valueOf(((Properties)hashtable).getProperty(CFG_SHOW_DIFFS_ONLY));
            }
            if (hashtable.containsKey(CFG_SHOW_TOOLBAR)) {
                this.setToolAreaVisible(Boolean.valueOf(((Properties)hashtable).getProperty(CFG_SHOW_TOOLBAR)));
            }
            if (hashtable.containsKey(CFG_SHOW_STATUSBAR)) {
                this.setStatusbarVisible(Boolean.valueOf(((Properties)hashtable).getProperty(CFG_SHOW_STATUSBAR)));
            }
            if (hashtable.containsKey(CFG_COMP_IGNORE_CASE)) {
                this.m_optIgnoreCase = Boolean.valueOf(((Properties)hashtable).getProperty(CFG_COMP_IGNORE_CASE));
            }
            if (hashtable.containsKey(CFG_COMP_IGNORE_EOL)) {
                this.m_optIgnoreEOL = Boolean.valueOf(((Properties)hashtable).getProperty(CFG_COMP_IGNORE_EOL));
            }
            if (hashtable.containsKey(CFG_COMP_WHITESPACE)) {
                try {
                    this.m_whitespaceIgnoreType = Integer.decode(((Properties)hashtable).getProperty(CFG_COMP_WHITESPACE));
                }
                catch (NumberFormatException numberFormatException) {
                    this.showError(numberFormatException, 102, CFG_COMP_WHITESPACE);
                }
            }
            if (hashtable.containsKey(CFG_DISPLAYED_TABSTOP)) {
                try {
                    this.m_displayTabSize = Integer.decode(((Properties)hashtable).getProperty(CFG_DISPLAYED_TABSTOP));
                }
                catch (NumberFormatException numberFormatException) {
                    this.showError(numberFormatException, 102, CFG_DISPLAYED_TABSTOP);
                }
            }
            int n = 0;
            while (n < this.m_textColors.length) {
                int n2 = 0;
                while (n2 < this.m_textColors[n].length) {
                    String string = CFG_COLOR_KEYBASE + new Integer(n).toString() + "_" + new Integer(n2).toString();
                    if (hashtable.containsKey(string)) {
                        try {
                            String string2 = ((Properties)hashtable).getProperty(string);
                            this.m_textColors[n][n2] = Color.decode(string2);
                        }
                        catch (NumberFormatException numberFormatException) {
                            this.showError(numberFormatException, 102, string);
                        }
                    }
                    ++n2;
                }
                ++n;
            }
        }
    }

    private void doEditCommand(String string) {
        if (string != null) {
            if (string.equals(ACT_CUT)) {
                this.m_mainView.editCut();
            } else if (string.equals(ACT_COPY)) {
                this.m_mainView.editCopy();
            } else if (string.equals(ACT_PASTE)) {
                this.m_mainView.editPaste();
            } else if (string.equals(ACT_SELECT_ALL)) {
                this.m_mainView.editSelectAll();
            }
        }
    }

    private void doPrint() {
        TextDiffFrame textDiffFrame = this;
        PrintJob printJob = Toolkit.getDefaultToolkit().getPrintJob(textDiffFrame, "VisDiff Printing", null);
        Graphics graphics = printJob.getGraphics();
        textDiffFrame.printAll(graphics);
        printJob.end();
    }

    private void closeDocs() {
        this.setDocsPresent(false);
        this.m_firstFile = null;
        this.m_secondFile = null;
        this.m_firstFileModified = 0L;
        this.m_secondFileModified = 0L;
        try {
            this.setSourceFileEncoding(null);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        this.setSourceTitle(null);
        try {
            this.setTargetFileEncoding(null);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        this.setTargetTitle(null);
        this.m_mainView.closeAll();
    }

    private void openDocs() {
        File file = null;
        File file2 = null;
        this.setMessage(this.getCommonResources().getString("STATUS_OPENING"));
        file = this.chooseFile();
        if (file != null) {
            if (!file.exists()) {
                this.showError(new FileNotFoundException(file.toString()));
            } else if (!file.isFile()) {
                this.showError(new IOException(file.toString()), 101);
            } else {
                file2 = this.chooseFile(file.getParent());
                if (file2 != null && file2.exists() && file2.isFile()) {
                    this.closeDocs();
                    this.m_firstFile = file;
                    this.m_secondFile = file2;
                    this.parseinFiles(this.m_mainView);
                    this.setDocsPresent(true);
                }
            }
        }
        this.setMessage(this.getCommonResources().getString("STATUS_DONE"));
    }

    private void setupFileFilters() {
        this.m_chooseFilters = new FileFilter[8];
        this.m_lastFilter = null;
        this.m_chooseFilters[0] = new ExampleFileFilter("java", this.getCommonResources().getString("FILETYPE_JAVA"));
        this.m_chooseFilters[1] = new ExampleFileFilter(new String[]{"c", "cpp", "cxx"}, this.getCommonResources().getString("FILETYPE_CPP"));
        this.m_chooseFilters[2] = new ExampleFileFilter(new String[]{"htm", "html", "shtml", "htx", "asp"}, this.getCommonResources().getString("FILETYPE_WEB"));
        this.m_chooseFilters[3] = new ExampleFileFilter(new String[]{"h", "hpp", "hxx"}, this.getCommonResources().getString("FILETYPE_HEADER"));
        this.m_chooseFilters[4] = new ExampleFileFilter(new String[]{"rc", "dlg"}, this.getCommonResources().getString("FILETYPE_RESOURCES"));
        this.m_chooseFilters[5] = new ExampleFileFilter("def", this.getCommonResources().getString("FILETYPE_DEF"));
        this.m_chooseFilters[6] = null;
        this.m_chooseFilters[7] = new ExampleFileFilter("txt", this.getCommonResources().getString("FILETYPE_TXT"));
    }

    private File chooseFile() {
        return this.chooseFile(null);
    }

    private File chooseFile(String string) {
        JFileChooser jFileChooser = null;
        File file = null;
        try {
            if (string != null) {
                jFileChooser = new JFileChooser(string);
            } else {
                jFileChooser = new JFileChooser();
                try {
                    if (this.m_lastDirectory == null) {
                        this.m_lastDirectory = new File(new File("./").getCanonicalPath());
                    }
                    jFileChooser.setCurrentDirectory(this.m_lastDirectory);
                }
                catch (IOException iOException) {
                    this.showError(iOException);
                }
            }
        }
        catch (IllegalAccessError illegalAccessError) {
            this.showError(illegalAccessError);
            jFileChooser = null;
        }
        if (jFileChooser != null) {
            if (this.m_chooseFilters == null) {
                this.setupFileFilters();
            }
            FileFilter fileFilter = jFileChooser.getAcceptAllFileFilter();
            jFileChooser.addChoosableFileFilter(fileFilter);
            int n = 0;
            while (n < this.m_chooseFilters.length) {
                if (this.m_chooseFilters[n] != null) {
                    jFileChooser.addChoosableFileFilter(this.m_chooseFilters[n]);
                }
                ++n;
            }
            jFileChooser.setFileFilter(fileFilter);
            n = 1;
            try {
                n = jFileChooser.showDialog(this, null);
            }
            catch (IllegalAccessError illegalAccessError) {
                TextDiffFrame.println("Bad file chooser 2");
            }
            if (n == 0) {
                FileFilter fileFilter2 = jFileChooser.getFileFilter();
                if (fileFilter2 != null && fileFilter2 != fileFilter) {
                    this.m_lastFilter = fileFilter2;
                }
                this.m_lastDirectory = jFileChooser.getCurrentDirectory();
                file = jFileChooser.getSelectedFile();
                if (file != null && file.isDirectory()) {
                    file = null;
                }
            }
        }
        return file;
    }

    private File chooseFileAWT(String string) {
        File file = null;
        FileDialog fileDialog = null;
        fileDialog = new FileDialog(this);
        if (fileDialog != null) {
            File file2;
            fileDialog.show();
            String string2 = fileDialog.getFile();
            fileDialog.dispose();
            if (string2 != null && (file2 = new File(string2)).exists() && file2.isFile() && file2.canRead()) {
                file = file2;
            }
        }
        return file;
    }

    private void setDocsPresent(boolean bl) {
        this.m_stateHack.setFilesOpen(bl);
    }

    private void parseinFiles(SplitDualDiffPane splitDualDiffPane) {
        try {
            String string;
            String string2 = string = "8859_1";
            if (this.m_firstEncoding != null) {
                string = this.m_firstEncoding;
            }
            if (this.m_secondEncoding != null) {
                string2 = this.m_secondEncoding;
            }
            long l = System.currentTimeMillis();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.m_firstFile), string));
            BufferedReader bufferedReader2 = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.m_secondFile), string2));
            this.m_firstFileModified = this.m_firstFile.lastModified();
            this.m_secondFileModified = this.m_secondFile.lastModified();
            ParsedCharSequence parsedCharSequence = new ParsedCharSequence(bufferedReader);
            ParsedCharSequence parsedCharSequence2 = new ParsedCharSequence(bufferedReader2);
            bufferedReader.close();
            bufferedReader2.close();
            long l2 = System.currentTimeMillis();
            int n = 0;
            if (this.m_optIgnoreCase) {
                n |= 0x100;
            }
            switch (this.m_whitespaceIgnoreType) {
                case 0: {
                    break;
                }
                case 1: {
                    n |= 0x11;
                    break;
                }
                case 2: {
                    n |= 0x15;
                    break;
                }
                case 3: {
                    n |= 0x1A;
                    break;
                }
            }
            splitDualDiffPane.setCompareFlags(n);
            splitDualDiffPane.setDiffTextColors(this.m_textColors);
            splitDualDiffPane.setTabSize(this.getDiffTabSize());
            splitDualDiffPane.setSource(parsedCharSequence);
            if (this.m_sourceTitle != null) {
                splitDualDiffPane.setSourceTitle(this.m_sourceTitle);
            } else {
                splitDualDiffPane.setSourceTitle(this.m_firstFile.getName());
            }
            splitDualDiffPane.setTarget(parsedCharSequence2);
            if (this.m_targetTitle != null) {
                splitDualDiffPane.setTargetTitle(this.m_targetTitle);
            } else {
                splitDualDiffPane.setTargetTitle(this.m_secondFile.getName());
            }
            this.setNumberingVisible(this.getNumberingVisible());
            splitDualDiffPane.performDiff(this.m_diffsOnly ? 1 : 0);
            this.m_hasDiffs = splitDualDiffPane.hasDifferences();
        }
        catch (Throwable throwable) {
            TextDiffFrame.println("ERROR: " + throwable);
            throwable.printStackTrace();
        }
    }

    private void applyDisplayChanges() {
        this.m_mainView.setDiffTextColors(this.m_textColors);
        this.m_mainView.setTabSize(this.getDiffTabSize());
        this.setNumberingVisible(this.getNumberingVisible());
        this.m_mainView.setVisible(false);
        this.m_mainView.revalidate();
        this.m_mainView.setVisible(true);
    }

    private void doExit() {
        this.dispose();
    }

    public void dispose() {
        super.dispose();
        if (this.m_lafListener != null) {
            UIManager.removePropertyChangeListener(this.m_lafListener);
            this.m_lafListener = null;
        }
    }

    private void doFindNext() {
        if (this.m_findText == null) {
            try {
                this.doFind();
            }
            catch (NoSuchMethodError noSuchMethodError) {
                TextDiffFrame.println("MS Error!" + noSuchMethodError);
            }
        } else {
            this.performFind();
        }
    }

    private void doFind() {
        if (this.m_textFinder == null) {
            if (this.m_textFindDialog != null) {
                this.m_textFindDialog.dispose();
                this.m_textFindDialog = null;
            }
            this.m_textFinder = new FindTextPane();
            this.m_textFinder.setTextColumns(10);
            this.m_textFinder.setDirectionVisible(true);
            this.m_textFinder.setApproveButtonText(this.getCommonResources().getString("BTN_FIND_NEXT"));
            this.m_textFinder.setCancelButtonText(this.getCommonResources().getString("BTN_IDCANCEL"));
            this.m_textFinder.setTextEntryLabel(this.getCommonResources().getString("FIND_ENTRY_LABEL"));
            this.m_textFinder.setDirectionLabel(this.getCommonResources().getString("FIND_DIRECTION_LABEL"));
            this.m_textFinder.setDirectionUpText(this.getCommonResources().getString("FIND_DIRECTION_UP"));
            this.m_textFinder.setDirectionDownText(this.getCommonResources().getString("FIND_DIRECTION_DOWN"));
            this.m_textFinder.setMatchCaseText(this.getCommonResources().getString("FIND_MATCH_CASE"));
            TextDiffFrame textDiffFrame = this;
            if (textDiffFrame == null) {
                throw null;
            }
            this.m_textFinder.addActionListener(new ActionListener(textDiffFrame){
                private final /* synthetic */ TextDiffFrame this$0;

                public void actionPerformed(ActionEvent actionEvent) {
                    String string = actionEvent.getActionCommand();
                    if (string.equals("FindSelection")) {
                        TextDiffFrame.access$8(this.this$0, TextDiffFrame.access$7(this.this$0).getText());
                        TextDiffFrame.access$10(this.this$0, TextDiffFrame.access$7(this.this$0).isCaseMatched());
                        TextDiffFrame.access$12(this.this$0, TextDiffFrame.access$7(this.this$0).getFindDirection());
                        this.this$0.performFind();
                    }
                }
                {
                    this.this$0 = textDiffFrame;
                    this.constructor$0(textDiffFrame);
                }

                private final void constructor$0(TextDiffFrame textDiffFrame) {
                }
            });
        }
        this.m_textFinder.setText(this.m_findText);
        this.m_textFinder.setCaseMatched(this.m_findCase);
        this.m_textFinder.setFindDirection(this.m_findDirection);
        if (this.m_textFindDialog == null) {
            this.m_textFindDialog = this.m_textFinder.createDialog(this, this.getCommonResources().getString("FIND_DIALOG_TITLE"));
        }
        this.m_textFindDialog.show();
    }

    void performFind() {
        boolean bl;
        boolean bl2 = bl = this.m_findDirection == 0;
        if (!this.m_mainView.find(this.m_findText, this.m_findCase, bl)) {
            JOptionPane.showMessageDialog(null, this.getCommonResources().getString("FIND_NOT_FOUND"), this.getCommonResources().getString("ApplicationName"), 2);
        }
    }

    private void doActivationChecks() {
        TextDiffFrame textDiffFrame = this;
        if (textDiffFrame == null) {
            throw null;
        }
        SwingUtilities.invokeLater(new Runnable(textDiffFrame){
            private final /* synthetic */ TextDiffFrame this$0;

            public void run() {
                long l = 0L;
                long l2 = 0L;
                if (TextDiffFrame.access$13(this.this$0) != null && TextDiffFrame.access$14(this.this$0) != null) {
                    l = TextDiffFrame.access$13(this.this$0).lastModified();
                    l2 = TextDiffFrame.access$14(this.this$0).lastModified();
                    if (l != TextDiffFrame.access$15(this.this$0) || l2 != TextDiffFrame.access$16(this.this$0)) {
                        int n = 0;
                        if (l != TextDiffFrame.access$15(this.this$0)) {
                            ++n;
                        }
                        if (l2 != TextDiffFrame.access$16(this.this$0)) {
                            ++n;
                        }
                        String string = null;
                        string = n == 1 ? TextDiffFrame.access$17(this.this$0).getString("SOURCECHANGE_PROMPT_SINGLE") : TextDiffFrame.access$17(this.this$0).getString("SOURCECHANGE_PROMPT_MANY");
                        Icon icon = new JOptionPane("", 3).getIcon();
                        String string2 = TextDiffFrame.access$17(this.this$0).getString("BTN_IDYES");
                        Object[] objectArray = new String[]{string2, TextDiffFrame.access$17(this.this$0).getString("BTN_IDNO")};
                        JOptionPane jOptionPane = new JOptionPane(string, 3, 0, icon, objectArray);
                        JDialog jDialog = jOptionPane.createDialog(this.this$0, TextDiffFrame.access$17(this.this$0).getString("ApplicationName"));
                        jDialog.show();
                        Object object = jOptionPane.getValue();
                        int n2 = -1;
                        if (object != null) {
                            if (object instanceof Integer) {
                                n2 = (Integer)object;
                            } else if (object instanceof String && string2.equals(object)) {
                                n2 = 0;
                            }
                        } else {
                            TextDiffFrame.access$18("Strange. Got this:" + object.getClass().getName() + "[" + object + "]");
                        }
                        if (n2 == 0) {
                            try {
                                this.this$0.performDiff();
                            }
                            catch (IOException iOException) {
                                TextDiffFrame.access$19(this.this$0, iOException);
                            }
                        } else {
                            TextDiffFrame.access$20(this.this$0, l);
                            TextDiffFrame.access$21(this.this$0, l2);
                        }
                    }
                }
                TextDiffFrame.access$2(this.this$0, false);
            }
            {
                this.this$0 = textDiffFrame;
                this.constructor$0(textDiffFrame);
            }

            private final void constructor$0(TextDiffFrame textDiffFrame) {
            }
        });
    }

    public int getViewSplit() {
        return this.m_mainView.getSplitType();
    }

    public void setViewSplit(int n) {
        int n2 = n;
        if (n == 2) {
            Action action = this.m_commands.get(ACT_SPLIT_VERT);
        } else if (n == 1) {
            Action action = this.m_commands.get(ACT_SPLIT_HORIZ);
        } else if (n == 0) {
            Action action = this.m_commands.get(ACT_SPLIT_NONE);
        } else {
            n2 = 2;
            Action action = this.m_commands.get(ACT_SPLIT_VERT);
        }
        this.m_mainView.setSplitType(n2);
    }

    private boolean getNumberingVisible() {
        return this.m_optShowLineNumbers;
    }

    private void setNumberingVisible(boolean bl) {
        this.m_optShowLineNumbers = bl;
        if (this.m_optShowLineNumbers) {
            this.m_mainView.setLineNumberDisplayType(3);
        } else {
            this.m_mainView.setLineNumberDisplayType(0);
        }
    }

    private boolean getToolAreaVisible() {
        return this.m_optShowToolbar;
    }

    private void setToolAreaVisible(boolean bl) {
        this.m_optShowToolbar = bl;
        ((Component)this.m_toolArea).setVisible(this.m_optShowToolbar);
    }

    private boolean getStatusbarVisible() {
        return this.m_optShowStatusbar;
    }

    private void setStatusbarVisible(boolean bl) {
        this.m_optShowStatusbar = bl;
        ((Component)this.m_messageTray).setVisible(this.m_optShowStatusbar);
    }

    private int getDiffTabSize() {
        return this.m_displayTabSize;
    }

    private void setDiffTabSize(int n) {
        this.m_displayTabSize = n;
    }

    private void toggleDiffsOnly() {
        this.m_diffsOnly = !this.m_diffsOnly;
        try {
            this.performDiff();
        }
        catch (IOException iOException) {
            this.showError(iOException);
        }
        this.m_stateHack.setDiffOnly(this.m_diffsOnly);
    }

    private void swapSources() {
        this.m_mainView.swapSources();
    }

    private void gotoDiff(int n) {
        this.m_mainView.setPositionToDiff(n);
    }

    private void gotoMatch(int n) {
        this.m_mainView.setPositionToMatch(n);
    }

    private void querySetEncoding(String string) {
        String string2;
        String string3;
        if (string.equals(ACT_TARGET_ENCODE)) {
            string3 = this.getCommonResources().getString("ENCODING_TARGET_TITLE");
            string2 = this.getTargetFileEncoding();
        } else {
            string3 = this.getCommonResources().getString("ENCODING_SOURCE_TITLE");
            string2 = this.getSourceFileEncoding();
        }
        FileEncodingPane fileEncodingPane = new FileEncodingPane();
        fileEncodingPane.setEncoding(string2);
        fileEncodingPane.setApproveButtonText(this.getCommonResources().getString("BTN_IDOK"));
        fileEncodingPane.setCancelButtonText(this.getCommonResources().getString("BTN_IDCANCEL"));
        fileEncodingPane.setLabelText(this.getCommonResources().getString("ENCODING_LABEL"));
        fileEncodingPane.setFormatDefaultString(this.getCommonResources().getString("ENCODING_FORMAT_DEFAULT_STRING"));
        JDialog jDialog = fileEncodingPane.createDialog(this, string3);
        jDialog.show();
        jDialog.dispose();
        String string4 = fileEncodingPane.getEncoding();
        boolean bl = false;
        if (string4 != null) {
            if (string.equals(ACT_TARGET_ENCODE)) {
                if (!string4.equals(this.getTargetFileEncoding())) {
                    try {
                        this.setTargetFileEncoding(string4);
                        bl = true;
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        bl = false;
                    }
                }
            } else if (!string4.equals(this.getSourceFileEncoding())) {
                try {
                    this.setSourceFileEncoding(string4);
                    bl = true;
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    bl = false;
                }
            }
            if (bl) {
                try {
                    this.performDiff();
                }
                catch (IOException iOException) {
                    this.showError(iOException);
                }
            }
        }
    }

    private void doOptionsDialog() {
        int n;
        OptionsSetter optionsSetter = new OptionsSetter((Frame)this, true, this.getCommonResources());
        optionsSetter.putValue("ShowLinesNums", new Boolean(this.getNumberingVisible()));
        optionsSetter.putValue("ShowDiffs", new Boolean(this.m_optShowDiffsOnly));
        optionsSetter.putValue(CFG_SHOW_TOOLBAR, new Boolean(this.getToolAreaVisible()));
        optionsSetter.putValue(CFG_SHOW_STATUSBAR, new Boolean(this.getStatusbarVisible()));
        optionsSetter.putValue("IgnoreCase", new Boolean(this.m_optIgnoreCase));
        optionsSetter.putValue("IgnoreEOL", new Boolean(this.m_optIgnoreEOL));
        optionsSetter.putValue("WhitespaceType", new Integer(this.m_whitespaceIgnoreType));
        optionsSetter.putValue("TabSize", new Integer(this.getDiffTabSize()));
        Color[][] colorArray = new Color[this.m_textColors.length][];
        int n2 = 0;
        while (n2 < this.m_textColors.length) {
            colorArray[n2] = new Color[this.m_textColors[n2].length];
            n = 0;
            while (n < this.m_textColors[n2].length) {
                colorArray[n2][n] = this.m_textColors[n2][n];
                ++n;
            }
            ++n2;
        }
        optionsSetter.putValue("TextColors", colorArray);
        optionsSetter.pack();
        optionsSetter.setLocationRelativeTo(this);
        optionsSetter.show();
        if (optionsSetter.getStatus() == 1) {
            boolean bl = false;
            n2 = 0;
            n = 0;
            bl = true;
            if (bl) {
                Color[][] colorArray2;
                Integer n3;
                boolean bl2;
                Boolean bl3 = (Boolean)optionsSetter.getValue("ShowLinesNums");
                if (bl3 != null) {
                    bl2 = bl3;
                    if (this.getNumberingVisible() != bl2) {
                        n2 = 1;
                    }
                    this.setNumberingVisible(bl2);
                }
                if ((bl3 = (Boolean)optionsSetter.getValue("ShowDiffs")) != null) {
                    this.m_optShowDiffsOnly = bl3;
                }
                if ((bl3 = (Boolean)optionsSetter.getValue(CFG_SHOW_TOOLBAR)) != null) {
                    this.setToolAreaVisible(bl3);
                }
                if ((bl3 = (Boolean)optionsSetter.getValue(CFG_SHOW_STATUSBAR)) != null) {
                    this.setStatusbarVisible(bl3);
                }
                if ((bl3 = (Boolean)optionsSetter.getValue("IgnoreCase")) != null) {
                    bl2 = bl3;
                    if (bl2 != this.m_optIgnoreCase) {
                        n = 1;
                    }
                    this.m_optIgnoreCase = bl2;
                }
                if ((bl3 = (Boolean)optionsSetter.getValue("IgnoreEOL")) != null) {
                    bl2 = bl3;
                    if (bl2 != this.m_optIgnoreEOL) {
                        n = 1;
                    }
                    this.m_optIgnoreEOL = bl2;
                }
                if ((n3 = (Integer)optionsSetter.getValue("WhitespaceType")) != null) {
                    if (this.m_whitespaceIgnoreType != n3) {
                        n = 1;
                    }
                    this.m_whitespaceIgnoreType = n3;
                }
                if ((n3 = (Integer)optionsSetter.getValue("TabSize")) != null) {
                    this.setDiffTabSize(n3);
                }
                if ((colorArray2 = (Color[][])optionsSetter.getValue("TextColors")) != null) {
                    this.m_textColors = colorArray2;
                }
                this.saveSettings();
                if (n != 0) {
                    try {
                        this.performDiff();
                    }
                    catch (IOException iOException) {
                        this.showError(iOException);
                    }
                } else {
                    this.applyDisplayChanges();
                }
            }
        }
        optionsSetter.dispose();
    }

    private void doSetLocale() {
        TextDiffFrame textDiffFrame = this.m_UI;
        Cursor cursor = textDiffFrame.getCursor();
        ((Component)textDiffFrame).setCursor(Cursor.getPredefinedCursor(3));
        LocaleChooserPanel localeChooserPanel = new LocaleChooserPanel(this.m_locale);
        JDialog jDialog = new JDialog(this);
        jDialog.setModal(true);
        Container container = jDialog.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)localeChooserPanel, "Center");
        TextDiffFrame textDiffFrame2 = this;
        if (textDiffFrame2 == null) {
            throw null;
        }
        LocaleButtonListener localeButtonListener = textDiffFrame2.new LocaleButtonListener(jDialog, localeChooserPanel);
        JPanel jPanel = new JPanel(new FlowLayout(2));
        JButton jButton = new JButton(this.getCommonResources().getString("BTN_IDOK"));
        jButton.setActionCommand("OK");
        jButton.addActionListener(localeButtonListener);
        jPanel.add(jButton);
        jDialog.getRootPane().setDefaultButton(jButton);
        jButton = new JButton(this.getCommonResources().getString("BTN_IDCANCEL"));
        jButton.setActionCommand("CANCEL");
        jButton.addActionListener(localeButtonListener);
        jPanel.add(jButton);
        container.add((Component)jPanel, "South");
        ((Component)textDiffFrame).setCursor(cursor);
        jDialog.pack();
        jDialog.setLocationRelativeTo(this);
        jDialog.show();
    }

    private ActionMap buildDefaultCommands() {
        String[] stringArray = new String[]{ACT_FILE_OPEN, ACT_FILE_FOLDERS, ACT_FILE_CLOSE, ACT_FILE_MERGE, ACT_FILE_PAGESETUP, ACT_FILE_PRINT, ACT_FILE_CHART, ACT_FILE_RELOAD, ACT_EXIT, ACT_CUT, ACT_COPY, ACT_PASTE, ACT_SELECT_ALL, ACT_FIND, ACT_FIND_NEXT, ACT_DIFF_ONLY, ACT_DIFF_NEXT, ACT_DIFF_PREV, ACT_MATCH_NEXT, ACT_MATCH_PREV, ACT_OPTIONS, ACT_SOURCE_ENCODE, ACT_TARGET_ENCODE, ACT_SPLIT_VERT, ACT_SPLIT_HORIZ, ACT_SPLIT_NONE, ACT_SWAP_SOURCES, "Help", ACT_HELP_ABOUT};
        ActionMap actionMap = new ActionMap();
        int n = 0;
        while (n < stringArray.length) {
            TextDiffFrame textDiffFrame = this;
            if (textDiffFrame == null) {
                throw null;
            }
            AbstractAction abstractAction = new AbstractAction(textDiffFrame){
                private final /* synthetic */ TextDiffFrame this$0;

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$0.fireCommand("fire", actionEvent);
                }
                {
                    this.this$0 = textDiffFrame;
                    this.constructor$0(textDiffFrame);
                }

                private final void constructor$0(TextDiffFrame textDiffFrame) {
                }
            };
            abstractAction.putValue("Name", stringArray[n]);
            abstractAction.putValue("Default", stringArray[n]);
            abstractAction.setEnabled(false);
            actionMap.put(stringArray[n], abstractAction);
            ++n;
        }
        return actionMap;
    }

    protected JMenu[] createMenus(ActionMap actionMap, Hashtable hashtable) {
        ResourceBundle resourceBundle = this.getCommonResources();
        String[][] stringArray = new String[][]{{MENU_BASE_FILE, ACT_FILE_OPEN, ACT_FILE_CLOSE, ACT_FILE_MERGE, null, ACT_FILE_RELOAD, null, ACT_EXIT}, {MENU_BASE_EDIT, ACT_COPY, null, ACT_SELECT_ALL, null, ACT_SOURCE_ENCODE, ACT_TARGET_ENCODE, null, ACT_OPTIONS}, {MENU_BASE_SEARCH, ACT_FIND, ACT_FIND_NEXT, null, ACT_DIFF_NEXT, ACT_DIFF_PREV, null, ACT_MATCH_NEXT, ACT_MATCH_PREV}, {MENU_BASE_WINDOW, ACT_SPLIT_VERT, ACT_SPLIT_HORIZ, ACT_SPLIT_NONE, ACT_SWAP_SOURCES, null, ACT_DIFF_ONLY}};
        JMenu[] jMenuArray = new JMenu[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            ButtonLook buttonLook = (ButtonLook)resourceBundle.getObject("Menu" + stringArray[n][0]);
            jMenuArray[n] = new JMenu(buttonLook.getDisplayName());
            if (buttonLook.getMnemonic() != '\u0000') {
                jMenuArray[n].setMnemonic(buttonLook.getMnemonic());
            }
            int n2 = 1;
            while (n2 < stringArray[n].length) {
                if (stringArray[n][n2] != null) {
                    JMenuItem jMenuItem;
                    String string = stringArray[n][n2];
                    Integer n3 = (Integer)hashtable.get(string);
                    int n4 = n3 != null ? n3 : 0;
                    ButtonLook buttonLook2 = (ButtonLook)resourceBundle.getObject("act_" + string + ".menubar");
                    switch (n4) {
                        case 1: {
                            jMenuItem = new JCheckBoxMenuItem();
                            break;
                        }
                        case 2: {
                            jMenuItem = new JRadioButtonMenuItem();
                            break;
                        }
                        default: {
                            jMenuItem = new JMenuItem();
                            break;
                        }
                    }
                    Action action = actionMap.get(string);
                    buttonLook2.configure(jMenuItem);
                    jMenuItem.setHorizontalTextPosition(4);
                    jMenuItem.setVerticalTextPosition(0);
                    jMenuItem.setActionCommand(string);
                    ActionUtils.wireActionToButton(jMenuItem, action);
                    this.specialWire(string, jMenuItem, action);
                    jMenuArray[n].add((Component)jMenuItem);
                } else {
                    jMenuArray[n].addSeparator();
                }
                ++n2;
            }
            ++n;
        }
        return jMenuArray;
    }

    private JToolBar[] createToolBars(ActionMap actionMap, Hashtable hashtable) {
        JToolBar[] jToolBarArray;
        ResourceBundle resourceBundle = this.getCommonResources();
        boolean bl = true;
        String[][] stringArray = new String[][]{{ACT_FILE_OPEN, ACT_FILE_RELOAD}, {ACT_DIFF_NEXT, ACT_DIFF_PREV, null, ACT_MATCH_NEXT, ACT_MATCH_PREV, null, ACT_FIND}, {ACT_COPY}, {ACT_SPLIT_VERT, ACT_SPLIT_HORIZ, ACT_SPLIT_NONE, ACT_SWAP_SOURCES, null, ACT_DIFF_ONLY}};
        if (bl) {
            jToolBarArray = new JToolBar[]{new JToolBar()};
            jToolBarArray[0].setFloatable(false);
        } else {
            jToolBarArray = new JToolBar[stringArray.length];
        }
        int n = 0;
        while (n < stringArray.length) {
            int n2;
            if (bl) {
                n2 = 0;
            } else {
                n2 = n;
                jToolBarArray[n2] = new JToolBar();
                jToolBarArray[n2].setFloatable(false);
            }
            int n3 = 0;
            while (n3 < stringArray[n].length) {
                if (stringArray[n][n3] != null) {
                    AbstractButton abstractButton;
                    String string = stringArray[n][n3];
                    Integer n4 = (Integer)hashtable.get(string);
                    int n5 = n4 != null ? n4 : 0;
                    ButtonLook buttonLook = (ButtonLook)resourceBundle.getObject("act_" + string + ".toolbar");
                    switch (n5) {
                        case 1: {
                            abstractButton = new JToggleButton();
                            break;
                        }
                        case 2: {
                            abstractButton = new JToggleButton();
                            break;
                        }
                        default: {
                            abstractButton = new JButton();
                            break;
                        }
                    }
                    Action action = actionMap.get(string);
                    buttonLook.configure(abstractButton);
                    abstractButton.setHorizontalTextPosition(0);
                    abstractButton.setVerticalTextPosition(3);
                    abstractButton.setActionCommand(string);
                    ActionUtils.wireActionToButton(abstractButton, action);
                    this.specialWire(string, abstractButton, action);
                    jToolBarArray[n2].add(abstractButton);
                } else {
                    jToolBarArray[n2].addSeparator();
                }
                ++n3;
            }
            if (n < stringArray.length) {
                jToolBarArray[n2].addSeparator();
            }
            ++n;
        }
        return jToolBarArray;
    }

    private void specialWire(String string, AbstractButton abstractButton, Action action) {
        if (string.equals(ACT_DIFF_ONLY)) {
            TextDiffFrame textDiffFrame = this;
            if (textDiffFrame == null) {
                throw null;
            }
            this.m_stateHack.addPropertyChangeListener(textDiffFrame.new BooleanSelectionAdapter(abstractButton, this.m_stateHack.PROPERTY_DIFF_ONLY));
        } else if (string.equals(ACT_SPLIT_VERT)) {
            TextDiffFrame textDiffFrame = this;
            if (textDiffFrame == null) {
                throw null;
            }
            this.m_mainView.addPropertyChangeListener(textDiffFrame.new IntegerSelectionAdapter(abstractButton, "splitType", 2));
            abstractButton.setSelected(this.m_mainView.getSplitType() == 2);
        } else if (string.equals(ACT_SPLIT_HORIZ)) {
            TextDiffFrame textDiffFrame = this;
            if (textDiffFrame == null) {
                throw null;
            }
            this.m_mainView.addPropertyChangeListener(textDiffFrame.new IntegerSelectionAdapter(abstractButton, "splitType", 1));
            abstractButton.setSelected(this.m_mainView.getSplitType() == 1);
        } else if (string.equals(ACT_SPLIT_NONE)) {
            TextDiffFrame textDiffFrame = this;
            if (textDiffFrame == null) {
                throw null;
            }
            this.m_mainView.addPropertyChangeListener(textDiffFrame.new IntegerSelectionAdapter(abstractButton, "splitType", 0));
            abstractButton.setSelected(this.m_mainView.getSplitType() == 0);
        }
    }

    private void setCommonResources(Locale locale) {
        String string = this.getClass().getName();
        int n = string.lastIndexOf(46);
        String string2 = n >= 0 ? string.substring(0, n + 1) : "";
        try {
            this.m_comonResources = locale != null ? ResourceBundle.getBundle(string2 + "CommonResources", locale) : ResourceBundle.getBundle(string2 + "CommonResources");
        }
        catch (MissingResourceException missingResourceException) {
            TextDiffFrame.println("Error: unable to load common resources1.");
        }
        if (this.m_comonResources == null) {
            TextDiffFrame.println("Error: unable to load common resources.");
            throw new RuntimeException("Missing needed resources");
        }
    }

    private ResourceBundle getCommonResources() {
        if (this.m_comonResources == null) {
            this.setCommonResources(null);
        }
        return this.m_comonResources;
    }

    private void updateLookAndFeel() {
        TextDiffFrame textDiffFrame = this.m_UI;
        ((Component)textDiffFrame).setCursor(Cursor.getPredefinedCursor(3));
        SwingUtilities.updateComponentTreeUI(textDiffFrame);
        this.pack();
        if (this.m_textFindDialog != null) {
            SwingUtilities.updateComponentTreeUI(this.m_textFindDialog);
            this.m_textFindDialog.pack();
        }
        ((Component)textDiffFrame).invalidate();
        ((Component)textDiffFrame).validate();
        textDiffFrame.repaint();
        ((Component)textDiffFrame).setCursor(Cursor.getPredefinedCursor(0));
    }

    private void configureMenu(JMenu jMenu, String string) {
        ButtonLook buttonLook;
        try {
            buttonLook = (ButtonLook)this.getCommonResources().getObject(string);
        }
        catch (MissingResourceException missingResourceException) {
            buttonLook = null;
        }
        if (buttonLook != null) {
            jMenu.setText(buttonLook.getDisplayName());
            if (buttonLook.getMnemonic() != '\u0000') {
                jMenu.setMnemonic(buttonLook.getMnemonic());
            }
        } else {
            jMenu.setText(string);
        }
    }

    protected JMenu lookNFeelMenu() {
        Object object;
        JMenu jMenu = new JMenu();
        this.configureMenu(jMenu, "MenuUserInterface");
        JMenu jMenu2 = new JMenu();
        this.configureMenu(jMenu2, "MenuLookNFeel");
        Object object2 = (ButtonLook)this.getCommonResources().getObject("act_SetLocale.menubar");
        Serializable serializable = new JMenuItem("Set Locale...");
        if (object2 != null) {
            ((ButtonLook)object2).configure((AbstractButton)serializable);
        }
        ((AbstractButton)serializable).setHorizontalTextPosition(0);
        ((AbstractButton)serializable).setVerticalTextPosition(3);
        ((AbstractButton)serializable).setActionCommand(ACT_SET_LOCALE);
        Action action = this.m_commands.get(ACT_SET_LOCALE);
        ActionUtils.wireActionToButton((AbstractButton)serializable, action);
        this.specialWire(ACT_SET_LOCALE, (AbstractButton)serializable, action);
        jMenu.add((JMenuItem)serializable);
        jMenu.addSeparator();
        object2 = null;
        serializable = new ButtonGroup();
        TextDiffFrame textDiffFrame = this;
        if (textDiffFrame == null) {
            throw null;
        }
        ToggleUIListener toggleUIListener = textDiffFrame.new ToggleUIListener();
        UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
        int n = 0;
        while (n < lookAndFeelInfoArray.length) {
            object = lookAndFeelInfoArray[n].getName();
            object2 = new JRadioButtonMenuItem((String)object);
            if (((String)object).equals(UIManager.getLookAndFeel().getName())) {
                ((AbstractButton)object2).setSelected(true);
            }
            ((AbstractButton)object2).addItemListener(toggleUIListener);
            ((ButtonGroup)serializable).add((AbstractButton)object2);
            jMenu2.add((JMenuItem)object2);
            ++n;
        }
        PropertiesMetalTheme propertiesMetalTheme = null;
        object = new File(".", "MyTheme.theme");
        if (!((File)object).exists()) {
            object = new File(System.getProperty(USER_HOME_PROPERTY_KEY), "MyTheme.theme");
        }
        if (((File)object).exists()) {
            try {
                propertiesMetalTheme = new PropertiesMetalTheme(new FileInputStream((File)object));
            }
            catch (IOException iOException) {
                System.out.println(iOException);
            }
        }
        MetalTheme[] metalThemeArray = new MetalTheme[]{new DefaultMetalTheme(), new GreenMetalTheme(), new AquaMetalTheme(), new KhakiMetalTheme(), new DemoMetalTheme(), new BigGreenMetalTheme(), new ContrastMetalTheme(), new BigContrastMetalTheme(), propertiesMetalTheme};
        MetalThemeMenu metalThemeMenu = new MetalThemeMenu("Theme", metalThemeArray, this.m_UI);
        this.configureMenu(metalThemeMenu, "MenuTheme");
        jMenu2.addSeparator();
        jMenu2.add(metalThemeMenu);
        jMenu.add(jMenu2);
        return jMenu;
    }

    protected void fireCommand(String string, ActionEvent actionEvent) {
        String string2 = "\n";
        String string3 = "Action event detected by: " + string + string2 + "    source class: [" + actionEvent.getSource().getClass().getName() + "]" + string2 + "    Event source: " + actionEvent.getSource() + string2;
        TextDiffFrame.println(string3);
    }

    private void setMessage(String string) {
        String string2 = string;
        if (string == null || string.length() == 0) {
            string2 = " ";
        }
        this.m_messageTray.setMessage(string2);
        this.m_messageTray.repaint();
    }

    private static void println(String string) {
    }

    private static void print(String string) {
    }

    static /* synthetic */ boolean access$1(TextDiffFrame textDiffFrame) {
        return textDiffFrame.m_askingForReload;
    }

    static /* synthetic */ void access$2(TextDiffFrame textDiffFrame, boolean bl) {
        textDiffFrame.m_askingForReload = bl;
    }

    static /* synthetic */ void access$3(TextDiffFrame textDiffFrame) {
        textDiffFrame.doActivationChecks();
    }

    static /* synthetic */ ActionMap access$4(TextDiffFrame textDiffFrame) {
        return textDiffFrame.m_commands;
    }

    static /* synthetic */ void access$5(TextDiffFrame textDiffFrame) {
        textDiffFrame.updateLookAndFeel();
    }

    static /* synthetic */ String access$6(TextDiffFrame textDiffFrame) {
        return textDiffFrame.m_findText;
    }

    static /* synthetic */ FindTextPane access$7(TextDiffFrame textDiffFrame) {
        return textDiffFrame.m_textFinder;
    }

    static /* synthetic */ void access$8(TextDiffFrame textDiffFrame, String string) {
        textDiffFrame.m_findText = string;
    }

    static /* synthetic */ boolean access$9(TextDiffFrame textDiffFrame) {
        return textDiffFrame.m_findCase;
    }

    static /* synthetic */ void access$10(TextDiffFrame textDiffFrame, boolean bl) {
        textDiffFrame.m_findCase = bl;
    }

    static /* synthetic */ int access$11(TextDiffFrame textDiffFrame) {
        return textDiffFrame.m_findDirection;
    }

    static /* synthetic */ void access$12(TextDiffFrame textDiffFrame, int n) {
        textDiffFrame.m_findDirection = n;
    }

    static /* synthetic */ File access$13(TextDiffFrame textDiffFrame) {
        return textDiffFrame.m_firstFile;
    }

    static /* synthetic */ File access$14(TextDiffFrame textDiffFrame) {
        return textDiffFrame.m_secondFile;
    }

    static /* synthetic */ long access$15(TextDiffFrame textDiffFrame) {
        return textDiffFrame.m_firstFileModified;
    }

    static /* synthetic */ long access$16(TextDiffFrame textDiffFrame) {
        return textDiffFrame.m_secondFileModified;
    }

    static /* synthetic */ ResourceBundle access$17(TextDiffFrame textDiffFrame) {
        return textDiffFrame.getCommonResources();
    }

    static /* synthetic */ void access$20(TextDiffFrame textDiffFrame, long l) {
        textDiffFrame.m_firstFileModified = l;
    }

    static /* synthetic */ void access$21(TextDiffFrame textDiffFrame, long l) {
        textDiffFrame.m_secondFileModified = l;
    }

    static /* synthetic */ String access$22() {
        return EXIT_ACTION;
    }

    public TextDiffFrame() {
        this(Locale.getDefault());
    }

    public TextDiffFrame(Locale locale) {
        Serializable serializable;
        this.m_UI = this;
        this.m_locale = locale;
        this.setCommonResources(locale);
        this.setTitle(this.getCommonResources().getString("ApplicationName"));
        URL uRL = this.getClass().getResource("images/VisDiffIcon.gif");
        if (uRL != null) {
            serializable = new ImageIcon(uRL);
            ((Frame)this).setIconImage(serializable.getImage());
        }
        TextDiffFrame textDiffFrame = this;
        if (textDiffFrame == null) {
            throw null;
        }
        this.m_stateHack = textDiffFrame.new StateBean();
        this.m_stateHack.setDiffOnly(false);
        TextDiffFrame textDiffFrame2 = this;
        if (textDiffFrame2 == null) {
            throw null;
        }
        this.addWindowListener(new WindowAdapter(textDiffFrame2){
            private final /* synthetic */ TextDiffFrame this$0;

            public void windowClosing(WindowEvent windowEvent) {
                TextDiffFrame.access$0(this.this$0);
            }

            public void windowActivated(WindowEvent windowEvent) {
                if (!TextDiffFrame.access$1(this.this$0)) {
                    TextDiffFrame.access$2(this.this$0, true);
                    TextDiffFrame.access$3(this.this$0);
                }
            }
            {
                this.this$0 = textDiffFrame;
                this.constructor$0(textDiffFrame);
            }

            private final void constructor$0(TextDiffFrame textDiffFrame) {
            }
        });
        this.m_mainView = new SplitDualDiffPane();
        this.m_commands = this.buildDefaultCommands();
        TextDiffFrame textDiffFrame3 = this;
        if (textDiffFrame3 == null) {
            throw null;
        }
        serializable = textDiffFrame3.new FileCloseAction();
        this.m_stateHack.addPropertyChangeListener((PropertyChangeListener)((Object)serializable));
        this.m_commands.put(ACT_FILE_CLOSE, (Action)((Object)serializable));
        TextDiffFrame textDiffFrame4 = this;
        if (textDiffFrame4 == null) {
            throw null;
        }
        this.m_commands.put(ACT_FILE_OPEN, textDiffFrame4.new FileOpenAction());
        TextDiffFrame textDiffFrame5 = this;
        if (textDiffFrame5 == null) {
            throw null;
        }
        serializable = textDiffFrame5.new FileReloadAction();
        this.m_stateHack.addPropertyChangeListener((PropertyChangeListener)((Object)serializable));
        this.m_commands.put(ACT_FILE_RELOAD, (Action)((Object)serializable));
        TextDiffFrame textDiffFrame6 = this;
        if (textDiffFrame6 == null) {
            throw null;
        }
        serializable = textDiffFrame6.new PrintAction();
        this.m_stateHack.addPropertyChangeListener((PropertyChangeListener)((Object)serializable));
        this.m_commands.put(ACT_FILE_PRINT, (Action)((Object)serializable));
        TextDiffFrame textDiffFrame7 = this;
        if (textDiffFrame7 == null) {
            throw null;
        }
        this.m_commands.put(ACT_CUT, textDiffFrame7.new EditAction(ACT_CUT));
        TextDiffFrame textDiffFrame8 = this;
        if (textDiffFrame8 == null) {
            throw null;
        }
        this.m_commands.put(ACT_COPY, textDiffFrame8.new EditAction(ACT_COPY));
        TextDiffFrame textDiffFrame9 = this;
        if (textDiffFrame9 == null) {
            throw null;
        }
        this.m_commands.put(ACT_PASTE, textDiffFrame9.new EditAction(ACT_PASTE));
        TextDiffFrame textDiffFrame10 = this;
        if (textDiffFrame10 == null) {
            throw null;
        }
        serializable = textDiffFrame10.new EditAction(ACT_SELECT_ALL);
        this.m_stateHack.addPropertyChangeListener((PropertyChangeListener)((Object)serializable));
        this.m_commands.put(ACT_SELECT_ALL, (Action)((Object)serializable));
        TextDiffFrame textDiffFrame11 = this;
        if (textDiffFrame11 == null) {
            throw null;
        }
        serializable = textDiffFrame11.new SetEncodingAction();
        this.m_stateHack.addPropertyChangeListener((PropertyChangeListener)((Object)serializable));
        this.m_commands.put(ACT_SOURCE_ENCODE, (Action)((Object)serializable));
        TextDiffFrame textDiffFrame12 = this;
        if (textDiffFrame12 == null) {
            throw null;
        }
        serializable = textDiffFrame12.new SetEncodingAction();
        this.m_stateHack.addPropertyChangeListener((PropertyChangeListener)((Object)serializable));
        this.m_commands.put(ACT_TARGET_ENCODE, (Action)((Object)serializable));
        TextDiffFrame textDiffFrame13 = this;
        if (textDiffFrame13 == null) {
            throw null;
        }
        this.m_commands.put(ACT_SPLIT_HORIZ, textDiffFrame13.new SetSplitAction(1));
        TextDiffFrame textDiffFrame14 = this;
        if (textDiffFrame14 == null) {
            throw null;
        }
        this.m_commands.put(ACT_SPLIT_VERT, textDiffFrame14.new SetSplitAction(2));
        TextDiffFrame textDiffFrame15 = this;
        if (textDiffFrame15 == null) {
            throw null;
        }
        this.m_commands.put(ACT_SPLIT_NONE, textDiffFrame15.new SetSplitAction(0));
        TextDiffFrame textDiffFrame16 = this;
        if (textDiffFrame16 == null) {
            throw null;
        }
        serializable = textDiffFrame16.new SwapAction();
        this.m_stateHack.addPropertyChangeListener((PropertyChangeListener)((Object)serializable));
        this.m_commands.put(ACT_SWAP_SOURCES, (Action)((Object)serializable));
        TextDiffFrame textDiffFrame17 = this;
        if (textDiffFrame17 == null) {
            throw null;
        }
        serializable = textDiffFrame17.new DiffOnlyAction();
        this.m_stateHack.addPropertyChangeListener((PropertyChangeListener)((Object)serializable));
        this.m_commands.put(ACT_DIFF_ONLY, (Action)((Object)serializable));
        TextDiffFrame textDiffFrame18 = this;
        if (textDiffFrame18 == null) {
            throw null;
        }
        serializable = textDiffFrame18.new GotoDiffAction(2);
        this.m_stateHack.addPropertyChangeListener((PropertyChangeListener)((Object)serializable));
        this.m_commands.put(ACT_DIFF_NEXT, (Action)((Object)serializable));
        TextDiffFrame textDiffFrame19 = this;
        if (textDiffFrame19 == null) {
            throw null;
        }
        serializable = textDiffFrame19.new GotoDiffAction(3);
        this.m_stateHack.addPropertyChangeListener((PropertyChangeListener)((Object)serializable));
        this.m_commands.put(ACT_DIFF_PREV, (Action)((Object)serializable));
        TextDiffFrame textDiffFrame20 = this;
        if (textDiffFrame20 == null) {
            throw null;
        }
        serializable = textDiffFrame20.new GotoMatchAction(2);
        this.m_stateHack.addPropertyChangeListener((PropertyChangeListener)((Object)serializable));
        this.m_commands.put(ACT_MATCH_NEXT, (Action)((Object)serializable));
        TextDiffFrame textDiffFrame21 = this;
        if (textDiffFrame21 == null) {
            throw null;
        }
        serializable = textDiffFrame21.new GotoMatchAction(3);
        this.m_stateHack.addPropertyChangeListener((PropertyChangeListener)((Object)serializable));
        this.m_commands.put(ACT_MATCH_PREV, (Action)((Object)serializable));
        TextDiffFrame textDiffFrame22 = this;
        if (textDiffFrame22 == null) {
            throw null;
        }
        serializable = textDiffFrame22.new FindAction();
        this.m_stateHack.addPropertyChangeListener((PropertyChangeListener)((Object)serializable));
        this.m_commands.put(ACT_FIND, (Action)((Object)serializable));
        TextDiffFrame textDiffFrame23 = this;
        if (textDiffFrame23 == null) {
            throw null;
        }
        serializable = textDiffFrame23.new FindNextAction();
        this.m_stateHack.addPropertyChangeListener((PropertyChangeListener)((Object)serializable));
        this.m_commands.put(ACT_FIND_NEXT, (Action)((Object)serializable));
        TextDiffFrame textDiffFrame24 = this;
        if (textDiffFrame24 == null) {
            throw null;
        }
        this.m_commands.put(ACT_EXIT, textDiffFrame24.new ExitAction());
        TextDiffFrame textDiffFrame25 = this;
        if (textDiffFrame25 == null) {
            throw null;
        }
        this.m_commands.put(ACT_OPTIONS, textDiffFrame25.new OptionsAction());
        TextDiffFrame textDiffFrame26 = this;
        if (textDiffFrame26 == null) {
            throw null;
        }
        this.m_commands.put(ACT_SET_LOCALE, textDiffFrame26.new SetLocaleAction());
        Enumeration enumeration = this.m_commands.elements();
        while (enumeration.hasMoreElements()) {
            Action action = (Action)enumeration.nextElement();
            action.setEnabled(false);
        }
        this.m_commandFlags = new Hashtable();
        this.m_commandFlags.put(ACT_DIFF_ONLY, new Integer(1));
        this.m_commandFlags.put(ACT_SPLIT_HORIZ, new Integer(2));
        this.m_commandFlags.put(ACT_SPLIT_VERT, new Integer(2));
        this.m_commandFlags.put(ACT_SPLIT_NONE, new Integer(2));
        this.m_commands.get(ACT_EXIT).setEnabled(true);
        this.m_commands.get(ACT_FILE_OPEN).setEnabled(true);
        this.m_commands.get(ACT_FILE_PAGESETUP).setEnabled(false);
        this.m_commands.get(ACT_OPTIONS).setEnabled(true);
        this.m_commands.get(ACT_SPLIT_HORIZ).setEnabled(true);
        this.m_commands.get(ACT_SPLIT_VERT).setEnabled(true);
        this.m_commands.get(ACT_SPLIT_NONE).setEnabled(false);
        this.m_commands.get(ACT_SET_LOCALE).setEnabled(true);
        this.m_commands.get("Help").setEnabled(false);
        this.m_commands.get(ACT_HELP_ABOUT).setEnabled(true);
        TextDiffFrame textDiffFrame27 = this;
        if (textDiffFrame27 == null) {
            throw null;
        }
        this.m_mainView.addPropertyChangeListener(new PropertyChangeListener(textDiffFrame27){
            private final /* synthetic */ TextDiffFrame this$0;

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("selectionPresent")) {
                    boolean bl = (Boolean)propertyChangeEvent.getNewValue();
                    TextDiffFrame.access$4(this.this$0).get("Copy").setEnabled(bl);
                }
            }
            {
                this.this$0 = textDiffFrame;
                this.constructor$0(textDiffFrame);
            }

            private final void constructor$0(TextDiffFrame textDiffFrame) {
            }
        });
        this.m_messageTray = new MessageTray();
        this.setStatusbarVisible(this.m_optShowStatusbar);
        this.m_contentPane = new JPanel();
        this.m_contentPane.setLayout(new BorderLayout());
        this.m_contentPane.setPreferredSize(new Dimension(600, 400));
        this.buildControls();
        this.m_contentPane.add((Component)this.m_mainView, "Center");
        this.m_contentPane.add((Component)this.m_messageTray, "South");
        this.setContentPane(this.m_contentPane);
        this.loadSettings();
        TextDiffFrame textDiffFrame28 = this;
        if (textDiffFrame28 == null) {
            throw null;
        }
        this.m_lafListener = new PropertyChangeListener(textDiffFrame28){
            private final /* synthetic */ TextDiffFrame this$0;

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("lookAndFeel".equals(propertyChangeEvent.getPropertyName())) {
                    TextDiffFrame.access$5(this.this$0);
                }
            }
            {
                this.this$0 = textDiffFrame;
                this.constructor$0(textDiffFrame);
            }

            private final void constructor$0(TextDiffFrame textDiffFrame) {
            }
        };
        UIManager.addPropertyChangeListener(this.m_lafListener);
    }

    abstract class ListeningAbstractAction
    extends AbstractAction
    implements PropertyChangeListener {
        public abstract void propertyChange(PropertyChangeEvent var1);

        ListeningAbstractAction() {
        }
    }

    class ExitAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            TextDiffFrame.this.doExit();
        }

        ExitAction() {
            super(TextDiffFrame.EXIT_ACTION);
        }
    }

    class FindAction
    extends ListeningAbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            TextDiffFrame.this.doFind();
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals(((TextDiffFrame)TextDiffFrame.this).m_stateHack.PROPERTY_FILES_OPEN)) {
                this.setEnabled((Boolean)propertyChangeEvent.getNewValue());
            }
        }

        FindAction() {
        }
    }

    class FindNextAction
    extends ListeningAbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            TextDiffFrame.this.doFindNext();
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals(((TextDiffFrame)TextDiffFrame.this).m_stateHack.PROPERTY_FILES_OPEN)) {
                this.setEnabled((Boolean)propertyChangeEvent.getNewValue());
            }
        }

        FindNextAction() {
        }
    }

    class SetSplitAction
    extends AbstractAction {
        private int m_splitOrientation = 1;

        public void actionPerformed(ActionEvent actionEvent) {
            TextDiffFrame.this.setViewSplit(this.m_splitOrientation);
        }

        SetSplitAction(int n) {
            this.m_splitOrientation = n;
        }
    }

    class SwapAction
    extends ListeningAbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            TextDiffFrame.this.swapSources();
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals(((TextDiffFrame)TextDiffFrame.this).m_stateHack.PROPERTY_FILES_OPEN)) {
                this.setEnabled((Boolean)propertyChangeEvent.getNewValue());
            }
        }

        SwapAction() {
        }
    }

    class DiffOnlyAction
    extends ListeningAbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            TextDiffFrame.this.toggleDiffsOnly();
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals(((TextDiffFrame)TextDiffFrame.this).m_stateHack.PROPERTY_FILES_OPEN)) {
                this.setEnabled((Boolean)propertyChangeEvent.getNewValue());
            }
        }

        DiffOnlyAction() {
        }
    }

    class GotoDiffAction
    extends ListeningAbstractAction {
        private int m_gotoTarget = 0;

        public void actionPerformed(ActionEvent actionEvent) {
            TextDiffFrame.this.gotoDiff(this.m_gotoTarget);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals(((TextDiffFrame)TextDiffFrame.this).m_stateHack.PROPERTY_FILES_OPEN)) {
                this.setEnabled((Boolean)propertyChangeEvent.getNewValue());
            }
        }

        GotoDiffAction(int n) {
            this.m_gotoTarget = n;
        }
    }

    class GotoMatchAction
    extends ListeningAbstractAction {
        private int m_gotoTarget = 0;

        public void actionPerformed(ActionEvent actionEvent) {
            TextDiffFrame.this.gotoMatch(this.m_gotoTarget);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals(((TextDiffFrame)TextDiffFrame.this).m_stateHack.PROPERTY_FILES_OPEN)) {
                this.setEnabled((Boolean)propertyChangeEvent.getNewValue());
            }
        }

        GotoMatchAction(int n) {
            this.m_gotoTarget = n;
        }
    }

    class FileCloseAction
    extends ListeningAbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            TextDiffFrame.this.closeDocs();
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals(((TextDiffFrame)TextDiffFrame.this).m_stateHack.PROPERTY_FILES_OPEN)) {
                this.setEnabled((Boolean)propertyChangeEvent.getNewValue());
            }
        }

        FileCloseAction() {
        }
    }

    class FileOpenAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            TextDiffFrame.this.openDocs();
        }

        FileOpenAction() {
        }
    }

    class FileReloadAction
    extends ListeningAbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                TextDiffFrame.this.performDiff();
            }
            catch (IOException iOException) {
                TextDiffFrame.this.showError(iOException);
            }
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals(((TextDiffFrame)TextDiffFrame.this).m_stateHack.PROPERTY_FILES_OPEN)) {
                this.setEnabled((Boolean)propertyChangeEvent.getNewValue());
            }
        }

        FileReloadAction() {
        }
    }

    class EditAction
    extends ListeningAbstractAction {
        private String m_command;

        public void actionPerformed(ActionEvent actionEvent) {
            TextDiffFrame.this.doEditCommand(this.m_command);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals(((TextDiffFrame)TextDiffFrame.this).m_stateHack.PROPERTY_FILES_OPEN)) {
                this.setEnabled((Boolean)propertyChangeEvent.getNewValue());
            }
        }

        public EditAction(String string) {
            this.m_command = string;
        }
    }

    class PrintAction
    extends ListeningAbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            TextDiffFrame.this.doPrint();
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals(((TextDiffFrame)TextDiffFrame.this).m_stateHack.PROPERTY_FILES_OPEN)) {
                this.setEnabled((Boolean)propertyChangeEvent.getNewValue());
            }
        }

        PrintAction() {
        }
    }

    class SetEncodingAction
    extends ListeningAbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            TextDiffFrame.this.querySetEncoding(actionEvent.getActionCommand());
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals(((TextDiffFrame)TextDiffFrame.this).m_stateHack.PROPERTY_FILES_OPEN)) {
                this.setEnabled((Boolean)propertyChangeEvent.getNewValue());
            }
        }

        SetEncodingAction() {
        }
    }

    class OptionsAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            TextDiffFrame.this.doOptionsDialog();
        }

        OptionsAction() {
        }
    }

    class SetLocaleAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            TextDiffFrame.this.doSetLocale();
        }

        SetLocaleAction() {
        }
    }

    class LocaleButtonListener
    implements ActionListener {
        private JDialog m_dialog;
        private LocaleChooserPanel m_choose;

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("OK")) {
                ((Component)this.m_dialog).setVisible(false);
                Locale locale = this.m_choose.getLocale();
                this.m_dialog.dispose();
                TextDiffFrame.this.localeChanged(new LocaleChangeEvent(this, locale));
            } else if (string.equals("CANCEL")) {
                this.m_dialog.dispose();
            }
        }

        LocaleButtonListener() {
        }

        LocaleButtonListener(JDialog jDialog, LocaleChooserPanel localeChooserPanel) {
            this();
            this.m_dialog = jDialog;
            this.m_choose = localeChooserPanel;
        }
    }

    private class BooleanSelectionAdapter
    implements PropertyChangeListener {
        AbstractButton m_button;
        String m_propertyName;

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals(this.m_propertyName)) {
                boolean bl = (Boolean)propertyChangeEvent.getNewValue();
                this.m_button.setSelected(bl);
            }
        }

        BooleanSelectionAdapter(AbstractButton abstractButton, String string) {
            this.m_button = abstractButton;
            this.m_propertyName = string;
        }
    }

    private class IntegerSelectionAdapter
    implements PropertyChangeListener {
        AbstractButton m_button;
        String m_propretyName;
        int m_matchValue;

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals(this.m_propretyName)) {
                int n = (Integer)propertyChangeEvent.getNewValue();
                boolean bl = n == this.m_matchValue;
                this.m_button.setSelected(bl);
            }
        }

        IntegerSelectionAdapter(AbstractButton abstractButton, String string, int n) {
            this.m_button = abstractButton;
            this.m_matchValue = n;
            this.m_propretyName = string;
        }
    }

    class ToggleUIListener
    implements ItemListener {
        public void itemStateChanged(ItemEvent itemEvent) {
            JRadioButtonMenuItem jRadioButtonMenuItem = (JRadioButtonMenuItem)itemEvent.getSource();
            String string = jRadioButtonMenuItem.getText();
            String string2 = null;
            UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
            int n = 0;
            while (n < lookAndFeelInfoArray.length) {
                if (string.equals(lookAndFeelInfoArray[n].getName())) {
                    string2 = lookAndFeelInfoArray[n].getClassName();
                }
                ++n;
            }
            if (string2 != null) {
                Exception exception = null;
                TextDiffFrame textDiffFrame = TextDiffFrame.this.m_UI;
                LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
                try {
                    UIManager.setLookAndFeel(string2);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    exception = classNotFoundException;
                }
                catch (InstantiationException instantiationException) {
                    exception = instantiationException;
                }
                catch (IllegalAccessException illegalAccessException) {
                    exception = illegalAccessException;
                }
                catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
                    exception = unsupportedLookAndFeelException;
                }
                if (exception != null) {
                    jRadioButtonMenuItem.setEnabled(false);
                    TextDiffFrame.println("Could not load LookAndFeel: " + jRadioButtonMenuItem.getText());
                    exception.printStackTrace(System.out);
                    try {
                        UIManager.setLookAndFeel(lookAndFeel);
                    }
                    catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
                        TextDiffFrame.println("Could not fallback to old LookAndFeel: " + jRadioButtonMenuItem.getText());
                        unsupportedLookAndFeelException.printStackTrace(System.out);
                    }
                }
            }
        }

        ToggleUIListener() {
        }
    }

    private class StateBean {
        String PROPERTY_DIFF_ONLY = "stateDiffOnly";
        String PROPERTY_FILES_OPEN = "stateFilesOpen";
        private PropertyChangeSupport m_support = new PropertyChangeSupport(this);
        private boolean m_diffOnly;
        private boolean m_filesOpen;
        private int m_splitType;

        synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.m_support.addPropertyChangeListener(propertyChangeListener);
        }

        synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.m_support.removePropertyChangeListener(propertyChangeListener);
        }

        void setDiffOnly(boolean bl) {
            boolean bl2 = this.m_diffOnly;
            this.m_diffOnly = bl;
            this.m_support.firePropertyChange(this.PROPERTY_DIFF_ONLY, new Boolean(bl2), new Boolean(bl));
        }

        boolean isDiffOnly() {
            return this.m_diffOnly;
        }

        void setFilesOpen(boolean bl) {
            boolean bl2 = this.m_filesOpen;
            this.m_filesOpen = bl;
            this.m_support.firePropertyChange(this.PROPERTY_FILES_OPEN, new Boolean(bl2), new Boolean(bl));
        }

        boolean isFilesOpen() {
            return this.m_filesOpen;
        }

        StateBean() {
        }
    }
}

