/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.visdiff;

import com.starbase.visdiff.EncodingSupport;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.border.EmptyBorder;

class FileEncodingPane
extends JComponent {
    private String[] m_validEncodings = null;
    private String m_initialEncoding;
    private String m_encoding = this.m_initialEncoding = "8859_1";
    private JList m_encList = null;
    private ListSelectionModel m_listSelModel;
    private JScrollPane m_scroller = null;
    private String m_labelText = "Select an encoding :";
    private String m_defaultDisplayFormat = "(System default:{0})";
    private String m_approveButtonText = "OK";
    private String m_cancelButtontext = "Cancel";

    public void setEncoding(String string) {
        this.m_initialEncoding = string;
        this.m_encoding = string;
        this.setInitialSelection();
    }

    public String getEncoding() {
        return this.m_encoding;
    }

    public String getApproveButtonText() {
        return this.m_approveButtonText;
    }

    public void setApproveButtonText(String string) {
        this.m_approveButtonText = string;
    }

    public String getCancelButtonText() {
        return this.m_cancelButtontext;
    }

    public void setCancelButtonText(String string) {
        this.m_cancelButtontext = string;
    }

    public String getLabelText() {
        return this.m_labelText;
    }

    public void setLabelText(String string) {
        this.m_labelText = string;
    }

    public String getFormatDefaultString() {
        return this.m_defaultDisplayFormat;
    }

    public void setFormatDefaultString(String string) {
        this.m_defaultDisplayFormat = string;
    }

    public JDialog createDialog(Component component, String string) {
        JDialog jDialog = new JDialog((Frame)component, string, true);
        Container container = jDialog.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)this, "Center");
        JPanel jPanel = new JPanel(new FlowLayout(2));
        FileEncodingPane fileEncodingPane = this;
        if (fileEncodingPane == null) {
            throw null;
        }
        ButtonListener buttonListener = fileEncodingPane.new ButtonListener(jDialog);
        JButton jButton = new JButton(this.getApproveButtonText());
        jButton.setActionCommand("OK");
        jButton.addActionListener(buttonListener);
        jPanel.add(jButton);
        this.getRootPane().setDefaultButton(jButton);
        jButton = new JButton(this.getCancelButtonText());
        jButton.setActionCommand("CANCEL");
        jButton.addActionListener(buttonListener);
        jPanel.add(jButton);
        container.add((Component)jPanel, "South");
        jDialog.pack();
        this.m_encList.ensureIndexIsVisible(this.m_encList.getSelectedIndex());
        return jDialog;
    }

    private void setInitialSelection() {
        int n = 0;
        while (n < this.m_validEncodings.length) {
            if (this.m_validEncodings[n].equals(this.m_initialEncoding)) {
                this.m_encList.setSelectedIndex(n);
                break;
            }
            ++n;
        }
    }

    static /* synthetic */ String access$0(FileEncodingPane fileEncodingPane) {
        return fileEncodingPane.m_encoding;
    }

    public FileEncodingPane() {
        this.m_validEncodings = EncodingSupport.getValidInputEncodings();
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.m_encList = new JList<String>(this.m_validEncodings);
        this.m_encList.setSelectionMode(0);
        this.m_listSelModel = this.m_encList.getSelectionModel();
        this.m_scroller = new JScrollPane(this.m_encList);
        this.add((Component)new JLabel(this.getLabelText()), "North");
        this.add((Component)this.m_scroller, "Center");
        Object[] objectArray = new Object[]{System.getProperty("file.encoding")};
        MessageFormat messageFormat = new MessageFormat(this.getFormatDefaultString());
        this.add((Component)new JLabel(messageFormat.format(objectArray)), "South");
        this.setInitialSelection();
    }

    private class ButtonListener
    implements ActionListener {
        private Component m_parent;

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("OK")) {
                FileEncodingPane.this.m_encoding = (String)FileEncodingPane.this.m_encList.getSelectedValue();
                this.m_parent.setVisible(false);
            } else if (string.equals("CANCEL")) {
                FileEncodingPane.this.m_encoding = null;
                this.m_parent.setVisible(false);
            }
        }

        ButtonListener() {
        }

        ButtonListener(Component component) {
            this();
            this.m_parent = component;
        }
    }
}

