/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.visdiff;

import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.filechooser.FileFilter;

class ExampleFileFilter
extends FileFilter {
    private Hashtable m_filters = null;
    private String m_description = null;
    private String m_fullDescription = null;
    private boolean m_useExtensionsInDescription = true;

    public boolean accept(File file) {
        if (file != null) {
            if (file.isDirectory()) {
                return true;
            }
            String string = this.getExtension(file);
            if (string != null && this.m_filters.get(this.getExtension(file)) != null) {
                return true;
            }
        }
        return false;
    }

    public String getExtension(File file) {
        String string;
        int n;
        if (file != null && (n = (string = file.getName()).lastIndexOf(46)) > 0 && n < string.length() - 1) {
            return string.substring(n + 1).toLowerCase();
        }
        return null;
    }

    public void addExtension(String string) {
        if (this.m_filters == null) {
            this.m_filters = new Hashtable(5);
        }
        this.m_filters.put(string.toLowerCase(), this);
        this.m_fullDescription = null;
    }

    public String getDescription() {
        if (this.m_fullDescription == null) {
            StringBuffer stringBuffer = new StringBuffer();
            if (this.m_description == null || this.isExtensionListInDescription()) {
                if (this.m_description != null) {
                    stringBuffer.append(this.m_description);
                }
                stringBuffer.append(" (");
                Enumeration enumeration = this.m_filters.keys();
                if (enumeration != null) {
                    stringBuffer.append('.');
                    stringBuffer.append((String)enumeration.nextElement());
                    while (enumeration.hasMoreElements()) {
                        stringBuffer.append(", .");
                        stringBuffer.append((String)enumeration.nextElement());
                    }
                }
                stringBuffer.append(")");
            } else {
                stringBuffer.append(this.m_description);
            }
            this.m_fullDescription = stringBuffer.toString();
        }
        return this.m_fullDescription;
    }

    public void setDescription(String string) {
        this.m_description = string;
        this.m_fullDescription = null;
    }

    public void setExtensionListInDescription(boolean bl) {
        this.m_useExtensionsInDescription = bl;
        this.m_fullDescription = null;
    }

    public boolean isExtensionListInDescription() {
        return this.m_useExtensionsInDescription;
    }

    protected ExampleFileFilter() {
        this((String)null, (String)null);
    }

    protected ExampleFileFilter(String string) {
        this(string, null);
    }

    protected ExampleFileFilter(String string, String string2) {
        this(new String[]{string}, string2);
    }

    protected ExampleFileFilter(String[] stringArray) {
        this(stringArray, null);
    }

    protected ExampleFileFilter(String[] stringArray, String string) {
        this.m_filters = new Hashtable(stringArray.length);
        int n = 0;
        while (n < stringArray.length) {
            this.addExtension(stringArray[n]);
            ++n;
        }
        this.setDescription(string);
    }
}

