/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.visdiff;

import com.starbase.visdiff.DiffedDocument;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.GapContent;
import javax.swing.text.PlainDocument;

class DefaultDiffedDocument
extends PlainDocument
implements DiffedDocument {
    private int m_matchId;
    private int[] m_localLineMap = null;
    private int m_currentType = -1;
    private Vector m_diffList = new Vector();
    private Hashtable m_typeList = new Hashtable();

    public int getMasterLineCount() {
        return this.getDefaultRootElement().getElementCount();
    }

    public int getLocalLineCount() {
        int n = -1;
        int n2 = this.getDefaultRootElement().getElementCount();
        int[] nArray = this.getLocalLineMap();
        if (n2 > 0 && n2 <= nArray.length) {
            n = nArray[n2 - 1];
        }
        return 0;
    }

    public void setLineType(String string) {
        Integer n = (Integer)this.m_typeList.get(string);
        if (n != null && n != this.m_currentType) {
            this.m_currentType = n;
            DefaultDiffedDocument defaultDiffedDocument = this;
            if (defaultDiffedDocument == null) {
                throw null;
            }
            this.m_diffList.addElement(defaultDiffedDocument.new DiffRun(this.getLength(), n));
        }
    }

    public int getTypeAtOffset(int n) {
        int n2 = 0;
        Enumeration enumeration = this.m_diffList.elements();
        while (enumeration.hasMoreElements()) {
            DiffRun diffRun = (DiffRun)enumeration.nextElement();
            if (diffRun.getPosition() > n) continue;
            n2 = diffRun.getDiffType();
        }
        return n2;
    }

    public int getLocalLineAtOffset(int n) {
        int n2 = -1;
        int[] nArray = this.getLocalLineMap();
        int n3 = this.getDefaultRootElement().getElementIndex(n);
        if (n3 < nArray.length) {
            n2 = nArray[n3];
        }
        return n2;
    }

    public int getDiffAfter(int n) {
        int n2 = 0;
        Enumeration enumeration = this.m_diffList.elements();
        while (enumeration.hasMoreElements()) {
            DiffRun diffRun = (DiffRun)enumeration.nextElement();
            if (diffRun.getPosition() <= n || diffRun.getDiffType() == this.m_matchId) continue;
            n2 = diffRun.getPosition();
            break;
        }
        return n2;
    }

    public int getDiffBefore(int n) {
        int n2 = 0;
        Enumeration enumeration = this.m_diffList.elements();
        while (enumeration.hasMoreElements()) {
            DiffRun diffRun = (DiffRun)enumeration.nextElement();
            if (diffRun.getPosition() >= n) break;
            if (diffRun.getDiffType() == this.m_matchId) continue;
            n2 = diffRun.getPosition();
        }
        return n2;
    }

    public int getMatchAfter(int n) {
        int n2 = 0;
        Enumeration enumeration = this.m_diffList.elements();
        while (enumeration.hasMoreElements()) {
            DiffRun diffRun = (DiffRun)enumeration.nextElement();
            if (diffRun.getPosition() <= n || diffRun.getDiffType() != this.m_matchId) continue;
            n2 = diffRun.getPosition();
            break;
        }
        return n2;
    }

    public int getMatchBefore(int n) {
        int n2 = 0;
        Enumeration enumeration = this.m_diffList.elements();
        while (enumeration.hasMoreElements()) {
            DiffRun diffRun = (DiffRun)enumeration.nextElement();
            if (diffRun.getPosition() >= n) break;
            if (diffRun.getDiffType() != this.m_matchId) continue;
            n2 = diffRun.getPosition();
        }
        return n2;
    }

    public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
        this.nukeCache();
        super.insertString(n, string, attributeSet);
    }

    public void remove(int n, int n2) throws BadLocationException {
        this.nukeCache();
        super.remove(n, n2);
    }

    public int[] getLocalLineMap() {
        if (this.m_localLineMap == null) {
            this.m_localLineMap = this.buildLocalLineMap();
        }
        return this.m_localLineMap;
    }

    private int[] buildLocalLineMap() {
        Element element = this.getDefaultRootElement();
        int n = element.getElementCount();
        int[] nArray = new int[n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            nArray[n3] = n2++;
            Element element2 = element.getElement(n3);
            if (this.getTypeAtOffset(element2.getStartOffset()) != 4) {
                // empty if block
            }
            ++n3;
        }
        return nArray;
    }

    private void nukeCache() {
        this.m_localLineMap = null;
    }

    public DefaultDiffedDocument() {
        super(new GapContent(1024));
        this.m_typeList.put("same", new Integer(0));
        this.m_typeList.put("add", new Integer(1));
        this.m_typeList.put("del", new Integer(2));
        this.m_typeList.put("repl", new Integer(3));
        this.m_typeList.put("miss", new Integer(4));
        this.m_typeList.put("move", new Integer(5));
        this.m_matchId = (Integer)this.m_typeList.get("same");
    }

    private class DiffRun {
        private int m_position;
        private int m_diffType;

        public int getDiffType() {
            return this.m_diffType;
        }

        public void setDiffType(int n) {
            this.m_diffType = n;
        }

        public int getPosition() {
            return this.m_position;
        }

        public void setPosition(int n) {
            this.m_position = n;
        }

        DiffRun(int n, int n2) {
            this.m_position = n;
            this.m_diffType = n2;
        }
    }
}

