/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.util.swing;

import com.starbase.util.LocaleChangeEvent;
import com.starbase.util.LocaleChangeListener;
import com.starbase.util.swing.LocaleChooser;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.util.Date;
import java.util.Locale;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;

public class LocaleChooserPanel
extends JPanel
implements LocaleChangeListener {
    private Locale m_locale;
    private LocaleChooser m_chooser;
    private JTextField m_testLabel;
    private Date m_now;
    private int m_numItems;
    private JLabel[] m_labels;
    private JTextField[] m_data;
    private JTextField[] m_dayEntries;
    private JTextField[] m_monthEntries;
    private JPanel m_dates;
    private JPanel m_days;
    private JPanel m_months;
    String[] m_formatNames = new String[]{"DEFAULT", "SHORT", "MEDIUM", "LONG", "FULL"};
    int[] m_formatValues = new int[]{2, 3, 2, 1, 0};

    public void localeChanged(LocaleChangeEvent localeChangeEvent) {
        this.setLocale(localeChangeEvent.getLocale());
    }

    public void setLocale(Locale locale) {
        Cloneable cloneable;
        this.m_locale = locale;
        int n = 0;
        while (n < this.m_numItems) {
            cloneable = DateFormat.getDateTimeInstance(this.m_formatValues[n], this.m_formatValues[n], this.m_locale);
            this.m_data[n].setText(((DateFormat)cloneable).format(this.m_now));
            ++n;
        }
        String string = this.m_locale.getDisplayName(this.m_locale);
        if (string == null || string.length() < 1) {
            string = "NOT! ";
        }
        this.m_testLabel.setText(string);
        this.m_testLabel.revalidate();
        cloneable = new DateFormatSymbols(this.m_locale);
        String[] stringArray = ((DateFormatSymbols)cloneable).getWeekdays();
        int n2 = 0;
        while (n2 < stringArray.length && n2 < this.m_dayEntries.length) {
            if (stringArray[n2].length() > 0) {
                this.m_dayEntries[n2].setVisible(true);
                this.m_dayEntries[n2].setText(stringArray[n2]);
            } else {
                this.m_dayEntries[n2].setVisible(false);
            }
            ++n2;
        }
        String[] stringArray2 = ((DateFormatSymbols)cloneable).getMonths();
        int n3 = 0;
        while (n3 < stringArray2.length && n3 < this.m_monthEntries.length) {
            if (stringArray2[n3].length() > 0) {
                this.m_monthEntries[n3].setVisible(true);
                this.m_monthEntries[n3].setText(stringArray2[n3]);
            } else {
                this.m_monthEntries[n3].setVisible(false);
            }
            ++n3;
        }
        this.revalidate();
    }

    public Locale getLocale() {
        return this.m_locale;
    }

    public LocaleChooserPanel() {
        this(Locale.getDefault());
    }

    public LocaleChooserPanel(Locale locale) {
        JPanel jPanel;
        this.m_locale = locale;
        this.m_chooser = new LocaleChooser(this.m_locale);
        LocaleChooserPanel localeChooserPanel = this;
        if (localeChooserPanel == null) {
            throw null;
        }
        this.m_chooser.addLocaleChangeListener(new LocaleChangeListener(localeChooserPanel){
            private final /* synthetic */ LocaleChooserPanel this$0;

            public void localeChanged(LocaleChangeEvent localeChangeEvent) {
                this.this$0.setLocale(localeChangeEvent.getLocale());
            }
            {
                this.this$0 = localeChooserPanel;
                this.constructor$0(localeChooserPanel);
            }

            private final void constructor$0(LocaleChooserPanel localeChooserPanel) {
            }
        });
        this.m_chooser.setAlignmentX(0.0f);
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(new EmptyBorder(15, 15, 15, 15));
        this.add(this.m_chooser);
        this.m_testLabel = new JTextField("test");
        this.m_testLabel.setAlignmentX(0.0f);
        this.add(this.m_testLabel);
        this.m_now = new Date();
        this.m_numItems = 5;
        this.m_labels = new JLabel[this.m_numItems];
        this.m_data = new JTextField[this.m_numItems];
        this.m_dates = new JPanel();
        this.m_dates.setLayout(new BoxLayout(this.m_dates, 1));
        this.m_dates.setBorder(new TitledBorder("Dates"));
        this.m_dates.setAlignmentX(0.0f);
        this.add(this.m_dates);
        int n = 0;
        while (n < this.m_numItems) {
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new BoxLayout(jPanel2, 0));
            jPanel2.setAlignmentX(0.0f);
            this.m_labels[n] = new JLabel();
            this.m_labels[n].setText(this.m_formatNames[n]);
            this.m_data[n] = new JTextField();
            jPanel2.add(this.m_labels[n]);
            jPanel2.add(this.m_data[n]);
            this.m_dates.add(jPanel2);
            ++n;
        }
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        jPanel3.setAlignmentX(0.0f);
        this.m_days = new JPanel();
        this.m_days.setLayout(new BoxLayout(this.m_days, 1));
        this.m_days.setBorder(new TitledBorder("Weekdays"));
        this.m_dayEntries = new JTextField[8];
        int n2 = 0;
        while (n2 < 8) {
            jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 0));
            jPanel.setAlignmentX(0.0f);
            this.m_dayEntries[n2] = new JTextField();
            jPanel.add(this.m_dayEntries[n2]);
            this.m_days.add(jPanel);
            ++n2;
        }
        this.m_months = new JPanel();
        this.m_months.setLayout(new BoxLayout(this.m_months, 1));
        this.m_months.setBorder(new TitledBorder("Months"));
        this.m_monthEntries = new JTextField[12];
        n2 = 0;
        while (n2 < 12) {
            jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 0));
            jPanel.setAlignmentX(0.0f);
            this.m_monthEntries[n2] = new JTextField();
            jPanel.add(this.m_monthEntries[n2]);
            this.m_months.add(jPanel);
            ++n2;
        }
        this.m_months.setAlignmentX(0.0f);
        this.m_months.setAlignmentY(0.0f);
        this.m_days.setAlignmentX(0.0f);
        this.m_days.setAlignmentY(0.0f);
        jPanel3.add(this.m_days);
        jPanel3.add(Box.createHorizontalStrut(10));
        jPanel3.add(this.m_months);
        this.add(jPanel3);
        this.setLocale(this.m_locale);
    }
}

