/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.util;

import System.Exception;
import com.starbase.util.FileAccess;
import com.starbase.util.Platform;
import com.starbase.util.Res;
import com.starbase.util.ResIDs;
import com.starbase.util.WorkStationException;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.StringTokenizer;
import java.util.Vector;

public class UnixFileAccess
extends FileAccess {
    private String[] expandCmdArray(String string, String string2, String string3) {
        Object[] objectArray;
        Vector<String> vector = new Vector<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \t");
        while (stringTokenizer.hasMoreTokens()) {
            objectArray = stringTokenizer.nextToken();
            String string4 = this.replaceFileTime((String)objectArray, string2, string3);
            vector.addElement(string4);
        }
        objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private String[] expandCmdArray(String string, String string2) {
        Object[] objectArray;
        Vector<String> vector = new Vector<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \t");
        while (stringTokenizer.hasMoreTokens()) {
            objectArray = stringTokenizer.nextToken();
            String string3 = this.replaceFile((String)objectArray, string2);
            vector.addElement(string3);
        }
        objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private String replaceFileTime(String string, String string2, String string3) {
        return this.replaceAll(this.replaceAll(string, "file", string2), "time", string3);
    }

    private String replaceFile(String string, String string2) {
        return this.replaceAll(string, "file", string2);
    }

    private String replaceAll(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n = 0;
        int n2 = 0;
        int n3 = string.length();
        int n4 = string2.length();
        do {
            if ((n = string.indexOf(36, n2)) == -1) continue;
            stringBuffer.append(string.substring(n2, n));
            if (n3 - n2 > n4) {
                if (string.regionMatches(true, n + 1, string2, 0, n4)) {
                    stringBuffer.append(string3);
                    n2 = n + n4 + 1;
                    continue;
                }
                stringBuffer.append('$');
                n2 = n + 1;
                continue;
            }
            stringBuffer.append('$');
            n2 = n + 1;
        } while (n != -1 && n2 < n3);
        if (n2 < n3) {
            stringBuffer.append(string.substring(n2));
        }
        return stringBuffer.toString();
    }

    public long getLastModified(String string) throws IOException {
        return new File(string).lastModified();
    }

    public void setLastModified(String string, long l) throws IOException {
        long l2 = -2145755648000L;
        long l3 = 2145772799000L;
        if (l > l2 && l < l3) {
            Date date = new Date(l);
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            gregorianCalendar.setTime(date);
            String string2 = "";
            string2 = "" + UnixFileAccess.padLeft(gregorianCalendar.get(1), 4) + UnixFileAccess.padLeft(gregorianCalendar.get(2) + 1, 2) + UnixFileAccess.padLeft(gregorianCalendar.get(5), 2) + UnixFileAccess.padLeft(gregorianCalendar.get(11), 2) + UnixFileAccess.padLeft(gregorianCalendar.get(12), 2) + "." + UnixFileAccess.padLeft(gregorianCalendar.get(13), 2) + "";
            String[] stringArray = this.expandCmdArray(Platform.getTouchCmd(), string, string2);
            this.runCommand(stringArray, "touch");
        }
    }

    public boolean getIsExecutable(String string) throws IOException {
        return false;
    }

    public void setIsExecutable(String string, boolean bl) throws IOException {
        String string2 = null;
        try {
            string2 = Platform.getWSOptions().getOption("executable");
        }
        catch (WorkStationException workStationException) {
            string2 = null;
        }
        if (string2 != null) {
            String[] stringArray = this.expandCmdArray(string2, string);
            this.runCommand(stringArray, "executable");
        }
    }

    public void setCanWrite(String string, boolean bl) throws IOException {
        String[] stringArray;
        String string2 = "";
        if (bl) {
            stringArray = this.expandCmdArray(Platform.getSetWritableCmd(), string);
            string2 = "writable";
        } else {
            stringArray = this.expandCmdArray(Platform.getSetReadOnlyCmd(), string);
            string2 = "readonly";
        }
        this.runCommand(stringArray, string2);
    }

    private String opString(String[] stringArray, String string) {
        StringBuffer stringBuffer = new StringBuffer(256);
        int n = 0;
        while (n < stringArray.length) {
            stringBuffer.append(stringArray[n]);
            stringBuffer.append(" ");
            ++n;
        }
        return Res.formatKey(ResIDs.COMMAND_DESCRIPTION_FMT, new Object[]{string, stringBuffer.toString()});
    }

    private void runCommand(String[] stringArray, String string) throws IOException {
        if (stringArray.length == 0) {
            return;
        }
        try {
            Process process = null;
            String string2 = null;
            try {
                try {
                    process = Runtime.getRuntime().exec(stringArray);
                }
                catch (SecurityException securityException) {
                    string2 = securityException.getMessage();
                }
                catch (IOException iOException) {
                    string2 = iOException.getMessage();
                }
                catch (RuntimeException runtimeException) {
                    string2 = runtimeException.getMessage();
                }
            }
            catch (Exception exception) {
                string2 = exception.get_Message();
            }
            if (process == null) {
                if (string2 == null) {
                    string2 = Res.getString(ResIDs.UNKNOWN);
                }
                throw new IOException(Res.formatKey(ResIDs.ERROR_LITERAL_FMT, new Object[]{string2, this.opString(stringArray, string)}));
            }
            int n = process.waitFor();
            if (n != 0) {
                throw new IOException(Res.formatKey(ResIDs.ERROR_RETURN_CODE_FMT, new Object[]{new Integer(n), this.opString(stringArray, string)}));
            }
        }
        catch (InterruptedException interruptedException) {
            throw new IOException(Res.formatKey(ResIDs.COMMAND_INTERRUPTED_FMT, new Object[]{this.opString(stringArray, string)}));
        }
    }

    private static String padLeft(int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer("" + n);
        int n3 = ("" + n).length();
        int n4 = 0;
        while (n4 < n2 - n3) {
            stringBuffer.insert(0, "0");
            ++n4;
        }
        return stringBuffer.toString();
    }
}

