/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.util;

import java.io.IOException;
import java.io.InputStream;

public class UTF8 {
    private static final int MAX_UCS2 = 65535;
    private static final int MAX_UTF16 = 0x10FFFF;
    private static final int UNICODE_REPLACEMENT_CHAR = 65533;
    private static final int UNICODE_SURROGATE_LOW_START = 56320;
    private static final int UNICODE_SURROGATE_LOW_END = 57343;
    private static final int UNICODE_SURROGATE_HIGH_START = 55296;
    private static final int UNICODE_SURROGATE_HIGH_END = 56319;

    public static String Utf8ToString(byte[] byArray) {
        int n;
        if (byArray != null && byArray.length > 0 && (n = UTF8.Utf8ToUtf16(byArray, null)) > 0) {
            char[] cArray = new char[n];
            UTF8.Utf8ToUtf16(byArray, cArray);
            return new String(cArray);
        }
        return "";
    }

    public static int Utf8ToUtf16Char(InputStream inputStream) {
        try {
            int n = inputStream.read();
            while ((n & 0xC0) == 128 || n == 254 || n == 255) {
                n = inputStream.read();
            }
            long l = 0L;
            int n2 = 0;
            if ((n & 0x80) == 0) {
                n2 = 0;
                l = n;
            } else if ((n & 0xE0) == 192) {
                n2 = 1;
                l = n & 0x1F;
            } else if ((n & 0xF0) == 224) {
                n2 = 2;
                l = n & 0xF;
            } else if ((n & 0xF8) == 240) {
                n2 = 3;
                l = n & 7;
            } else if ((n & 0xFC) == 248) {
                n2 = 4;
                l = n & 3;
            } else if ((n & 0xFE) == 252) {
                n2 = 5;
                l = n & 1;
            }
            int n3 = 0;
            while (n3 < n2) {
                n = inputStream.read();
                l = l << 6 | (long)n & 0x3FL;
                ++n3;
            }
            if (l <= 65535L) {
                return (char)l;
            }
            if (l > 0x10FFFFL) {
                return 65533;
            }
            char c = (char)((l -= 65536L) >> 10);
            c = (char)(c + 55296);
            char c2 = (char)(l & 0x3FFL);
            c2 = (char)(c2 + 56320);
            return c << 16 | c2;
        }
        catch (IOException iOException) {
            return -1;
        }
    }

    public static int Utf8ToUtf16(byte[] byArray, char[] cArray) {
        int n = 0;
        int n2 = 0;
        int n3 = byArray.length;
        int n4 = cArray == null ? 0 : cArray.length;
        int n5 = -1;
        if (byArray != null) {
            n = 0;
            while (n < n3) {
                if ((byArray[n] & 0xC0) == 128) {
                    while (n < n3 && (byArray[n] & 0xC0) == 128) {
                        ++n;
                    }
                    continue;
                }
                if (byArray[n] == 254 || byArray[n] == 255) {
                    ++n;
                    continue;
                }
                long l = 0L;
                int n6 = 0;
                if ((byArray[n] & 0x80) == 0) {
                    n6 = 0;
                    l = byArray[n++];
                } else if ((byArray[n] & 0xE0) == 192) {
                    n6 = 1;
                    l = byArray[n++] & 0x1F;
                } else if ((byArray[n] & 0xF0) == 224) {
                    n6 = 2;
                    l = byArray[n++] & 0xF;
                } else if ((byArray[n] & 0xF8) == 240) {
                    n6 = 3;
                    l = byArray[n++] & 7;
                } else if ((byArray[n] & 0xFC) == 248) {
                    n6 = 4;
                    l = byArray[n++] & 3;
                } else if ((byArray[n] & 0xFE) == 252) {
                    n6 = 5;
                    l = byArray[n++] & 1;
                }
                int n7 = 0;
                while (n7 < n6) {
                    l = l << 6 | (long)byArray[n] & 0x3FL;
                    ++n;
                    ++n7;
                }
                if (l <= 65535L) {
                    if (cArray != null) {
                        if (n2 >= n4) break;
                        cArray[n2++] = (char)l;
                        continue;
                    }
                    ++n2;
                    continue;
                }
                if (l > 0x10FFFFL) {
                    if (cArray != null) {
                        if (n2 >= n4) break;
                        cArray[n2++] = 65533;
                        continue;
                    }
                    ++n2;
                    continue;
                }
                if (cArray != null) {
                    if (n2 >= n4 - 1) break;
                    cArray[n2] = (char)((l -= 65536L) >> 10);
                    int n8 = n2++;
                    cArray[n8] = (char)(cArray[n8] + 55296);
                    cArray[n2] = (char)(l & 0x3FFL);
                    int n9 = n2++;
                    cArray[n9] = (char)(cArray[n9] + 56320);
                    continue;
                }
                n2 += 2;
            }
            n5 = n2;
        }
        return n5;
    }

    public static byte[] StringToUtf8(String string) {
        if (string != null && !string.equals("")) {
            char[] cArray = new char[string.length()];
            string.getChars(0, string.length(), cArray, 0);
            int n = UTF8.Utf16ToUtf8(cArray, null);
            byte[] byArray = new byte[n];
            UTF8.Utf16ToUtf8(cArray, byArray);
            return byArray;
        }
        return new byte[0];
    }

    public static int Utf16ToUtf8(char[] cArray, byte[] byArray) {
        int n = -1;
        if (cArray != null) {
            int n2 = 0;
            int n3 = 0;
            int n4 = cArray.length;
            int n5 = byArray == null ? 0 : byArray.length;
            while (n2 < n4) {
                if ((cArray[n2] & 0xFF80) == 0) {
                    if (byArray != null) {
                        if (n3 + 1 > n5) break;
                        byArray[n3] = (byte)cArray[n2];
                    }
                    ++n3;
                    ++n2;
                    continue;
                }
                if ((cArray[n2] & 0xF800) == 0) {
                    if (byArray != null) {
                        if (n3 + 2 > n5) break;
                        byArray[n3] = (byte)(0xC0 | cArray[n2] >> 6);
                        byArray[++n3] = (byte)(0x80 | cArray[n2] & 0x3F);
                        ++n3;
                    } else {
                        n3 += 2;
                    }
                    ++n2;
                    continue;
                }
                if (cArray[n2] >= '\ud800' && cArray[n2] <= '\udbff' && n2 + 2 <= n4 && cArray[n2 + 1] >= '\udc00' && cArray[n2 + 1] <= '\udfff') {
                    long l = cArray[n2] - 55296 << 10;
                    if ((l += (long)(cArray[n2 + 1] - 56320) + 65536L) < 0x200000L) {
                        if (byArray != null) {
                            if (n3 + 4 > n5) break;
                            byArray[n3] = (byte)(0xF0L | l >> 18);
                            byArray[++n3] = (byte)(0x80L | l >> 12 & 0x3FL);
                            byArray[++n3] = (byte)(0x80L | l >> 6 & 0x3FL);
                            byArray[++n3] = (byte)(0x80L | l & 0x3FL);
                            ++n3;
                        } else {
                            n3 += 4;
                        }
                        n2 += 2;
                        continue;
                    }
                    if (l < 0x4000000L) {
                        if (byArray != null) {
                            if (n3 + 5 > n5) break;
                            byArray[n3] = (byte)(0xF8L | l >> 24);
                            byArray[++n3] = (byte)(0x80L | l >> 18 & 0x3FL);
                            byArray[++n3] = (byte)(0x80L | l >> 12 & 0x3FL);
                            byArray[++n3] = (byte)(0x80L | l >> 6 & 0x3FL);
                            byArray[++n3] = (byte)(0x80L | l & 0x3FL);
                            ++n3;
                        } else {
                            n3 += 5;
                        }
                        n2 += 2;
                        continue;
                    }
                    if (byArray != null) {
                        if (n3 + 6 > n5) break;
                        byArray[n3] = (byte)(0xFCL | l >> 30);
                        byArray[++n3] = (byte)(0x80L | l >> 24 & 0x3FL);
                        byArray[++n3] = (byte)(0x80L | l >> 18 & 0x3FL);
                        byArray[++n3] = (byte)(0x80L | l >> 12 & 0x3FL);
                        byArray[++n3] = (byte)(0x80L | l >> 6 & 0x3FL);
                        byArray[++n3] = (byte)(0x80L | l & 0x3FL);
                        ++n3;
                    } else {
                        n3 += 6;
                    }
                    n2 += 2;
                    continue;
                }
                if (byArray != null) {
                    if (n3 + 3 > n5) break;
                    byArray[n3] = (byte)(0xE0 | cArray[n2] >> 12);
                    byArray[++n3] = (byte)(0x80 | cArray[n2] >> 6 & 0x3F);
                    byArray[++n3] = (byte)(0x80 | cArray[n2] & 0x3F);
                    ++n3;
                } else {
                    n3 += 3;
                }
                ++n2;
            }
            n = n3;
        }
        return n;
    }
}

