/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.util;

import com.starbase.starteam.ServerException;
import com.starbase.util.MD5;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;

public class Diagnostics {
    public static String createBugReport(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        if (throwable instanceof ServerException) {
            String[] stringArray;
            ServerException serverException = (ServerException)throwable;
            printWriter.println("Server Exception Message:");
            printWriter.println("=========================");
            printWriter.println("ClassName: " + serverException.getClassName());
            printWriter.println("ErrorSource: " + serverException.getErrorSource());
            printWriter.println("Code: " + serverException.getErrorCode());
            printWriter.println("Logged: " + serverException.isLogged());
            if (serverException.isLogged()) {
                printWriter.println("Log Entry: " + serverException.getLogEntry());
                printWriter.println("Log time: " + serverException.getTimeLogged().toString());
            }
            if ((stringArray = serverException.getAuxKeys()).length != 0) {
                printWriter.println("Auxliary Data: ");
                int n = 0;
                while (n < stringArray.length) {
                    String string = stringArray[n];
                    printWriter.println(string + ": ");
                    printWriter.println(serverException.getAuxData(string).toString());
                    printWriter.println("");
                    ++n;
                }
            }
            printWriter.println("Message: " + serverException.getErrorMessage());
        } else {
            printWriter.println("Exception Class: " + throwable.getClass().getName());
            printWriter.println("================");
            printWriter.println("");
            printWriter.println("Exception Message:");
            printWriter.println("==================");
            printWriter.println(throwable.getMessage());
        }
        printWriter.println("");
        printWriter.println("Stack Trace:");
        printWriter.println("============");
        throwable.printStackTrace(printWriter);
        printWriter.println("");
        printWriter.print(Diagnostics.getSystemInfo());
        return stringWriter.toString();
    }

    public static String getSystemInfo() {
        String string;
        String string2;
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println("Memory:");
        printWriter.println("======");
        printWriter.println("Free memory : " + Runtime.getRuntime().freeMemory());
        printWriter.println("Total memory: " + Runtime.getRuntime().totalMemory());
        printWriter.println("");
        printWriter.println("Threads:");
        printWriter.println("=======");
        Diagnostics.printThreads(printWriter);
        printWriter.println("");
        printWriter.println("System Properties:");
        printWriter.println("==================");
        Properties properties = System.getProperties();
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            string2 = (String)enumeration.nextElement();
            string = properties.getProperty(string2);
            printWriter.print(string2);
            printWriter.print(": ");
            if (string2.equals("line.separator")) {
                printWriter.println(Diagnostics.asHex(string));
                continue;
            }
            printWriter.println(string);
        }
        string2 = properties.getProperty("java.class.path");
        if (string2 != null && (string = properties.getProperty("path.separator")) != null) {
            printWriter.println("");
            printWriter.println("CLASSPATH details:");
            printWriter.println("==================");
            Diagnostics.printClassPath(string2, string, printWriter);
        }
        printWriter.close();
        return stringWriter.toString();
    }

    private static String asHex(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        int n = 0;
        while (n < string.length()) {
            if (n != 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append("0x");
            stringBuffer.append(Integer.toHexString(string.charAt(n)));
            ++n;
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    private static void printClassPath(String string, String string2, PrintWriter printWriter) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            Diagnostics.printClassPathEntry(string3, printWriter);
        }
    }

    private static void printClassPathEntry(String string, PrintWriter printWriter) {
        File file = new File(string);
        if (file.exists()) {
            if (file.isDirectory()) {
                printWriter.println(string + " : directory");
            } else {
                String string2 = "unknown";
                try {
                    MD5 mD5 = new MD5();
                    mD5.computeFileMD5(file);
                    string2 = mD5.toString();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                printWriter.println(string + " : size=" + file.length() + ", time=[" + new Date(file.lastModified()) + "], md5=" + string2);
            }
        } else {
            printWriter.println(string + " : does not exist");
        }
    }

    private static void printThreads(PrintWriter printWriter) {
        Thread thread = Thread.currentThread();
        ThreadGroup threadGroup = thread.getThreadGroup();
        while (threadGroup != null) {
            if (threadGroup.getParent() == null) break;
            threadGroup = threadGroup.getParent();
        }
        Diagnostics.printGroup(threadGroup, printWriter, 0);
    }

    private static void printGroup(ThreadGroup threadGroup, PrintWriter printWriter, int n) {
        ThreadGroup[] threadGroupArray;
        int n2;
        ThreadGroup threadGroup2 = threadGroup;
        synchronized (threadGroup2) {
            n2 = 0;
            while (n2 < n) {
                printWriter.print(" ");
                ++n2;
            }
            printWriter.println(threadGroup);
            n += 4;
            n2 = threadGroup.activeCount();
            Thread[] threadArray = new Thread[n2];
            threadGroup.enumerate(threadArray, false);
            int n3 = 0;
            while (n3 < n2) {
                if (threadArray[n3] != null) {
                    int n4 = 0;
                    while (n4 < n) {
                        printWriter.print(" ");
                        ++n4;
                    }
                    printWriter.println(threadArray[n3]);
                }
                ++n3;
            }
            n3 = threadGroup.activeGroupCount();
            threadGroupArray = new ThreadGroup[n3];
            threadGroup.enumerate(threadGroupArray, false);
        }
        n2 = 0;
        while (n2 < threadGroupArray.length) {
            if (threadGroupArray[n2] != null) {
                Diagnostics.printGroup(threadGroupArray[n2], printWriter, n);
            }
            ++n2;
        }
    }

    private Diagnostics() {
    }
}

