/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.util;

import com.starbase.util.Platform;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.util.Locale;

public final class BaseFileUtils {
    public static boolean isBinary(File file) throws IOException {
        int n = 1024;
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream, n);
            byte[] byArray = new byte[n];
            int n2 = 0;
            boolean bl = false;
            block2: while (n2 != -1 && !bl) {
                n2 = bufferedInputStream.read(byArray, 0, n);
                if (n2 <= 0) continue;
                int n3 = 0;
                while (n3 < n2) {
                    int n4 = byArray[n3] & 0xFF;
                    if (n4 == 0) {
                        bl = true;
                        continue block2;
                    }
                    ++n3;
                }
            }
            ((FilterInputStream)bufferedInputStream).close();
            return bl;
        }
        catch (IOException iOException) {
            fileInputStream.close();
            throw iOException;
        }
    }

    public static final boolean isAbsolute(String string) {
        char c;
        if (string == null) {
            return false;
        }
        int n = string.length();
        if (n <= 0) {
            return false;
        }
        if (BaseFileUtils.isSlash(string.charAt(0))) {
            return true;
        }
        return Platform.isWin32() && n > 1 && string.charAt(1) == ':' && (c = Character.toUpperCase(string.charAt(0))) >= 'A' && c <= 'Z';
    }

    public static final String getAbsolutePath(String string) {
        if (BaseFileUtils.isAbsolute(string)) {
            return string;
        }
        return new File(string).getAbsolutePath();
    }

    public static final String getCanonicalPathName(String string, boolean bl) {
        return BaseFileUtils.getCanonicalPath(string, bl, BaseFileUtils.defaultFileDelim());
    }

    static final String getCanonicalPath(String string, boolean bl, char c) {
        int n;
        char[] cArray = new char[string.length() + 1];
        string.getChars(0, string.length(), cArray, 0);
        char c2 = '\u0000';
        if (c != c2) {
            n = 0;
            while (cArray[n] != c2) {
                if (BaseFileUtils.isSlash(cArray[n])) {
                    cArray[n] = c;
                }
                ++n;
            }
        }
        n = 0;
        int n2 = 0;
        while (cArray[n] != c2) {
            if (n2 > 1 && BaseFileUtils.isSlash(cArray[n2 - 1]) && BaseFileUtils.isSlash(cArray[n])) {
                ++n;
                continue;
            }
            cArray[n2++] = cArray[n++];
        }
        cArray[n2] = c2;
        n = 0;
        n2 = 0;
        while (cArray[n] != c2) {
            if (BaseFileUtils.isDot(cArray[n]) && BaseFileUtils.isSlash(cArray[n + 1]) && (n == 0 || BaseFileUtils.isSlash(cArray[n - 1]))) {
                n += 2;
                continue;
            }
            cArray[n2++] = cArray[n++];
        }
        if (n2 == 1 && BaseFileUtils.isDot(cArray[0])) {
            --n2;
        } else if (n2 > 1 && BaseFileUtils.isDot(cArray[n2 - 1]) && BaseFileUtils.isSlash(cArray[n2 - 2])) {
            --n2;
        }
        cArray[n2] = c2;
        n = 0;
        while (cArray[n] != c2) {
            if (BaseFileUtils.isDot(cArray[n]) && BaseFileUtils.isDot(cArray[n + 1]) && BaseFileUtils.isSlash(cArray[n + 2]) && (n == 0 || BaseFileUtils.isSlash(cArray[n - 1]))) {
                int n3 = n + 3;
                if ((n -= 2) >= 0) {
                    while (n >= 0 && !BaseFileUtils.isSlash(cArray[n])) {
                        --n;
                    }
                } else {
                    n = 0;
                }
                int n4 = ++n;
                while ((cArray[n4] = cArray[n3]) != c2) {
                    ++n4;
                    ++n3;
                }
                continue;
            }
            ++n;
        }
        if (n == 2 && BaseFileUtils.isDot(cArray[0]) && BaseFileUtils.isDot(cArray[1])) {
            cArray[0] = c2;
        } else if (n > 2 && BaseFileUtils.isDot(cArray[n - 1]) && BaseFileUtils.isDot(cArray[n - 2]) && BaseFileUtils.isSlash(cArray[n - 3])) {
            if ((n -= 4) >= 0) {
                while (n >= 0 && !BaseFileUtils.isSlash(cArray[n])) {
                    --n;
                }
                ++n;
            } else {
                n = 0;
            }
            cArray[n] = c2;
        }
        n2 = 0;
        while (cArray[n2] != c2) {
            ++n2;
        }
        if (n2 != 0 && BaseFileUtils.isSlash(cArray[n2 - 1])) {
            cArray[--n2] = c2;
        }
        String string2 = new String(cArray, 0, n2);
        if (!bl) {
            string2 = string2.toLowerCase(Locale.getDefault());
        }
        return string2;
    }

    private static boolean isDot(char c) {
        return c == '.';
    }

    private static boolean isSlash(char c) {
        return c == '\\' || c == '/';
    }

    private static char defaultFileDelim() {
        return '\\';
    }

    public static final String fullyResolvedPath(String string, String string2) {
        String string3 = BaseFileUtils.getCanonicalPathName(string, true);
        int n = string3.length();
        char c = BaseFileUtils.defaultFileDelim();
        StringBuffer stringBuffer = new StringBuffer(n);
        int n2 = 0;
        while (n2 < n) {
            char c2 = string3.charAt(n2);
            if (c2 == c) {
                stringBuffer.append(string2);
            } else {
                stringBuffer.append(c2);
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    private BaseFileUtils() {
    }
}

