/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam.vts.pickle;

import com.starbase.starteam.vts.comm.Command;
import com.starbase.starteam.vts.pickle.IntegerFactory;
import com.starbase.starteam.vts.pickle.Res;
import com.starbase.starteam.vts.pickle.ResIDs;
import com.starbase.util.Assert;
import com.starbase.util.OLEDate;
import java.io.IOException;

public class Variant {
    public static final int UNKNOWN = 0;
    public static final int LONG = 1;
    public static final int DOUBLE = 2;
    public static final int TIME = 3;
    public static final int TEXT = 4;
    public static final int BINARY = 5;
    public static final int IDARRAY = 6;
    private static final Class LONG_CLASS = new Integer(0).getClass();
    private static final Class DOUBLE_CLASS = new Double(0.0).getClass();
    private static final Class TIME_CLASS = new OLEDate().getClass();
    private static final Class TEXT_CLASS = new String("").getClass();
    private static final Class BINARY_CLASS = new byte[0].getClass();
    private static final Class IDARRAY_CLASS = new int[0].getClass();
    private static final IntegerFactory m_Integers = new IntegerFactory(512, -1);
    private static final OLEDate m_zeroDate = new OLEDate(0.0);
    private static final Double m_zeroDouble = new Double(0.0);
    private int m_eType = 0;
    private Object m_data = null;

    public static Variant createVariant(Object object) {
        if (object == null) {
            return new Variant();
        }
        if (object instanceof Integer) {
            return new Variant((Integer)object);
        }
        if (object instanceof Double) {
            return new Variant((Double)object);
        }
        if (object instanceof OLEDate) {
            return new Variant((OLEDate)object);
        }
        if (object instanceof String) {
            return new Variant((String)object);
        }
        if (object instanceof byte[]) {
            return new Variant((byte[])object);
        }
        if (object instanceof int[]) {
            return new Variant((int[])object);
        }
        if (object instanceof Variant) {
            return new Variant((Variant)object);
        }
        String string = object.getClass().getName();
        String string2 = Res.formatKey(ResIDs.TYPE_NOT_SUPPORTED_FMT, new Object[]{string});
        throw new IllegalArgumentException(string2);
    }

    public Variant copy() {
        return new Variant(this);
    }

    public Object getData() {
        return this.m_data;
    }

    public void copy(Variant variant) {
        this.m_eType = variant.getType();
        switch (this.m_eType) {
            case 1: {
                this.m_data = new Integer(variant.getLong());
                break;
            }
            case 2: {
                this.m_data = new Double(variant.getDouble());
                break;
            }
            case 3: {
                this.m_data = new OLEDate(variant.getTime());
                break;
            }
            case 4: {
                this.m_data = variant.getString();
                break;
            }
            case 5: {
                byte[] byArray = variant.getBytes();
                this.m_data = new byte[byArray.length];
                System.arraycopy(byArray, 0, this.m_data, 0, byArray.length);
                break;
            }
            case 6: {
                int[] nArray = variant.getIDArray();
                this.m_data = new int[nArray.length];
                System.arraycopy(nArray, 0, this.m_data, 0, nArray.length);
                break;
            }
        }
    }

    public int compare(Variant variant, boolean bl, boolean bl2) {
        if (variant.m_eType != this.m_eType) {
            throw new RuntimeException(Res.getString(ResIDs.COMPARE_DIFFERENT_TYPES));
        }
        switch (this.m_eType) {
            case 1: {
                return this.getLong() - variant.getLong();
            }
            case 2: {
                double d = this.getDouble() - variant.getDouble();
                if (d > 0.0) {
                    return 1;
                }
                if (d == 0.0) {
                    return 0;
                }
                return -1;
            }
            case 3: {
                double d = bl ? (double)((long)this.getTime().getDoubleValue() - (long)variant.getTime().getDoubleValue()) : this.getTime().getDoubleValue() - variant.getTime().getDoubleValue();
                if (d > 0.0) {
                    return 1;
                }
                if (d == 0.0) {
                    return 0;
                }
                return -1;
            }
            case 4: {
                if (bl2) {
                    return this.getString().toLowerCase().compareTo(variant.getString().toLowerCase());
                }
                return this.getString().compareTo(variant.getString());
            }
            case 5: {
                return Variant.compare(this.getBytes(), variant.getBytes());
            }
            case 6: {
                return Variant.compare(this.getIDArray(), variant.getIDArray());
            }
        }
        Assert.internalError("Variant.compare(), m_eType=" + this.m_eType);
        return 0;
    }

    private static int compare(byte[] byArray, byte[] byArray2) {
        if (byArray.length == byArray2.length) {
            int n = byArray.length;
            int n2 = 0;
            while (n2 < n) {
                int n3 = byArray[n2] - byArray2[n2];
                if (n3 != 0) {
                    return n3;
                }
                ++n2;
            }
            return 0;
        }
        return byArray.length - byArray2.length;
    }

    private static int compare(int[] nArray, int[] nArray2) {
        if (nArray.length == nArray2.length) {
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int n3 = nArray[n2] - nArray2[n2];
                if (n3 != 0) {
                    return n3;
                }
                ++n2;
            }
            return 0;
        }
        return nArray.length - nArray2.length;
    }

    public static int compare(Object object, Object object2, boolean bl, boolean bl2) {
        if (object.getClass() != object2.getClass()) {
            throw new RuntimeException(Res.getString(ResIDs.COMPARE_DIFFERENT_TYPES));
        }
        Class<?> clazz = object.getClass();
        if (clazz == LONG_CLASS) {
            return (Integer)object - (Integer)object2;
        }
        if (clazz == DOUBLE_CLASS) {
            double d = (Double)object - ((Integer)object2).doubleValue();
            if (d == 0.0) {
                return 0;
            }
            return d > 0.0 ? 1 : -1;
        }
        if (clazz == TIME_CLASS) {
            double d = 0.0;
            d = bl2 ? (double)((long)((OLEDate)object).getDoubleValue() - (long)((OLEDate)object2).getDoubleValue()) : ((OLEDate)object).getDoubleValue() - ((OLEDate)object2).getDoubleValue();
            if (d == 0.0) {
                return 0;
            }
            return d > 0.0 ? 1 : -1;
        }
        if (clazz == TEXT_CLASS) {
            if (bl) {
                return ((String)object).toLowerCase().compareTo(((String)object2).toLowerCase());
            }
            return ((String)object).compareTo((String)object2);
        }
        if (clazz == BINARY_CLASS) {
            byte[] byArray = (byte[])object;
            byte[] byArray2 = (byte[])object2;
            return Variant.compare(byArray, byArray2);
        }
        if (clazz == IDARRAY_CLASS) {
            int[] nArray = (int[])object;
            int[] nArray2 = (int[])object2;
            return Variant.compare(nArray, nArray2);
        }
        String string = clazz.getName();
        String string2 = Res.formatKey(ResIDs.TYPE_NOT_SUPPORTED_FMT, new Object[]{string});
        throw new IllegalArgumentException(string2);
    }

    public int getType() {
        return this.m_eType;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Variant)) {
            return false;
        }
        Variant variant = (Variant)object;
        return this.compare(variant, false, false) == 0;
    }

    public int hashCode() {
        int n = this.m_eType;
        switch (this.m_eType) {
            case 1: {
                n = n * 37 + this.getLong();
                break;
            }
            case 2: {
                n = n * 37 + (int)this.getDouble();
                break;
            }
            case 3: {
                n = n * 37 + (int)this.getTime().getLongValue();
                break;
            }
            case 4: {
                n = n * 37 + this.getString().hashCode();
                break;
            }
            case 5: {
                n = n * 37 + this.getBytes().length;
                break;
            }
            case 6: {
                n = n * 37 + this.getIDArray().length;
                break;
            }
        }
        return n;
    }

    public int getLong() {
        this.validateType(1, "Integer");
        return (Integer)this.m_data;
    }

    public double getDouble() {
        this.validateType(2, "Double");
        return (Double)this.m_data;
    }

    public String getString() {
        this.validateType(4, "String");
        return (String)this.m_data;
    }

    public OLEDate getTime() {
        this.validateType(3, "OLEDate");
        return (OLEDate)this.m_data;
    }

    public byte[] getBytes() {
        this.validateType(5, "byte[]");
        return (byte[])this.m_data;
    }

    public int[] getIDArray() {
        this.validateType(6, "int[]");
        return (int[])this.m_data;
    }

    private void validateType(int n, String string) {
        if (this.m_eType != n) {
            String string2 = Res.formatKey(ResIDs.CLASS_CAST_EXCEPTION_FMT, new Object[]{string});
            throw new ClassCastException(string2);
        }
    }

    public String toString() {
        if (this.m_eType == 5) {
            byte[] byArray = this.getBytes();
            int n = byArray.length;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("[");
            int n2 = 0;
            while (n2 < n) {
                stringBuffer.append("0x" + Integer.toHexString(byArray[n2] & 0xFF));
                if (n2 == n - 1) {
                    stringBuffer.append("]");
                } else {
                    stringBuffer.append(",");
                }
                ++n2;
            }
            return stringBuffer.toString();
        }
        if (this.m_eType == 6) {
            int[] nArray = this.getIDArray();
            int n = nArray.length;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("[");
            int n3 = 0;
            while (n3 < n) {
                stringBuffer.append(nArray[n3]);
                if (n3 == n - 1) {
                    stringBuffer.append("]");
                } else {
                    stringBuffer.append(",");
                }
                ++n3;
            }
            return stringBuffer.toString();
        }
        return this.m_data.toString();
    }

    public static Variant read(Command command) throws IOException {
        Variant variant = new Variant();
        variant.readGuts(command);
        return variant;
    }

    public void readGuts(Command command) throws IOException {
        this.m_eType = command.readInt();
        this.m_data = Variant.readData(command, this.m_eType);
    }

    public static Object readData(Command command, int n) throws IOException {
        switch (n) {
            case 1: {
                return m_Integers.get(command.readInt());
            }
            case 4: {
                return command.readString();
            }
            case 3: {
                double d = command.readTime();
                return d == 0.0 ? m_zeroDate : new OLEDate(d);
            }
            case 2: {
                double d = command.readDouble();
                return d == 0.0 ? m_zeroDouble : new Double(d);
            }
            case 6: {
                return command.readVariantIDs();
            }
            case 5: {
                return command.readVariantBytes();
            }
        }
        return null;
    }

    public static void gobbleType(Command command, int n) throws IOException {
        switch (n) {
            case 1: {
                command.readInt();
                break;
            }
            case 2: {
                command.readDouble();
                break;
            }
            case 3: {
                command.readTime();
                break;
            }
            case 4: {
                command.readString();
                break;
            }
            case 5: {
                command.readVariantBytes();
                break;
            }
            case 6: {
                command.readVariantIDs();
                break;
            }
            default: {
                Assert.internalError("Variant.gobbleType(), type=" + n);
            }
        }
    }

    public void writeGuts(Command command) throws IOException {
        this.writeType(command);
        this.writeValue(command);
    }

    public void writeValue(Command command) throws IOException {
        switch (this.m_eType) {
            case 1: {
                command.writeInt(this.getLong());
                break;
            }
            case 2: {
                command.writeDouble(this.getDouble());
                break;
            }
            case 3: {
                command.writeTime(this.getTime().getDoubleValue());
                break;
            }
            case 4: {
                command.writeString(this.getString());
                break;
            }
            case 5: {
                command.writeVariantBytes(this.getBytes());
                break;
            }
            case 6: {
                command.writeVariantIDs(this.getIDArray());
                break;
            }
        }
    }

    public void writeType(Command command) throws IOException {
        command.writeInt(this.m_eType);
    }

    public Variant() {
        this.m_eType = 0;
        this.m_data = null;
    }

    public Variant(int n) {
        this.m_eType = 1;
        this.m_data = new Integer(n);
    }

    public Variant(double d) {
        this.m_eType = 2;
        this.m_data = new Double(d);
    }

    public Variant(OLEDate oLEDate) {
        this.m_eType = 3;
        this.m_data = oLEDate;
    }

    public Variant(String string) {
        this.m_eType = 4;
        this.m_data = string;
    }

    public Variant(byte[] byArray) {
        this.m_eType = 5;
        this.m_data = byArray;
    }

    public Variant(int[] nArray) {
        this.m_eType = 6;
        this.m_data = nArray;
    }

    public Variant(Variant variant) {
        this.m_eType = variant.getType();
        switch (this.m_eType) {
            case 1: {
                this.m_data = new Integer(variant.getLong());
                break;
            }
            case 2: {
                this.m_data = new Double(variant.getDouble());
                break;
            }
            case 3: {
                this.m_data = new OLEDate(variant.getTime());
                break;
            }
            case 4: {
                this.m_data = variant.getString();
                break;
            }
            case 5: {
                byte[] byArray = variant.getBytes();
                this.m_data = new byte[byArray.length];
                System.arraycopy(byArray, 0, this.m_data, 0, byArray.length);
                break;
            }
            case 6: {
                int[] nArray = variant.getIDArray();
                this.m_data = new int[nArray.length];
                System.arraycopy(nArray, 0, this.m_data, 0, nArray.length);
                break;
            }
        }
    }
}

