/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam.vts.pickle;

import com.starbase.starteam.Translations;
import com.starbase.starteam.vts.comm.Command;
import com.starbase.util.Assert;
import java.io.IOException;
import java.util.Locale;
import java.util.Vector;

public class TranslationCache {
    private static final String EMPTY = "";
    public static final int TRANSLATIONS_FALLBACK = 0;
    public static final int TRANSLATIONS_CLIENT = 1;
    public static final int TRANSLATIONS_FALLBACK_AND_CLIENT = 2;
    public static final int TRANSLATIONS_ALL = 3;
    private static final Locale INVARIANT = new Locale("", "", "");
    private String m_fallback;
    private String m_localized;
    private Locale m_locale;
    private Translations m_translations;

    public TranslationCache copyForModify(Locale locale, String string) {
        TranslationCache translationCache = this.copy();
        if (translationCache.m_translations == null) {
            translationCache.m_localized = string;
            translationCache.m_locale = locale;
        } else {
            translationCache.m_translations.setTranslation(locale, string);
        }
        return translationCache;
    }

    public String getFallBack() {
        return this.m_fallback;
    }

    public String getLocalized(int n) {
        return this.m_localized;
    }

    public Translations getTranslations() {
        return this.m_translations;
    }

    public static TranslationCache read(Command command, int n) throws IOException {
        TranslationCache translationCache = new TranslationCache();
        translationCache.readGuts(command, n);
        return translationCache;
    }

    private void readGuts(Command command, int n) throws IOException {
        if (command.supports((short)100, "1.9")) {
            if (n == 3) {
                Translations translations;
                this.m_translations = translations = TranslationCache.readTranslations(command);
                this.m_fallback = translations.getDefault();
                this.m_locale = translations.closestDefined(Locale.getDefault());
                this.m_localized = translations.getTranslation(this.m_locale);
            } else if (n == 2) {
                this.m_fallback = command.readString();
                this.m_locale = command.readLocale();
                this.m_localized = command.readString();
                this.m_translations = null;
            } else if (n == 0) {
                this.m_fallback = command.readString();
                this.m_localized = null;
                this.m_locale = null;
                this.m_translations = null;
            } else if (n == 1) {
                this.m_locale = command.readLocale();
                this.m_localized = command.readString();
                this.m_fallback = null;
                this.m_translations = null;
            } else {
                Assert.internalError("TranslationCache.readGuts;flag=" + n);
            }
        } else {
            this.m_fallback = command.readString();
            this.m_localized = null;
            this.m_translations = null;
        }
    }

    private static Translations readTranslations(Command command) throws IOException {
        Translations translations = new Translations();
        translations.setDefault(command.readString());
        int n = command.readInt();
        int n2 = 0;
        while (n2 < n) {
            Locale locale = command.readLocale();
            String string = command.readString();
            translations.setTranslation(locale, string);
            ++n2;
        }
        return translations;
    }

    public static boolean areEqual(TranslationCache translationCache, TranslationCache translationCache2) {
        if (translationCache == null && translationCache2 == null) {
            return true;
        }
        if (translationCache != null && translationCache2 != null) {
            return translationCache.isEqualTo(translationCache2);
        }
        return false;
    }

    public void write(Command command, TranslationCache translationCache) throws IOException {
        if (command.supports((short)100, "1.9")) {
            Translations translations = translationCache != null ? translationCache.getTranslations() : null;
            Translations translations2 = this.getTranslations();
            if (translations2 == null) {
                String string = this.m_fallback == null ? this.m_localized : this.m_fallback;
                command.writeString(string);
                command.writeInt(0);
                if (this.m_locale.equals(INVARIANT)) {
                    command.writeInt(0);
                    command.writeInt(0);
                } else if (translationCache != null && translationCache.m_locale.equals(this.m_locale)) {
                    command.writeInt(1);
                    command.writeLocale(this.m_locale);
                    command.writeString(this.m_localized);
                    command.writeInt(0);
                } else {
                    command.writeInt(0);
                    command.writeInt(1);
                    command.writeLocale(this.m_locale);
                    command.writeString(this.m_localized);
                }
            } else {
                TranslationCache.saveTranslations(command, translations, translations2);
            }
        } else {
            String string = null;
            if (this.getTranslations() == null) {
                string = this.m_fallback == null ? this.m_localized : this.m_fallback;
            } else {
                string = this.m_translations.getTranslation(Locale.getDefault());
                if (string == null) {
                    string = this.m_translations.getDefault();
                }
            }
            command.writeString(string);
        }
    }

    public boolean isEqualTo(TranslationCache translationCache) {
        if (translationCache.m_translations == null == (this.m_translations == null)) {
            if (this.m_translations != null && !this.m_translations.isEqualTo(translationCache.m_translations)) {
                return false;
            }
        } else {
            return false;
        }
        return this.eq2(translationCache.m_fallback, this.m_fallback) && this.eq2(translationCache.m_localized, this.m_localized) && this.eq2(translationCache.m_locale, this.m_locale);
    }

    private boolean eq2(Object object, Object object2) {
        if (object == null) {
            return object2 == null;
        }
        if (object2 == null) {
            return false;
        }
        return object.equals(object2);
    }

    public TranslationCache copy() {
        TranslationCache translationCache = new TranslationCache();
        translationCache.m_fallback = this.m_fallback;
        translationCache.m_locale = this.m_locale;
        translationCache.m_localized = this.m_localized;
        translationCache.m_translations = this.m_translations == null ? null : this.m_translations.copy();
        return translationCache;
    }

    public static void saveTranslations(Command command, Translations translations, Translations translations2) throws IOException {
        command.writeString(translations2.getDefault());
        Locale[] localeArray = translations2.getLocales();
        Locale[] localeArray2 = translations == null ? new Locale[]{} : translations.getLocales();
        Locale[] localeArray3 = TranslationCache.getAdded(localeArray2, localeArray);
        command.writeInt(localeArray3.length);
        int n = 0;
        while (n < localeArray3.length) {
            command.writeLocale(localeArray3[n]);
            ++n;
        }
        Locale[] localeArray4 = TranslationCache.getModified(translations2, localeArray, translations, localeArray2);
        command.writeInt(localeArray4.length);
        int n2 = 0;
        while (n2 < localeArray4.length) {
            command.writeLocale(localeArray4[n2]);
            String string = translations2.getTranslation(localeArray4[n2]);
            command.writeString(string);
            ++n2;
        }
        Locale[] localeArray5 = TranslationCache.getAdded(localeArray, localeArray2);
        command.writeInt(localeArray5.length);
        int n3 = 0;
        while (n3 < localeArray5.length) {
            command.writeLocale(localeArray5[n3]);
            String string = translations2.getTranslation(localeArray5[n3]);
            command.writeString(string);
            ++n3;
        }
    }

    public String getDisplayName() {
        return this.m_localized != null ? this.m_localized : this.m_fallback;
    }

    private static Locale[] getModified(Translations translations, Locale[] localeArray, Translations translations2, Locale[] localeArray2) {
        Vector<Locale> vector = new Vector<Locale>();
        int n = 0;
        while (n < localeArray.length) {
            String string;
            Locale locale = localeArray[n];
            String string2 = translations.getTranslation(locale);
            String string3 = string = translations2 == null ? null : translations2.getTranslation(locale);
            if (string != null && string2 != null && !string2.equals(string)) {
                vector.addElement(locale);
            }
            ++n;
        }
        Object[] objectArray = new Locale[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private static Locale[] getAdded(Locale[] localeArray, Locale[] localeArray2) {
        Vector<Locale> vector = new Vector<Locale>();
        int n = 0;
        while (n < localeArray.length) {
            if (!TranslationCache.isMember(localeArray[n], localeArray2)) {
                vector.addElement(localeArray[n]);
            }
            ++n;
        }
        Object[] objectArray = new Locale[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private static boolean isMember(Locale locale, Locale[] localeArray) {
        if (localeArray == null) {
            return false;
        }
        int n = 0;
        while (n < localeArray.length) {
            if (locale.equals(localeArray[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private TranslationCache() {
    }

    public TranslationCache(String string) {
        this.m_localized = string;
        this.m_locale = Locale.getDefault();
        this.m_fallback = null;
        this.m_translations = null;
    }

    public TranslationCache(Translations translations) {
        this.m_translations = translations;
        this.m_fallback = translations.getDefault();
        this.m_locale = translations.closestDefined(Locale.getDefault());
        this.m_localized = translations.getTranslation(this.m_locale);
    }
}

