/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam.vts.pickle;

import com.starbase.starteam.vts.comm.Command;
import java.io.IOException;

public class ObjectInfoList {
    private int[] m_objectIDs;
    private int[] m_deleted;
    private String[] m_primaryDescriptors;
    private String[][] m_secondaryDescriptors;

    public int getSize() {
        return this.m_objectIDs.length;
    }

    public boolean isDeleted(int n) {
        return this.m_deleted.length != 0 && this.m_deleted[n] != 0;
    }

    public int getIDAt(int n) {
        return this.m_objectIDs[n];
    }

    public String getPrimaryDescriptorAt(int n) {
        return this.m_primaryDescriptors[n];
    }

    public int getDefault() {
        return this.m_objectIDs.length != 0 ? this.m_objectIDs[0] : -1;
    }

    public String toString() {
        String string = System.getProperty("line.separator");
        String string2 = ",";
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString() + string);
        stringBuffer.append("  ObjectIDs: ");
        int n = 0;
        while (n < this.m_objectIDs.length) {
            if (n > 0) {
                stringBuffer.append(string2);
            }
            stringBuffer.append(this.m_objectIDs[n]);
            ++n;
        }
        stringBuffer.append(string);
        stringBuffer.append("  Deleted: ");
        n = 0;
        while (n < this.m_deleted.length) {
            if (n > 0) {
                stringBuffer.append(string2);
            }
            stringBuffer.append(this.m_deleted[n]);
            ++n;
        }
        stringBuffer.append(string);
        stringBuffer.append("  PrimaryDescriptors: ");
        n = 0;
        while (n < this.m_primaryDescriptors.length) {
            if (n > 0) {
                stringBuffer.append(string2);
            }
            stringBuffer.append(this.m_primaryDescriptors[n]);
            ++n;
        }
        stringBuffer.append(string);
        if (this.m_secondaryDescriptors != null) {
            stringBuffer.append("  SecondaryDescriptors: ");
            n = 0;
            while (n < this.m_secondaryDescriptors.length) {
                stringBuffer.append("    Descriptor[" + n + "]: ");
                int n2 = 0;
                while (n2 < this.m_secondaryDescriptors[n].length) {
                    if (n2 > 0) {
                        stringBuffer.append(string2);
                    }
                    stringBuffer.append(this.m_secondaryDescriptors[n][n2]);
                    ++n2;
                }
                stringBuffer.append(string);
                ++n;
            }
        }
        return stringBuffer.toString();
    }

    public static ObjectInfoList read(Command command) throws IOException {
        ObjectInfoList objectInfoList = new ObjectInfoList();
        objectInfoList.readGuts(command);
        return objectInfoList;
    }

    public void readGuts(Command command) throws IOException {
        this.m_objectIDs = command.readIntArray();
        this.m_deleted = command.readIntArray();
        this.m_primaryDescriptors = command.readStringArray();
        int n = command.readInt();
        if (n == 0) {
            this.m_secondaryDescriptors = null;
        } else {
            this.m_secondaryDescriptors = new String[n][];
            int n2 = 0;
            while (n2 < n) {
                this.m_secondaryDescriptors[n2] = command.readStringArray();
                ++n2;
            }
        }
    }

    public void writeGuts(Command command) throws IOException {
        command.writeIntArray(this.m_objectIDs);
        command.writeIntArray(this.m_deleted);
        command.writeStringArray(this.m_primaryDescriptors);
        if (this.m_secondaryDescriptors == null) {
            command.writeInt(0);
        } else {
            int n = this.m_secondaryDescriptors.length;
            command.writeInt(n);
            int n2 = 0;
            while (n2 < n) {
                command.writeStringArray(this.m_secondaryDescriptors[n2]);
                ++n2;
            }
        }
    }
}

