/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam.vts.comm;

import com.starbase.util.Assert;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class SystemRevisionNumbers {
    private static String m_RevisionString = null;
    private static short m_nRevisionNumber = (short)-1;
    private static final Hashtable m_revinfo = new Hashtable();
    private static final Hashtable m_apirevinfo = new Hashtable();
    private static short m_oldestSupported = (short)-1;
    private static short m_maxRevision = (short)-1;
    public static final short REV_42 = 63;
    public static final short REV_SECURE_COMMANDS = 66;
    public static final short REV_PORTABLE_VTS = 67;
    public static final short REV_SHUTDOWN_SUPPORTED = 68;
    public static final short REV_IDARRAY_STREAMED_AS_INTARRAY = 68;
    public static final short REV_MOVE_FOLDER_DELETE_ABANDONS_VIEWS = 69;
    public static final short REV_SHARE_FLAGS_ADDED = 71;
    public static final short REV_PROTOCOL_TCPIPXML_SUPPORTED = 72;
    public static final short REV_FALCON_ADDED_CLIENT_PROPS = 72;
    public static final short REV_SERVER_LICENSE_INFO_SUPPORTED = 73;
    public static final short REV_GET_SERVER_LOCK = 76;
    public static final short REV_REPLICATION_SUPPORT = 79;
    public static final short REV_CLIENT_STATUS = 80;
    public static final short REV_FIRST_5_2_BUILD = 80;
    public static final short REV_CORRECTED_REF_MODIFIED_TIME = 82;
    public static final short REV_MODIFIED_CREATE_LINK = 83;
    public static final short REV_CONCURRENT_LICENSES_SUPPORTED = 84;
    public static final short REV_FORWARD_COMPATIBILITY = 100;

    public static String getRevisionName(short s) {
        if (s >= 100) {
            return "5.3+";
        }
        Object v = m_revinfo.get(new Short(s));
        if (v == null) {
            return null;
        }
        return (String)v;
    }

    private static void oldestSupportedRevision(short s) {
        m_oldestSupported = s;
    }

    private static void addRevision(short s, String string) {
        SystemRevisionNumbers.addRevision(s, string, null);
    }

    private static void addRevision(short s, String string, String string2) {
        if (string2 != null) {
            m_apirevinfo.put(new Short(s), string2);
        } else if (s >= 100) {
            Assert.internalError("SystemRevisionNubmers.addRevision()");
        }
        m_revinfo.put(new Short(s), string);
        if (s > m_maxRevision) {
            m_maxRevision = s;
        }
    }

    public static short[] getSupportedRevs() {
        int n = m_maxRevision - m_oldestSupported + 1;
        short[] sArray = new short[n];
        int n2 = 0;
        while (n2 < n) {
            sArray[n2] = (short)(m_maxRevision - n2);
            ++n2;
        }
        return sArray;
    }

    public static boolean isClientManagedStatus(short s) {
        return s >= 80;
    }

    static boolean supportsSingleBlockFileStreaming(short s, String string) {
        return SystemRevisionNumbers.equalOrGreater(s, string, (short)100, "1.7");
    }

    public static boolean equalOrGreater(short s, String string, short s2, String string2) {
        if (s > s2) {
            return true;
        }
        if (s == s2) {
            return SystemRevisionNumbers.isSameOrAncestor(string2, string);
        }
        return false;
    }

    private static boolean isSameOrAncestor(String string, String string2) {
        String string3 = SystemRevisionNumbers.findCommonAncestor(string, string2);
        return string3.equals(string);
    }

    static String chooseAPIRevision(short s, String string) {
        String string2 = (String)m_apirevinfo.get(new Short(s));
        if (string2 == null) {
            Assert.internalError("SystemRevisionNumbers.chooseAPIRevision()");
        }
        return SystemRevisionNumbers.findCommonAncestor(string2, string);
    }

    private static String findCommonAncestor(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        StringTokenizer stringTokenizer2 = new StringTokenizer(string2, ".");
        return SystemRevisionNumbers.findBranch("", stringTokenizer, stringTokenizer2);
    }

    private static String findVersion(String string, StringTokenizer stringTokenizer, StringTokenizer stringTokenizer2) {
        String string2;
        String string3 = stringTokenizer.nextToken();
        if (string3.equals(string2 = stringTokenizer2.nextToken())) {
            return string + "." + string3 + SystemRevisionNumbers.findBranch(".", stringTokenizer, stringTokenizer2);
        }
        int n = Integer.parseInt(string3);
        int n2 = Integer.parseInt(string2);
        if (n2 > n) {
            return string + "." + string3;
        }
        return string + "." + string2;
    }

    private static String findBranch(String string, StringTokenizer stringTokenizer, StringTokenizer stringTokenizer2) {
        String string2;
        String string3;
        if (stringTokenizer.hasMoreTokens() && stringTokenizer2.hasMoreTokens() && (string3 = stringTokenizer.nextToken()).equals(string2 = stringTokenizer2.nextToken())) {
            return string + SystemRevisionNumbers.findVersion(string3, stringTokenizer, stringTokenizer2);
        }
        return "";
    }

    private SystemRevisionNumbers() {
    }

    static {
        SystemRevisionNumbers.addRevision((short)40, "3.00.401");
        SystemRevisionNumbers.addRevision((short)41, "3.00.407");
        SystemRevisionNumbers.addRevision((short)42, "4.00.408");
        SystemRevisionNumbers.addRevision((short)43, "4.00.410");
        SystemRevisionNumbers.addRevision((short)44, "4.00.411");
        SystemRevisionNumbers.addRevision((short)45, "4.00.418");
        SystemRevisionNumbers.addRevision((short)46, "4.00.419");
        SystemRevisionNumbers.addRevision((short)47, "4.00.428");
        SystemRevisionNumbers.addRevision((short)48, "4.00.430");
        SystemRevisionNumbers.addRevision((short)49, "4.00.431");
        SystemRevisionNumbers.addRevision((short)50, "4.00.432");
        SystemRevisionNumbers.addRevision((short)51, "4.00.433");
        SystemRevisionNumbers.addRevision((short)52, "4.00.441");
        SystemRevisionNumbers.oldestSupportedRevision((short)52);
        SystemRevisionNumbers.addRevision((short)53, "4.00.463");
        SystemRevisionNumbers.addRevision((short)54, "4.00.463");
        SystemRevisionNumbers.addRevision((short)55, "4.00.473");
        SystemRevisionNumbers.addRevision((short)56, "4.00.477");
        SystemRevisionNumbers.addRevision((short)57, "4.00.479");
        SystemRevisionNumbers.addRevision((short)58, "4.00.487");
        SystemRevisionNumbers.addRevision((short)59, "4.00.491");
        SystemRevisionNumbers.addRevision((short)60, "4.00.496");
        SystemRevisionNumbers.addRevision((short)61, "4.00.498");
        SystemRevisionNumbers.addRevision((short)62, "4.00.501");
        SystemRevisionNumbers.addRevision((short)63, "4.2.551");
        SystemRevisionNumbers.addRevision((short)64, "4.2.583");
        SystemRevisionNumbers.addRevision((short)65, "4.2.585");
        SystemRevisionNumbers.addRevision((short)66, "4.2.588");
        SystemRevisionNumbers.addRevision((short)67, "5.0.000");
        SystemRevisionNumbers.addRevision((short)68, "5.0.013");
        SystemRevisionNumbers.addRevision((short)69, "5.0.042");
        SystemRevisionNumbers.addRevision((short)70, "5.0.061");
        SystemRevisionNumbers.addRevision((short)71, "5.0.076");
        SystemRevisionNumbers.addRevision((short)72, "5.1.005");
        SystemRevisionNumbers.addRevision((short)73, "5.1.021");
        SystemRevisionNumbers.addRevision((short)74, "5.1.043");
        SystemRevisionNumbers.addRevision((short)75, "5.1.109");
        SystemRevisionNumbers.addRevision((short)76, "5.1.124");
        SystemRevisionNumbers.addRevision((short)77, "5.1.139");
        SystemRevisionNumbers.addRevision((short)78, "5.1.207");
        SystemRevisionNumbers.addRevision((short)79, "5.1.239");
        SystemRevisionNumbers.addRevision((short)80, "5.2.xxx");
        SystemRevisionNumbers.addRevision((short)81, "5.2.XXX");
        SystemRevisionNumbers.addRevision((short)82, "5.2 XXX");
        SystemRevisionNumbers.addRevision((short)83, "5.2 XXX");
        SystemRevisionNumbers.addRevision((short)84, "5.2.076");
        SystemRevisionNumbers.addRevision((short)100, "5.3.003", "1.0");
        SystemRevisionNumbers.addRevision((short)100, "5.3.003", "1.1");
        SystemRevisionNumbers.addRevision((short)100, "5.3.003", "1.2");
        SystemRevisionNumbers.addRevision((short)100, "5.3.003", "1.3");
        SystemRevisionNumbers.addRevision((short)100, "5.3.003", "1.4");
        SystemRevisionNumbers.addRevision((short)100, "5.3.033", "1.5");
        SystemRevisionNumbers.addRevision((short)100, "5.3.051", "1.6");
        SystemRevisionNumbers.addRevision((short)100, "5.3.097", "1.7");
        SystemRevisionNumbers.addRevision((short)100, "5.3.125", "1.8");
        SystemRevisionNumbers.addRevision((short)100, "5.4", "1.9");
        SystemRevisionNumbers.addRevision((short)100, "6.0", "1.10");
        SystemRevisionNumbers.addRevision((short)100, "6.0.017", "1.11");
        SystemRevisionNumbers.addRevision((short)100, "6.0.029", "1.12");
        SystemRevisionNumbers.addRevision((short)100, "6.0.032", "1.13");
        SystemRevisionNumbers.addRevision((short)100, "6.0.051", "1.14");
        SystemRevisionNumbers.addRevision((short)100, "7.0.001", "1.15");
        SystemRevisionNumbers.addRevision((short)100, "7.0.004", "1.16");
        SystemRevisionNumbers.addRevision((short)100, "7.0.011", "1.17");
        SystemRevisionNumbers.addRevision((short)100, "7.0.043", "1.18");
        SystemRevisionNumbers.addRevision((short)100, "7.0.030", "1.19");
        SystemRevisionNumbers.addRevision((short)100, "7.0.045", "1.21");
        SystemRevisionNumbers.addRevision((short)100, "7.0.056", "1.22");
        SystemRevisionNumbers.addRevision((short)100, "7.0.071", "1.23");
    }
}

