/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam.vts.comm;

import com.starbase.starteam.vts.comm.Command;
import com.starbase.starteam.vts.comm.CommandExceptionDetected;
import com.starbase.starteam.vts.comm.CommandFile;
import com.starbase.starteam.vts.comm.PacketHeader;
import com.starbase.starteam.vts.comm.ProtocolException;
import com.starbase.starteam.vts.comm.Res;
import com.starbase.starteam.vts.comm.ResIDs;
import com.starbase.starteam.vts.comm.Unzipper;
import com.starbase.util.Assert;
import com.starbase.util.ByteOrder;
import java.io.IOException;
import java.io.InputStream;

class ReceiveCommandFile
extends CommandFile {
    private Command m_cmd = null;
    protected int m_nBufPos = 0;
    protected int m_nReceievedSize = 0;
    protected boolean m_bLastPacket = false;
    protected byte[] m_aBuf = new byte[65536];
    protected Unzipper m_unzipper = new Unzipper();
    private InputStream m_inputStream = null;
    private PacketHeader m_header = new PacketHeader();
    private byte[] _tmp = new byte[4];
    private int[] m_produced = new int[1];
    private int[] m_consumed = new int[1];

    void setCompaction(int n) {
        super.setCompaction(n);
        this.m_unzipper.reset();
    }

    boolean compressingData() {
        return !this.m_cmd.readingGZIPContents() && super.compressingData();
    }

    void reset() {
        super.reset();
        this.m_nBufPos = 0;
        this.m_nReceievedSize = 0;
        this.m_bLastPacket = false;
        this.m_unzipper.reset();
    }

    void resetInflater() {
        this.m_unzipper.reset();
        this.prepareToReceive(this.m_aBuf, this.m_nBufPos, this.getAvailableByteCount());
    }

    private void prepareToReceive(byte[] byArray, int n, int n2) {
        if (this.compressingData()) {
            if (!this.m_unzipper.isInputNeeded()) {
                Assert.internalError("ReceiveCommandFile.prepareToReceive()");
            }
            this.m_unzipper.setInput(byArray, n, n2);
        }
    }

    private void processReceiveData(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4, int[] nArray, int[] nArray2) {
        if (this.compressingData()) {
            int n5 = n3;
            int n6 = n4;
            nArray2[0] = 0;
            nArray[0] = 0;
            while (!this.m_unzipper.isInputNeeded() && n6 != 0) {
                int n7 = this.m_unzipper.getTotalBytesOut();
                nArray2[0] = nArray2[0] + this.m_unzipper.unzip(byArray2, n5, n6);
                nArray[0] = nArray[0] + (this.m_unzipper.getTotalBytesOut() - n7);
                n5 += nArray2[0];
                n6 -= nArray2[0];
            }
        } else {
            int n8 = n4 > n2 ? n2 : n4;
            System.arraycopy(byArray, n, byArray2, n3, n8);
            nArray2[0] = n8;
            nArray[0] = n8;
        }
    }

    int read(byte[] byArray, int n) throws CommandExceptionDetected, IOException {
        return this.read(byArray, 0, n);
    }

    int read(byte[] byArray, int n, int n2) throws CommandExceptionDetected, IOException {
        int n3 = n2;
        int n4 = 0;
        while (n3 != 0) {
            if (this.getAvailableByteCount() == 0 && n3 != 0) {
                this.receivePacket();
                if (this.m_nBufPos != 0) {
                    Assert.internalError("ReceiveCommandFile.read(), m_nBufPos=" + this.m_nBufPos);
                }
                this.prepareToReceive(this.m_aBuf, 0, this.getAvailableByteCount());
            }
            this.processReceiveData(this.m_aBuf, this.m_nBufPos, this.getAvailableByteCount(), byArray, n4 + n, n3, this.m_consumed, this.m_produced);
            this.m_nBufPos += this.m_consumed[0];
            n3 -= this.m_produced[0];
            n4 += this.m_produced[0];
        }
        return n2;
    }

    void close() throws CommandExceptionDetected, IOException {
        if (this.m_bClosed) {
            return;
        }
        if (this.m_nBufPos != this.m_nReceievedSize) {
            throw new ProtocolException(4);
        }
        if (!this.m_bLastPacket) {
            this.receivePacket();
            if (this.m_nReceievedSize != 0) {
                throw new ProtocolException(4);
            }
        }
    }

    void flushInput() throws CommandExceptionDetected, IOException {
        while (!this.m_bLastPacket) {
            this.receivePacket();
        }
    }

    protected final void receivePacket() throws CommandExceptionDetected, IOException {
        if (this.m_bLastPacket) {
            throw new ProtocolException(5);
        }
        this.readPacketHeader(this.m_header);
        if (this.m_header.m_signature != PacketHeader.ST_PACKET_SIGNATURE || 65536 < this.m_header.m_packetSize) {
            throw new ProtocolException(3);
        }
        int n = 0;
        n = this.readRawData(this.m_aBuf, this.m_header.m_packetSize);
        if (n < this.m_header.m_packetSize) {
            throw new ProtocolException(5);
        }
        this.m_nBufPos = 0;
        this.decryptPacket(this.m_aBuf, this.m_header);
        this.m_nReceievedSize = this.m_header.m_packetSize;
        this.m_bLastPacket = this.m_header.isEndOfData();
        if (this.m_bException) {
            if (!this.m_header.isException()) {
                Assert.internalError("ReceiveCommandFile.receivePacket(), !m_header.isException().");
            }
            if (this.m_header.isCompacted()) {
                Assert.internalError("ReceiveCommandFile.receivePacket(), m_header.isCompacted().");
            }
        } else if (this.m_header.isException()) {
            if (this.m_header.isCompacted()) {
                Assert.internalError("ReceiveCommandFile.receivePacket(), !m_bException && m_header.isCompacted().");
            }
            this.m_bException = true;
            throw new CommandExceptionDetected();
        }
    }

    private final int readRawData(byte[] byArray, int n) throws IOException {
        if (n == 0) {
            return 0;
        }
        int n2 = n;
        while (n2 > 0) {
            int n3 = this.m_inputStream.read(byArray, n - n2, n2);
            if (n3 == -1) {
                throw new IOException(Res.getString(ResIDs.CANNOT_READ_FROM_SOCKET));
            }
            n2 -= n3;
        }
        this.m_cmd.read(n);
        return n;
    }

    private final void readPacketHeader(PacketHeader packetHeader) throws IOException {
        packetHeader.m_signature = this.readInt();
        packetHeader.m_packetSize = this.readInt();
        packetHeader.m_dataSize = this.readInt();
        packetHeader.m_flags = this.readInt();
    }

    final int readInt() throws IOException {
        this.readRawData(this._tmp, 4);
        return ByteOrder.readInt(this._tmp);
    }

    protected final void decryptPacket(byte[] byArray, PacketHeader packetHeader) {
        int n;
        if (packetHeader.m_packetSize == 0) {
            return;
        }
        if (this.m_aCipher == null) {
            return;
        }
        if (!packetHeader.isEncrypted()) {
            return;
        }
        packetHeader.m_packetSize = n = this.m_aCipher.decrypt(byArray, packetHeader.m_packetSize);
    }

    protected final int getAvailableByteCount() {
        return this.m_nReceievedSize - this.m_nBufPos;
    }

    ReceiveCommandFile(Command command, InputStream inputStream) {
        this.m_cmd = command;
        this.m_inputStream = inputStream;
    }
}

