/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam.vts.comm;

import COM.rsa.jsafe.JSAFE_AsymmetricCipher;
import COM.rsa.jsafe.JSAFE_IVException;
import COM.rsa.jsafe.JSAFE_InputException;
import COM.rsa.jsafe.JSAFE_InvalidKeyException;
import COM.rsa.jsafe.JSAFE_InvalidParameterException;
import COM.rsa.jsafe.JSAFE_InvalidUseException;
import COM.rsa.jsafe.JSAFE_KeyPair;
import COM.rsa.jsafe.JSAFE_PaddingException;
import COM.rsa.jsafe.JSAFE_PrivateKey;
import COM.rsa.jsafe.JSAFE_PublicKey;
import COM.rsa.jsafe.JSAFE_SecretKey;
import COM.rsa.jsafe.JSAFE_SecureRandom;
import COM.rsa.jsafe.JSAFE_SymmetricCipher;
import COM.rsa.jsafe.JSAFE_UnimplementedException;
import com.starbase.starteam.ConfigFiles;
import com.starbase.starteam.vts.comm.EncryptContext;
import com.starbase.starteam.vts.comm.EncryptionAlgorithm;
import com.starbase.starteam.vts.comm.Res;
import com.starbase.starteam.vts.comm.ResIDs;
import com.starbase.util.Assert;
import com.starbase.util.ByteOrder;
import com.starbase.util.MD5;
import com.starbase.util.Platform;
import com.starbase.util.WorkStationOptions;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.SecureRandom;
import java.util.Date;
import java.util.StringTokenizer;

class JSAFEEncryptContext
implements EncryptContext {
    private static final String STARTEAM_SERVER = "StarTeam Server";
    private static final String STARTEAM_CLIENT = "StarTeam Client";
    private String m_jsafe_device = "Native/Java";
    private JSAFE_AsymmetricCipher m_keycipher = null;
    private JSAFE_SymmetricCipher m_datacipher = null;
    private JSAFE_SecureRandom m_random = null;
    private JSAFE_PublicKey m_publicKey = null;
    private JSAFE_PrivateKey m_privateKey = null;
    private JSAFE_SecretKey m_mysessionkey = null;
    private JSAFE_PublicKey m_serverPublicKey = null;
    private JSAFE_SecretKey m_othersessionkey = null;
    private int m_keyBitCount = 0;
    private EncryptionAlgorithm m_algID = null;

    private void init() {
        try {
            this.m_random = JSAFE_SecureRandom.getInstance((String)"MD5Random", (String)this.m_jsafe_device);
        }
        catch (JSAFE_UnimplementedException jSAFE_UnimplementedException) {
            throw new RuntimeException(jSAFE_UnimplementedException.toString());
        }
        String string = new Date().toString();
        this.m_random.seed(string.getBytes());
        try {
            this.m_keycipher = JSAFE_AsymmetricCipher.getInstance((String)"RSA/PKCS1Block02Pad", (String)this.m_jsafe_device);
        }
        catch (JSAFE_InvalidParameterException jSAFE_InvalidParameterException) {
            throw new RuntimeException(jSAFE_InvalidParameterException.toString());
        }
        catch (JSAFE_UnimplementedException jSAFE_UnimplementedException) {
            throw new RuntimeException(jSAFE_UnimplementedException.toString());
        }
    }

    public int encrypt(byte[] byArray, int n, int n2) {
        try {
            this.m_datacipher.encryptInit(this.m_mysessionkey);
            int n3 = this.m_datacipher.encryptUpdate(byArray, 0, n, byArray, 0);
            n3 += this.m_datacipher.encryptFinal(byArray, n3);
            return n3;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Assert.internalError("JSAFEEncryptContext.encrypt(), " + exception.toString());
            return -1;
        }
    }

    public int decrypt(byte[] byArray, int n) {
        try {
            this.m_datacipher.decryptInit(this.m_othersessionkey);
            int n2 = this.m_datacipher.decryptUpdate(byArray, 0, n, byArray, 0);
            n2 += this.m_datacipher.decryptFinal(byArray, n2);
            return n2;
        }
        catch (Exception exception) {
            Assert.internalError("JSAFEEncryptContext.decrypt(), " + exception.getMessage());
            return -1;
        }
    }

    public int getBlockLength() {
        int n = this.m_datacipher.getBlockSize();
        return n;
    }

    public byte[] exportPublicKeyToCAPI() {
        byte[][] byArray = null;
        try {
            byArray = this.m_publicKey.getKeyData("RSAPublicKey");
        }
        catch (JSAFE_UnimplementedException jSAFE_UnimplementedException) {
            throw new RuntimeException(jSAFE_UnimplementedException.toString());
        }
        int n = byArray[0].length * 8;
        int n2 = 8;
        int n3 = 12;
        int n4 = n2 + n3 + byArray[0].length;
        byte[] byArray2 = new byte[n4];
        byArray2[0] = 6;
        byArray2[1] = 2;
        byArray2[5] = -92;
        byArray2[8] = 82;
        byArray2[9] = 83;
        byArray2[10] = 65;
        byArray2[11] = 49;
        byte[] byArray3 = new byte[4];
        ByteOrder.writeInt(byArray3, n);
        System.arraycopy(byArray3, 0, byArray2, 12, 4);
        System.arraycopy(byArray[1], 0, byArray2, 16, byArray[1].length);
        byte[] byArray4 = new byte[byArray[0].length];
        System.arraycopy(byArray[0], 0, byArray4, 0, byArray4.length);
        JSAFEEncryptContext.reverse(byArray4);
        System.arraycopy(byArray4, 0, byArray2, 20, byArray4.length);
        return byArray2;
    }

    public void beginKeyExchange(EncryptionAlgorithm encryptionAlgorithm, int n) {
        try {
            this.ensureKeyPair();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.toString());
        }
        if (n != 40) {
            throw new IllegalArgumentException(Res.getString(ResIDs.ONLY_40_BIT_KEYS_SUPPORTED));
        }
        this.m_keyBitCount = n;
        this.m_algID = encryptionAlgorithm;
        this.makeCipher();
    }

    public void generateSessionKey() {
        this.m_mysessionkey = this.makeBlankKey();
        int[] nArray = new int[]{0};
        nArray[0] = this.m_keyBitCount;
        try {
            this.m_mysessionkey.generateInit(nArray, (SecureRandom)this.m_random);
        }
        catch (JSAFE_InvalidParameterException jSAFE_InvalidParameterException) {
            throw new RuntimeException(jSAFE_InvalidParameterException.toString());
        }
        catch (JSAFE_InvalidUseException jSAFE_InvalidUseException) {
            throw new RuntimeException(jSAFE_InvalidUseException.toString());
        }
        try {
            this.m_mysessionkey.generate();
        }
        catch (JSAFE_InvalidParameterException jSAFE_InvalidParameterException) {
            throw new RuntimeException(jSAFE_InvalidParameterException.toString());
        }
    }

    public void importCAPIPublicKey(byte[] byArray) {
        byte[] byArray2 = new byte[]{6, 2, 0, 0, 0, -92, 0, 0, 82, 83, 65, 49};
        int n = 0;
        while (n < byArray2.length) {
            if (byArray[n] != byArray2[n]) {
                throw new RuntimeException(Res.formatKey(ResIDs.BAD_PUBLIC_RSA_FROM_SERVER_FMT, new Object[]{this.bytesToString(byArray)}));
            }
            ++n;
        }
        n = this.readInt(byArray, 12);
        int n2 = this.readInt(byArray, 16);
        int n3 = n / 8;
        byte[][] byArray3 = null;
        byArray3 = new byte[2][];
        int n4 = 0;
        int n5 = 0;
        while (n5 < 4) {
            if (byArray[n5 + 16] != 0) {
                n4 = n5 + 1;
            }
            ++n5;
        }
        byArray3[1] = new byte[n4];
        System.arraycopy(byArray, 16, byArray3[1], 0, n4);
        byArray3[0] = new byte[n3];
        System.arraycopy(byArray, 20, byArray3[0], 0, n3);
        JSAFEEncryptContext.reverse(byArray3[0]);
        try {
            this.m_serverPublicKey = JSAFE_PublicKey.getInstance((String)"RSA", (String)this.m_jsafe_device);
        }
        catch (JSAFE_UnimplementedException jSAFE_UnimplementedException) {
            throw new RuntimeException(jSAFE_UnimplementedException.getMessage());
        }
        try {
            this.m_serverPublicKey.setKeyData(byArray3);
        }
        catch (JSAFE_InvalidKeyException jSAFE_InvalidKeyException) {
            throw new RuntimeException(jSAFE_InvalidKeyException.getMessage());
        }
    }

    public byte[] exportSessionKeyToCAPI() {
        byte[] byArray = this.m_mysessionkey.getSecretKeyData();
        try {
            this.m_keycipher.encryptInit(this.m_serverPublicKey, (SecureRandom)this.m_random);
        }
        catch (JSAFE_InvalidKeyException jSAFE_InvalidKeyException) {
            throw new RuntimeException(jSAFE_InvalidKeyException.toString());
        }
        catch (JSAFE_InvalidUseException jSAFE_InvalidUseException) {
            throw new RuntimeException(jSAFE_InvalidUseException.toString());
        }
        int n = byArray.length;
        int n2 = this.m_keycipher.getOutputBufferSize(n);
        byte[] byArray2 = new byte[n2];
        int n3 = 0;
        try {
            n3 = this.m_keycipher.encryptUpdate(byArray, 0, n, byArray2, 0);
        }
        catch (JSAFE_InputException jSAFE_InputException) {
            throw new RuntimeException(jSAFE_InputException.toString());
        }
        catch (JSAFE_InvalidUseException jSAFE_InvalidUseException) {
            throw new RuntimeException(jSAFE_InvalidUseException.toString());
        }
        try {
            n3 += this.m_keycipher.encryptFinal(byArray2, n3);
        }
        catch (JSAFE_PaddingException jSAFE_PaddingException) {
            throw new RuntimeException(jSAFE_PaddingException.toString());
        }
        catch (JSAFE_InvalidUseException jSAFE_InvalidUseException) {
            throw new RuntimeException(jSAFE_InvalidUseException.toString());
        }
        catch (JSAFE_InputException jSAFE_InputException) {
            throw new RuntimeException(jSAFE_InputException.toString());
        }
        byte[] byArray3 = new byte[n3];
        System.arraycopy(byArray2, 0, byArray3, 0, n3);
        JSAFEEncryptContext.reverse(byArray3);
        byte[] byArray4 = byArray3;
        byte[] byArray5 = this.getPrefix();
        byte[] byArray6 = new byte[byArray4.length + byArray5.length];
        System.arraycopy(byArray5, 0, byArray6, 0, byArray5.length);
        System.arraycopy(byArray4, 0, byArray6, byArray5.length, byArray4.length);
        return byArray6;
    }

    public void importCAPISessionKey(byte[] byArray) {
        try {
            this.m_keycipher.decryptInit(this.m_privateKey);
        }
        catch (JSAFE_InvalidKeyException jSAFE_InvalidKeyException) {
            throw new RuntimeException(jSAFE_InvalidKeyException.getMessage());
        }
        catch (JSAFE_InvalidUseException jSAFE_InvalidUseException) {
            throw new RuntimeException(jSAFE_InvalidUseException.toString());
        }
        int n = byArray.length - 12;
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 12, byArray2, 0, n);
        JSAFEEncryptContext.reverse(byArray2);
        int n2 = this.m_keycipher.getOutputBufferSize(n);
        byte[] byArray3 = new byte[n2];
        int n3 = 0;
        int n4 = this.m_keycipher.getMaxInputLen();
        try {
            n3 = this.m_keycipher.decryptUpdate(byArray2, 0, n, byArray3, 0);
        }
        catch (JSAFE_InputException jSAFE_InputException) {
            throw new RuntimeException(jSAFE_InputException.toString());
        }
        catch (JSAFE_InvalidUseException jSAFE_InvalidUseException) {
            throw new RuntimeException(jSAFE_InvalidUseException.toString());
        }
        try {
            n3 += this.m_keycipher.decryptFinal(byArray3, n3);
        }
        catch (JSAFE_InputException jSAFE_InputException) {
            throw new RuntimeException(jSAFE_InputException.toString());
        }
        catch (JSAFE_InvalidUseException jSAFE_InvalidUseException) {
            throw new RuntimeException(jSAFE_InvalidUseException.toString());
        }
        catch (JSAFE_PaddingException jSAFE_PaddingException) {
            throw new RuntimeException(jSAFE_PaddingException.toString());
        }
        this.m_othersessionkey = this.makeBlankKey();
        byte[][] byArray4 = new byte[][]{new byte[n3]};
        System.arraycopy(byArray3, 0, byArray4[0], 0, n3);
        try {
            this.m_othersessionkey.setKeyData(byArray4);
        }
        catch (JSAFE_InvalidKeyException jSAFE_InvalidKeyException) {
            throw new RuntimeException(jSAFE_InvalidKeyException.getMessage());
        }
    }

    private byte[] getClientSessionKeyData() {
        byte[] byArray = this.m_mysessionkey.getKeyData()[0];
        JSAFEEncryptContext.reverse(byArray);
        return byArray;
    }

    private byte[] getServerSessionKeyData() {
        byte[] byArray = this.m_othersessionkey.getKeyData()[0];
        JSAFEEncryptContext.reverse(byArray);
        return byArray;
    }

    public boolean validServerHash(byte[] byArray) {
        byte[][] byArray2 = new byte[][]{this.getClientSessionKeyData(), this.getServerSessionKeyData(), this.convert(STARTEAM_CLIENT), this.convert(STARTEAM_SERVER), this.convert("phase 2")};
        MD5 mD5 = new MD5();
        mD5.computeBufferMD5(this.catentate(byArray2));
        return JSAFEEncryptContext.equal(byArray, mD5.getData());
    }

    private static boolean equal(byte[] byArray, byte[] byArray2) {
        if (byArray.length != byArray2.length) {
            return false;
        }
        int n = 0;
        while (n < byArray.length) {
            if (byArray[n] != byArray2[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private byte[] catentate(byte[][] byArray) {
        int n = 0;
        int n2 = 0;
        while (n2 < byArray.length) {
            n += byArray[n2].length;
            ++n2;
        }
        byte[] byArray2 = new byte[n];
        int n3 = 0;
        int n4 = 0;
        while (n4 < byArray.length) {
            System.arraycopy(byArray[n4], 0, byArray2, n3, byArray[n4].length);
            n3 += byArray[n4].length;
            ++n4;
        }
        return byArray2;
    }

    private byte[] convert(String string) {
        byte[] byArray = new byte[string.length()];
        int n = 0;
        while (n < string.length()) {
            byArray[n] = (byte)(string.charAt(n) & 0xFF);
            ++n;
        }
        return byArray;
    }

    public byte[] getClientHash() {
        byte[][] byArray = new byte[][]{this.getServerSessionKeyData(), this.convert(STARTEAM_CLIENT), this.convert(STARTEAM_SERVER), this.convert("phase 3")};
        MD5 mD5 = new MD5();
        mD5.computeBufferMD5(this.catentate(byArray));
        return mD5.getData();
    }

    public void dispose() {
    }

    public void endKeyExchange() {
        this.m_othersessionkey = this.saltMicrosoftKey(this.m_othersessionkey);
        this.m_mysessionkey = this.saltMicrosoftKey(this.m_mysessionkey);
    }

    public void generateKeys() {
        JSAFE_KeyPair jSAFE_KeyPair = null;
        try {
            jSAFE_KeyPair = JSAFE_KeyPair.getInstance((String)"RSA", (String)this.m_jsafe_device);
        }
        catch (JSAFE_UnimplementedException jSAFE_UnimplementedException) {
            throw new RuntimeException(jSAFE_UnimplementedException.toString());
        }
        int[] nArray = new int[]{512, 65537};
        try {
            jSAFE_KeyPair.generateInit(null, nArray, (SecureRandom)this.m_random);
        }
        catch (JSAFE_InvalidParameterException jSAFE_InvalidParameterException) {
            throw new RuntimeException(jSAFE_InvalidParameterException.toString());
        }
        catch (JSAFE_InvalidUseException jSAFE_InvalidUseException) {
            throw new RuntimeException(jSAFE_InvalidUseException.toString());
        }
        try {
            jSAFE_KeyPair.generate();
        }
        catch (JSAFE_InvalidUseException jSAFE_InvalidUseException) {
            throw new RuntimeException(jSAFE_InvalidUseException.toString());
        }
        this.m_publicKey = jSAFE_KeyPair.getPublicKey();
        this.m_privateKey = jSAFE_KeyPair.getPrivateKey();
    }

    private JSAFE_SecretKey saltMicrosoftKey(JSAFE_SecretKey jSAFE_SecretKey) {
        if (this.m_keyBitCount != 40) {
            return jSAFE_SecretKey;
        }
        byte[][] byArray = jSAFE_SecretKey.getKeyData();
        byte[] byArray2 = new byte[16];
        int n = byArray[0].length;
        int n2 = 0;
        while (n2 < n) {
            byArray2[n2] = byArray[0][n2];
            ++n2;
        }
        byArray[0] = byArray2;
        JSAFE_SecretKey jSAFE_SecretKey2 = null;
        try {
            jSAFE_SecretKey2 = this.makeBlankKey();
            jSAFE_SecretKey2.setKeyData(byArray);
        }
        catch (JSAFE_InvalidKeyException jSAFE_InvalidKeyException) {
            throw new RuntimeException(jSAFE_InvalidKeyException.toString());
        }
        return jSAFE_SecretKey2;
    }

    private byte[] getPrefix() {
        if (this.m_algID == null || this.m_algID == EncryptionAlgorithm.NULL) {
            Assert.internalError("JSAFEEncryptContext::getPrefix(), m_algID=" + this.m_algID);
        }
        byte[] byArray = new byte[]{1, 2, 0, 0, 1, 104, 0, 0, 0, -92, 0, 0};
        byte[] byArray2 = new byte[]{1, 2, 0, 0, 2, 102, 0, 0, 0, -92, 0, 0};
        if (this.m_algID == EncryptionAlgorithm.RC4) {
            return byArray;
        }
        return byArray2;
    }

    private JSAFE_SecretKey makeBlankKey() {
        JSAFE_SecretKey jSAFE_SecretKey = this.m_datacipher.getBlankKey();
        return jSAFE_SecretKey;
    }

    private void makeCipher() {
        String string = null;
        EncryptionAlgorithm encryptionAlgorithm = this.m_algID;
        int n = this.m_keyBitCount;
        if (encryptionAlgorithm == EncryptionAlgorithm.RC4) {
            string = "RC4";
        }
        if (encryptionAlgorithm == EncryptionAlgorithm.RC2_CBC) {
            string = "RC2-" + n + "/CBC/PKCS5Padding";
        }
        if (encryptionAlgorithm == EncryptionAlgorithm.RC2_ECB) {
            string = "RC2-" + n + "/ECB/PKCS5Padding";
        }
        if (encryptionAlgorithm == EncryptionAlgorithm.RC2_CFB) {
            throw new RuntimeException("RC2_CFB encryption not available with JSafe");
        }
        if (string == null) {
            throw new RuntimeException(Res.formatKey(ResIDs.NONSUPPORTED_ALGORITHM_FMT, new Object[]{encryptionAlgorithm}));
        }
        JSAFE_SymmetricCipher jSAFE_SymmetricCipher = null;
        try {
            jSAFE_SymmetricCipher = JSAFE_SymmetricCipher.getInstance((String)string, (String)this.m_jsafe_device);
        }
        catch (JSAFE_UnimplementedException jSAFE_UnimplementedException) {
            throw new RuntimeException(jSAFE_UnimplementedException.toString());
        }
        catch (JSAFE_InvalidParameterException jSAFE_InvalidParameterException) {
            throw new RuntimeException(jSAFE_InvalidParameterException.toString());
        }
        if (encryptionAlgorithm == EncryptionAlgorithm.RC2_CBC || encryptionAlgorithm == EncryptionAlgorithm.RC2_CFB) {
            try {
                byte[] byArray = new byte[8];
                jSAFE_SymmetricCipher.setIV(byArray, 0, 8);
            }
            catch (JSAFE_IVException jSAFE_IVException) {
                throw new RuntimeException(jSAFE_IVException.toString());
            }
        }
        this.m_datacipher = jSAFE_SymmetricCipher;
    }

    private static void reverse(byte[] byArray) {
        int n = byArray.length;
        int n2 = n / 2;
        int n3 = 0;
        while (n3 < n2) {
            byte by;
            byte by2 = byArray[n3];
            byArray[n3] = by = byArray[n - n3 - 1];
            byArray[n - n3 - 1] = by2;
            ++n3;
        }
    }

    private int readInt(byte[] byArray, int n) {
        int n2 = byArray[n] & 0xFF;
        int n3 = byArray[1 + n] & 0xFF;
        int n4 = byArray[2 + n] & 0xFF;
        int n5 = byArray[3 + n] & 0xFF;
        return n2 + (n3 << 8) + (n4 << 16) + (n5 << 24);
    }

    private static byte[] parseHexArray(String string) {
        byte[] byArray = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        int n = stringTokenizer.countTokens();
        byArray = new byte[n];
        int n2 = 0;
        while (n2 < n) {
            String string2 = stringTokenizer.nextToken();
            int n3 = Integer.parseInt(string2, 16);
            byArray[n2] = (byte)(n3 & 0xFF);
            ++n2;
        }
        return byArray;
    }

    private void printbytes(byte[] byArray, int n, boolean bl) {
        int n2 = 0;
        while (n2 < n) {
            int n3 = byArray[n2] & 0xFF;
            if (bl) {
                System.out.print("(byte)0x");
            }
            if (n3 < 16) {
                System.out.print("0");
            }
            System.out.print(Integer.toHexString(n3));
            System.out.print(",");
            if ((n2 + 1) % 8 == 0) {
                System.out.println("");
            } else {
                System.out.print(" ");
            }
            ++n2;
        }
        System.out.println("");
    }

    private String bytesToString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer(byArray.length * 3);
        stringBuffer.append("[");
        int n = byArray.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = byArray[n2] & 0xFF;
            if (n3 < 16) {
                stringBuffer.append("0");
            }
            stringBuffer.append(Integer.toHexString(n3).toUpperCase());
            if (n2 < n - 1) {
                stringBuffer.append(" ");
            }
            ++n2;
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    private void ensureKeyPair() throws IOException {
        WorkStationOptions workStationOptions = Platform.getWSOptions();
        String string = null;
        File file = null;
        try {
            string = workStationOptions.getOption("keyfile");
            file = new File(string);
        }
        catch (Throwable throwable) {
            File file2 = ConfigFiles.getStarTeamINI();
            file = new File(file2.getParent(), "stkeys");
        }
        if (file.exists()) {
            this.loadKeyPair(file);
        } else {
            this.generateKeys();
            this.saveKeyPair(file);
        }
    }

    private void loadKeyPair(File file) throws IOException {
        JSAFE_PublicKey jSAFE_PublicKey = null;
        JSAFE_PrivateKey jSAFE_PrivateKey = null;
        DataInputStream dataInputStream = new DataInputStream(new FileInputStream(file));
        try {
            int n;
            jSAFE_PublicKey = JSAFE_PublicKey.getInstance((String)"RSA", (String)this.m_jsafe_device);
            jSAFE_PrivateKey = JSAFE_PrivateKey.getInstance((String)"RSA", (String)this.m_jsafe_device);
            int n2 = dataInputStream.readInt();
            int n3 = dataInputStream.readInt();
            if (n2 != 1246970182 || n3 != 1162560857) {
                Assert.internalError("JSAFEEncryptContext.loadKeyPair(), invalid key file");
            }
            if ((n = dataInputStream.readInt()) != 1) {
                Assert.internalError("JSAFEEncryptContext.loadKeyPair(), invalid key file version");
            }
            byte[][] byArray = this.readKeyData(dataInputStream);
            byte[][] byArray2 = this.readKeyData(dataInputStream);
            dataInputStream.close();
            jSAFE_PublicKey.setKeyData("RSAPublicKey", byArray);
            jSAFE_PrivateKey.setKeyData("RSAPrivateKey", byArray2);
            this.m_publicKey = jSAFE_PublicKey;
            this.m_privateKey = jSAFE_PrivateKey;
        }
        catch (JSAFE_UnimplementedException jSAFE_UnimplementedException) {
            dataInputStream.close();
            Assert.internalError("JSAFEEncryptContext.loadKeyPair(), JSAFE_UnimplementedException: " + jSAFE_UnimplementedException.getMessage());
        }
        catch (JSAFE_InvalidKeyException jSAFE_InvalidKeyException) {
            dataInputStream.close();
            Assert.internalError("JSAFEEncryptContext.loadKeyPair(), invalid keys in file: " + file.getAbsolutePath());
        }
    }

    public void saveKeyPair(File file) throws IOException {
        DataOutputStream dataOutputStream = new DataOutputStream(new FileOutputStream(file));
        dataOutputStream.writeInt(1246970182);
        dataOutputStream.writeInt(1162560857);
        dataOutputStream.writeInt(1);
        try {
            this.writeKeyData(dataOutputStream, this.m_publicKey.getKeyData("RSAPublicKey"));
            this.writeKeyData(dataOutputStream, this.m_privateKey.getKeyData("RSAPrivateKey"));
        }
        catch (JSAFE_UnimplementedException jSAFE_UnimplementedException) {
            dataOutputStream.close();
            Assert.internalError("JSAFEEncryptContext.saveKeyPair()");
        }
        dataOutputStream.close();
    }

    private void writeKeyData(DataOutputStream dataOutputStream, byte[][] byArray) throws IOException {
        int n = byArray.length;
        dataOutputStream.writeInt(n);
        int n2 = 0;
        while (n2 < n) {
            byte[] byArray2 = byArray[n2];
            int n3 = byArray2.length;
            dataOutputStream.writeInt(n3);
            int n4 = 0;
            while (n4 < n3) {
                dataOutputStream.writeByte(byArray2[n4]);
                ++n4;
            }
            ++n2;
        }
    }

    private byte[][] readKeyData(DataInputStream dataInputStream) throws IOException {
        byte[][] byArray = null;
        int n = dataInputStream.readInt();
        byArray = new byte[n][];
        int n2 = 0;
        while (n2 < n) {
            int n3 = dataInputStream.readInt();
            byte[] byArray2 = new byte[n3];
            byArray[n2] = byArray2;
            int n4 = 0;
            while (n4 < n3) {
                byArray2[n4] = dataInputStream.readByte();
                ++n4;
            }
            ++n2;
        }
        return byArray;
    }

    public JSAFEEncryptContext() {
        this.init();
    }
}

