/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam.vts.comm;

import com.starbase.starteam.ConfigFiles;
import com.starbase.starteam.vts.comm.EncryptContext;
import com.starbase.starteam.vts.comm.EncryptionAlgorithm;
import com.starbase.starteam.vts.comm.Res;
import com.starbase.starteam.vts.comm.ResIDs;
import com.starbase.util.Assert;
import com.starbase.util.ByteOrder;
import com.starbase.util.MD5;
import com.starbase.util.Platform;
import com.starbase.util.WorkStationOptions;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.Provider;
import java.security.Security;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.RC2ParameterSpec;

class JCEEncryptContext
implements EncryptContext {
    private static final String RSA_ALG = "RSA/ECB/PKCS#1";
    private static final String PROVIDER_CLASS = "com.isnetworks.provider.jce.ISNetworksProvider";
    private static final String PROVIDER_NAME = "ISNetworks";
    private static final String STARTEAM_SERVER = "StarTeam Server";
    private static final String STARTEAM_CLIENT = "StarTeam Client";
    private Cipher m_keycipher = null;
    private Cipher m_datacipher = null;
    private AlgorithmParameterSpec m_dataCipherParam = null;
    private RSAPublicKey m_publicKey = null;
    private RSAPrivateKey m_privateKey = null;
    private SecretKey m_mysessionkey = null;
    private byte[] m_mysessionkeydata = null;
    private RSAPublicKey m_serverPublicKey = null;
    private SecretKey m_othersessionkey = null;
    private byte[] m_othersessionkeydata = null;
    private int m_keyBitCount = 0;
    private EncryptionAlgorithm m_algID = null;

    private void init() {
        try {
            this.m_keycipher = Cipher.getInstance(RSA_ALG, PROVIDER_NAME);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    public int encrypt(byte[] byArray, int n, int n2) {
        try {
            this.m_datacipher.init(1, (Key)this.m_mysessionkey, this.m_dataCipherParam);
            return this.m_datacipher.doFinal(byArray, 0, n, byArray, 0);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable.toString());
        }
    }

    public int decrypt(byte[] byArray, int n) {
        try {
            this.m_datacipher.init(2, (Key)this.m_othersessionkey, this.m_dataCipherParam);
            return this.m_datacipher.doFinal(byArray, 0, n, byArray, 0);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable.toString());
        }
    }

    public int getBlockLength() {
        return this.m_algID == EncryptionAlgorithm.RC4 ? 0 : 8;
    }

    public byte[] exportPublicKeyToCAPI() {
        return JCEEncryptContext.exportToCAPI(this.m_publicKey);
    }

    public void beginKeyExchange(EncryptionAlgorithm encryptionAlgorithm, int n) {
        try {
            this.ensureKeyPair();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.toString());
        }
        if (n != 40) {
            throw new IllegalArgumentException(Res.getString(ResIDs.ONLY_40_BIT_KEYS_SUPPORTED));
        }
        this.m_keyBitCount = n;
        this.m_algID = encryptionAlgorithm;
        this.makeCipher();
    }

    public void generateSessionKey() {
        try {
            KeyGenerator keyGenerator = null;
            keyGenerator = this.m_algID == EncryptionAlgorithm.RC4 ? KeyGenerator.getInstance("RC4", PROVIDER_NAME) : KeyGenerator.getInstance("RC2", PROVIDER_NAME);
            keyGenerator.init(this.m_keyBitCount);
            this.m_mysessionkey = keyGenerator.generateKey();
            this.m_mysessionkeydata = this.m_mysessionkey.getEncoded();
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    public void importCAPIPublicKey(byte[] byArray) {
        this.m_serverPublicKey = RSAPublicKeyImpl.importFromCAPI(byArray);
    }

    public byte[] exportSessionKeyToCAPI() {
        byte[] byArray = JCEEncryptContext.encrypt(this.m_mysessionkeydata, this.m_serverPublicKey);
        JCEEncryptContext.reverse(byArray);
        byte[] byArray2 = byArray;
        byte[] byArray3 = this.getPrefix();
        byte[] byArray4 = new byte[byArray2.length + byArray3.length];
        System.arraycopy(byArray3, 0, byArray4, 0, byArray3.length);
        System.arraycopy(byArray2, 0, byArray4, byArray3.length, byArray2.length);
        return byArray4;
    }

    public void importCAPISessionKey(byte[] byArray) {
        int n = byArray.length - 12;
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 12, byArray2, 0, n);
        JCEEncryptContext.reverse(byArray2);
        byte[] byArray3 = JCEEncryptContext.decrypt(byArray2, this.m_privateKey);
        this.m_othersessionkeydata = byArray3;
        this.m_othersessionkey = new SecretKeyImpl(byArray3, this.m_algID == EncryptionAlgorithm.RC4 ? "RC4" : "RC2");
    }

    private byte[] getClientSessionKeyData() {
        byte[] byArray = new byte[this.m_mysessionkeydata.length];
        System.arraycopy(this.m_mysessionkeydata, 0, byArray, 0, byArray.length);
        JCEEncryptContext.reverse(byArray);
        return byArray;
    }

    private byte[] getServerSessionKeyData() {
        byte[] byArray = new byte[this.m_othersessionkeydata.length];
        System.arraycopy(this.m_othersessionkeydata, 0, byArray, 0, byArray.length);
        JCEEncryptContext.reverse(byArray);
        return byArray;
    }

    public boolean validServerHash(byte[] byArray) {
        byte[][] byArray2 = new byte[][]{this.getClientSessionKeyData(), this.getServerSessionKeyData(), this.convert(STARTEAM_CLIENT), this.convert(STARTEAM_SERVER), this.convert("phase 2")};
        MD5 mD5 = new MD5();
        mD5.computeBufferMD5(this.catentate(byArray2));
        return JCEEncryptContext.equal(byArray, mD5.getData());
    }

    private static boolean equal(byte[] byArray, byte[] byArray2) {
        if (byArray.length != byArray2.length) {
            return false;
        }
        int n = 0;
        while (n < byArray.length) {
            if (byArray[n] != byArray2[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private byte[] catentate(byte[][] byArray) {
        int n = 0;
        int n2 = 0;
        while (n2 < byArray.length) {
            n += byArray[n2].length;
            ++n2;
        }
        byte[] byArray2 = new byte[n];
        int n3 = 0;
        int n4 = 0;
        while (n4 < byArray.length) {
            System.arraycopy(byArray[n4], 0, byArray2, n3, byArray[n4].length);
            n3 += byArray[n4].length;
            ++n4;
        }
        return byArray2;
    }

    private byte[] convert(String string) {
        byte[] byArray = new byte[string.length()];
        int n = 0;
        while (n < string.length()) {
            byArray[n] = (byte)(string.charAt(n) & 0xFF);
            ++n;
        }
        return byArray;
    }

    public byte[] getClientHash() {
        byte[][] byArray = new byte[][]{this.getServerSessionKeyData(), this.convert(STARTEAM_CLIENT), this.convert(STARTEAM_SERVER), this.convert("phase 3")};
        MD5 mD5 = new MD5();
        mD5.computeBufferMD5(this.catentate(byArray));
        byte[] byArray2 = mD5.getData();
        return byArray2;
    }

    public void dispose() {
    }

    public void endKeyExchange() {
        this.m_othersessionkey = this.saltMicrosoftKey(this.m_othersessionkeydata);
        this.m_mysessionkey = this.saltMicrosoftKey(this.m_mysessionkeydata);
    }

    public void generateKeys() {
        try {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA", PROVIDER_NAME);
            keyPairGenerator.initialize(512);
            KeyPair keyPair = keyPairGenerator.generateKeyPair();
            this.m_publicKey = (RSAPublicKey)keyPair.getPublic();
            this.m_privateKey = (RSAPrivateKey)keyPair.getPrivate();
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable.toString());
        }
    }

    private SecretKey saltMicrosoftKey(byte[] byArray) {
        if (this.m_keyBitCount != 40) {
            Assert.internalError("JCEEncryptContext::saltMicrosoftKey(), m_keyBitCount=" + this.m_keyBitCount);
        }
        byte[] byArray2 = new byte[16];
        int n = byArray.length;
        int n2 = 0;
        while (n2 < n) {
            byArray2[n2] = byArray[n2];
            ++n2;
        }
        return new SecretKeyImpl(byArray2, this.m_algID == EncryptionAlgorithm.RC4 ? "RC4" : "RC2");
    }

    private byte[] getPrefix() {
        if (this.m_algID == null || this.m_algID == EncryptionAlgorithm.NULL) {
            Assert.internalError("JCEEncryptContext::getPrefix(), m_algID=" + this.m_algID);
        }
        byte[] byArray = new byte[]{1, 2, 0, 0, 1, 104, 0, 0, 0, -92, 0, 0};
        byte[] byArray2 = new byte[]{1, 2, 0, 0, 2, 102, 0, 0, 0, -92, 0, 0};
        if (this.m_algID == EncryptionAlgorithm.RC4) {
            return byArray;
        }
        return byArray2;
    }

    private void makeCipher() {
        try {
            String string = null;
            EncryptionAlgorithm encryptionAlgorithm = this.m_algID;
            int n = this.m_keyBitCount;
            if (encryptionAlgorithm == EncryptionAlgorithm.RC4) {
                string = "RC4";
            }
            if (encryptionAlgorithm == EncryptionAlgorithm.RC2_CBC) {
                string = "RC2/CBC/PKCS5Padding";
            }
            if (encryptionAlgorithm == EncryptionAlgorithm.RC2_ECB) {
                string = "RC2/ECB/PKCS5Padding";
            }
            if (string == null) {
                throw new RuntimeException(Res.formatKey(ResIDs.NONSUPPORTED_ALGORITHM_FMT, new Object[]{encryptionAlgorithm}));
            }
            Cipher cipher = Cipher.getInstance(string, PROVIDER_NAME);
            this.m_dataCipherParam = encryptionAlgorithm == EncryptionAlgorithm.RC2_CBC || encryptionAlgorithm == EncryptionAlgorithm.RC2_CFB ? new RC2ParameterSpec(this.m_keyBitCount, new byte[8]) : (encryptionAlgorithm == EncryptionAlgorithm.RC2_ECB ? new RC2ParameterSpec(this.m_keyBitCount) : null);
            this.m_datacipher = cipher;
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    private static void reverse(byte[] byArray) {
        int n = byArray.length;
        int n2 = n / 2;
        int n3 = 0;
        while (n3 < n2) {
            byte by;
            byte by2 = byArray[n3];
            byArray[n3] = by = byArray[n - n3 - 1];
            byArray[n - n3 - 1] = by2;
            ++n3;
        }
    }

    private static int readInt(byte[] byArray, int n) {
        int n2 = byArray[n] & 0xFF;
        int n3 = byArray[1 + n] & 0xFF;
        int n4 = byArray[2 + n] & 0xFF;
        int n5 = byArray[3 + n] & 0xFF;
        return n2 + (n3 << 8) + (n4 << 16) + (n5 << 24);
    }

    private static String bytesToString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer(byArray.length * 3);
        stringBuffer.append("[");
        int n = byArray.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = byArray[n2] & 0xFF;
            if (n3 < 16) {
                stringBuffer.append("0");
            }
            stringBuffer.append(Integer.toHexString(n3).toUpperCase());
            if (n2 < n - 1) {
                stringBuffer.append(" ");
            }
            ++n2;
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    private void ensureKeyPair() throws IOException {
        WorkStationOptions workStationOptions = Platform.getWSOptions();
        String string = null;
        File file = null;
        try {
            string = workStationOptions.getOption("keyfile");
            file = new File(string);
        }
        catch (Throwable throwable) {
            File file2 = ConfigFiles.getStarTeamINI();
            file = new File(file2.getParent(), "stkeys");
        }
        if (file.exists()) {
            this.loadKeyPair(file);
        } else {
            this.generateKeys();
            JCEEncryptContext.saveKeyPair(file, this.m_publicKey, this.m_privateKey);
        }
    }

    private void loadKeyPair(File file) throws IOException {
        int n;
        DataInputStream dataInputStream = new DataInputStream(new FileInputStream(file));
        int n2 = dataInputStream.readInt();
        int n3 = dataInputStream.readInt();
        if (n2 != 1246970182 || n3 != 1162560857) {
            Assert.internalError("JCEEncryptContext.loadKeyPair(), invalid key file");
        }
        if ((n = dataInputStream.readInt()) != 1) {
            Assert.internalError("JCEEncryptContext.loadKeyPair(), invalid key file version");
        }
        byte[][] byArray = this.readKeyData(dataInputStream);
        byte[][] byArray2 = this.readKeyData(dataInputStream);
        dataInputStream.close();
        this.m_publicKey = new RSAPublicKeyImpl(byArray[0], byArray[1]);
        this.m_privateKey = new RSAPrivateKeyImpl(byArray2[0], byArray2[1]);
    }

    private static void saveKeyPair(File file, RSAPublicKey rSAPublicKey, RSAPrivateKey rSAPrivateKey) throws IOException {
        DataOutputStream dataOutputStream = new DataOutputStream(new FileOutputStream(file));
        dataOutputStream.writeInt(1246970182);
        dataOutputStream.writeInt(1162560857);
        dataOutputStream.writeInt(1);
        try {
            JCEEncryptContext.writeKeyData(dataOutputStream, rSAPublicKey.getModulus(), rSAPublicKey.getPublicExponent());
            JCEEncryptContext.writeKeyData(dataOutputStream, rSAPrivateKey.getModulus(), rSAPrivateKey.getPrivateExponent());
        }
        finally {
            Object var5_4 = null;
            dataOutputStream.close();
        }
    }

    private static byte[] stripLeadingZeros(byte[] byArray) {
        int n = 0;
        int n2 = 0;
        while (n2 < byArray.length) {
            if (byArray[n2] != 0) break;
            ++n;
            ++n2;
        }
        byte[] byArray2 = new byte[byArray.length - n];
        System.arraycopy(byArray, n, byArray2, 0, byArray2.length);
        return byArray2;
    }

    private static void writeKeyData(DataOutputStream dataOutputStream, BigInteger bigInteger, BigInteger bigInteger2) throws IOException {
        dataOutputStream.writeInt(2);
        JCEEncryptContext.writeBigInteger(dataOutputStream, bigInteger);
        JCEEncryptContext.writeBigInteger(dataOutputStream, bigInteger2);
    }

    private static void writeBigInteger(DataOutputStream dataOutputStream, BigInteger bigInteger) throws IOException {
        byte[] byArray = JCEEncryptContext.stripLeadingZeros(bigInteger.toByteArray());
        dataOutputStream.writeInt(byArray.length);
        int n = 0;
        while (n < byArray.length) {
            dataOutputStream.writeByte(byArray[n]);
            ++n;
        }
    }

    private byte[][] readKeyData(DataInputStream dataInputStream) throws IOException {
        byte[][] byArray = null;
        int n = dataInputStream.readInt();
        byArray = new byte[n][];
        int n2 = 0;
        while (n2 < n) {
            int n3 = dataInputStream.readInt();
            byte[] byArray2 = new byte[n3];
            byArray[n2] = byArray2;
            int n4 = 0;
            while (n4 < n3) {
                byArray2[n4] = dataInputStream.readByte();
                ++n4;
            }
            ++n2;
        }
        return byArray;
    }

    private static byte[] encrypt(byte[] byArray, RSAPublicKey rSAPublicKey) {
        try {
            Cipher cipher = Cipher.getInstance(RSA_ALG, PROVIDER_NAME);
            cipher.init(1, rSAPublicKey);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray2 = cipher.update(byArray);
            if (byArray2 != null) {
                byteArrayOutputStream.write(byArray2);
            }
            if ((byArray2 = cipher.doFinal()) != null) {
                byteArrayOutputStream.write(byArray2);
            }
            byteArrayOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable.toString());
        }
    }

    private static byte[] decrypt(byte[] byArray, RSAPrivateKey rSAPrivateKey) {
        try {
            Cipher cipher = Cipher.getInstance(RSA_ALG, PROVIDER_NAME);
            cipher.init(2, rSAPrivateKey);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray2 = cipher.update(byArray);
            if (byArray2 != null) {
                byteArrayOutputStream.write(byArray2);
            }
            if ((byArray2 = cipher.doFinal()) != null) {
                byteArrayOutputStream.write(byArray2);
            }
            byteArrayOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable.toString());
        }
    }

    private static byte[] exportToCAPI(RSAPublicKey rSAPublicKey) {
        byte[] byArray = JCEEncryptContext.stripLeadingZeros(rSAPublicKey.getModulus().toByteArray());
        byte[] byArray2 = JCEEncryptContext.stripLeadingZeros(rSAPublicKey.getPublicExponent().toByteArray());
        int n = byArray.length * 8;
        int n2 = 8;
        int n3 = 12;
        int n4 = n2 + n3 + byArray.length;
        byte[] byArray3 = new byte[n4];
        byArray3[0] = 6;
        byArray3[1] = 2;
        byArray3[5] = -92;
        byArray3[8] = 82;
        byArray3[9] = 83;
        byArray3[10] = 65;
        byArray3[11] = 49;
        byte[] byArray4 = new byte[4];
        ByteOrder.writeInt(byArray4, n);
        System.arraycopy(byArray4, 0, byArray3, 12, 4);
        System.arraycopy(byArray2, 0, byArray3, 16, byArray2.length);
        byte[] byArray5 = new byte[byArray.length];
        System.arraycopy(byArray, 0, byArray5, 0, byArray5.length);
        JCEEncryptContext.reverse(byArray5);
        System.arraycopy(byArray5, 0, byArray3, 20, byArray5.length);
        return byArray3;
    }

    public JCEEncryptContext() {
        this.init();
    }

    static {
        try {
            Class<?> clazz = Class.forName(PROVIDER_CLASS);
            Provider provider = (Provider)clazz.newInstance();
            Security.addProvider(provider);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable.toString());
        }
    }

    public static class SecretKeyImpl
    implements SecretKey {
        private byte[] m_raw = null;
        private String m_alg = null;

        public String getAlgorithm() {
            return this.m_alg;
        }

        public byte[] getEncoded() {
            return this.m_raw;
        }

        public String getFormat() {
            return "RAW";
        }

        public SecretKeyImpl(byte[] byArray, String string) {
            this.m_raw = byArray;
            this.m_alg = string;
        }
    }

    public static class RSAPublicKeyImpl
    implements RSAPublicKey {
        private BigInteger m_mod = null;
        private BigInteger m_exp = null;
        private byte[] m_modbytes;
        private byte[] m_expbytes;

        public BigInteger getModulus() {
            return this.m_mod;
        }

        public BigInteger getPublicExponent() {
            return this.m_exp;
        }

        public String getAlgorithm() {
            return "RSA";
        }

        public byte[] getEncoded() {
            return null;
        }

        public String getFormat() {
            return "X509";
        }

        public String toString() {
            return "Public mod=" + this.m_mod + ", exp=" + this.m_exp;
        }

        public static RSAPublicKeyImpl importFromCAPI(byte[] byArray) {
            byte[] byArray2 = new byte[]{6, 2, 0, 0, 0, -92, 0, 0, 82, 83, 65, 49};
            int n = 0;
            while (n < byArray2.length) {
                if (byArray[n] != byArray2[n]) {
                    throw new RuntimeException(Res.formatKey(ResIDs.BAD_PUBLIC_RSA_FROM_SERVER_FMT, new Object[]{JCEEncryptContext.bytesToString(byArray)}));
                }
                ++n;
            }
            n = JCEEncryptContext.readInt(byArray, 12);
            int n2 = JCEEncryptContext.readInt(byArray, 16);
            int n3 = n / 8;
            byte[][] byArray3 = null;
            byArray3 = new byte[2][];
            int n4 = 0;
            int n5 = 0;
            while (n5 < 4) {
                if (byArray[n5 + 16] != 0) {
                    n4 = n5 + 1;
                }
                ++n5;
            }
            byArray3[1] = new byte[n4];
            System.arraycopy(byArray, 16, byArray3[1], 0, n4);
            JCEEncryptContext.reverse(byArray3[1]);
            byArray3[0] = new byte[n3];
            System.arraycopy(byArray, 20, byArray3[0], 0, n3);
            JCEEncryptContext.reverse(byArray3[0]);
            return new RSAPublicKeyImpl(byArray3[0], byArray3[1]);
        }

        public RSAPublicKeyImpl(byte[] byArray, byte[] byArray2) {
            this.m_mod = new BigInteger(1, byArray);
            this.m_exp = new BigInteger(1, byArray2);
            this.m_modbytes = byArray;
            this.m_expbytes = byArray2;
        }
    }

    public static class RSAPrivateKeyImpl
    implements RSAPrivateKey {
        private BigInteger m_mod = null;
        private BigInteger m_exp = null;

        public BigInteger getModulus() {
            return this.m_mod;
        }

        public BigInteger getPrivateExponent() {
            return this.m_exp;
        }

        public String getAlgorithm() {
            return "RSA";
        }

        public byte[] getEncoded() {
            return null;
        }

        public String getFormat() {
            return "PKCS8";
        }

        public String toString() {
            return "Private mod=" + this.m_mod + ", exp=" + this.m_exp;
        }

        public RSAPrivateKeyImpl(byte[] byArray, byte[] byArray2) {
            this.m_mod = new BigInteger(1, byArray);
            this.m_exp = new BigInteger(1, byArray2);
        }
    }
}

