/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam.vts.comm;

import System.Exception;
import com.starbase.starteam.vts.comm.EncryptContext;
import com.starbase.starteam.vts.comm.Res;
import com.starbase.starteam.vts.comm.ResIDs;
import com.starbase.util.Platform;

class EncryptFactory {
    private static final String PACKAGE = "com.starbase.starteam.vts.comm";
    static final String CAPI_LIBRARY = "StSDKCAPIEncryptContext_02";

    public static EncryptContext getContext() {
        try {
            try {
                if (Platform.isWin32()) {
                    return EncryptFactory.createCAPI();
                }
                return EncryptFactory.getNativeContext();
            }
            catch (Throwable throwable) {
                throw new RuntimeException(EncryptFactory.generateNoEncrytpionMsg(throwable.getMessage()));
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(EncryptFactory.generateNoEncrytpionMsg(exception.get_Message()));
        }
    }

    private static EncryptContext getNativeContext() throws IllegalAccessException, InstantiationException, ClassNotFoundException {
        try {
            try {
                return EncryptFactory.createJSAFE();
            }
            catch (Throwable throwable) {
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return EncryptFactory.createJCE();
    }

    private static EncryptContext createCAPI() throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        EncryptContext encryptContext = null;
        try {
            Class<?> clazz = Class.forName("com.starbase.starteam.vts.comm.CAPIEncryptContext");
            encryptContext = (EncryptContext)clazz.newInstance();
        }
        catch (LinkageError linkageError) {
            throw new RuntimeException(Res.formatKey(ResIDs.NATIVE_LIBRARY_MISSING_FMT, new Object[]{CAPI_LIBRARY}));
        }
        return encryptContext;
    }

    private static EncryptContext createJSAFE() throws IllegalAccessException, InstantiationException, ClassNotFoundException {
        Class<?> clazz = Class.forName("com.starbase.starteam.vts.comm.JSAFEEncryptContext");
        return (EncryptContext)clazz.newInstance();
    }

    private static EncryptContext createJCE() throws IllegalAccessException, InstantiationException, ClassNotFoundException {
        Class<?> clazz = Class.forName("com.starbase.starteam.vts.comm.JCEEncryptContext");
        return (EncryptContext)clazz.newInstance();
    }

    private static String generateNoEncrytpionMsg(String string) {
        String string2 = System.getProperty("java.version");
        String string3 = System.getProperty("java.vendor");
        String string4 = System.getProperty("os.name");
        String string5 = System.getProperty("os.version");
        return Res.formatKey(ResIDs.ENCRYPTION_SUPPORT_NOT_AVAILABLE_FMT, new Object[]{string2 == null ? "?" : string2, string3 == null ? "?" : string3, string4 == null ? "?" : string4, string5 == null ? "?" : string5, string});
    }

    EncryptFactory() {
    }
}

